/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class OkoProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("{").number("(d{15}),").optional().number("(dd)(dd)(dd)(?:.d+)?,").expression("([AV]),").number("(dd)(dd.d+),").expression("([NS]),").number("(ddd)(dd.d+),").expression("([EW]),").number("(d+.?d*)?,").number("(d+.?d*)?,").number("(dd)(dd)(dd),").number("(d+),").number("(d+.d+|xx),").number("(xx),").number("(d+.d+|xx),").number("d").number(",(xx)").optional().any().compile();

    public OkoProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private double decodeVoltage(Parser parser) {
        String value = parser.next();
        if (value.contains(".")) {
            return Double.parseDouble(value);
        }
        return (double)Integer.parseInt(value, 16) * 0.1;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = parser.hasNext() ? this.getDeviceSession(channel, remoteAddress, parser.next()) : this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(), parser.nextInt(), parser.nextInt());
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        dateBuilder.setDateReverse(parser.nextInt(), parser.nextInt(), parser.nextInt());
        position.setTime(dateBuilder.getDate());
        position.set("sat", parser.nextInt());
        position.set("adc1", this.decodeVoltage(parser));
        position.set("event", parser.next());
        position.set("power", this.decodeVoltage(parser));
        position.set("input", parser.nextHexInt());
        return position;
    }
}

