/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.snapshot;

import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.Index;
import com.google.firebase.database.snapshot.NamedNode;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.snapshot.NodeUtilities;
import com.google.firebase.database.snapshot.StringNode;

public class PriorityIndex
extends Index {
    private static final PriorityIndex INSTANCE = new PriorityIndex();

    private PriorityIndex() {
    }

    public static PriorityIndex getInstance() {
        return INSTANCE;
    }

    @Override
    public int compare(NamedNode node1, NamedNode node2) {
        Node priority1 = node1.getNode().getPriority();
        Node priority2 = node2.getNode().getPriority();
        return NodeUtilities.nameAndPriorityCompare(node1.getName(), priority1, node2.getName(), priority2);
    }

    @Override
    public boolean isDefinedOn(Node a) {
        return !a.getPriority().isEmpty();
    }

    @Override
    public NamedNode makePost(ChildKey name, Node value) {
        return new NamedNode(name, new StringNode("[PRIORITY-POST]", value));
    }

    @Override
    public NamedNode maxPost() {
        return this.makePost(ChildKey.getMaxName(), Node.MAX_NODE);
    }

    @Override
    public String getQueryDefinition() {
        throw new IllegalArgumentException("Can't get query definition on priority index!");
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof PriorityIndex;
    }

    public int hashCode() {
        return 3155577;
    }

    public String toString() {
        return "PriorityIndex";
    }
}

