package routeros;
##
## rancid 3.13
## Copyright (c) 1997-2019 by Henry Kilmer and John Heasley
## All rights reserved.
##
## This code is derived from software contributed to and maintained by
## Henry Kilmer, John Heasley, Andrew Partan,
## Pete Whiting, Austin Schutz, and Andrew Fort.
##
## Redistribution and use in source and binary forms, with or without
## modification, are permitted provided that the following conditions
## are met:
## 1. Redistributions of source code must retain the above copyright
##    notice, this list of conditions and the following disclaimer.
## 2. Redistributions in binary form must reproduce the above copyright
##    notice, this list of conditions and the following disclaimer in the
##    documentation and/or other materials provided with the distribution.
## 3. Neither the name of RANCID nor the names of its
##    contributors may be used to endorse or promote products derived from
##    this software without specific prior written permission.
##
## THIS SOFTWARE IS PROVIDED BY Henry Kilmer, John Heasley AND CONTRIBUTORS
## ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
## TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
## PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COMPANY OR CONTRIBUTORS
## BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
## CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
## SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
## INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
## CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
## ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
## POSSIBILITY OF SUCH DAMAGE.
##
## It is the request of the authors, but not a condition of license, that
## parties packaging or redistributing RANCID NOT distribute altered versions
## of the etc/rancid.types.base file nor alter how this file is processed nor
## when in relation to etc/rancid.types.conf.  The goal of this is to help
## suppress our support costs.  If it becomes a problem, this could become a
## condition of license.
# 
#  The expect login scripts were based on Erik Sherk's gwtn, by permission.
# 
#  The original looking glass software was written by Ed Kern, provided by
#  permission and modified beyond recognition.
#
#  RANCID - Really Awesome New Cisco confIg Differ
#
#  routeros.pm - Mikrotik RouterOS rancid procedures
#
# Original mtrancid was modified by Chris Boot for MikroTik.

use 5.010;
use strict 'vars';
use warnings;
no warnings 'uninitialized';
require(Exporter);
our @ISA = qw(Exporter);

use rancid 3.13;

@ISA = qw(Exporter rancid main);
#XXX @Exporter::EXPORT = qw($VERSION @commandtable %commands @commands);

# load-time initialization
sub import {
    $timeo = 90;                       # mtlogin timeout in seconds

    0;
}

# post-open(collection file) initialization
sub init {
    # add content lines and separators
    ProcessHistory("","","","!RANCID-CONTENT-TYPE: $devtype\n!\n");
    ProcessHistory("COMMENTS","keysort","B0","!\n");
    ProcessHistory("COMMENTS","keysort","D0","!\n");
    ProcessHistory("COMMENTS","keysort","F0","!\n");
    ProcessHistory("COMMENTS","keysort","G0","!\n");

    0;
}

# main loop of input of device output
sub inloop {
    my($INPUT, $OUTPUT) = @_;
    my($cmd, $rval);

TOP: while (<$INPUT>) {
	tr/\015//d;
	if (/[>#]\s*quit$/) {
	    $clean_run=1;
	    last;
	}
	if (/^Error:/) {
	    print STDOUT ("$host mtlogin error: $_");
	    print STDERR ("$host mtlogin error: $_") if ($debug);
	    $clean_run = 0;
	    last;
	}
	while (/\s*($cmds_regexp)\s*$/) {
	    $cmd = $1;
	    if (!defined($prompt)) {
		$prompt = "\] > ";  # crude but effective
		print STDERR ("PROMPT MATCH: $prompt\n") if ($debug);
	    }
	    print STDERR ("HIT COMMAND:$_") if ($debug);
	    if (! defined($commands{$cmd})) {
		print STDERR "$host: found unexpected command - \"$cmd\"\n";
		$clean_run = 0;
		last TOP;
	    }
	    $rval = &{$commands{$cmd}}($INPUT, $OUTPUT, $cmd);
	    delete($commands{$cmd});
	    if ($rval == -1) {
		$clean_run = 0;
		last TOP;
	    }
	}
    }
}

# This routine parses "show version"
sub SystemPackagePrintDetail {
    my($INPUT, $OUTPUT, $cmd) = @_;
    print STDERR "    In SystemPackagePrintDetail: $_" if ($debug);
    my($buffer) = "";
    my($name);
    my(%packages) = ();

    while (<$INPUT>) {
	tr/\015//d;
	last if (/$prompt/);
	next if (/^Flags:/);
	return(1) if (/(bad command name )/);

	s/^\s+//g;
	s/^\d+\s+//g;
	s/\s+$//g;

	if (/^$/) {
	    if ($buffer =~ /name="(.+)"/) {
			$packages{$1} = $buffer;
	    }
	    $buffer = "";
	} else {
	    $buffer .= "$_ ";
	}
    }

    if ($buffer =~ /name="(.+)"/) {
	$packages{$1} = $buffer;
    }

    for $name (sort keys %packages) {
	ProcessHistory("COMMENTS","keysort","A1","# " . $packages{$name} .
		       "\n");
    }

    return(0);
}

sub SystemRouterboardPrint {
    my($INPUT, $OUTPUT, $cmd) = @_;
    print STDERR "    In SystemRouterboardPrint: $_" if ($debug);

    while (<$INPUT>) {
	tr/\015//d;
	last if (/$prompt/);
	next if (/^(\s*|\s*$cmd\s*)$/);
	return(1) if (/(bad command name )/);
	s/^\s+//g;

	# license renewal timestamp
	next if (/^next-renewal-at:/i);

	ProcessHistory("COMMENTS","keysort","C1","# $_");
    }

    return(0);
}

sub SystemLicensePrint {
    my($INPUT, $OUTPUT, $cmd) = @_;
    print STDERR "    In SystemLicensePrint: $_" if ($debug);

    while (<$INPUT>) {
	tr/\015//d;
	last if (/$prompt/);
	next if (/^(\s*|\s*$cmd\s*)$/);
	return(1) if (/(bad command name )/);
	s/^\s+//g;

	ProcessHistory("COMMENTS","keysort","E1","# $_");
    }

    return(0);
}

sub Export {
    my($INPUT, $OUTPUT, $cmd) = @_;
    print STDERR "    In Export: $_" if ($debug);
    my($buffer) = "";

    while (<$INPUT>) {
	tr/\015//d;
	if (/$prompt/) { $found_end=1; $clean_run=1; return 0};
	next if(/^(\s*|\s*$cmd\s*)$/);
	next if(/^#/);
	return(1) if /(bad command name )/;
	s/^\s+//g;

	# RouterOS splits long lines with backslashes - this re-joins them
	if (/\\\n$/) {
	    s/\s*\\\n$//;
	    $buffer .= $_;
	    if (!/=$/ && !/="[^"]+$/ ) {
		$buffer .= " ";
	    }
	} else {
	    $buffer .= $_;

	    # Fix quoted strings
	    $buffer =~ s/(\S+)="(\S+)"/$1=$2/g;

	    # skip dynamic configuration, like
	    # set <pppoe-joker> disabled=yes display-time=5s
	    # set <pppoe-smoker > disabled=yes display-time=5s
	    ($buffer = "", next) if (/set "?<\S+\s?>"? /);

	    ProcessHistory("","","","$buffer");
	    $buffer = "";
	}
    }
}

1;
