/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ECPointFormat;
import de.rub.nds.tlsattacker.core.constants.EllipticCurveType;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.crypto.SignatureCalculator;
import de.rub.nds.tlsattacker.core.crypto.ec.CurveFactory;
import de.rub.nds.tlsattacker.core.crypto.ec.EllipticCurve;
import de.rub.nds.tlsattacker.core.crypto.ec.ForgivingX25519Curve;
import de.rub.nds.tlsattacker.core.crypto.ec.ForgivingX448Curve;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.crypto.ec.PointFormatter;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.exceptions.PreparationException;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.ServerKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ECDHEServerKeyExchangePreparator<T extends ECDHEServerKeyExchangeMessage>
extends ServerKeyExchangePreparator<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final T msg;

    public ECDHEServerKeyExchangePreparator(Chooser chooser, T msg) {
        super(chooser, (ServerKeyExchangeMessage)msg);
        this.msg = msg;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        ((ECDHEServerKeyExchangeMessage)this.msg).prepareComputations();
        ((ECDHEServerKeyExchangeMessage)this.msg).getComputations().setPrivateKey(this.chooser.getConfig().getDefaultServerEcPrivateKey());
        this.prepareCurveType(this.msg);
        this.prepareEcDhParams();
        SignatureAndHashAlgorithm signHashAlgo = this.chooser.getSelectedSigHashAlgorithm();
        this.prepareSignatureAndHashAlgorithm(this.msg, signHashAlgo);
        byte[] signature = new byte[]{};
        try {
            signature = this.generateSignature(this.msg, signHashAlgo);
        }
        catch (CryptoException E) {
            LOGGER.warn("Could not generate Signature! Using empty one instead!", (Throwable)E);
        }
        this.prepareSignature(this.msg, signature);
        this.prepareSignatureLength(this.msg);
    }

    protected void prepareEcDhParams() {
        NamedGroup namedGroup = this.selectNamedGroup(this.msg);
        ((ECDHEServerKeyExchangeMessage)this.msg).getComputations().setNamedGroup(namedGroup.getValue());
        this.prepareNamedGroup(this.msg);
        namedGroup = NamedGroup.getNamedGroup((byte[])((ECDHEServerKeyExchangeMessage)this.msg).getComputations().getNamedGroup().getValue());
        if (namedGroup == null) {
            LOGGER.warn("Could not deserialize group from computations. Using default group instead");
            namedGroup = this.chooser.getConfig().getDefaultSelectedNamedGroup();
        }
        ECPointFormat pointFormat = this.selectPointFormat(this.msg);
        ((ECDHEServerKeyExchangeMessage)this.msg).getComputations().setEcPointFormat(pointFormat.getValue());
        pointFormat = ECPointFormat.getECPointFormat((Byte)((ECDHEServerKeyExchangeMessage)this.msg).getComputations().getEcPointFormat().getValue());
        if (pointFormat == null) {
            LOGGER.warn("Could not deserialize group from computations. Using default point format instead");
            pointFormat = this.chooser.getConfig().getDefaultSelectedPointFormat();
        }
        byte[] publicKeyBytes = null;
        if (namedGroup == NamedGroup.ECDH_X25519) {
            publicKeyBytes = ForgivingX25519Curve.computePublicKey((BigInteger)((ECDHEServerKeyExchangeMessage)this.msg).getComputations().getPrivateKey().getValue());
        } else if (namedGroup == NamedGroup.ECDH_X448) {
            publicKeyBytes = ForgivingX448Curve.computePublicKey((BigInteger)((ECDHEServerKeyExchangeMessage)this.msg).getComputations().getPrivateKey().getValue());
        } else if (namedGroup.isCurve()) {
            EllipticCurve curve = CurveFactory.getCurve(namedGroup);
            Point publicKey = curve.mult((BigInteger)((ECDHEServerKeyExchangeMessage)this.msg).getComputations().getPrivateKey().getValue(), curve.getBasePoint());
            publicKeyBytes = PointFormatter.formatToByteArray(namedGroup, publicKey, pointFormat);
        }
        ((ServerKeyExchangeMessage)this.msg).setPublicKey(publicKeyBytes);
        ((ServerKeyExchangeMessage)this.msg).setPublicKeyLength(((byte[])((ServerKeyExchangeMessage)this.msg).getPublicKey().getValue()).length);
        this.prepareClientServerRandom(this.msg);
    }

    protected ECPointFormat selectPointFormat(T msg) {
        ECPointFormat selectedFormat;
        if (this.chooser.getConfig().isEnforceSettings().booleanValue()) {
            selectedFormat = this.chooser.getConfig().getDefaultSelectedPointFormat();
        } else {
            HashSet<ECPointFormat> serverSet = new HashSet<ECPointFormat>(this.chooser.getConfig().getDefaultServerSupportedPointFormats());
            HashSet<ECPointFormat> clientSet = new HashSet<ECPointFormat>(this.chooser.getClientSupportedPointFormats());
            serverSet.retainAll(clientSet);
            if (serverSet.isEmpty()) {
                LOGGER.warn("No common ECPointFormat - falling back to default");
                selectedFormat = this.chooser.getConfig().getDefaultSelectedPointFormat();
            } else {
                selectedFormat = serverSet.contains((Object)this.chooser.getConfig().getDefaultSelectedPointFormat()) ? this.chooser.getConfig().getDefaultSelectedPointFormat() : (ECPointFormat)((Object)serverSet.toArray()[0]);
            }
        }
        return selectedFormat;
    }

    protected NamedGroup selectNamedGroup(T msg) {
        NamedGroup namedGroup;
        if (this.chooser.getConfig().isEnforceSettings().booleanValue()) {
            namedGroup = this.chooser.getConfig().getDefaultSelectedNamedGroup();
        } else {
            HashSet<NamedGroup> serverSet = new HashSet<NamedGroup>(this.chooser.getConfig().getDefaultServerNamedGroups());
            HashSet<NamedGroup> clientSet = new HashSet<NamedGroup>(this.chooser.getClientSupportedNamedGroups());
            serverSet.retainAll(clientSet);
            if (serverSet.isEmpty()) {
                LOGGER.warn("No common NamedGroup - falling back to default");
                namedGroup = this.chooser.getConfig().getDefaultSelectedNamedGroup();
            } else {
                namedGroup = serverSet.contains((Object)this.chooser.getConfig().getDefaultSelectedNamedGroup()) ? this.chooser.getConfig().getDefaultSelectedNamedGroup() : (NamedGroup)((Object)serverSet.toArray()[0]);
            }
        }
        return namedGroup;
    }

    protected byte[] generateSignatureContents(T msg) {
        EllipticCurveType curveType = this.chooser.getEcCurveType();
        ByteArrayOutputStream ecParams = new ByteArrayOutputStream();
        switch (curveType) {
            case EXPLICIT_PRIME: 
            case EXPLICIT_CHAR2: {
                throw new UnsupportedOperationException("Signing of explicit curves not implemented yet.");
            }
            case NAMED_CURVE: {
                ecParams.write(curveType.getValue());
                try {
                    ecParams.write((byte[])((ECDHEServerKeyExchangeMessage)msg).getNamedGroup().getValue());
                    break;
                }
                catch (IOException ex) {
                    throw new PreparationException("Failed to add named group to ECDHEServerKeyExchange signature.", ex);
                }
            }
        }
        ecParams.write((Integer)((ServerKeyExchangeMessage)msg).getPublicKeyLength().getValue());
        try {
            ecParams.write((byte[])((ServerKeyExchangeMessage)msg).getPublicKey().getValue());
        }
        catch (IOException ex) {
            throw new PreparationException("Failed to add serializedPublicKey to ECDHEServerKeyExchange signature.", ex);
        }
        return ArrayConverter.concatenate((byte[][])new byte[][]{(byte[])((ECDHEServerKeyExchangeMessage)msg).getComputations().getClientServerRandom().getValue(), ecParams.toByteArray()});
    }

    protected byte[] generateSignature(T msg, SignatureAndHashAlgorithm algorithm) throws CryptoException {
        return SignatureCalculator.generateSignature(algorithm, this.chooser, this.generateSignatureContents(msg));
    }

    protected void prepareSignatureAndHashAlgorithm(T msg, SignatureAndHashAlgorithm signHashAlgo) {
        ((ServerKeyExchangeMessage)msg).setSignatureAndHashAlgorithm(signHashAlgo.getByteValue());
        LOGGER.debug("SignatureAndHashAlgorithm: " + ArrayConverter.bytesToHexString((byte[])((byte[])((ServerKeyExchangeMessage)msg).getSignatureAndHashAlgorithm().getValue())));
    }

    protected void prepareClientServerRandom(T msg) {
        ((ECDHEServerKeyExchangeMessage)msg).getComputations().setClientServerRandom(ArrayConverter.concatenate((byte[][])new byte[][]{this.chooser.getClientRandom(), this.chooser.getServerRandom()}));
        LOGGER.debug("ClientServerRandom: " + ArrayConverter.bytesToHexString((byte[])((byte[])((ECDHEServerKeyExchangeMessage)msg).getComputations().getClientServerRandom().getValue())));
    }

    protected void prepareSignature(T msg, byte[] signature) {
        ((ServerKeyExchangeMessage)msg).setSignature(signature);
        LOGGER.debug("Signature: " + ArrayConverter.bytesToHexString((byte[])((byte[])((ServerKeyExchangeMessage)msg).getSignature().getValue())));
    }

    protected void prepareSignatureLength(T msg) {
        ((ServerKeyExchangeMessage)msg).setSignatureLength(((byte[])((ServerKeyExchangeMessage)msg).getSignature().getValue()).length);
        LOGGER.debug("SignatureLength: " + ((ServerKeyExchangeMessage)msg).getSignatureLength().getValue());
    }

    protected void prepareSerializedPublicKeyLength(T msg) {
        ((ServerKeyExchangeMessage)msg).setPublicKeyLength(((byte[])((ServerKeyExchangeMessage)msg).getPublicKey().getValue()).length);
        LOGGER.debug("SerializedPublicKeyLength: " + ((ServerKeyExchangeMessage)msg).getPublicKeyLength().getValue());
    }

    protected void prepareCurveType(T msg) {
        ((ECDHEServerKeyExchangeMessage)msg).setCurveType(EllipticCurveType.NAMED_CURVE.getValue());
    }

    protected void prepareNamedGroup(T msg) {
        NamedGroup group = NamedGroup.getNamedGroup((byte[])((ECDHEServerKeyExchangeMessage)msg).getComputations().getNamedGroup().getValue());
        if (group == null) {
            LOGGER.warn("Could not deserialize group from computations. Using default group instead");
            group = this.chooser.getConfig().getDefaultSelectedNamedGroup();
        }
        ((ECDHEServerKeyExchangeMessage)msg).setNamedGroup(group.getValue());
    }
}

