{$A+,B-,D-,E-,F-,G-,I+,L-,N-,O-,R-,S-,V+,X-}
{$M 10000,0,655360}
program WordList;

{ reads a text file and puts all words on separate lines }

uses
  CRT; { just to enable output to screen when piping output }

var
  gv_Output  : text;


procedure WriteWord (pc_Word : string);
var
  i         : word;
const
  lc_Legal1 = ['a'..'z', 'A'..'Z', '\'];
  lc_Legal2 = ['a'..'z', 'A'..'Z'];
begin
while (pc_Word <> '') and (not (pc_Word [1] in lc_Legal1)) do
  pc_Word := Copy (pc_Word, 2, 255);
while (pc_Word <> '') and (not (pc_Word [Length (pc_Word)] in lc_Legal2)) do
  Dec (pc_Word [0]);
if Length (pc_Word) > 1 then
  begin
  for i := 1 to Length (pc_Word) do
    if pc_Word [i] in ['A'..'Z'] then
      pc_Word [i] := Char (byte (pc_Word [i]) + 32);
  {$I-}
  WriteLn (gv_Output, pc_Word);
  {$I+}
  if IOresult <> 0 then
    begin
    WriteLn ('!! error: can''t write to output (disk full?)');
    Close (gv_Output);
    Halt
    end
  end
end;


procedure MakeWordlist (pc_Name  : string;
                        pc_Level : word);
var
  lv_Word,
  lv_Line  : string;
  lv_Pos   : integer;
  lv_Input : text;
begin
for lv_Pos := 1 to pc_Level do
  Write ('  ');
for lv_Pos := 1 to Length (pc_Name) do
  if pc_Name [lv_Pos] = '/' then
    pc_Name [lv_Pos] := '\';
if Pos ('.', pc_Name) = 0 then
  pc_Name := pc_Name + '.tex';
{$I-}
Assign (lv_Input, pc_Name);
Reset (lv_Input);
{$I+}
if IOresult <> 0 then
  Writeln ('! ', pc_Name, ': not found')
else
  begin
  WriteLn ('reading ', pc_Name, '...');
  repeat
    ReadLn (lv_Input, lv_Line);
    while (lv_Line <> '') and
          (not (lv_Line [1] in ['a'..'z', 'A'..'Z', '\'])) do
      lv_Line := Copy (lv_Line, 2, 255);
    while lv_Line <> '' do
      begin
      if (Copy (lv_Line, 1, 6) = '\input') or
         ((Copy (lv_Line, 1, 8) = '\include') and
          (Copy (lv_Line, 9, 4) <> 'only')) then
        begin
        while (lv_Line [1] <> ' ') and (lv_Line [1] <> '{') do
          lv_Line := Copy (lv_Line, 2, 255);
        lv_Line := Copy (lv_Line, 2, 255);
        if (lv_Line [1] = ' ') or (lv_Line [1] = '{') then
          lv_Line := Copy (lv_Line, 2, 255);
        lv_Word := '';
        repeat
          lv_Word := lv_Word + lv_Line [1];
          lv_Line := Copy (lv_Line, 2, 255)
        until (lv_Line = '') or (lv_Line [1] in [' ', '}']);
        MakeWordlist (lv_Word, pc_Level + 1)
        end
      else
        begin
        lv_Pos := Pos (' ', lv_Line);
        if lv_Pos > 0 then
          begin
          lv_Word := Copy (lv_Line, 1, lv_Pos - 1);
          lv_Line := Copy (lv_Line, lv_Pos + 1, 255);
          WriteWord (lv_Word);
          while (lv_Line <> '') and (lv_Line [1] = ' ') do
            lv_Line := Copy (lv_Line, 2, 255)
          end
        else
          begin
          WriteWord (lv_Line);
          lv_Line := ''
          end
        end
      end
  until Eof (lv_Input);
  Close (lv_Input)
  end
end;


begin
if (Pos ('?', ParamStr (1)) > 0) or
   (Pos ('/', ParamStr (1)) > 0) then
  begin
  WriteLn ('WORDLIST <input> [output]');
  WriteLn ('writes a list of words in file <input> to file <output>');
  Halt
  end;
{$I-}
Assign (gv_Output, ParamStr (2));
Rewrite (gv_Output);
{$I+}
if IOresult <> 0 then
  begin
  WriteLn ('!! error: can''t write to ', ParamStr (2));
  Halt (1)
  end;
MakeWordlist (ParamStr (1), 0);
Close (gv_Output)
end.
