import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;

/*
 * ListBoxChooseAddDialogue.java
 *
 * Created on 14. Dezember 2005, 09:59
 */

/**
 *
 * @author  Olle Nebendahl
 */
public class ListBoxChooseAddDialogue extends JDialog 
{

    private JButton EditButton;
    private JButton ChooseButton;
    private JButton moveUpButton;
    private JButton deleteButton;
    private JButton addButton;
    private JButton discardButton;
    private JButton saveButton;
    private JLabel jLabel1;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;

    DefaultListModel myListModel;

    /** Creates new form ListBoxChooseAddDialogue */
    public ListBoxChooseAddDialogue(java.awt.Frame parent, boolean modal, DefaultListModel lm) 
    {
        super(parent, modal);
        myListModel=lm;
        initComponents();
    }

    public ListBoxChooseAddDialogue(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        myListModel=new DefaultListModel();

        initComponents();
    }
    
    private void initComponents() {
        jLabel1 = new JLabel();
        jPanel1 = new JPanel();
        jScrollPane1 = new JScrollPane();
        jList1 = new JList();
        jList1 = new JList(myListModel);
        jPanel2 = new JPanel();
        addButton = new JButton();
        EditButton = new JButton();
        ChooseButton = new JButton();
        moveUpButton = new JButton();
        deleteButton = new JButton();
        discardButton = new JButton();
        saveButton = new JButton();

        getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));

        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        jLabel1.setText("jLabel1");
        getContentPane().add(jLabel1);

        jPanel1.setLayout(new BoxLayout(jPanel1, BoxLayout.X_AXIS));

        jScrollPane1.setPreferredSize(new java.awt.Dimension(260, 32));
        jScrollPane1.setViewportView(jList1);

        jPanel1.add(jScrollPane1);

        jPanel2.setLayout(new BoxLayout(jPanel2, BoxLayout.Y_AXIS));

        addButton.setText("add");
        addButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addButtonActionPerformed(evt);
            }
        });

        jPanel2.add(addButton);

        EditButton.setText("edit");
        EditButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                EditButtonActionPerformed(evt);
            }
        });

        jPanel2.add(EditButton);

        moveUpButton.setText("move up");
        moveUpButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                moveUpButtonActionPerformed(evt);
            }
        });

        jPanel2.add(moveUpButton);

        deleteButton.setText("delete");
        deleteButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteButtonActionPerformed(evt);
            }
        });

        jPanel2.add(deleteButton);

        ChooseButton.setText("choose");
        ChooseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ChooseButtonActionPerformed(evt);
            }
        });

        jPanel2.add(ChooseButton);

        jPanel1.add(jPanel2);

        getContentPane().add(jPanel1);

        discardButton.setText("discard & quit");
        getContentPane().add(discardButton);

        saveButton.setText("save changes & quit");
        getContentPane().add(saveButton);

        pack();
    }

    private void EditButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
    }

    private void ChooseButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
    }

    private void addButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        myListModel.addElement(new String("new Element #"+myListModel.getSize()));
        EditButton.setVisible(true);
        moveUpButton.setVisible(true);
        deleteButton.setVisible(true);
        pack();
    }

    private void moveUpButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        int i=jList1.getSelectedIndex();
        if(i>0) 
        {
            Object swap=myListModel.get(i-1);
            myListModel.set(i-1, myListModel.get(i));
            myListModel.set(i, swap);
            jList1.setSelectedIndex(i-1);
        }
    }

    private void deleteButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        int i=jList1.getSelectedIndex();
        if(i>-1)
        myListModel.remove(jList1.getSelectedIndex());
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) 
    {
        final String s=args[0];
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new ListBoxChooseAddDialogue(new JFrame(), true, OLL.getAsDefaultListModel(CommandGetter.scanFile(s))).setVisible(true);
            }
        });
    }
}
