/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/


/* ks_edit.c edit keywords and source (journal name) data : write data into text file,
 * transfer from text file into database */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ks_edit.h"
#include "refs.h"
#include "fl_ut.h"
#include "str_fun.h"
#include "initial.h"
#include "interf.h"
#include "ix02_fun.h"
#include "ix03_fun.h"
#include "sortix02.h"
#include "sortix03.h"


#define MAXARR 32000
#define ID_ZEILE_LEN  FORM_LABEL_LEN + SCREENLINE_LEN

#define ZAHLSTRING_LEN 12

 extern char quell_pix_name[PFAD_LEN+1];
 extern char quell_name[PFAD_LEN+1];
 extern char stichw_name[PFAD_LEN+1];
 extern char stichw_pix_name[PFAD_LEN+1];

 extern char tempt_name[PFAD_LEN+1];

 extern quell_rec one_quell_rec;
 extern keylist_rec one_stichw_rec;
 extern quellpix_rec ix02rec;
 extern keylistpix_rec ix03rec;


 extern FILE * ix02file;
 extern FILE * ix03file;

 extern FILE * fpquell;
 extern FILE * fpstichw;

#define TMP02_IX     "tmp02.ix"  /* journal names */
#define DEST02_IX    "dest02.ix"
#define TMP03_IX     "tmp03.ix"  /*keywords names */
#define DEST03_IX    "dest03.ix"

 extern char wrtxtbu[WRTXTBU_LEN+1];

 static char tmp02_ix_name[PFAD_LEN+1]; /* temporary ix02 file */
 static char dest02_ix_name[PFAD_LEN+1]; /* temporary ix02 file */
 static char tmp03_ix_name[PFAD_LEN+1]; /* temporary ix03 file */
 static char dest03_ix_name[PFAD_LEN+1]; /* temporary ix03 file */

 static char ky_txt_name[PFAD_LEN + 1]; /* name of keywords text form to 
                                           be read */
 static char jn_txt_name[PFAD_LEN + 1]; /* name of journal name text 
                                           form to be read */

 
 
 extern char textpfad[PFAD_LEN+1];
 extern char rdbpfad[PFAD_LEN+1];

 static char id_zeile[ID_ZEILE_LEN + 1];

 static char * in_zeile;
 static char * ex_zeile;

 static FILE * fptxt;
 extern config_set one_config_set;

 static int journal_code_eingeben(char * code);
 static int ks_initialize(void);
 static int ks_aufraeumen(void);
 static int list_ky(void);
 static void compile_ky_leer_formular(void);
 static int lies_keywords(void);
 static int ky_textdatei_oeffnen(void);
 static int ky_textdatei_schliessen(void);
 static int keywords_speichern(void);
 static int dupl_ex_ix03(char * src_name, char * destin_name);
 static int list_jn(void);
 static void compile_jn_leer_formular(char * journal_code);
 static void compile_jn_formular(char * journal_code);
 static int jn_textdatei_oeffnen(void);
 static int jn_textdatei_schliessen(void);
 static int zeitschrift_textdatei_lesen(void);
 static int jn_in_db_schreiben(void);
 static long waehl_keywords(void);
 static int delete_keywords(long ix_zeiger);
 static long waehl_journal(void);
 static int delete_journal(long ix_zeiger);

 
int journal_edit_main(char * code, char * journal_code)
{
   ks_initialize();
   if (strcmp(code,"list")==0)
   {
      list_jn();
   }
   if (strcmp(code,"make_empty_journal_form")==0)
   {
       compile_jn_leer_formular(journal_code);
   }
   if (strcmp(code,"export_edit_journal_data")==0)
   {
       char jc[QUELLKUERZEL_LEN + 2];
       strcpy(jc,""); 
       if (journal_code_eingeben(jc)==1)
       {
         compile_jn_formular(jc);
       }
   }
   if (strcmp(code,"import_journal_code_data")==0)
   {   
       int ok, option;
       static char ein[INPUT_BU_LEN+1];
       quellpix_rec ix02rec_lokal;
       long datensatz_vorhanden;

       ok = zeitschrift_textdatei_lesen();
       /*  */
       read_ix02(quell_pix_name);
       datensatz_vorhanden =
        locate_ix02(one_quell_rec.quell_kuerzel,&ix02rec_lokal);
       close_ix02();
       if (ok == 1)
       {
          strcpy(ein,"menu");
          if (datensatz_vorhanden==-1)
          {
            wrtxt("\nWrite new record into database [y/n]?\n");
          }
          else
          {
            wrtxt("\nOverwrite existing record in database [y/n]?\n");
          }
          option = menu_wahl(ein,
            "[y] yes, save data\n"
            "[n] no, abort"
            );
          if (option==1)
          {
             jn_in_db_schreiben();
          }

       }
   }
   if (strcmp(code,"delete")==0)
   {
     long position;
     position=waehl_journal();
     if (position > -1)
     {
        if (do_delete_yn())
        {
          // wrtxt("\nhier kaeme Loeschen\n");
          delete_journal(position);
        } else
        {
           wrtxt("\n(nothing deleted)\n");
        }
     }
   }
   ks_aufraeumen();

   return 1;
}

int keywords_edit_main(char * code)
{
   /* loop removed May 7, 2005 */
   /*
   static char ein[INPUT_BU_LEN+1];
   int option;
   */
   ks_initialize();
   
   if (strcmp(code,"list")==0)
   {
      list_ky();
      /*
      option = 1;
      while (option!=2)
      {
        list_ky();
        strcpy(ein,"menu");
        wrtxt("\nMenu: continue [y/n]?\n");
        option = menu_wahl(ein,
          "[y] continue to look up keywords\n"
          "[n] no, return to menu `enter, edit, view'"
          );
      }
      */
   }
   if (strcmp(code,"make_keywords_form")==0)
   {
     compile_ky_leer_formular();
   }
   if (strcmp(code,"import")==0)
   {
     if (lies_keywords())
     {
        keywords_speichern();
     }
   }
   /* delete keywords */
   if (strcmp(code,"delete")==0)
   {
     long position;
     position=waehl_keywords();
     if (position > -1)
     {
        if (do_delete_yn())
        {
          delete_keywords(position);
        } else
        {
           wrtxt("\n(nothing deleted)\n");
        }
     }
   }
   
   ks_aufraeumen();
   return 1;
}

int journal_code_bereits_vorhanden(char * code)
{
   quellpix_rec ix02rec_lokal; 
   long ix02zeiger;
   int ok;

   do
   {
     ein_zeile(code,"Please enter journal code",QUELLKUERZEL_LEN);
     if (strlen(code)==0)
     {
       ok = 0;
     } else
     {
       ok = 1;
     }
      
   } while (ok==0);
   read_ix02(quell_pix_name);
   ix02zeiger = locate_ix02(code,&ix02rec_lokal);
   close_ix02();
   if (ix02zeiger==-1)
   {  
      return 0;
   }
   else
   {
      wrtxt("\nJournal code already in database, please select another "
        "one!\n");
      return 1;
   }

}

static int journal_code_eingeben(char * code)
{
   quellpix_rec ix02rec_lokal; 
   long ix02zeiger;
   int ok;

   if (list_jn()==0)
   {
      wrtxt("\n(aborted)\n");
      return 0;
   }
   ok=0;
   do
   {
     ein_zeile(code,"Please enter journal code",QUELLKUERZEL_LEN);
     if (strlen(code)==0)
     {
       int abort_option;
       static char abort_ein[INPUT_BU_LEN + 1];
       strcpy(abort_ein,"menu");
       wrtxt("\nMenu: abort selection of journal code for editing [y/n]?\n");
       
       abort_option = menu_wahl(abort_ein,
         "[y] yes, abort: do not prompt again for journal code\n"
         "[n] no, do not abort: prompt again for journal code");
       if (abort_option==1)
       {
          return 0;
       }
       ok = 0;
     } else
     {
       ok = 1;
     }
      
   } while (ok==0);
   read_ix02(quell_pix_name);
   ix02zeiger = locate_ix02(code,&ix02rec_lokal);
   close_ix02();
   if (ix02zeiger==-1)
   {  
      wrtxt("\nJournal code not found in in database!\n");
      return 0;
   }
   else
   {
      return 1;
   }

}


static int ks_initialize(void)
{
   strlimcpy(ky_txt_name,textpfad,PFAD_LEN);
   strlimcat(ky_txt_name,one_config_set.ky_form_name,PFAD_LEN);
   strlimcpy(jn_txt_name,textpfad,PFAD_LEN);
   strlimcat(jn_txt_name,one_config_set.jn_form_name,PFAD_LEN);

   strlimcpy(tmp02_ix_name,rdbpfad,PFAD_LEN);
   strlimcat(tmp02_ix_name,TMP02_IX,PFAD_LEN);
   
   strlimcpy(dest02_ix_name,rdbpfad,PFAD_LEN);
   strlimcat(dest02_ix_name,DEST02_IX,PFAD_LEN);

   strlimcpy(tmp03_ix_name,rdbpfad,PFAD_LEN);
   strlimcat(tmp03_ix_name,TMP03_IX,PFAD_LEN);
   
   strlimcpy(dest03_ix_name,rdbpfad,PFAD_LEN);
   strlimcat(dest03_ix_name,DEST03_IX,PFAD_LEN);

   if ((in_zeile = (char *) malloc((MAXARR+1) * sizeof(char)))==NULL)
   {
       fprintf(stderr,"\nError: cannot allocate memory for "
               "string (in_zeile in re_edit.c)\n");
       exit(1);
   }
   if ((ex_zeile = (char *) malloc((MAXARR+1) * sizeof(char)))==NULL)
   {
       fprintf(stderr,"\nError: cannot allocate memory for "
               "string (ex_zeile in re_edit.c)\n");
       exit(1);
   }
   return 1;
}

static int ks_aufraeumen(void)
{
    free(in_zeile);
    free(ex_zeile);
    return 1;
}

static int list_ky(void)
{
   char eingabezeile[KEYWORDS_LEN+1];
   char vergleichszeile[KEYWORDS_LEN+1];
   long i;
   long j; /* number of keywords with substring (matching) */
   keylistpix_rec ix_stichw_rec_lokal;
   long anzahl_stichw, byte_zeiger;

   wrtxt("\nList keywords\n");

   j = 0;
   ein_zeile(eingabezeile,"Substring (empty for all keywords)",
     KEYWORDS_LEN);

   if (filesize(stichw_pix_name) < sizeof(ix_stichw_rec_lokal))
   {
      wrtxt("\nNo keywords in file!\n");
      return 0;
   }
   if (read_ix03(stichw_pix_name)==0)
   {
      return 0;
   }
   temptextdatei_oeffnen();

   fseek(ix03file,0L,SEEK_END);
   byte_zeiger = ftell(ix03file);
   anzahl_stichw = byte_zeiger / sizeof(ix_stichw_rec_lokal);
   rewind(ix03file);
   anzahl_stichw--;
   if (strlen(eingabezeile)==0)
   {
     
     // korr. am 31.3.2002
     // for (i=1;i<=anzahl_stichw;i++)
     for (i=0;i<=anzahl_stichw;i++)
     {
        fread(&ix_stichw_rec_lokal,sizeof(ix_stichw_rec_lokal),1,ix03file);
        sprintf(wrtxtbu,"%6li: %s\n",
          // i-1,ix_stichw_rec_lokal.keywordsfield);
          i,ix_stichw_rec_lokal.keywordsfield);
        temptextdatei_schreiben(wrtxtbu);
        j++;
     }
      
   }
   else
   {
     for (i=0;i<=anzahl_stichw;i++)
     {
        fread(&ix_stichw_rec_lokal,sizeof(ix_stichw_rec_lokal),1,ix03file);
        // printf("\n%s",ix_stichw_rec_lokal.keywordsfield);   
        
        upper(eingabezeile);
        strcpy(vergleichszeile,ix_stichw_rec_lokal.keywordsfield);
        upper(vergleichszeile);
        if (is_substring(eingabezeile,vergleichszeile) > 0)
        {
          sprintf(wrtxtbu,"%6li: %s\n",
            // i-1,ix_stichw_rec_lokal.keywordsfield);
            i,ix_stichw_rec_lokal.keywordsfield);
          temptextdatei_schreiben(wrtxtbu);
          j++;
        }
     }
   }
   temptextdatei_schliessen();
   close_ix03();
   if (j > 0)
   {
   vtxt(tempt_name,"View keywords");
   }
   else
   {
      wrtxt("\nNo keyword(s) found in thesaurus\n");
   }
   return 1;
}

static void compile_ky_leer_formular(void)
{
   if ((fptxt=fopen(ky_txt_name,"w"))==NULL)
   {
      sprintf(wrtxtbu,"\nProblem: unable to open `%s' for writing\n",
        ky_txt_name); 
      wrtxt(wrtxtbu);
      return;
   }
   fprintf(fptxt,"%sKEYWORDS-[width:%i]\n%s\n",
     one_config_set.form_label,KEYWORDS_LEN,"");
   fprintf(fptxt,"%sEND-OF-FILE\n",one_config_set.form_label);
   fclose(fptxt);
   sprintf(wrtxtbu,"\n(Empty form written into file `%s')\n",ky_txt_name);
   wrtxt(wrtxtbu);
   load_file_yn(ky_txt_name);
   return;
}

static int lies_keywords(void)
{
   long i;
   int index_vorhanden; /* index file with at least 1 rec exists */
   int eintragen_ok;    /* this is a NEW keyword */
   keylistpix_rec ix03rec_lokal;
   FILE * fptemp;
   
   /* next line introduced for formal reasons 30.06.2002 */
   index_vorhanden = 0;
   /* geaendert 2.7.2002 */
   /*ky_textdatei_oeffnen();*/
   if (!ky_textdatei_oeffnen())
   {
       return 0;
   }
   
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"KEYWORDS-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: Label `%s' not found where expected "
           "in %s\n",id_zeile,ky_txt_name);
         wrtxt(wrtxtbu);
         /* Anfang eingefuegt 9.6.2002 */
         ky_textdatei_schliessen();
         /* Ende eingefuegt 9.6.2002 */
         return 0;
       }
     }
   }
   /* read keywords */
   i = 0;
   if (filesize(stichw_pix_name) >= sizeof(ix03rec))
   {
      index_vorhanden = 1;
      read_ix03(stichw_pix_name);
   }
   if ((fptemp=fopen(tmp03_ix_name,"wb"))==NULL)
   {
      fprintf(stderr,"\nError: cannot write into %s\n",tmp03_ix_name); 
      exit(1);
   }
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     i++;
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"END-OF-FILE",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         if (i==1)
         {
            wrtxt("\n(No keywords line found)");
         }
         /* all lines of title have been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: list of keywords not closed with `%s' "
           "in %s\n",id_zeile,ky_txt_name);
         wrtxt(wrtxtbu);
         /* next lines before 'return' introduced 3.7.2002 */
         if (index_vorhanden==1)
         {
           close_ix03();
         }
         fclose(fptemp);
         ky_textdatei_schliessen();
         return 0;
       }
     }
     rtrim(in_zeile,'\n');
     rtrim(in_zeile,' ');
     /* save keywords */
     if (strlen(in_zeile) > 0)
     {
        memset(&ix03rec,0,sizeof(ix03rec));
        memset(&ix03rec_lokal,0,sizeof(ix03rec_lokal));
        strlimcpy(ix03rec.keywordsfield,in_zeile,KEYWORDS_LEN);
        if (index_vorhanden==0)
        {
           eintragen_ok = 1;  
        } else /* index exists */
        {
          if (locate_ix03(ix03rec.keywordsfield,&ix03rec_lokal)==-1)
          {
             eintragen_ok = 1;
          } else
          {
             eintragen_ok = 0;
          }
        }
        
        if (eintragen_ok==1)
        {
          sprintf(wrtxtbu,"\n(`%s' new keyword, will be entered)",
            ix03rec.keywordsfield);
          wrtxt(wrtxtbu);
          if (fwrite(&ix03rec,sizeof(ix03rec),1,fptemp) < 1) schreibfehler();
          /* write into temporary file */
        }
        else 
        {
           sprintf(wrtxtbu,"\n(`%s' already in file, will be ignored)",
             ix03rec.keywordsfield);
           wrtxt(wrtxtbu);
        }
        strcpy(in_zeile,""); 
     } else
     {
        wrtxt("\n(Empty input line, ignored)");
     }
     
     /* completed: save keywords  */
   }
   fclose(fptemp);
   if (index_vorhanden==1)
   {
     close_ix03();
   }
   /* completed: read keywords */
   /* printf("%s\n",in_zeile); */
   wrtxt(in_zeile);
   wrtxt("\n");
   ky_textdatei_schliessen();
   return 1;
}

static int ky_textdatei_oeffnen(void)
{
   if ((fptxt=fopen(ky_txt_name,"r"))==NULL)
   {
     sprintf(wrtxtbu,"\nProblem: unable to read %s\n"
           "(probably file does not exist)\n",ky_txt_name);
     wrtxt(wrtxtbu);
     return 0;
   }
   return 1;
}

static int ky_textdatei_schliessen(void)
{
   fclose(fptxt);
   return 1;
}

static int keywords_speichern(void)
{
  FILE * fpdat;
  FILE * fpix;
  FILE * fpix_dest;
  long rptr, rptr_initial; /* record pointer */
  long i, anzahl_records;
  keylistpix_rec ix03rec_lokal;
  
  if (isfile(dest03_ix_name))
  {
     remove(dest03_ix_name);
  }
  /* remove duplicate records in tmp03_ix_name */
  if (isfile(tmp03_ix_name))
  {
     if (filesize(tmp03_ix_name) < sizeof(ix03rec))
     {
        /* keywords will not be stored */
        remove(tmp03_ix_name);
        return 0;
     }
     if (filesize(tmp03_ix_name) > sizeof(ix03rec))
     {
        /* sort */
        domerge03(tmp03_ix_name,dest03_ix_name);
        if (isfile(tmp03_ix_name))
        {
           remove(tmp03_ix_name);
        }
        rename(dest03_ix_name,tmp03_ix_name);
        /* remove duplicate entries */
        dupl_ex_ix03(tmp03_ix_name,dest03_ix_name);
        if (isfile(tmp03_ix_name))
        {
           remove(tmp03_ix_name);
        }
        rename(dest03_ix_name,tmp03_ix_name);
     }
  }
  /* determine record pointer */
  if (!isfile(stichw_name))
  {
     rptr = 0;
     rptr_initial = 0;
     /* create stichw_name */
     if ((fpdat=fopen(stichw_name,"wb"))==NULL)
     {
         fprintf(stderr,"\nError: cannot create %s (keywords_speichern())\n",
           stichw_name);
         exit(1);
     }
     fclose(fpdat);
  } else
  {
    if ((fpdat=fopen(stichw_name,"rb"))==NULL)
    {
        fprintf(stderr,"\nError: cannot read %s (keywords_speichern())\n",
          stichw_name);
        exit(1);
    }
    fseek(fpdat,0L,SEEK_END);
    rptr = ftell(fpdat)/sizeof(keylist_rec);
    rptr_initial = rptr;
    fclose(fpdat);
  }
  /* completed: determine record pointer */
  /* determine anzahl_records in tmp03_ix_name */
  if ((fpix=fopen(tmp03_ix_name,"rb"))==NULL)
  {
      fprintf(stderr,"\nError: cannot read %s (keywords_speichern())\n",
        tmp03_ix_name);
      exit(1);
  }
  fseek(fpix,0L,SEEK_END);
  anzahl_records = ftell(fpix)/sizeof(ix03rec);
  anzahl_records--;
  fclose(fpix);
  /* completed: determine anzahl_records in tmp03_ix_name */
  
  
 
  /*
  Datendatei oeffnen, Zeiger ans Ende setzen, schreiben, Indexdatensaetze
  schreiben, Indexdateien `mergen'
  */
  /* temporary index file to be read */
  if ((fpix=fopen(tmp03_ix_name,"rb"))==NULL)
  {
      fprintf(stderr,"\nError: cannot read %s (keywords_speichern())\n",
        tmp03_ix_name);
      exit(1);
  }
  /* temporary index file to be created */
  if ((fpix_dest=fopen(dest03_ix_name,"wb"))==NULL)
  {
      fprintf(stderr,"\nError: cannot create %s (keywords_speichern())\n",
        dest03_ix_name);
      exit(1);
  }
  /* data file */
  if ((fpdat=fopen(stichw_name,"r+b"))==NULL)
  {
      fprintf(stderr,"\nError: cannot write into %s (keywords_speichern())\n",
        stichw_name);
      exit(1);
  }
  fseek(fpdat,0L,SEEK_END);
  if ((ftell(fpdat)/sizeof(keylist_rec))!=rptr)
  {
     wrtxt("\n**** Error: wrong position in dat file!!!\n");
     return 0;
  }
  rewind(fpix);
  for (i=0;i<=anzahl_records;i++)
  {
     fread(&ix03rec_lokal,sizeof(ix03rec_lokal),1,fpix);
     
     /* write dat file */
     memset(&one_stichw_rec,0,sizeof(one_stichw_rec));
     strlimcpy(one_stichw_rec.keywordsfield,
       ix03rec_lokal.keywordsfield,
       KEYWORDS_LEN);
     one_stichw_rec.in_use = 1; 
     if (fwrite(&one_stichw_rec,sizeof(one_stichw_rec),1,fpdat)!=1)
     {
        fprintf(stderr,"\nError: unable to write into %s\n",
          stichw_name);
        exit(1);
     }
     
     /* write index file record */
     memset(&ix03rec,0,sizeof(ix03rec));
     strlimcpy(ix03rec.keywordsfield,
       ix03rec_lokal.keywordsfield,
       KEYWORDS_LEN);
     ix03rec.keywords_rptr = rptr;
     if (fwrite(&ix03rec,sizeof(ix03rec),1,fpix_dest)!=1)
     {
        fprintf(stderr,"\nError: unable to write into %s\n",
          dest03_ix_name);
        exit(1);
     }
     rptr++;
     // printf("%s\n",ix03rec.keywordsfield);
  }
  fclose(fpdat);
  fclose(fpix);
  fclose(fpix_dest);

  
  if (isfile(tmp03_ix_name))
  {
     remove(tmp03_ix_name);
  }
  rename(dest03_ix_name,tmp03_ix_name);
  mrgeix03(stichw_pix_name,tmp03_ix_name,dest03_ix_name);
  remove(stichw_pix_name);
  rename(dest03_ix_name,stichw_pix_name);
  // 31.3.2002: hier tmp03_ix_name loeschen!
  if (isfile(tmp03_ix_name))
  {
     remove(tmp03_ix_name);
  }
  // Ende 31.3.2002

  wrtxt("\n(Completed)\n");
  return 1;
}

static int dupl_ex_ix03(char * src_name, char * destin_name)
{
   FILE * fpsrc;
   FILE * fpdestin;
   long i, anzahl_records;
   keylistpix_rec one_ix03_rec;
   char keywordsfield_alt[KEYWORDS_LEN+1];
  
   if (!isfile(src_name))
   {
      fprintf(stderr,"\nError: cannot find %s (dupl_ex_ix03())\n",src_name);
      exit(1);
   }
   if (filesize(src_name) < 2*sizeof(one_ix03_rec)) /* one record only in
                                                       src_name */
   {
      if (isfile(destin_name))
      {
        remove(destin_name);
      }
      rename(src_name,destin_name);
      return 1;
   }
   if ((fpsrc=fopen(src_name,"rb"))==NULL) 
   {
      fprintf(stderr,"\nError: cannot read %s (dupl_ex_ix03())\n",src_name);
      exit(1);
   }
   if ((fpdestin=fopen(destin_name,"wb"))==NULL)
   {
      fprintf(stderr,"\nError: cannot create %s (dupl_ex_ix03())\n",src_name);
      exit(1);
   }
   strcpy(keywordsfield_alt,"");
   memset(&one_ix03_rec,0,sizeof(one_ix03_rec));
   fseek(fpsrc,0L,SEEK_END);
   ftell(fpsrc);
   anzahl_records = ftell(fpsrc)/sizeof(one_ix03_rec);
   rewind(fpsrc);
   for (i=1;i<=anzahl_records;i++)
   {
      if (fread(&one_ix03_rec,sizeof(one_ix03_rec),1,fpsrc)==0)
      {
         sprintf(wrtxtbu,"\nProblem: record not read in %s\n",src_name);
         wrtxt(wrtxtbu);
         fclose(fpsrc);
         fclose(fpdestin);
         return 0;
      }
      if (strcmp(keywordsfield_alt,one_ix03_rec.keywordsfield)!=0)
      {
         if (fwrite(&one_ix03_rec,sizeof(one_ix03_rec),1,fpdestin) < 1) schreibfehler();
      }
      strlimcpy(keywordsfield_alt,one_ix03_rec.keywordsfield,KEYWORDS_LEN);
   }
   fclose(fpsrc);
   fclose(fpdestin);
   return 1;
}

static int list_jn(void)
{
   char eingabezeile[ZEITSCHRIFT_LEN + 1];
   char vergleichszeile[ZEITSCHRIFT_LEN + 1];
   long i;
   long j; /* number of journals with substring (matching) */
   quellpix_rec quellpix_rec_lokal;
   /* quell_rec */
   long anzahl_journals, byte_zeiger;
   FILE * dat_quell;

   wrtxt("\nList journal data\n");

   j = 0;

   ein_zeile(eingabezeile,"Substring (empty for all journal names)",
     ZEITSCHRIFT_LEN);
   if (filesize(quell_pix_name) < sizeof(quellpix_rec_lokal))
   {
      wrtxt("\nNo journal data in file\n");
      return 0;
   }
   if (read_ix02(quell_pix_name)==0)
   {
      return 0;
   }
   fseek(ix02file,0L,SEEK_END);
   byte_zeiger = ftell(ix02file);
   anzahl_journals = byte_zeiger / sizeof(quellpix_rec_lokal);
   rewind(ix02file);
   anzahl_journals--;
   if ((dat_quell=fopen(quell_name,"rb"))==NULL)
   {
      fprintf(stderr,"\nError: cannot read %s\n",quell_name);
      exit(1);
   }
   
   temptextdatei_oeffnen();

   if (strlen(eingabezeile)==0) /* no substring entered */
   {
      // for (i=1;i<=anzahl_journals;i++)
      for (i=0;i<=anzahl_journals;i++)
      {
         if (j>0)
         {
           temptextdatei_schreiben("\n");
         }
         fread(&quellpix_rec_lokal,sizeof(quellpix_rec_lokal),1,ix02file);
         // sprintf(wrtxtbu,"Code:%li")
         byte_zeiger=quellpix_rec_lokal.quell_rptr * sizeof(one_quell_rec);
         fseek(dat_quell,byte_zeiger,SEEK_SET);
         fread(&one_quell_rec,sizeof(one_quell_rec),1,dat_quell);
         sprintf(wrtxtbu,
           "No: %li\n"
           "Code: %s\n"
           "Journal name: %s\n"
           "Journal name (short form): %s\n"
           "ISSN: %s\n",
           i,
           one_quell_rec.quell_kuerzel,
           one_quell_rec.quell_zeitschrift,
           one_quell_rec.quell_kurzform,
           one_quell_rec.quell_issn);
         temptextdatei_schreiben(wrtxtbu);
         j++;

      }
   }
   else
   {
      // for (i=1;i<=anzahl_journals;i++)
      for (i=0;i<=anzahl_journals;i++)
      {
         fread(&quellpix_rec_lokal,sizeof(quellpix_rec_lokal),1,ix02file);
         // sprintf(wrtxtbu,"Code:%li")
         byte_zeiger=quellpix_rec_lokal.quell_rptr * sizeof(one_quell_rec);
         fseek(dat_quell,byte_zeiger,SEEK_SET);
         fread(&one_quell_rec,sizeof(one_quell_rec),1,dat_quell);
         upper(eingabezeile);
         strlimcpy(vergleichszeile,one_quell_rec.quell_zeitschrift,ZEITSCHRIFT_LEN);
         upper(vergleichszeile);
         if (is_substring(eingabezeile,vergleichszeile) > 0)
         {
           if (j>0)
           {
             temptextdatei_schreiben("\n");
           }
           sprintf(wrtxtbu,
             "No: %li\n"
             "Code: %s\n"
             "Journal name: %s\n"
             "Journal name (short form): %s\n"
             "ISSN: %s\n",
             i,
             one_quell_rec.quell_kuerzel,
             one_quell_rec.quell_zeitschrift,
             one_quell_rec.quell_kurzform,
             one_quell_rec.quell_issn);

           temptextdatei_schreiben(wrtxtbu);
           j++;
         }
      }
   }

   temptextdatei_schliessen();
   fclose(dat_quell);
   close_ix02();
   if (j > 0)
   {
      vtxt(tempt_name,"View journal data");
   } else
   {
      sprintf(wrtxtbu,"\nNo journal data for substring `%s' "
        "found in database\n",eingabezeile);
      wrtxt(wrtxtbu);
      return 0;
   }
   return 1;
}

static void compile_jn_leer_formular(char * journal_code)
{
   char zeile[QUELLKUERZEL_LEN+1];
   
   strlimcpy(zeile,journal_code,QUELLKUERZEL_LEN);

   if ((fptxt=fopen(jn_txt_name,"w"))==NULL)
   {
      sprintf(wrtxtbu,"\nProblem: unable to open `%s' for writing\n",
        jn_txt_name); 
      wrtxt(wrtxtbu);
      return;
   }
   fprintf(fptxt,"%sJOURNAL-CODE-[width:%i]\n%s\n",
     one_config_set.form_label,QUELLKUERZEL_LEN,zeile);
   fprintf(fptxt,"%sCOMPLETE-JOURNAL-NAME-[width:%i]\n%s\n",
     one_config_set.form_label,ZEITSCHRIFT_LEN,"");
   fprintf(fptxt,"%sJOURNAL-SHORT-NAME-[width:%i]\n%s\n",
     one_config_set.form_label,KURZFORM_LEN,"");
   fprintf(fptxt,"%sISSN-[width:%i]\n%s\n",
     one_config_set.form_label,ISSN_LEN,"");
   fprintf(fptxt,"%sEND-OF-FILE\n",one_config_set.form_label);

   fclose(fptxt);
   sprintf(wrtxtbu,"\n(Empty form written into file `%s')\n",jn_txt_name);
   wrtxt(wrtxtbu);
   load_file_yn(jn_txt_name);
      
   return;
}

static void  compile_jn_formular(char * journal_code)
{
   FILE * dat_quell;
   long  byte_zeiger;
   quellpix_rec quellpix_rec_lokal;
   char zeile[QUELLKUERZEL_LEN+1];
   
   strlimcpy(zeile,journal_code,QUELLKUERZEL_LEN);
   
   if (filesize(quell_pix_name) < sizeof(quellpix_rec_lokal))
   {
      fprintf(stderr,"\nError: No journal data in file\n");
      exit(1);
   }
   if (read_ix02(quell_pix_name)==0)
   {
      fprintf(stderr,"\nError: Unable to read %s\n",quell_pix_name);
      exit(1);
   }

   /* --- */
   if ((fptxt=fopen(jn_txt_name,"w"))==NULL)
   {
      sprintf(wrtxtbu,"\nProblem: unable to open `%s' for writing\n",
        jn_txt_name); 
      wrtxt(wrtxtbu);
      return;
   }
   if ((dat_quell=fopen(quell_name,"rb"))==NULL)
   {
      fprintf(stderr,"\nError: cannot read %s\n",quell_name);
      exit(1);
   }
   if (locate_ix02(journal_code,&quellpix_rec_lokal)==-1)
   {
      fprintf(stderr,"\nError:  Journal code `%s' not found\n",journal_code);
      exit(1);
   }
   /// hier die Daten auslesen! 
   byte_zeiger=quellpix_rec_lokal.quell_rptr * sizeof(one_quell_rec);
   fseek(dat_quell,byte_zeiger,SEEK_SET);
   fread(&one_quell_rec,sizeof(one_quell_rec),1,dat_quell);

   fprintf(fptxt,"%sJOURNAL-CODE-[width:%i]\n%s\n",
     one_config_set.form_label,QUELLKUERZEL_LEN,zeile);
   fprintf(fptxt,"%sCOMPLETE-JOURNAL-NAME-[width:%i]\n%s\n",
     one_config_set.form_label,ZEITSCHRIFT_LEN,
     one_quell_rec.quell_zeitschrift);
   fprintf(fptxt,"%sJOURNAL-SHORT-NAME-[width:%i]\n%s\n",
     one_config_set.form_label,KURZFORM_LEN,
     one_quell_rec.quell_kurzform);
   fprintf(fptxt,"%sISSN-[width:%i]\n%s\n",
     one_config_set.form_label,ISSN_LEN,
     one_quell_rec.quell_issn);
   fprintf(fptxt,"%sEND-OF-FILE\n",one_config_set.form_label);

   fclose(dat_quell);
   close_ix02();
   fclose(fptxt);
   
   sprintf(wrtxtbu,"\n(Journal data of `%s' written into file `%s')\n",
     one_quell_rec.quell_kuerzel,
     jn_txt_name);
   wrtxt(wrtxtbu);
   load_file_yn(jn_txt_name);
      
   return;
}


static int jn_textdatei_oeffnen(void)
{
   if ((fptxt=fopen(jn_txt_name,"r"))==NULL)
   {
     sprintf(wrtxtbu,"\nProblem: unable to read %s\n"
           "(probably file does not exist)\n",jn_txt_name);
     wrtxt(wrtxtbu);
     return 0;
   }
   return 1;
}

static int jn_textdatei_schliessen(void)
{
   fclose(fptxt);
   return 1;
}


static int zeitschrift_textdatei_lesen(void)
{
   memset(&one_quell_rec,0,sizeof(one_quell_rec)); 

   if (!jn_textdatei_oeffnen())
   {
      return 0;
   }
   /*--*/
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
     strlimcat(id_zeile,"JOURNAL-CODE-",ID_ZEILE_LEN);
     if (locate_substring(id_zeile,in_zeile)==0)
     {
       strcpy(in_zeile,"");
       break;
     }
   }
   /* read journal code */
   if (fgets(in_zeile,MAXARR,fptxt)==NULL)
   {
     sprintf(wrtxtbu,"\nProblem: cannot read "
       "journal code in %s\n",jn_txt_name);
     wrtxt(wrtxtbu);
     jn_textdatei_schliessen();
     return 0;
   }
   rtrim(in_zeile,'\n');
   strlimcpy(one_quell_rec.quell_kuerzel,in_zeile,QUELLKUERZEL_LEN);
   /* end: read journal code */
  
   /* proceed to label COMPLETE-JOURNAL-NAME-  */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"COMPLETE-JOURNAL-NAME-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,"");
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: Label `%s' not found where expected "
           "in %s\n",id_zeile,jn_txt_name);
         wrtxt(wrtxtbu);
         jn_textdatei_schliessen();
         return 0;
       }
     }
   }

   /* read journal name */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"JOURNAL-SHORT-NAME-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* journal name has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: journal name not closed with `%s' "
           "in %s\n",id_zeile,jn_txt_name);
         wrtxt(wrtxtbu);
         jn_textdatei_schliessen();
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,ZEITSCHRIFT_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_quell_rec.quell_zeitschrift,ex_zeile,ZEITSCHRIFT_LEN);
   /* end: read journal name */
   /* read journal short name */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"ISSN-",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* ISSN has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: journal short name not closed with `%s' "
           "in %s\n",id_zeile,jn_txt_name);
         wrtxt(wrtxtbu);
         jn_textdatei_schliessen();
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,KURZFORM_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_quell_rec.quell_kurzform,ex_zeile,KURZFORM_LEN);
   /* end: read journal short name */
   /* read ISSN name */
   while (fgets(in_zeile,MAXARR,fptxt)!=NULL)
   {
     if(locate_substring(one_config_set.form_label,in_zeile)==0)
     {
       strlimcpy(id_zeile,one_config_set.form_label,ID_ZEILE_LEN);
       strlimcat(id_zeile,"END-OF-FILE",ID_ZEILE_LEN);
       if (locate_substring(id_zeile,in_zeile)==0)
       {
         strcpy(in_zeile,""); 
         /* ISSN has been read */
         break;
       }
       else
       {
         sprintf(wrtxtbu,"\nProblem: journal short name not closed with `%s' "
           "in %s\n",id_zeile,jn_txt_name);
         wrtxt(wrtxtbu);
         jn_textdatei_schliessen();
         return 0;
       }
     }
     strlimcpy(ex_zeile,in_zeile,ISSN_LEN);
   }
   rtrim(ex_zeile,'\n');
   rtrim(ex_zeile,' ');
   strlimcpy(one_quell_rec.quell_issn,ex_zeile,ISSN_LEN);
   /* end: read ISSN name */
   jn_textdatei_schliessen();

   sprintf(wrtxtbu,"\nJournal code: %s\nJournal: %s\nShort name: %s\nISSN: %s\n",
     one_quell_rec.quell_kuerzel,
     one_quell_rec.quell_zeitschrift,
     one_quell_rec.quell_kurzform,
     one_quell_rec.quell_issn);
   wrtxt(wrtxtbu);
   return 1;
}

static int jn_in_db_schreiben(void)
{
    quellpix_rec ix_quell_rec_lokal;
    /* ix02rec one_quell_rec */
    long ix_zeiger, rec_zeiger, byte_zeiger, byte_zeiger_alt;
    FILE * dat_quell;
    FILE * fptemp;

    byte_zeiger_alt = 1;
    if (strlen(one_quell_rec.quell_kuerzel) == 0)
    {
       wrtxt("\nJournal code not defined\n");
       return 0;
    }
    
    memset(&ix02rec,0,sizeof(ix02rec));
    strlimcpy(ix02rec.quell_kuerzel,
      one_quell_rec.quell_kuerzel,
      QUELLKUERZEL_LEN);
    one_quell_rec.in_use_quell = 1;
    
    if (filesize(quell_pix_name) < sizeof(ix_quell_rec_lokal))
    {
       ix_zeiger = -1;
    } else
    {
       read_ix02(quell_pix_name);
       ix_zeiger = locate_ix02(one_quell_rec.quell_kuerzel, 
         &ix_quell_rec_lokal);
       close_ix02();
    }
    
    if ((dat_quell=fopen(quell_name,"r+b"))==NULL)
    {
       fprintf(stderr,"\nERROR: Cannot write into %s\n",quell_name);
       exit(1);
    }
    if (ix_zeiger > -1)
    {
        byte_zeiger_alt = ix_quell_rec_lokal.quell_rptr * sizeof(quell_rec);
    }
    if (ix_zeiger==-1) /* a NEW record */
    {
       fseek(dat_quell,0L,SEEK_END);
       byte_zeiger = ftell(dat_quell);
       rec_zeiger = byte_zeiger/sizeof(one_quell_rec);
       if (fwrite(&one_quell_rec,sizeof(one_quell_rec),1,dat_quell) < 1) schreibfehler();
       // fclose(dat_quell); // geaendert v4.2-v4.2a
       ix02rec.quell_rptr = rec_zeiger;
    }
    else
    {
       fseek(dat_quell,byte_zeiger_alt,SEEK_SET);
       if (fwrite(&one_quell_rec,sizeof(one_quell_rec),1,dat_quell) < 1) schreibfehler();
       ix02rec.quell_rptr = ix_quell_rec_lokal.quell_rptr;
    }

    fclose(dat_quell); 
    // in temporaere Datei schreiben, mergen
    
    if (ix_zeiger == -1) /* This is a new record, update index file */
    {
       if ((fptemp=fopen(tmp02_ix_name,"wb"))==NULL)
       {
           fprintf(stderr,"\nERROR: Cannot create %s\n",tmp02_ix_name);
           exit(1);
       }
       if (fwrite(&ix02rec,sizeof(ix02rec),1,fptemp) < 1) schreibfehler();
       fclose(fptemp);
        
       if (isfile(quell_pix_name))
       {
         if (filesize(quell_pix_name)==0) remove(quell_pix_name);
       }

       if (!isfile(quell_pix_name))
       {
           // rename(tmpix_name,quell_pix_name);
           rename(tmp02_ix_name,quell_pix_name);
       }
       else
       {
           // mrgeix02(quell_pix_name,tmpix_name,"tmp02.ix$");
           mrgeix02(quell_pix_name,tmp02_ix_name,dest02_ix_name);
           // remove(quell_pix_name);remove(tmpix_name);
           remove(quell_pix_name);remove(tmp02_ix_name);
           // rename("tmp02.ix$",quell_pix_name);
           rename(dest02_ix_name,quell_pix_name);
       }
    }
    // wrtxt("!!! geschrieben");
    wrtxt("\n(Completed)\n");
    return 1;
}

static long waehl_keywords(void)
{
   char zahlstring[ZAHLSTRING_LEN+1];
   int ok, schleifenende;
   long rwert;
   long ix_groesse; /*  */
   
   ix_groesse = filesize(stichw_pix_name)/sizeof(ix03rec);

   if (ix_groesse <= 3)
   {
     sprintf(wrtxtbu,"\n(Thesaurus too small (<= records))\n");
     wrtxt(wrtxtbu);
     return -1;
   }
   list_ky();
   ok = 0;
   schleifenende=0;
   do
   {
      sprintf(wrtxtbu,"Please select keyword number [%li .. %li]",0L,ix_groesse-1);
      ein_zeile(zahlstring,wrtxtbu,ZAHLSTRING_LEN);
      if (strlen(zahlstring)==0)
      {
        wrtxt("\n(aborted)\n");
        return -1;
      }
      string_in_long(zahlstring,&rwert,&ok);
      if (ok)
      {
         if ((rwert >= 0) && (rwert <= (ix_groesse - 1)))
         {
            schleifenende = 1;
         }
      }
   } while(!schleifenende);
   return rwert;
}


static int delete_keywords(long ix_zeiger)
{
   keylistpix_rec     ix_stichw_rec_lokal;
   keylist_rec        one_stichw_rec_lokal;
   long rec_zeiger, byte_zeiger;
   FILE * dat_stichw;
   FILE * tmpix;
   
   read_ix03(stichw_pix_name);
   byte_zeiger = ix_zeiger * sizeof(ix_stichw_rec_lokal);
   fseek(ix03file,byte_zeiger,SEEK_SET);
   fread(&ix_stichw_rec_lokal,sizeof(ix_stichw_rec_lokal),1,ix03file);
   close_ix03();

   rec_zeiger = ix_stichw_rec_lokal.keywords_rptr;
   byte_zeiger = rec_zeiger * sizeof(one_stichw_rec_lokal);

   if ((dat_stichw=fopen(stichw_name,"r+b"))==NULL)
   {
      fprintf(stderr,"\nERROR: Cannot write into %s\n",stichw_name);
      exit(1);
   }
   fseek(dat_stichw,byte_zeiger,SEEK_SET);
   fread(&one_stichw_rec_lokal,sizeof(one_stichw_rec_lokal),1,dat_stichw);
   one_stichw_rec_lokal.in_use = 0;
   fseek(dat_stichw,byte_zeiger,SEEK_SET);
   if (fwrite(&one_stichw_rec_lokal,sizeof(one_stichw_rec_lokal),1,dat_stichw) < 1) schreibfehler();
   fclose(dat_stichw);

   //if ((tmpix = fopen(tmpix_name,"wb"))==NULL)
   if ((tmpix = fopen(tmp03_ix_name,"wb"))==NULL)
   {
     fprintf(stderr,"\nERROR: Cannot create %s\n",tmp03_ix_name);
     exit(1);
   }
   if (fwrite(&ix_stichw_rec_lokal,sizeof(ix_stichw_rec_lokal),1,tmpix) < 1) schreibfehler();
   fclose(tmpix);

   // deleteix03(stichw_pix_name,tmpix_name,newix_name);
   deleteix03(stichw_pix_name,tmp03_ix_name,dest03_ix_name);
   // remove(stichw_pix_name); remove(tmpix_name);
   remove(stichw_pix_name); remove(tmp03_ix_name);
   // rename(newix_name,stichw_pix_name);
   rename(dest03_ix_name,stichw_pix_name);
   sprintf(wrtxtbu,"\n(item `%s' deleted)\n",one_stichw_rec_lokal.keywordsfield);
   wrtxt(wrtxtbu);
   sprintf(wrtxtbu,"Item `%s'\n  in keywords-thesaurus deleted",
     one_stichw_rec_lokal.keywordsfield);
   protokollieren(wrtxtbu);
   return 1;
}

static long waehl_journal(void)
{
    char zahlstring[ZAHLSTRING_LEN+1];
    int ok, schleifenende;
    long rwert;
    long ix_groesse; /*  */

    ix_groesse = filesize(quell_pix_name)/sizeof(ix02rec);

    if (ix_groesse <= 3)
    {
      sprintf(wrtxtbu,"\n(Journal names database too small "
        "(3 <= records))\n");
      wrtxt(wrtxtbu);
      return -1;
    }
    list_jn();
    ok = 0;
    schleifenende=0;
    do
    {
       sprintf(wrtxtbu,"Please select journal number [%li .. %li]",0L,ix_groesse-1);
       ein_zeile(zahlstring,wrtxtbu,ZAHLSTRING_LEN);
       if (strlen(zahlstring)==0)
       {
         wrtxt("\n(aborted)\n");
         return -1;
       }
       string_in_long(zahlstring,&rwert,&ok);
       if (ok)
       {
          if ((rwert >= 0) && (rwert <= (ix_groesse - 1)))
          {
             schleifenende = 1;
          }
       }
    } while(!schleifenende);
    return rwert;
    
}

static int delete_journal(long ix_zeiger)
{
    FILE * tmpix;
    FILE * dat_quell;
    quellpix_rec        ix_quell_rec_lokal;
    quell_rec           one_quell_rec_lokal;
    long rec_zeiger, byte_zeiger;

    read_ix02(quell_pix_name);
    byte_zeiger = ix_zeiger * sizeof(ix_quell_rec_lokal);
    fseek(ix02file,byte_zeiger,SEEK_SET);
    fread(&ix_quell_rec_lokal,sizeof(ix_quell_rec_lokal),1,ix02file);
    close_ix02();

    rec_zeiger = ix_quell_rec_lokal.quell_rptr;
    byte_zeiger = rec_zeiger * sizeof(one_quell_rec_lokal);
    if ((dat_quell=fopen(quell_name,"r+b"))==NULL)
    {
       fprintf(stderr,"\nERROR: Cannot read/write file %s\n",quell_name);
       exit(1);
    }
    fseek(dat_quell,byte_zeiger,SEEK_SET);
    fread(&one_quell_rec_lokal,sizeof(one_quell_rec_lokal),1,dat_quell);
    one_quell_rec_lokal.in_use_quell = 0;
    fseek(dat_quell,byte_zeiger,SEEK_SET);
    if (fwrite(&one_quell_rec_lokal,sizeof(one_quell_rec_lokal),1,dat_quell) < 1) schreibfehler();
    fclose(dat_quell);
    // if ((tmpix = fopen(tmpix_name,"wb"))==NULL)
    if ((tmpix = fopen(tmp02_ix_name,"wb"))==NULL)
    {
        fprintf(stderr,"\nERROR: Cannot create %s\n",tmp02_ix_name);
        exit(1);
    }
    if (fwrite(&ix_quell_rec_lokal,sizeof(ix_quell_rec_lokal),1,tmpix) < 1) schreibfehler();
    fclose(tmpix);
    // deleteix02(quell_pix_name,tmpix_name,newix_name);
    deleteix02(quell_pix_name,tmp02_ix_name,dest02_ix_name);
    // remove(quell_pix_name); remove(tmpix_name);
    remove(quell_pix_name); remove(tmp02_ix_name);
    // rename(newix_name,quell_pix_name);
    rename(dest02_ix_name,quell_pix_name);
    sprintf(wrtxtbu,"\n(item `%s' deleted)\n",one_quell_rec_lokal.quell_zeitschrift);
    wrtxt(wrtxtbu);
    sprintf(wrtxtbu,"Item `%s'\n  in journal names table deleted",
      one_quell_rec_lokal.quell_zeitschrift);
    protokollieren(wrtxtbu);

    return 1;
}

