#!/bin/sh
# original mktextfm -- make a new TFM file, because one wasn't found.
# 
# (If you change or delete the word `original' on the previous line,
# installation won't write this script over yours.)
# 
# te@informatik.uni-hannover.de, kb@mail.tug.org, and infovore@xs4all.nl.
# Public domain.

version='$Id: mktextfm,v 1.17 1998/02/16 08:56:13 olaf Exp $'
progname=`echo $0 | sed 's%.*/%%'`
usage="Usage: $progname [--destdir DESTDIR] FONT.

Makes a TFM file for FONT, if possible. Use DESTDIR for the root of where
to install into, either the absolute directory name to use (if it starts
with a /) or relative to the default DESTDIR (if not)."

# Handle non-positional options, except for --version/--help
while test $# -gt 0; do
  case "$1" in
    --destdir) shift; DEST="$1"; shift ;;
    --version|-version) break ;;
    --help|-help) break ;;
    *) break ;;
  esac
done

# Common code for all scripts.
: ${MT_TEXMFMAIN=`kpsewhich --expand-path='$TEXMFMAIN'`}
: ${MT_MKTEX_OPT=`kpsewhich --format='web2c files' mktex.opt`}
test -n "$MT_MKTEX_OPT" || MT_MKTEX_OPT="$MT_TEXMFMAIN/web2c/mktex.opt"
if test ! -f "$MT_MKTEX_OPT"; then
  echo "$progname: Cannot find mktex.opt; check your installation." >&2
  exit 1
fi

. "$MT_MKTEX_OPT"

# start of redirection stdout -> stderr, stdin <- /dev/null
(

NAME=`basename "$1" .tfm`
MAG=1
#DEST="$2"
DPI=$BDPI

OIFS=$IFS; IFS=$SEP
set x `"$MT_MKTEXNAM" $NAME $DPI $MODE $DEST`; shift
IFS=$OIFS

PKDEST="$1"
TFMDEST="$2"
PKDESTDIR=`echo "$PKDEST" | sed 's%/[^/][^/]*$%%'` # can't rely on dirname
TFMDESTDIR=`echo "$TFMDEST" | sed 's%/[^/][^/]*$%%'`
PKNAME=`basename "$PKDEST"`
TFMNAME=$NAME.tfm
GFNAME=$NAME.$DPI'gf'

if test -r "$TFMDESTDIR/$TFMNAME"; then
  echo "$progname: $TFMDESTDIR/$TFMNAME already exists." >&2
  echo "$TFMDESTDIR/$TFMNAME" >$STDOUT
  "$MT_MKTEXUPD" "$TFMDESTDIR" $TFMNAME
  exit
fi

# Try to create the destdir first. Do not create fonts, if this fails.
"$MT_MKTEXDIR" "$TFMDESTDIR"
if test ! -d "$TFMDESTDIR"; then
  echo "$progname: mktexdir $TFMDESTDIR failed."
  exit 1
fi

cmd="mf \mode:=$MODE; mag:=$MAG; nonstopmode; input $NAME"
echo "$progname: Running $cmd"

$cmd </dev/null || {
  grep '^!' $NAME.log >$$.errs 2>/dev/null
  grep '^! Strange path' $$.errs >$$.strange 2>/dev/null
  if cmp $$.errs $$.strange >/dev/null 2>&1 \
    && test -s $$.strange >/dev/null 2>&1; then
    echo "$progname: warning: \`$cmd' caused strange path errors." >&2
  else
    echo "$progname: \`$cmd' failed." >&2
    test -s $NAME.log && mv -f $NAME.log "$KPSE_DOT"
    exit 1;
  fi
}

test -r $TFMNAME || { echo "$progname: \`$cmd' failed to make $TFMNAME."; exit 1; }

# Install the TFM file carefully, since others may be working simultaneously.
# Use cp when mv fails, since DOS will fail mv for deeply-nested directories.
mv $TFMNAME "$TFMDESTDIR/tfm$$.tmp" 2>/dev/null \
  || cp $TFMNAME "$TFMDESTDIR/tfm$$.tmp" || exit 1
cd "$TFMDESTDIR" || exit 1
chmod `kpsestat -xst,go-w .` tfm$$.tmp
test -r $TFMNAME || mv tfm$$.tmp $TFMNAME || exit 1

# OK, success with the TFM.
"$MT_MKTEXUPD" "$TFMDESTDIR" $TFMNAME
echo "$TFMDESTDIR/$TFMNAME" >$STDOUT
echo "$progname: $TFMDESTDIR/$TFMNAME: successfully generated." >&2

# Since we probably made a GF(->PK) file, too, may as well install it if
# it's needed.
cd $TEMPDIR
if test -r $GFNAME && test ! -f "$PKDESTDIR/$PKNAME"; then
  gftopk ./$GFNAME $PKNAME || exit 1
  "$MT_MKTEXDIR" "$PKDESTDIR"
  mv $PKNAME "$PKDESTDIR/pk$$.tmp" 2>/dev/null \
    || cp $PKNAME "$PKDESTDIR/pk$$.tmp" || exit 1
  cd "$PKDESTDIR" || exit 1
  if test -f $PKNAME; then
    rm -f pk$$.tmp
  else
    chmod `kpsestat -xst,go-w .` pk$$.tmp
    mv pk$$.tmp $PKNAME
    "$MT_MKTEXUPD" "$PKDESTDIR" $PKNAME
  fi
fi
) 1>&2 </dev/null
