// Name of a group of files
[groupname]
/l50002/l

// This section contains extensions of files belonging to the group.
// If one extenstion belongs to more than one group, definitions from all the
// groups are applied
[extensions]
bib

// Associations for Windows
// Syntaxt:
//     extension=internal_name=windows_shell_name
[associations]
bib=TeXBibFile.LEd=/l54000/l

// Access type to the files from the group
[access]
// level    = (0-readonly, 1-ask before edit, 2-fullaccess}
// question = {nicetext shown to ask the file should be edited}
// exec     = {file name to execute when a file is opened}
level=2

// Defines if the group of files is enabled by default
[default]
yes

// Some options
[options]
wrapline=yes
casesensitive=yes
usethesaurus=yes
spellchecking=yes

// Hilight commands
// Predefined groups:
// [hilight\keys]     - keywords
// [hilight\symbols]  - special symbols
// [hilight\types]    - types
// [hilight\comments] - comments
[hilight\BibTeXKeys]
@ARTICLE
@article
@BOOK
@book
@BOOKLET
@booklet
@CONFERENCE
@conference
@INBOOK
@inbook
@INCOLLECTION
@incollection
@INPROCEEDINGS
@inproceedings
@MANUAL
@manual
@MASTERSTHESIS
@mastersthesis
@MISC
@misc
@PHDTHESIS
@phdthesis
@PROCEEDINGS
@proceedings
@TECHREPORT
@techreport
@UNPUBLISHED
@unpublished
@STRING
@string

[hilight\BibTeXFields]
ADDRESS
address
AUTHOR
author
BOOKTITLE
booktitle
CHAPTER
chapter
EDITION
edition
EDITOR
editor
HOWPUBLISHED
howpublished
INSTITUTION
institution
JOURNAL
journal
KEY
key
MONTH
month
NOTE
note
NUMBER
number
ORGANIZATION
organization
PAGES
pages
PUBLISHER
publisher
SCHOOL
school
SERIES
series
TITLE
title
TYPE
type
VOLUME
volume
YEAR
year

// Defines comment commands
// single - symbol starting a comment ending by the end of line
// double - starting and ending symbols of the comment
[hilight\comments\BibTeXComments]
single=%
double=

// Defines hints for keywords. Each hint is a nicetext.
[hints]
@ARTICLE=/l54001/l
@article=/l54002/l
@BOOK=/l54003/l
@book=/l54004/l
@BOOKLET=/l54005/l
@booklet=/l54006/l
@CONFERENCE=/l54007/l
@conference=/l54008/l
@INBOOK=/l54009/l
@inbook=/l54010/l
@INCOLLECTION=/l54011/l
@incollection=/l54012/l
@INPROCEEDINGS=/l54013/l
@inproceedings=/l54014/l
@MANUAL=/l54015/l
@manual=/l54016/l
@MASTERSTHESIS=/l54017/l
@mastersthesis=/l54018/l
@MISC=/l54019/l
@misc=/l54020/l
@PHDTHESIS=/l54021/l
@phdthesis=/l54022/l
@PROCEEDINGS=/l54023/l
@proceedings=/l54024/l
@TECHREPORT=/l54025/l
@techreport=/l54026/l
@UNPUBLISHER=/l54027/l
@unpublisher=/l54028/l

@STRING=/l54041/l
@string=/l54042/l

ADDRESS=/l54151/l
address=/l54152/l
AUTHOR=/l54153/l
author=/l54154/l
BOOKTITLE=/l54155/l
booktitle=/l54156/l
CHAPTER=/l54157/l
chapter=/l54158/l
EDITION=/l54159/l
edition=/l54160/l
EDITOR=/l54161/l
editor=/l54162/l
HOWPUBLISHED=/l54163/l
howpublished=/l54164/l
INSTITUTION=/l54165/l
institution=/l54166/l
JOURNAL=/l54167/l
journal=/l54168/l
KEY=/l54169/l
key=/l54170/l
MONTH=/l54171/l
month=/l54172/l
NOTE=/l54173/l
note=/l54174/l
NUMBER=/l54175/l
number=/l54176/l
ORGANIZATION=/l54177/l
organization=/l54178/l
PAGES=/l54179/l
pages=/l54180/l
PUBLISHER=/l54181/l
publisher=/l54182/l
SCHOOL=/l54183/l
school=/l54184/l
SERIES=/l54185/l
series=/l54186/l
TITLE=/l54187/l
title=/l54188/l
TYPE=/l54189/l
type=/l54190/l
VOLUME=/l54191/l
volume=/l54192/l
YEAR=/l54193/l
year=/l54194/l


[CodeTree]
{ }
 
// This section defines commands related to the group of files
// Syntaxt of the row:
//     name     - command name (nicetext)
//     bitmap   - bitmap code from resources
//     shortcut - hotkey 
//     label    - (nicetext)
//     hint     - (nicetext)
//     command  - command to execute
//
// Command syntax:
//     exec:nicetext - execute nicetext
//     ins:nicetext' - insert nicetext to the editor window (_ denotes cursor position)
//
// Predefined constants:
//     <PROGRAMDIR>       - LEd directory
//     <PROJECT>          - full path of the project, e.g., C:\Papers\Newest.lpr
//     <PROJECTDIR>       - project directory, e.g., C:\Papers
//     <PROJECTNAME>      - project name, e.g., Newest
//     <PROJECTNAMEEXT>   - project name with extension, e.g., Newest.lpr
//     <MAINFILE>         - full path to the main project file, e.g., C:\Papers\Main.tex
//     <MAINFILEDIR>      - directory name of the main project file, e.g., C:\Papers
//     <MAINFILENAME>     - main file name, e.g., Main
//     <MAINFILENAMEEXT>  - main file name with extension, e.g., Main.tex
//     <FILE>             - full path to the selected file
//     <FILEDIR>          - directory of the selected file
//     <FILENAME>         - selected file name
//     <FILENAMEEXT>      - selected file name with extension
//     <BatchesDir>       - directory with LEd batches
//     <DefinitionsDir>   - directory with LEd definitions
//     <DictionariesDir>  - directory with LEd dictionaries
//     <LanguagesDir>     - directory with LEd language resources
//     <ProjectsDir>      - default LEd directory for projects
//     <TemplatesDir>     - directory with LEd templates
//     <ResourcesDir>     - directory with LEd resources
[commands]
54001=54001==@ARTICLE=/l54001/l=ins:/l54201/l
54003=54003==@BOOK=/l54003/l=ins:/l54203/l
54005=54005==@BOOKLET=/l54005/l=ins:/l54205/l
54007=54007==@CONFERENCE=/l54007/l=ins:/l54207/l
54009=54009==@INBOOK=/l54009/l=ins:/l54209/l
54011=54011==@INCOLLECTION=/l54011/l=ins:/l54211/l
54013=54013==@INPROCEEDINGS=/l54013/l=ins:/l54213/l
54015=54015==@MANUAL=/l54015/l=ins:/l54215/l
54017=54017==@MASTERSTHESIS=/l54017/l=ins:/l54217/l
54019=54019==@MISC=/l54019/l=ins:/l54219/l
54021=54021==@PHDTHESIS=/l54021/l=ins:/l54221/l
54023=54023==@PROCEEDINGS=/l54023/l=ins:/l54223/l
54025=54025==@TECHREPORT=/l54025/l=ins:/l54225/l
54027=54027==@UNPUBLISHED=/l54027/l=ins:/l54227/l
54041=54041==@STRING=/l54041/l=ins:/l54241/l

// Example for syntaxt hilighting for the group of files
[syntaxexample\BibTeXKeys,BibTeXFields,BibTeXComments]
=% Knuth book
=@BOOK{Knu1973,
=  author =    "D. E. Knuth",
=  title =     "The Art of Computer Programming",
=  publisher = "Addison--Wesley, Reading, Mass.",
=  volume =    "3. Sorting and Searching Algorithms",
=  year =      "1973"
=} 

