/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class LaTeXFile
extends TeXPath {
    private String baseName;
    private Vector<String> knownNames;
    private KeyValList options;
    private String ext;
    protected LaTeXParserListener listener;
    protected Vector<String> declaredOptions = null;
    private HashMap<String, TeXObject> declaredOptionCode = null;
    private TeXObject defaultOptionCode = null;
    protected boolean loadParentOptions = false;
    private LaTeXFile prevSty = null;

    public LaTeXFile(TeXParser teXParser, String string) throws IOException {
        this(teXParser, (KeyValList)null, string, "tex");
    }

    public LaTeXFile(TeXParser teXParser, String string, String string2) throws IOException {
        this(teXParser, (KeyValList)null, string, string2);
    }

    public LaTeXFile(TeXParser teXParser, KeyValList keyValList, String string, String string2) throws IOException {
        this(teXParser, keyValList, string, string2, false);
    }

    public LaTeXFile(TeXParser teXParser, KeyValList keyValList, String string, String string2, boolean bl) throws IOException {
        super(teXParser, string, string2);
        String string3 = this.getFileName().toString();
        int n = string3.lastIndexOf(".");
        if (n > -1) {
            this.ext = string3.substring(n);
            this.baseName = string3.substring(0, n);
        } else {
            this.ext = string2;
            this.baseName = string3;
        }
        this.options = keyValList;
        this.loadParentOptions = bl;
        this.listener = (LaTeXParserListener)teXParser.getListener();
        this.prevSty = this.listener.getCurrentSty(this.getExtension());
    }

    public String getName() {
        return this.baseName;
    }

    @Override
    public String getExtension() {
        return this.ext;
    }

    public KeyValList getOptions() {
        return this.options;
    }

    public void addOptionIfAbsent(String string, TeXObject teXObject) {
        if (this.options == null) {
            this.options = new KeyValList();
            this.options.put(string, teXObject);
        } else {
            this.options.putIfAbsent(string, teXObject);
        }
    }

    protected void addOptions(KeyValList keyValList) {
        if (keyValList != null) {
            if (this.options == null) {
                this.options = keyValList;
            } else {
                this.options.putAll(keyValList);
            }
        }
    }

    public LaTeXParserListener getListener() {
        return this.listener;
    }

    public TeXParser getParser() {
        return this.listener.getParser();
    }

    protected void loadParentOptions() throws IOException {
        KeyValList keyValList;
        if (this.loadParentOptions && this.prevSty != null && (keyValList = this.prevSty.getOptions()) != null) {
            for (String string : keyValList.keySet()) {
                this.addOptionIfAbsent(string, (TeXObject)keyValList.get(string));
            }
        }
        this.listener.setCurrentSty(this, this.getExtension());
        keyValList = this.listener.getPassedOptions(String.format("%s.%s", this.getName(), this.getExtension()));
        if (keyValList != null) {
            for (String string : keyValList.keySet()) {
                this.addOptionIfAbsent(string, (TeXObject)keyValList.get(string));
            }
        }
    }

    public void processOptions(TeXObjectList teXObjectList) throws IOException {
        if (this.getParser().isDebugMode(64)) {
            this.getParser().logMessage("Processing options for " + this.getName());
        }
        this.loadParentOptions();
        KeyValList keyValList = this.getOptions();
        try {
            if (keyValList != null) {
                this.load(keyValList, teXObjectList);
            } else {
                this.preOptions(teXObjectList);
                this.postOptions(teXObjectList);
            }
        }
        finally {
            this.listener.setCurrentSty(this.prevSty, this.getExtension());
            if (this.getParser().isDebugMode(64)) {
                this.getParser().logMessage("Finished processing options for " + this.getName());
            }
        }
    }

    public void load(KeyValList keyValList, TeXObjectList teXObjectList) throws IOException {
        this.preOptions(teXObjectList);
        KeyValList keyValList2 = this.listener.getDocumentClassOptions();
        if (keyValList2 != keyValList) {
            this.processOptions(keyValList2);
        }
        this.processOptions(keyValList);
        this.postOptions(teXObjectList);
    }

    protected void preOptions(TeXObjectList teXObjectList) throws IOException {
    }

    protected void postOptions(TeXObjectList teXObjectList) throws IOException {
    }

    public void processOption(String string, TeXObject teXObject) throws IOException {
    }

    public void processOptions(KeyValList keyValList) throws IOException {
        if (keyValList == null) {
            return;
        }
        if (this.declaredOptions == null) {
            Iterator<String> iterator = keyValList.getOrderedKeyIterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                TeXObject teXObject = (TeXObject)keyValList.get(string);
                this.processOption(string, teXObject);
            }
        } else {
            TeXObject teXObject;
            for (String string : this.declaredOptions) {
                if (!keyValList.containsKey(string)) continue;
                teXObject = (TeXObject)keyValList.get(string);
                this.processOption(string, teXObject);
            }
            Iterator<String> iterator = keyValList.getOrderedKeyIterator();
            while (iterator.hasNext()) {
                String string;
                string = iterator.next();
                if (this.declaredOptions.contains(string)) continue;
                teXObject = (TeXObject)keyValList.get(string);
                this.processUnknownOption(string, teXObject);
            }
        }
    }

    public void declareUnknownOption(TeXObject teXObject) {
        this.defaultOptionCode = teXObject;
    }

    public void declareOption(String string, TeXObject teXObject) {
        if (teXObject == null) {
            throw new NullPointerException();
        }
        if (this.declaredOptions == null) {
            this.declaredOptions = new Vector();
        }
        this.declaredOptions.add(string);
        if (this.declaredOptionCode == null) {
            this.declaredOptionCode = new HashMap();
        }
        this.declaredOptionCode.put(string, teXObject);
    }

    protected void processUnknownOption(String string, TeXObject teXObject) throws IOException {
        if (this.defaultOptionCode != null) {
            this.getParser().putControlSequence(true, new GenericCommand("CurrentOption", null, this.getListener().createString(string)));
            if (teXObject == null) {
                this.defaultOptionCode.process(this.getParser());
            } else {
                Group group = this.getListener().createGroup();
                group.add(teXObject);
                TeXObjectList teXObjectList = new TeXObjectList();
                teXObjectList.add(group);
                this.defaultOptionCode.process(this.getParser(), teXObjectList);
            }
        }
    }

    protected void processDeclaredOption(String string, TeXObject teXObject) throws IOException {
        if (this.declaredOptions == null || !this.declaredOptions.contains(string)) {
            this.processUnknownOption(string, teXObject);
            return;
        }
        TeXObject teXObject2 = this.declaredOptionCode.get(string);
        if (teXObject2 != null) {
            if (teXObject == null) {
                teXObject2.process(this.getParser());
            } else {
                Group group = this.getListener().createGroup();
                group.add(teXObject);
                TeXObjectList teXObjectList = new TeXObjectList();
                teXObjectList.add(group);
                teXObject2.process(this.getParser(), teXObjectList);
            }
        }
    }

    protected void updateName(String string) {
        if (string.equals(this.baseName)) {
            return;
        }
        if (this.knownNames == null) {
            this.knownNames = new Vector();
            this.knownNames.add(this.baseName);
        } else if (!this.knownNames.contains(this.baseName)) {
            this.knownNames.add(this.baseName);
        }
        this.baseName = string;
    }

    public boolean isName(String string) {
        return this.baseName.equals(string) || this.knownNames != null && this.knownNames.contains(string);
    }
}

