program nrecov;

uses
  crt, dos;

const
  copyerror : integer = 0;
  bufmax = 10000;

type
  buffertype = array[0..bufmax-1] of byte;
  filetype = record
               buf : ^buffertype;
               bckbeg, bckend : longint;
               pos : longint;
               f : file;
               eof : boolean;
             end;


  sourcetype = record
                 name : pathstr;
                 path: pathstr;
                 index : filetype;
                 game : filetype;
               end;

  gametype = record
               beg : longint;
               beg_next : longint;
               len : longint;
               bytes : array[0..10000] of integer;
             end;

var
  source, target : sourcetype;
  io_error : boolean;
  game : gametype;



function aktual_disk: byte;
var
  regs : registers;
begin
  regs.ah:=$19;
  msdos(regs);
  aktual_disk:=regs.al+1;
end;

function upcasestr(s1: string) : string;
var
  s2: string;
  i : integer;

begin
  s2:='';
  for i:=1 to length(s1) do
    s2:=s2+upcase(s1[i]);
  upcasestr:=s2;
end;

function file_exist (file_name : string): boolean;
var
  f : file;

begin
  {$i-}
  assign(f, file_name);
  reset(f);
  close(f);
  {i+}
  file_exist:=((ioresult=0) and (file_name<>''));
end;

procedure remove_ext(VAR s1 : pathstr);
begin
  while pos('.',s1)>0 do
    s1:=copy(s1,1,length(s1)-1);
end;

procedure io_test;
begin
  copyerror:=ioresult;
  if copyerror=0 then
    if doserror<>0 then
      copyerror:=doserror;
  doserror:=0;
end; {io_test}


procedure plus_backslash(var path: pathstr);
begin
  if path[length(path)]<>'\' then
    path:=path+'\';
end; {plus_backslash}

procedure find_path(VAR search_files, path: pathstr);

begin
  if pos('\',search_files)>0 then
  begin
    path:=search_files;
    while path[length(path)]<>'\' do
      path:=copy(path,1,length(path)-1);
  end
  else
  if pos(':',search_files)>0 then
  begin
    getdir(ord(search_files[1])-64,path);
  end
  else
    getdir(aktual_disk,path);

  plus_backslash(path);
  while (pos(':',search_files)>0) or (pos('\',search_files)>0) do
    search_files:=copy(search_files,2,length(search_files)-1);
  search_files:=upcasestr(search_files);
  path:=upcasestr(path);
end;

procedure open_file_for_read(VAR fil : filetype; name : string);
begin
  assign(fil.f,name);
  io_error:=false;
  if not file_exist(name) then
  begin
    io_error:=true;
  end
  else
  begin
    reset(fil.f,1);
    io_test; io_error:=io_error or (copyerror<>0);
  end;
  fil.bckbeg:=0;
  fil.bckend:=-1;
  fil.pos:=-1;
  fil.buf:=nil;
  new(fil.buf);
end;

procedure open_file_for_write(VAR fil : filetype; name : string);
begin
  assign(fil.f,name);
  io_error:=false;
  if file_exist(name) then
  begin
    erase(fil.f);
    io_test;
  end;
  io_error:=false;
  rewrite(fil.f,1);
  io_test; io_error:=io_error or (copyerror<>0);
  fil.bckbeg:=0;
  fil.bckend:=-1;
  fil.pos:=-1;
  fil.buf:=nil;
  new(fil.buf);
end;

procedure close_read_file(VAR fil: filetype);
begin
  close(fil.f);
  io_test;
  dispose(fil.buf);
  fil.bckbeg:=-1;
  fil.bckend:=-1;
  fil.pos:=-1;
  fil.buf:=nil;
end;

procedure close_write_file(VAR fil: filetype);
var
  bytes_written : integer;

begin
  blockwrite(fil.f,fil.buf^,fil.bckend-fil.bckbeg+1,bytes_written);
  io_error:=false; io_test;
  io_error:=io_error or (copyerror<>0) or
            (bytes_written<>fil.bckend-fil.bckbeg+1);
  close(fil.f);
  io_test;
  dispose(fil.buf);
  fil.bckbeg:=-1;
  fil.bckend:=-1;
  fil.pos:=-1;
  fil.buf:=nil;
end;


function get_next_byte(VAR fil : filetype): longint;
var
  b : longint;
  bytes_read : integer;

begin
  inc(fil.pos);
  if (fil.pos<=fil.bckend) then
  begin
    b:=fil.buf^[fil.pos-fil.bckbeg];
  end
  else
  begin
    fil.bckbeg:=fil.bckend+1;
    blockread(fil.f,fil.buf^,bufmax,bytes_read);
    io_error:=false; io_test;
    io_error:=io_error or (copyerror<>0);
    fil.bckend:=fil.bckend+bytes_read;
    b:=fil.buf^[0];
    fil.eof:=(bytes_read=0);
  end;
  get_next_byte:=b;
end;

procedure put_next_byte(VAR fil : filetype; a : longint);
var
  b : byte;
  bytes_written : integer;

begin
  b:=a mod 256;
  inc(fil.pos);
  inc(fil.bckend);
  if (fil.bckend-fil.bckbeg+1)<=bufmax then
  begin
    fil.buf^[fil.bckend-fil.bckbeg]:=b;
  end
  else
  begin
    blockwrite(fil.f,fil.buf^,fil.bckend-fil.bckbeg,bytes_written);
    io_error:=false; io_test;
    io_error:=io_error or (copyerror<>0) or
              (bytes_written<>fil.bckend-fil.bckbeg);
    fil.bckbeg:=fil.bckbeg+bytes_written;
    fil.bckend:=fil.bckbeg;
    fil.buf^[0]:=b;
  end;
end;

function get_index_val(VAR fil : filetype) : longint;
var
  byte_numb : array[0..3] of longint;
  i : integer;
  p : longint;

begin
  for i:=0 to 3 do
  begin
    byte_numb[i]:=get_next_byte(fil);
  end;
  p:=byte_numb[0]*256*256*256+
     byte_numb[1]*256*256 +
     byte_numb[2]*256 +
     byte_numb[3];
  get_index_val:=p;
end;

procedure put_index_val(VAR fil : filetype; p: longint);
var
  byte_numb : array[0..3] of longint;
  i : integer;

begin
  byte_numb[3]:=p mod 256;
  p:=p div 256;
  byte_numb[2]:=p mod 256;
  p:=p div 256;
  byte_numb[1]:=p mod 256;
  p:=p div 256;
  byte_numb[0]:=p mod 256;
  put_next_byte(fil,byte_numb[0]);
  put_next_byte(fil,byte_numb[1]);
  put_next_byte(fil,byte_numb[2]);
  put_next_byte(fil,byte_numb[3]);
end;



var
  i : integer;
  numb_of_games, game_numb, recovered_games : longint;

{mainprogram}
begin
  io_test;
  if paramcount=2 then
  begin
    source.name:=paramstr(1);
    target.name:=paramstr(2);
  end
  else
  if paramcount=1 then
  begin
    source.name:=paramstr(1);
    target.name:='NICRECOV';
  end
  else
  begin
    write('Type name of file with deleted games:    ');
    readln(source.name);
    write('Type name of file getting deleted games: ');
    readln(target.name);
  end;
  writeln;
  writeln('Carsten Hansen, CH0506@HDC.HHA.DK, any comments welcome');
  writeln;
  remove_ext(source.name);
  remove_ext(target.name);
  find_path(source.name,source.path);
  find_path(target.name,target.path);
  if file_exist(source.path+source.name+'.I30') and
     file_exist(source.path+source.name+'.G30') then
  begin
    if source.path+source.name=target.path+target.name then
    begin
      writeln('Source and Target are not allowed to be identical');
      io_error:=true;
    end
    else
    begin
      open_file_for_read(source.index  ,source.path+source.name+'.I30');
      open_file_for_read(source.game   ,source.path+source.name+'.G30');
      open_file_for_write(target.index ,target.path+target.name+'.I30');
      open_file_for_write(target.game  ,target.path+target.name+'.G30');
    end;
    if not io_error then
    begin
      put_index_val(target.index,0);
      game.beg:=get_index_val(source.index);
      numb_of_games:=(filesize(source.index.f)-4) div 4;
      writeln(numb_of_games:6,' Games to examine');
      game_numb:=1; recovered_games:=0;
      while (game_numb<=numb_of_games) and (not io_error) do
      begin
        game.beg_next:=get_index_val(source.index);
        game.len:=game.beg_next-game.beg;
        if game.len<0 then
          write('game.len<0');
        for i:=0 to game.len-1 do
        begin
          game.bytes[i]:=get_next_byte(source.game);
        end;
        game.bytes[game.len]:=-1;
        if ((game.bytes[0] and 1)=1) and (not io_error) then
        begin
          put_next_byte(target.game,game.bytes[0] and 254);
          for i:=1 to game.len-1 do
          begin
            put_next_byte(target.game,game.bytes[i]);
          end;
          put_index_val(target.index,target.game.pos+1);
          inc(recovered_games);
        end;
        game.beg:=game.beg_next;
        gotoxy(1,wherey);
        write(game_numb:6,' Games Examined    ');
        write(recovered_games:6,' Games Recovered');
        inc(game_numb);
      end;
    end;
    writeln;
    close_read_file(source.index);
    close_read_file(source.game);
    close_write_file(target.index);
    close_write_file(target.game);
    if recovered_games=0 then
    begin
      writeln('No Games recovered');
      erase(target.index.f);
      erase(target.game.f);
    end;
  end
  else
  begin
    writeln(source.path+source.name,'.* Does not exist');
  end;
end.
