/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.bibeditor;

import java.util.List;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.bibeditor.BibCodeFolder;
import net.sourceforge.texlipse.bibeditor.BibDocumentModel;
import net.sourceforge.texlipse.bibeditor.BibOutlinePage;
import net.sourceforge.texlipse.bibeditor.BibSourceViewerConfiguration;
import net.sourceforge.texlipse.editor.TexPairMatcher;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class BibEditor
extends TextEditor {
    public static final String BIB_PARTITIONING = "__bibtex_partitioning";
    public static final String ID = "net.sourceforge.texlipse.bibeditor.BibEditor";
    private TexPairMatcher fBracketMatcher = new TexPairMatcher("{}[]()");
    private BibOutlinePage outlinePage;
    private BibDocumentModel documentModel;
    private BibCodeFolder folder = new BibCodeFolder(this);
    private ProjectionSupport fProjectionSupport;

    public void dispose() {
        if (this.outlinePage != null) {
            this.outlinePage = null;
        }
        super.dispose();
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.documentModel = new BibDocumentModel(this);
        this.setSourceViewerConfiguration(new BibSourceViewerConfiguration(this));
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        this.getPreferenceStore().setValue("matchingBrackets", TexlipsePlugin.getPreference("matchingBrackets"));
        this.getPreferenceStore().setValue("matchingBracketsColor", TexlipsePlugin.getPreference("matchingBracketsColor"));
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.fBracketMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("matchingBrackets", "matchingBracketsColor");
        super.configureSourceViewerDecorationSupport(support);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.fProjectionSupport.install();
        if (TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("bibCodeFolding")) {
            projectionViewer.doOperation(19);
        }
        this.documentModel.update();
    }

    protected void createActions() {
        super.createActions();
        TextOperationAction a = new TextOperationAction(TexlipsePlugin.getDefault().getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this, 13);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        this.documentModel.update();
    }

    public Object getAdapter(Class required) {
        Object adapter;
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.outlinePage == null) {
                this.outlinePage = new BibOutlinePage((ITextEditor)this);
                this.documentModel.update();
            }
            return this.outlinePage;
        }
        if (this.fProjectionSupport != null && (adapter = this.fProjectionSupport.getAdapter(this.getSourceViewer(), required)) != null) {
            return adapter;
        }
        return super.getAdapter(required);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public void updateCodeFolder(List outlineTree) {
        this.folder.update(outlineTree);
    }

    public BibOutlinePage getOutlinePage() {
        return this.outlinePage;
    }

    public BibDocumentModel getDocumentModel() {
        return this.documentModel;
    }

    public IProject getProject() {
        IResource res = (IResource)this.getEditorInput().getAdapter(IResource.class);
        if (res == null) {
            return null;
        }
        return res.getProject();
    }
}

