/*-
******************************************************************************
******************************************************************************
**
**  ARCHIVE HEADER INFORMATION
**
**  @C-file{
**      FILENAME    = "specific.h",
**      VERSION     = "1.00",
**      DATE        = "",
**      TIME        = "",
**
**      AUTHOR      = "Niel Kempson",
**      ADDRESS     = "25 Whitethorn Drive
**                     Cheltenham
**                     GL52 5LL
**                     England",
**      TELEPHONE   = "+44-242 579105",
**      EMAIL       = "kempson@tex.ac.uk (Internet)",
**
**      SUPPORTED   = "yes",
**      ARCHIVED    = "tex.ac.uk, ftp.tex.ac.uk",
**      KEYWORDS    = "VVcode",
**
**      CODETABLE   = "ISO/ASCII",
**      CHECKSUM    = "51492 1481 5732 57976",
**
**      DOCSTRING   = { This file is part of VVcode.
**                  }
**  }
**
**  MODULE CONTENTS
**
**      apply_defaults      -   Apply default file name and extension to a
**                              full file specification if either of these 
**                              components is missing.
**      confirm_yesno       -   Display a message to the user and wait for a
**                              yes/no answer.
**      examine_file        -   Examine a file and determine its key features, 
**                              including mode, format, record length and 
**                              timestamp.
**      explain_error       -   Explain the reason for an error.
**      f_open_in           -   Open a file for input using the appropriate 
**                              mode, format etc for the file.
**      f_open_out          -   Open a file for output using the appropriate
**                              mode, format etc for the file.
**      file_exists         -   Determine whether a file exists.
**      force_file_ext      -   Force the file extension of a full file
**                              specification to a specified value.
**      is_a_file           -   Determine whether a file stream is connected
**                              to a real file rather than a character
**                              device, pipe etc.
**      legal_filespec      -   Takes an arbitrary string which may a file 
**                              specification from another operating system
**                              and manipulates it to produce a legal file 
**                              specification for the current operating
**                              system.
**      make_filespec       -   Construct a full file specification from
**                              component parts.
**      prompt_for_string   -   Present a prompt string and accept a string 
**                              from the user.
**      read_bytes          -   Read bytes from a currently open file.
**      read_line           -   Read a line from a currently open (text) file.
**      read_record         -   Read a record from a currently open file.
**      scan_cmd_line       -   [tbs]
**      set_ftime           -   Set the timestamp of a file to a specified 
**                              value.
**      set_pipe_mode       -   Set the mode of a file stream connected to a
**                              pipe, character device, redirected
**                              stdin/stdout/stderr, in fact any non-file.
**      split_file_spec     -   Split a full file specification into its
**                              component parts.
**      tz_offset           -   Determine the offset of local time from 
**                              Greenwich Mean Time (Coordinated Universal
**                              Time) at a specified date and time.  
**      user_message        -   Present a message to the user.
**      vv_exit             -   Exit the program, returning the appropriate
**                              status to the operating system.
**      write_bytes         -   Write bytes to a currently open file.
**      write_record        -   Write a record to a currently open file.
**
**  COPYRIGHT
**
**      Written 1991-1992 by Niel Kempson <kempson@tex.ac.uk> who claims
**      no copyright over this program - you are free to use it as you wish.
**
**  CHANGE LOG
**
******************************************************************************
******************************************************************************
*/


/*
******************************************************************************
******************************************************************************
**
** Forward declarations of the environment specific functions
**
******************************************************************************
******************************************************************************
*/
void apply_defaults             ARGS ((CONST char *default_name,
                                    CONST char *default_ext,
                                    char *full_spec));
Boolean confirm_yesno           ARGS ((CONST char *confirm_str));
void examine_file               ARGS ((File_Info *ex_info));
void explain_error              ARGS ((void));
FILE *f_open_in                 ARGS ((File_Info *ip_file));
FILE *f_open_out                ARGS ((CONST Int16 overwrite_files,
                                    File_Info *op_file));
Boolean file_exists             ARGS ((CONST char *file_spec));
void force_file_ext             ARGS ((CONST char *forced_ext,
                                    char *full_spec));
Boolean is_a_file               ARGS ((CONST File_Info *ex_file));
char *legal_filespec            ARGS ((CONST char *hdrf_spec));
void make_file_spec             ARGS ((CONST char *preamble,
                                    CONST char *name,
                                    CONST char *extension,
                                    CONST char *postamble,
                                    char *full_spec));
void prompt_for_string          ARGS ((CONST char *confirm_str,
                                    CONST Int16 buf_size,
                                    char *return_buffer));
Int32 read_bytes                ARGS ((CONST Int32 max_bytes,
                                    char *buffer,
                                    File_Info *ip_file));
Int32 read_line                 ARGS ((CONST Int32 max_bytes,
                                    char *buffer,
                                    File_Info *ip_file));
Int32 read_record               ARGS ((CONST Int32 max_bytes,
                                    char *buffer,
                                    File_Info *ip_file));
void scan_cmd_line              ARGS ((CONST int qargc,
                                    CONST char *qargv[],
                                    CONST char *q_intro_str,
                                    CONST char *q_sep_str,
                                    Qualifier_Struct *qual_array,
                                    Qualifier_Struct *qual_ipfile,
                                    Qualifier_Struct *qual_opfile));
void set_ftime                  ARGS ((File_Info *target_file));
void set_pipe_mode              ARGS ((File_Info *target_file));
Unsigned16 split_file_spec      ARGS ((CONST char *full_spec,
                                    char *preamble,
                                    char *name,
                                    char *extension,
                                    char *postamble));
TIME_T tz_offset                ARGS ((TIME_T the_time));
void user_message               ARGS ((CONST Int16 status,
				    CONST char *msg_str,
				    File_Info *log_file));
void vv_exit                    ARGS ((void));  
void write_bytes                ARGS ((CONST Int32 rec_len,
                                    CONST char *buffer,
                                    File_Info *op_file));
void write_record               ARGS ((CONST Int32 rec_len,
                                    CONST char *buffer,
                                    File_Info *op_file));
