/* changecode : code translation program                               */
/*                                                                     */
/* Copyright (C) 1999  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University */

#include <stdio.h>
#include <string.h>
#ifndef AIX
  #include <sys/fcntl.h>
#else
  #include <fcntl.h>
  #include <unistd.h>
#endif
#define PMODE 0666
#define BUFLEN_E 32768
#define BUFLEN_A 32768

char buffer_a[BUFLEN_A];
int  cnt_a=0;
int  filed1, filed2;
char *ptr_a;
int  anznl=0, tpos=0, anzz=0;

extern void nl();     /* counts the newlines, print "." all 100 newlines "." */
extern void wchar();  /* puts 1 character into the buffer */
extern void wchar0(); /* writes and clears the buffer */
extern int  gchar();  /* get 1 character from the buffer */
extern void ibmiso(); /* code translation ISO latin 1 <---> IBM-DOS-PC */

main (Anz,Vekt)
int   Anz;
char  *Vekt[]; /* [1]=code translation mode; [2]=input file, [3]=output file */

{
  extern int errno;
  int i, rret, ivar;
  unsigned char ch;
  int  soz=0, suz=0;
  int errorparam=0;
  
  if ( Anz < 3 ) errorparam++;
  if ( Anz==3 && (strcmp(Vekt[1],"-analyse")!=0) ) { errorparam++; }
  if ( errorparam != 0 ) {
    printf("call: changecode [ -mode ] input_file output_file\n");
    printf("              -u2t      German-umlaute --> TeX\n");
    printf("              -u2gt     German-umlaute --> German-TeX\n");
    printf("              -tgt2u    TeX- & German-TeX --> German-umlaute\n");
    printf("              -d2u      DOS --> Unix\n");
    printf("              -u2d      Unix --> DOS\n");
    printf("              -ibm2iso  8 Bit IBM-DOS-Code -->  ISO-latin-1\n");
    printf("              -iso2ibm  ISO-latin-1 --> 8 Bit IBM-DOS-Code\n");
    printf("              -tabexp   tabulator expanding with blanks\n");
    printf("              -ascii7   German-umlaute  --> ae ou ue Ae Oe Ue ss\n");
    printf("              -analyse  file analysis\n");
    exit(1);
  }
  /*authors: R.Weibezahn, G.Lamprecht; LRW c/o Uni Bremen, Tel. 0421-218-3532 */
  printf("\nchangecode  LRW(Wz.) V.08/24.11.95-SOLARIS2.3");

  if ( (Anz==3) || (strcmp(Vekt[1],"-analyse")==0) ) {
    printf("\n%s with option: %s",Vekt[2],Vekt[1]);
  }
  else {
    printf("\n%s --> %s with option: %s",Vekt[2],Vekt[3],Vekt[1]);
  }

  ptr_a=buffer_a;
  anznl=0;
  filed1=open(Vekt[2],O_RDONLY);     /* filed1 >= 0 : OK, sonst Fehler */
  filed2=creat(Vekt[3],PMODE);

  if ((int)filed1 <= 0) {printf("\ninput file not found\n");exit(1);}

  
  if ( strcmp(Vekt[1],"-u2t") == 0 ) { /* German-umlaute --> TeX */

    static int feld []
      ={1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,1,

        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1};

    rret=gchar(&ch);
    while (rret > 0) {             /*     printf("ch=%c(%d) ",ch,ch);     */
      if (feld[ch]==0) { wchar(&ch); }
      else {
	switch (ch) {
	case (unsigned char) '' : wchar("\\");wchar("\"");wchar("a");suz++;break;
	case (unsigned char) '' : wchar("\\");wchar("\"");wchar("o");suz++;break;
	case (unsigned char) '' : wchar("\\");wchar("\"");wchar("u");suz++;break;
	case (unsigned char) '' : wchar("\\");wchar("\"");wchar("A");suz++;break;
	case (unsigned char) '' : wchar("\\");wchar("\"");wchar("O");suz++;break;
	case (unsigned char) '' : wchar("\\");wchar("\"");wchar("U");suz++;break;
	case (unsigned char) '' : wchar("{"); wchar("\\");wchar("s");
	                           wchar("s"); wchar("}"); suz++; break;
	case (unsigned char) '\n': wchar("\n");nl(); break;
	default                  : wchar(&ch); soz++; break;
	}
      }
      rret=gchar(&ch);
    }
  }

  else if ( strcmp(Vekt[1],"-u2gt") == 0 ) {/* German-umlaute --> German-TeX */

    static int feld []
      ={1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
	0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,1,
	
	1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1};

    rret=gchar(&ch);
    while (rret > 0) {             /*     printf("ch=%c(%d) ",ch,ch);     */
      if (feld[ch]==0) { wchar(&ch); }
      else {
	switch (ch) {
	case (unsigned char) '' : wchar("\""); wchar("a"); suz++; break;
	case (unsigned char) '' : wchar("\""); wchar("o"); suz++; break;
	case (unsigned char) '' : wchar("\""); wchar("u"); suz++; break;
	case (unsigned char) '' : wchar("\""); wchar("A"); suz++; break;
	case (unsigned char) '' : wchar("\""); wchar("O"); suz++; break;
	case (unsigned char) '' : wchar("\""); wchar("U"); suz++; break;
	case (unsigned char) '' : wchar("\""); wchar("s"); suz++; break;
	case (unsigned char) '\n': wchar("\n"); nl(); break;
	default                  : wchar(&ch); soz++; break;
	}
      }
      rret=gchar(&ch);
    }
  }

  else if ( strcmp(Vekt[1],"-tgt2u") == 0 ) {
                                      /* TeX- & German-TeX --> German-umlaute */

    static int feld []
      ={1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        0,0,1,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,1,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,1,0,0,0,1,

        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1};

    rret=gchar(&ch);
    while (rret > 0) {             /*     printf("ch=%c(%d) ",ch,ch);     */
     character_read_in_ch:
      if (feld[ch]==0) { wchar(&ch); }
      else {
	switch (ch) {

	case (unsigned char) '\\'  :  /* test for: \"a \"o \"u \"A \"O \"U  */
	                              /* ("\\" is for linebreak in input file!) */
	  if (gchar(&ch)==0) {wchar("\\");break;}
	  if (ch=='\\') {wchar("\\");wchar("\\");break;}     /* linebreak! */
	  if (ch!='"')  {wchar("\\");wchar(&ch); break;}     /* no "Umlaut"! */
	  if (gchar(&ch)==0) {wchar("\\");wchar(&ch);break;}
          switch (ch) {      /* test for: \"a \"o \"u \"A \"O \"U \"s */
	  case (unsigned char) 'a' : wchar("");suz++; break;   /* \"a */
	  case (unsigned char) 'o' : wchar("");suz++; break;   /* \"o */
	  case (unsigned char) 'u' : wchar("");suz++; break;   /* \"u */
	  case (unsigned char) 'A' : wchar("");suz++; break;   /* \"A */
	  case (unsigned char) 'O' : wchar("");suz++; break;   /* \"O */
	  case (unsigned char) 'U' : wchar("");suz++; break;   /* \"U */
	  default                  : wchar("\\");wchar("\"");wchar(&ch); break;
          }
	  break;

	case (unsigned char) '{'  :  /* test for: {\ss}  {\"a  .. {\"U  {"a .. {"U  */
	  if (gchar(&ch)==0) {wchar("{");break;}
	  if (ch=='{') {wchar("{");goto character_read_in_ch;} /* double braces! */
	  if ( (ch!='\\') && (ch!='\"') ) {wchar("{");wchar(&ch); break;}
	  if (ch=='\"') {
	    if (gchar(&ch)==0) {wchar("{");wchar("\\");wchar("\"");break;}
            switch (ch) {      /* test for: {"a {"o {"u {"A {"O {"U {"s   */
	    case (unsigned char) 'a' : wchar("{");wchar("");suz++; break; /* {"a */
	    case (unsigned char) 'o' : wchar("{");wchar("");suz++; break; /* {"o */
	    case (unsigned char) 'u' : wchar("{");wchar("");suz++; break; /* {"u */
	    case (unsigned char) 'A' : wchar("{");wchar("");suz++; break; /* {"A */
	    case (unsigned char) 'O' : wchar("{");wchar("");suz++; break; /* {"O */
	    case (unsigned char) 'U' : wchar("{");wchar("");suz++; break; /* {"U */
	    case (unsigned char) 's' : wchar("{");wchar("");suz++; break; /* {"s */
	    default                  : wchar("{");wchar("\"");wchar(&ch); break;
	    }
	    break;
	  }
	  if (gchar(&ch)==0) {wchar("{");wchar("\\");break;}
	  if ( (ch!='s') && (ch!='\"') )  {wchar("{");wchar("\\");wchar(&ch);break;}
	  if (ch=='\"') {
	    if (gchar(&ch)==0) {wchar("{");wchar("\\");wchar("\"");break;}
            switch (ch) {      /* test for: {\"a {\"o {\"u {\"A {\"O {\"U {\"s  */
	    case (unsigned char) 'a' : wchar("{");wchar("");suz++; break; /* {\"a */
	    case (unsigned char) 'o' : wchar("{");wchar("");suz++; break; /* {\"o */
	    case (unsigned char) 'u' : wchar("{");wchar("");suz++; break; /* {\"u */
	    case (unsigned char) 'A' : wchar("{");wchar("");suz++; break; /* {\"A */
	    case (unsigned char) 'O' : wchar("{");wchar("");suz++; break; /* {\"O */
	    case (unsigned char) 'U' : wchar("{");wchar("");suz++; break; /* {\"U */
	    default                  : wchar("{");wchar("\\");wchar("\"");wchar(&ch);break;
	    }
	    break;
	  }
	  if (gchar(&ch)==0) {wchar("{");wchar("\\");wchar("s");break;}
	  if (ch!='s')  {wchar("{");wchar("\\");wchar("s");wchar(&ch);break;} 
	  if (gchar(&ch)==0) {wchar("{");wchar("\\");wchar("s");wchar("s");break;}
	  if (ch!='}')  {wchar("{");wchar("\\");wchar("s");wchar("s");wchar(&ch);break;}
	  wchar("");suz++;                                       /* {\ss} */
	  break;

        case (unsigned char) '"'  :        /* test for: "a "o "u "A "O "U "s  */
	  if (gchar(&ch)==0) {wchar("\"");break;}
          switch (ch) {
	    case (unsigned char) 'a' : wchar("");suz++; break;    /* "a */
	    case (unsigned char) 'o' : wchar("");suz++; break;    /* "o */
	    case (unsigned char) 'u' : wchar("");suz++; break;    /* "u */
	    case (unsigned char) 'A' : wchar("");suz++; break;    /* "A */
	    case (unsigned char) 'O' : wchar("");suz++; break;    /* "O */
	    case (unsigned char) 'U' : wchar("");suz++; break;    /* "U */
	    case (unsigned char) 's' : wchar("");suz++; break;    /* "s */
	    default                  : wchar("\"");wchar(&ch); break;
          }
	  break;

	case (unsigned char) '\n'  : wchar("\n"); nl(); break;

	default                    : wchar(&ch); soz++; break;

	}
      }
      rret=gchar(&ch);
    }
  }

  else if ( strcmp(Vekt[1],"-u2d") == 0 ) {     /*  Unix -> DOS  (linebreaks!) */
                                                /*  (old) DOS-end_of_file see below!  */

    static int feld []
      ={1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,1,

        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1};

    rret=gchar(&ch);
    while (rret > 0) {            /*     printf("ch=%c(%d) ",ch,ch);     */
      if (feld[ch]==0) { wchar(&ch); }
      else {
	switch (ch) {
	case (unsigned char) '\r'  : break;
	/*case (unsigned char) '\032': break;  Unix: Substitute Char.; DOS: end_of_file*/
	case (unsigned char) '\n'  : wchar("\r"); wchar("\n"); nl(); break;
	default                    : wchar(&ch); soz++; break;
	}
      }
      rret=gchar(&ch);
    }
  }

  else if ( strcmp(Vekt[1],"-d2u") == 0 ) {/* DOS -> Unix (linebreaks and end_of_file!) */

    static int feld []
      ={1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,1,

        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1};

    rret=gchar(&ch);
    while (rret > 0) {            /*     printf("ch=%c(%d) ",ch,ch);     */
      if (feld[ch]==0) { wchar(&ch); }
      else {
	switch (ch) {
	case (unsigned char) '\n'  : wchar("\n"); nl(); break;
	case (unsigned char) '\r'  : break;  /* in DOS before newline */
	case (unsigned char) '\032': break;  /* in DOS(old) before EOF */
	default                    : wchar(&ch); soz++; break;
	}
      }
      rret=gchar(&ch);
    }
  }

  else if ( strcmp(Vekt[1],"-ibm2iso") == 0 ) { /* 8 Bit IBM-DOS-Code --> ISO-latin-1 */

    ibmiso(0);

  }

  else if ( strcmp(Vekt[1],"-iso2ibm") == 0 ) { /* ISO-latin-1 --> 8 Bit IBM-DOS-Code */

    ibmiso(1);

  }

  else if ( strcmp(Vekt[1],"-tabexp") == 0 ) { /* tabulator expanding with blanks */

    static int feld []
      ={0,0,0,0,0,0,0,0, 0,1,1,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,

        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0};
    int zb=0, zt=0;

    rret=gchar(&ch); tpos++;
    while (rret > 0) {            /*     printf("ch=%c(%d) ",ch,ch);     */
      if (feld[ch]==0)
	   { wchar(&ch); }
      else {
	switch (ch) {
	case (unsigned char) '\n' : wchar("\n");nl(); break;
	case (unsigned char) '\t' : zt++;
                                    if ((tpos%8)==0)
                                      {wchar(" ");zb++;}
                                    else {
	                              for (i=1;i<=(9-(tpos%8));i++) {wchar(" ");zb++;}
				      tpos=tpos+(8-(tpos%8));
                                    }
				    break;
	default  :
		      printf("\n%c(%d): characters deleted",ch,ch);
		      printf(" (in line %d)\n",anznl+1);
		      break;
	}
      }
      rret=gchar(&ch); tpos++;
    }
    printf("\n\n %i tabulators expanded by  %i blanks!",zt,zb);
  }

  else if ( strcmp(Vekt[1],"-analyse") == 0 ) { /* file analysis */

    static int feld []
      ={1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,1,

        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0};
    int anztab=0;
    int anzcr=0;
    int anzeof=0;
    int anzsonst=0;
    int anz8=0;
    int maxzl=0, zl=0;

    rret=gchar(&ch); tpos++; zl++;
    while (rret > 0) { /*  printf(" %i ",zl);  */
      if (feld[ch]!=0) {
	switch (ch) {
	case (unsigned char) '\t'   :
                                       if ((tpos%8)==0)
                                         {zl++;}
                                       else {
                                         for (i=1;i<=(9-(tpos%8));i++) {zl++;}
				         tpos=tpos+(8-(tpos%8));
                                       }
	                               anztab++;
				       break;
	case (unsigned char) '\n'   : anznl++; if(zl>maxzl) {maxzl=zl;} zl=0;  break;
	case (unsigned char) '\r'   : anzcr++;    break;
	case (unsigned char) '\032' : anzeof++;   break;
	default                     : anzsonst++; break;
	}
      }
      if ( ch >= 127) anz8++;
      rret=gchar(&ch); tpos++; zl++;
    }
    printf ("\nfile:  %s",Vekt[2]);
    printf ("\n             %9i lines",anznl);
    printf ("\n             %9i characters in longest line",maxzl);
    printf ("\n             %9i characters in all",anzz);
    if (anztab > 0)
      printf ("\n                 %9i tabulators",anztab);
    if (anzcr > 0)
      printf ("\n                 %9i CR-characters",anzcr);
    if (anzeof > 0)
      printf ("\n                 %9i DOS-end_of_file-characters",anzeof);
    if (anzsonst > 0)
      printf ("\n                 %9i other control characters",anzsonst);
  }

  else if ( strcmp(Vekt[1],"-ascii7") == 0 ) { /* German-umlaute --> ae ou ue Ae Oe Ue ss */

    static int feld []
      ={1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,1,

        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1};

    rret=gchar(&ch); tpos++;
    while (rret > 0) {            /*     printf("ch=%c(%d) ",ch,ch);     */
      if (feld[ch]==0) { wchar(&ch); }
      else {
	switch (ch) {
	case (unsigned char) ''   : wchar("a"); wchar("e"); break;
	case (unsigned char) ''   : wchar("o"); wchar("e"); break;
	case (unsigned char) ''   : wchar("u"); wchar("e"); break;
	case (unsigned char) ''   : wchar("A"); wchar("e"); break;
	case (unsigned char) ''   : wchar("O"); wchar("e"); break;
	case (unsigned char) ''   : wchar("U"); wchar("e"); break;
	case (unsigned char) ''   : wchar("s"); wchar("s"); break;
	case (unsigned char) '\n'  : wchar("\n");nl(); break;
	default  :
		      printf("\n%c(%d): characters deleted",ch,ch);
		      printf(" (in line %d)\n",anznl+1);
		      break;
	}
      }
      rret=gchar(&ch); tpos++;
    }
  }

  else { printf("\nwrong option (code translation mode)\n");  exit(1);  }

  /********************************************************************************/
  /* if (old) DOS-end_of_file-character (explicit end_of_file) ist to be written  */
  /* uncomment the following statement:                                           */
  /*                                                                              */
  /* if ( strcmp(Vekt[1],"-u2d") == 0 ) { wchar("\032"); }                        */
  /********************************************************************************/

  if ( suz!=0 )
    printf("\n%6i German-umlaute in the input-file were changed",suz);
  if ( soz!=0 )
    printf("\n       file contains %i special characters (control-characters, 8bit-extension)",soz);

  close(filed1);
  wchar0();   close(filed2);
  printf("\n");
  /* eventually: */ /* (void) system("ls -l"); */
  /* or */          /* ivar = system("ls -l"); */
  exit(0);
}

/******************************************************************************/

void nl()
{
  anznl=anznl+1;  /* newline count! */
  tpos=0;
  if (anznl%100==0) write(1,".",1);
}

/******************************************************************************/

int  gchar(byt)
   /* reads (buffered) 1 character and returns it via the argument byt to the
      calling program    */
  char   *byt;
{
  static char buffer[BUFLEN_E];
  static int cnt=0;
  static char *ptr;

  if (cnt == 0)
   {cnt=read(filed1,buffer,BUFLEN_E);
		      /* printf("\n%d characters read",cnt); */
    ptr=buffer;
   }
  if (cnt > 0)
   {*byt = *ptr;     /*  printf("*%c,%d*",*ptr,cnt);  */
    cnt--;  ptr++;  anzz++;
    return (1);
   }
  else if (cnt < 0)
   {printf("\nerror in reading, return code=%d\n",cnt);
    return (cnt);
   }
  else
   {return (cnt);
   }
}

/******************************************************************************/

void wchar(byt)
     /* puts 1 character (=byt) into the buffer; */
     /* writes the buffer into output file when buffer is filled */
     /* last buffer is written at program end by a call of "wchar0()") */
  char   *byt;
{
  *ptr_a = *byt;
  cnt_a++;  ptr_a++;
  if (cnt_a == BUFLEN_A) {
    write(filed2,buffer_a,BUFLEN_A);
    /*   printf("\n#%c..%c#\n",buffer_a[0],buffer_a[BUFLEN_A-1]); */
    cnt_a=0;   ptr_a=buffer_a;
  }

  return;
}

/******************************************************************************/

void wchar0()
   /* forces writing of the buffer contents into the output file   */
{
  write(filed2,buffer_a,cnt_a);
  /*   printf("\n#%c..%c#\n",buffer_a[0],buffer_a[cnt_a]);  */
  cnt_a=0;   ptr_a=buffer_a;

  return;
}

/******************************************************************************/


#define AAA (unsigned char)'\251'	     /* not in ISO-latin-1, thus "Copyright"  */
#define III (unsigned char)'\333'           /* not in IBM-DOS-PC-code, this "Graphic"   */

void ibmiso(int index)
{

/*       index=0:    IBM-DOS-PC   -->  ISO-latin-1
	 index=1:    ISO-latin-1  -->  IBM-DOS-PC        */


                                                           /* Dez Okt | DOS      --> ISO-1    || ISO-1    --> DOS      */
static unsigned char w[256][2]=
     { { (unsigned char)'\000' , (unsigned char)'\000' },  /*   0 000 | NUL      --> NUL      ||   NUL    --> NUL      */ 
       { (unsigned char)'\001' , (unsigned char)'\001' },  /*   1 001 | SOH      --> SOH      ||   SOH    --> SOH      */ 
       { (unsigned char)'\002' , (unsigned char)'\002' },  /*   2 002 | STX      --> STX      ||   STX    --> STX      */ 
       { (unsigned char)'\003' , (unsigned char)'\003' },  /*   3 003 | ETX      --> ETX      ||   ETX    --> ETX      */ 
       { (unsigned char)'\004' , (unsigned char)'\004' },  /*   4 004 | EOT      --> EOT      ||   EOT    --> EOT      */ 
       { (unsigned char)'\005' , (unsigned char)'\005' },  /*   5 005 | ENQ      --> ENQ      ||   ENQ    --> ENQ      */ 
       { (unsigned char)'\006' , (unsigned char)'\006' },  /*   6 006 | ACK      --> ACK      ||   ACK    --> ACK      */ 
       { (unsigned char)'\007' , (unsigned char)'\007' },  /*   7 007 | BEL      --> BEL      ||   BEL    --> BEL      */ 
       { (unsigned char)'\010' , (unsigned char)'\010' },  /*   8 010 | BS       --> BS       ||   BS     --> BS       */ 
       { (unsigned char)'\011' , (unsigned char)'\011' },  /*   9 011 | HT       --> HT       ||   HT     --> HT       */ 
       { (unsigned char)'\012' , (unsigned char)'\012' },  /*  10 012 | LF       --> LF       ||   LF     --> LF       */ 
       { (unsigned char)'\013' , (unsigned char)'\013' },  /*  11 013 | VT       --> VT       ||   VT     --> VT       */ 
       { (unsigned char)'\014' , (unsigned char)'\014' },  /*  12 014 | FF       --> FF       ||   FF     --> FF       */ 
       { (unsigned char)'\015' , (unsigned char)'\015' },  /*  13 015 | CR       --> CR       ||   CR     --> CR       */ 
       { (unsigned char)'\016' , (unsigned char)'\016' },  /*  14 016 | SO       --> SO       ||   SO     --> SO       */ 
       { (unsigned char)'\017' , (unsigned char)'\017' },  /*  15 017 | SI       --> SI       ||   SI     --> SI       */ 
       { (unsigned char)'\020' , (unsigned char)'\020' },  /*  16 020 | DLE      --> DLE      ||   DLE    --> DLE      */ 
       { (unsigned char)'\021' , (unsigned char)'\021' },  /*  17 021 | DC1      --> DC1      ||   DC1    --> DC1      */ 
       { (unsigned char)'\022' , (unsigned char)'\022' },  /*  18 022 | DC2      --> DC2      ||   DC2    --> DC2      */ 
       { (unsigned char)'\023' , (unsigned char)'\023' },  /*  19 023 | DC3      --> DC3      ||   DC3    --> DC3      */ 
       { (unsigned char)'\266' ,                  III  },  /*  20 024 | \P       --> \P       ||   DC4    --> ***      */ 
       { (unsigned char)'\247' ,                  III  },  /*  21 025 | \S       --> \S       ||   NAK    --> ***      */ 
       { (unsigned char)'\026' , (unsigned char)'\026' },  /*  22 026 | SYN      --> SYN      ||   SYN    --> SYN      */ 
       { (unsigned char)'\027' , (unsigned char)'\027' },  /*  23 027 | ETB      --> ETB      ||   ETB    --> ETB      */ 
       { (unsigned char)'\030' , (unsigned char)'\030' },  /*  24 030 | CAN      --> CAN      ||   CAN    --> CAN      */ 
       { (unsigned char)'\031' , (unsigned char)'\031' },  /*  25 031 | EM       --> EM       ||   EM     --> EM       */ 
       { (unsigned char)'\032' , (unsigned char)'\032' },  /*  26 032 | SUB      --> SUB      ||   SUB    --> SUB      */ 
       { (unsigned char)'\033' , (unsigned char)'\033' },  /*  27 033 | ESC      --> ESC      ||   ESC    --> ESC      */ 
       { (unsigned char)'\034' , (unsigned char)'\034' },  /*  28 034 | FS       --> FS       ||   FS     --> FS       */ 
       { (unsigned char)'\035' , (unsigned char)'\035' },  /*  29 035 | GS       --> GS       ||   GS     --> GS       */ 
       { (unsigned char)'\036' , (unsigned char)'\036' },  /*  30 036 | RS       --> RS       ||   RS     --> RS       */ 
       { (unsigned char)'\037' , (unsigned char)'\037' },  /*  31 037 | US       --> US       ||   US     --> US       */ 
       { (unsigned char)'\040' , (unsigned char)'\040' },  /*  32 040 | blank    --> blank    ||   blank  --> blank    */ 
       { (unsigned char)'\041' , (unsigned char)'\041' },  /*  33 041 | !        --> !        ||   !      --> !        */
       { (unsigned char)'\042' , (unsigned char)'\042' },  /*  34 042 | "        --> "        ||   "      --> "        */
       { (unsigned char)'\043' , (unsigned char)'\043' },  /*  35 043 | #        --> #        ||   #      --> #        */
       { (unsigned char)'\044' , (unsigned char)'\044' },  /*  36 044 | $        --> $        ||   $      --> $        */
       { (unsigned char)'\045' , (unsigned char)'\045' },  /*  37 045 | %        --> %        ||   %      --> %        */
       { (unsigned char)'\046' , (unsigned char)'\046' },  /*  38 046 | &        --> &        ||   &      --> &        */
       { (unsigned char)'\047' , (unsigned char)'\047' },  /*  39 047 | '        --> '        ||   '      --> '        */
       { (unsigned char)'\050' , (unsigned char)'\050' },  /*  40 050 | (        --> (        ||   (      --> (        */
       { (unsigned char)'\051' , (unsigned char)'\051' },  /*  41 051 | )        --> )        ||   )      --> )        */
       { (unsigned char)'\052' , (unsigned char)'\052' },  /*  42 052 | *        --> *        ||   *      --> *        */
       { (unsigned char)'\053' , (unsigned char)'\053' },  /*  43 053 | +        --> +        ||   +      --> +        */
       { (unsigned char)'\054' , (unsigned char)'\054' },  /*  44 054 | , (Komma)--> ,        ||   ,      --> ,        */
       { (unsigned char)'\055' , (unsigned char)'\055' },  /*  45 055 | - (Minus)--> -        ||   -      --> -        */
       { (unsigned char)'\056' , (unsigned char)'\056' },  /*  46 056 | . (Punkt)--> .        ||   .      --> .        */
       { (unsigned char)'\057' , (unsigned char)'\057' },  /*  47 057 | /        --> /        ||   /      --> /        */
       { (unsigned char)'\060' , (unsigned char)'\060' },  /*  48 060 | 0        --> 0        ||   0      --> 0        */
       { (unsigned char)'\061' , (unsigned char)'\061' },  /*  49 061 | 1        --> 1        ||   1      --> 1        */
       { (unsigned char)'\062' , (unsigned char)'\062' },  /*  50 062 | 2        --> 2        ||   2      --> 2        */
       { (unsigned char)'\063' , (unsigned char)'\063' },  /*  51 063 | 3        --> 3        ||   3      --> 3        */
       { (unsigned char)'\064' , (unsigned char)'\064' },  /*  52 064 | 4        --> 4        ||   4      --> 4        */
       { (unsigned char)'\065' , (unsigned char)'\065' },  /*  53 065 | 5        --> 5        ||   5      --> 5        */
       { (unsigned char)'\066' , (unsigned char)'\066' },  /*  54 066 | 6        --> 6        ||   6      --> 6        */
       { (unsigned char)'\067' , (unsigned char)'\067' },  /*  55 067 | 7        --> 7        ||   7      --> 7        */
       { (unsigned char)'\070' , (unsigned char)'\070' },  /*  56 070 | 8        --> 8        ||   8      --> 8        */
       { (unsigned char)'\071' , (unsigned char)'\071' },  /*  57 071 | 9        --> 9        ||   9      --> 9        */
       { (unsigned char)'\072' , (unsigned char)'\072' },  /*  58 072 | :        --> :        ||   :      --> :        */
       { (unsigned char)'\073' , (unsigned char)'\073' },  /*  59 073 | ;        --> ;        ||   ;      --> ;        */
       { (unsigned char)'\074' , (unsigned char)'\074' },  /*  60 074 | <        --> <        ||   <      --> <        */
       { (unsigned char)'\075' , (unsigned char)'\075' },  /*  61 075 | =        --> =        ||   =      --> =        */
       { (unsigned char)'\076' , (unsigned char)'\076' },  /*  62 076 | >        --> >        ||   >      --> >        */
       { (unsigned char)'\077' , (unsigned char)'\077' },  /*  63 077 | ?        --> ?        ||   ?      --> ?        */
       { (unsigned char)'\100' , (unsigned char)'\100' },  /*  64 100 | @        --> @        ||   @      --> @        */
       { (unsigned char)'\101' , (unsigned char)'\101' },  /*  65 101 | A        --> A        ||   A      --> A        */
       { (unsigned char)'\102' , (unsigned char)'\102' },  /*  66 102 | B        --> B        ||   B      --> B        */
       { (unsigned char)'\103' , (unsigned char)'\103' },  /*  67 103 | C        --> C        ||   C      --> C        */
       { (unsigned char)'\104' , (unsigned char)'\104' },  /*  68 104 | D        --> D        ||   D      --> D        */
       { (unsigned char)'\105' , (unsigned char)'\105' },  /*  69 105 | E        --> E        ||   E      --> E        */
       { (unsigned char)'\106' , (unsigned char)'\106' },  /*  70 106 | F        --> F        ||   F      --> F        */
       { (unsigned char)'\107' , (unsigned char)'\107' },  /*  71 107 | G        --> G        ||   G      --> G        */
       { (unsigned char)'\110' , (unsigned char)'\110' },  /*  72 110 | H        --> H        ||   H      --> H        */
       { (unsigned char)'\111' , (unsigned char)'\111' },  /*  73 111 | I        --> I        ||   I      --> I        */
       { (unsigned char)'\112' , (unsigned char)'\112' },  /*  74 112 | J        --> J        ||   J      --> J        */
       { (unsigned char)'\113' , (unsigned char)'\113' },  /*  75 113 | K        --> K        ||   K      --> K        */
       { (unsigned char)'\114' , (unsigned char)'\114' },  /*  76 114 | L        --> L        ||   L      --> L        */
       { (unsigned char)'\115' , (unsigned char)'\115' },  /*  77 115 | M        --> M        ||   M      --> M        */
       { (unsigned char)'\116' , (unsigned char)'\116' },  /*  78 116 | N        --> N        ||   N      --> N        */
       { (unsigned char)'\117' , (unsigned char)'\117' },  /*  79 117 | O        --> O        ||   O      --> O        */
       { (unsigned char)'\120' , (unsigned char)'\120' },  /*  80 120 | P        --> P        ||   P      --> P        */
       { (unsigned char)'\121' , (unsigned char)'\121' },  /*  81 121 | Q        --> Q        ||   Q      --> Q        */
       { (unsigned char)'\122' , (unsigned char)'\122' },  /*  82 122 | R        --> R        ||   R      --> R        */
       { (unsigned char)'\123' , (unsigned char)'\123' },  /*  83 123 | S        --> S        ||   S      --> S        */
       { (unsigned char)'\124' , (unsigned char)'\124' },  /*  84 124 | T        --> T        ||   T      --> T        */
       { (unsigned char)'\125' , (unsigned char)'\125' },  /*  85 125 | U        --> U        ||   U      --> U        */
       { (unsigned char)'\126' , (unsigned char)'\126' },  /*  86 126 | V        --> V        ||   V      --> V        */
       { (unsigned char)'\127' , (unsigned char)'\127' },  /*  87 127 | W        --> W        ||   W      --> W        */
       { (unsigned char)'\130' , (unsigned char)'\130' },  /*  88 130 | X        --> X        ||   X      --> X        */
       { (unsigned char)'\131' , (unsigned char)'\131' },  /*  89 131 | Y        --> Y        ||   Y      --> Y        */
       { (unsigned char)'\132' , (unsigned char)'\132' },  /*  90 132 | Z        --> Z        ||   Z      --> Z        */
       { (unsigned char)'\133' , (unsigned char)'\133' },  /*  91 133 | [        --> [        ||   [      --> [        */
       { (unsigned char)'\134' , (unsigned char)'\134' },  /*  92 134 | \        --> \        ||   \      --> \        */
       { (unsigned char)'\135' , (unsigned char)'\135' },  /*  93 135 | ]        --> ]        ||   ]      --> ]        */
       { (unsigned char)'\136' , (unsigned char)'\136' },  /*  94 136 | ^        --> ^        ||   ^      --> ^        */
       { (unsigned char)'\137' , (unsigned char)'\137' },  /*  95 137 | _        --> _        ||   _      --> _        */
       { (unsigned char)'\140' , (unsigned char)'\140' },  /*  96 140 | `        --> `        ||   `      --> `        */
       { (unsigned char)'\141' , (unsigned char)'\141' },  /*  97 141 | a        --> a        ||   a      --> a        */
       { (unsigned char)'\142' , (unsigned char)'\142' },  /*  98 142 | b        --> b        ||   b      --> b        */
       { (unsigned char)'\143' , (unsigned char)'\143' },  /*  99 143 | c        --> c        ||   c      --> c        */
       { (unsigned char)'\144' , (unsigned char)'\144' },  /* 100 144 | d        --> d        ||   d      --> d        */
       { (unsigned char)'\145' , (unsigned char)'\145' },  /* 101 145 | e        --> e        ||   e      --> e        */
       { (unsigned char)'\146' , (unsigned char)'\146' },  /* 102 146 | f        --> f        ||   f      --> f        */
       { (unsigned char)'\147' , (unsigned char)'\147' },  /* 103 147 | g        --> g        ||   g      --> g        */
       { (unsigned char)'\150' , (unsigned char)'\150' },  /* 104 150 | h        --> h        ||   h      --> h        */
       { (unsigned char)'\151' , (unsigned char)'\151' },  /* 105 151 | i        --> i        ||   i      --> i        */
       { (unsigned char)'\152' , (unsigned char)'\152' },  /* 106 152 | j        --> j        ||   j      --> j        */
       { (unsigned char)'\153' , (unsigned char)'\153' },  /* 107 153 | k        --> k        ||   k      --> k        */
       { (unsigned char)'\154' , (unsigned char)'\154' },  /* 108 154 | l        --> l        ||   l      --> l        */
       { (unsigned char)'\155' , (unsigned char)'\155' },  /* 109 155 | m        --> m        ||   m      --> m        */
       { (unsigned char)'\156' , (unsigned char)'\156' },  /* 110 156 | n        --> n        ||   n      --> n        */
       { (unsigned char)'\157' , (unsigned char)'\157' },  /* 111 157 | o        --> o        ||   o      --> o        */
       { (unsigned char)'\160' , (unsigned char)'\160' },  /* 112 160 | p        --> p        ||   p      --> p        */
       { (unsigned char)'\161' , (unsigned char)'\161' },  /* 113 161 | q        --> q        ||   q      --> q        */
       { (unsigned char)'\162' , (unsigned char)'\162' },  /* 114 162 | r        --> r        ||   r      --> r        */
       { (unsigned char)'\163' , (unsigned char)'\163' },  /* 115 163 | s        --> s        ||   s      --> s        */
       { (unsigned char)'\164' , (unsigned char)'\164' },  /* 116 164 | t        --> t        ||   t      --> t        */
       { (unsigned char)'\165' , (unsigned char)'\165' },  /* 117 165 | u        --> u        ||   u      --> u        */
       { (unsigned char)'\166' , (unsigned char)'\166' },  /* 118 166 | v        --> v        ||   v      --> v        */
       { (unsigned char)'\167' , (unsigned char)'\167' },  /* 119 167 | w        --> w        ||   w      --> w        */
       { (unsigned char)'\170' , (unsigned char)'\170' },  /* 120 170 | x        --> x        ||   x      --> x        */
       { (unsigned char)'\171' , (unsigned char)'\171' },  /* 121 171 | y        --> y        ||   y      --> y        */
       { (unsigned char)'\172' , (unsigned char)'\172' },  /* 122 172 | z        --> z        ||   z      --> z        */
       { (unsigned char)'\173' , (unsigned char)'\173' },  /* 123 173 | {        --> {        ||   {      --> {        */
       { (unsigned char)'\174' , (unsigned char)'\174' },  /* 124 174 | |        --> |        ||   |      --> |        */
       { (unsigned char)'\175' , (unsigned char)'\175' },  /* 125 175 | }        --> }        ||   }      --> }        */
       { (unsigned char)'\176' , (unsigned char)'\176' },  /* 126 176 | ~        --> ~        ||   ~      --> ~        */
       { (unsigned char)'\177' , (unsigned char)'\177' },  /* 127 177 | DEL      --> DEL      ||   DEL    --> DEL      */
       { (unsigned char)'\307' ,                  III  },  /* 128 200 | \c{C}    --> \c{C}    || ***      --> ***      */
       { (unsigned char)'\374' ,                  III  },  /* 129 201 | \"u      --> \"u      || ***      --> ***      */
       { (unsigned char)'\351' ,                  III  },  /* 130 202 | \acute{e}--> \acute{e}|| ***      --> ***      */
       { (unsigned char)'\342' ,                  III  },  /* 131 203 | \hat{a}  --> \hat{a}  || ***      --> ***      */
       { (unsigned char)'\344' ,                  III  },  /* 132 204 | \"a      --> \"a      || ***      --> ***      */
       { (unsigned char)'\340' ,                  III  },  /* 133 205 | \grave{a}--> \grave{a}|| ***      --> ***      */
       { (unsigned char)'\345' ,                  III  },  /* 134 206 | \aa      --> \aa      || ***      --> ***      */
       { (unsigned char)'\347' ,                  III  },  /* 135 207 | \c{c}    --> \c{c}    || ***      --> ***      */
       { (unsigned char)'\352' ,                  III  },  /* 136 210 | \hat{e}  --> \hat{e}  || ***      --> ***      */
       { (unsigned char)'\353' ,                  III  },  /* 137 211 | \"e      --> \"e      || ***      --> ***      */
       { (unsigned char)'\350' ,                  III  },  /* 138 212 | \grave{e}--> \grave{e}|| ***      --> ***      */
       { (unsigned char)'\357' ,                  III  },  /* 139 213 | \"i      --> \"i      || ***      --> ***      */
       { (unsigned char)'\356' ,                  III  },  /* 140 214 | \hat{i}  --> \hat{i}  || ***      --> ***      */
       { (unsigned char)'\354' ,                  III  },  /* 141 215 | \grave{i}--> \grave{i}|| ***      --> ***      */
       { (unsigned char)'\304' ,                  III  },  /* 142 216 | \"A      --> \"A      || ***      --> ***      */
       { (unsigned char)'\305' ,                  III  },  /* 143 217 | \AA      --> \AA      || ***      --> ***      */
       { (unsigned char)'\311' ,                  III  },  /* 144 220 | \acute{E}--> \acute{E}|| ***      --> ***      */
       { (unsigned char)'\346' ,                  III  },  /* 145 221 | \ae      --> \ae      || ***      --> ***      */
       { (unsigned char)'\306' ,                  III  },  /* 146 222 | \AE      --> \AE      || ***      --> ***      */
       { (unsigned char)'\364' ,                  III  },  /* 147 223 | \hat{o}  --> \hat{o}  || ***      --> ***      */
       { (unsigned char)'\366' ,                  III  },  /* 148 224 | \"o      --> \"o      || ***      --> ***      */
       { (unsigned char)'\362' ,                  III  },  /* 149 225 | \grave{o}--> \grave{o}|| ***      --> ***      */
       { (unsigned char)'\373' ,                  III  },  /* 150 226 | \hat{u}  --> \hat{u}  || ***      --> ***      */
       { (unsigned char)'\371' ,                  III  },  /* 151 227 | \grave{u}--> \grave{u}|| ***      --> ***      */
       { (unsigned char)'\377' ,                  III  },  /* 152 230 | \"y      --> \"y      || ***      --> ***      */
       { (unsigned char)'\326' ,                  III  },  /* 153 231 | \"O      --> \"O      || ***      --> ***      */
       { (unsigned char)'\334' ,                  III  },  /* 154 232 | \"U      --> \"U      || ***      --> ***      */
       { (unsigned char)'\242' ,                  III  },  /* 155 233 | \|C      --> \|C      || ***      --> ***      */
       { (unsigned char)'\243' ,                  III  },  /* 156 234 | \pounds  --> \pounds  || ***      --> ***      */
       { (unsigned char)'\245' ,                  III  },  /* 157 235 | Yen      --> Yen      || ***      --> ***      */
       {                  AAA  ,                  III  },  /* 158 236 | Pt       --> ***      || ***      --> ***      */
       {                  AAA  ,                  III  },  /* 159 237 | f        --> ***      || ***      --> ***      */
       { (unsigned char)'\341' ,                  III  },  /* 160 240 | \acute{a}--> \acute{a}|| ***      --> ***      */
       { (unsigned char)'\355' , (unsigned char)'\255' },  /* 161 241 | \acute{i}--> \acute{i}|| !'       --> !'       */
       { (unsigned char)'\363' , (unsigned char)'\233' },  /* 162 242 | \acute{o}--> \acute{o}|| \|C      --> \|C      */
       { (unsigned char)'\372' , (unsigned char)'\234' },  /* 163 243 | \acute{u}--> \acute{u}|| \pounds  --> \pounds  */
       { (unsigned char)'\361' ,                  III  },  /* 164 244 | \tilde{n}--> \tilde{n}|| Sofakiss --> ***      */
       { (unsigned char)'\321' , (unsigned char)'\235' },  /* 165 245 | \tilde{N}--> \tilde{N}|| Yen      --> Yen      */
       { (unsigned char)'\252' , (unsigned char)'\174' },  /* 166 246 | ^{a}     --> ^{a}     || |unterbr --> |unterbr */
       { (unsigned char)'\272' , (unsigned char)'\025' },  /* 167 247 | ^{o}     --> ^{o}     || \S       --> NAK      */
       { (unsigned char)'\277' ,                  III  },  /* 168 250 | ?'       --> ?'       || \ddot    --> ***      */
       {                  AAA  ,                  III  },  /* 169 251 | ***      --> ***      || \copyright-> ***      */
       { (unsigned char)'\254' , (unsigned char)'\246' },  /* 170 252 | \not     --> \not     || ^{a}     --> ^{a}     */
       { (unsigned char)'\275' , (unsigned char)'\256' },  /* 171 253 | 1/2      --> 1/2      || <<       --> <<       */
       { (unsigned char)'\274' , (unsigned char)'\252' },  /* 172 254 | 1/4      --> 1/4      || \not     --> \not     */
       { (unsigned char)'\241' ,                  III  },  /* 173 255 | !'       --> !'       || SHY      --> ***      */
       { (unsigned char)'\253' ,                  III  },  /* 174 256 | <<       --> <<       || regist   --> ***      */
       { (unsigned char)'\273' ,                  III  },  /* 175 257 | >>       --> >>       || ^{-}     --> ***      */
       {                  AAA  , (unsigned char)'\370' },  /* 176 260 | ***      --> ***      || ^{o}     --> ^{o}     */
       {                  AAA  , (unsigned char)'\361' },  /* 177 261 | ***      --> ***      || \pm      --> \pm      */
       {                  AAA  , (unsigned char)'\375' },  /* 178 262 | ***      --> ***      || ^{2}     --> ^{2}     */
       {                  AAA  ,                  III  },  /* 179 263 | ***      --> ***      || ^{3}     --> ***      */
       {                  AAA  ,                  III  },  /* 180 264 | ***      --> ***      || \acute   --> ***      */
       {                  AAA  , (unsigned char)'\346' },  /* 181 265 | ***      --> ***      || \mu      --> \mu      */
       {                  AAA  , (unsigned char)'\024' },  /* 182 266 | ***      --> ***      || PI       --> PI       */
       {                  AAA  ,                  III  },  /* 183 267 | ***      --> ***      || ***      --> ***      */
       {                  AAA  ,                  III  },  /* 184 270 | ***      --> ***      || ***      --> ***      */
       {                  AAA  ,                  III  },  /* 185 271 | ***      --> ***      || ^{1}     --> ***      */
       {                  AAA  , (unsigned char)'\247' },  /* 186 272 | ***      --> ***      || ^{o}     --> ^{o}     */
       {                  AAA  , (unsigned char)'\257' },  /* 187 273 | ***      --> ***      || >>       --> >>       */
       {                  AAA  , (unsigned char)'\254' },  /* 188 274 | ***      --> ***      || 1/4      --> 1/4      */
       {                  AAA  , (unsigned char)'\253' },  /* 189 275 | ***      --> ***      || 1/2      --> 1/2      */
       {                  AAA  ,                  III  },  /* 190 276 | ***      --> ***      || 3/4      --> ***      */
       {                  AAA  , (unsigned char)'\250' },  /* 191 277 | ***      --> ***      || ?'       --> ?'       */
       {                  AAA  ,                  III  },  /* 192 300 | ***      --> ***      || \grave{A}--> ***      */
       {                  AAA  ,                  III  },  /* 193 301 | ***      --> ***      || \acute{A}--> ***      */
       {                  AAA  ,                  III  },  /* 194 302 | ***      --> ***      || \hat{A}  --> ***      */
       {                  AAA  ,                  III  },  /* 195 303 | ***      --> ***      || \tilde{A}--> ***      */
       {                  AAA  , (unsigned char)'\216' },  /* 196 304 | ***      --> ***      || \"A      --> \"A      */
       {                  AAA  , (unsigned char)'\217' },  /* 197 305 | ***      --> ***      || \AA      --> \AA      */
       {                  AAA  , (unsigned char)'\222' },  /* 198 306 | ***      --> ***      || \AE      --> \AE      */
       {                  AAA  , (unsigned char)'\200' },  /* 199 307 | ***      --> ***      || \c{C}    --> \c{C}    */
       {                  AAA  ,                  III  },  /* 200 310 | ***      --> ***      || \grave{E}--> ***      */
       {                  AAA  , (unsigned char)'\220' },  /* 201 311 | ***      --> ***      || \acute{E}--> \acute{E}*/
       {                  AAA  ,                  III  },  /* 202 312 | ***      --> ***      || ***      --> ***      */
       {                  AAA  ,                  III  },  /* 203 313 | ***      --> ***      || \"E      --> ***      */
       {                  AAA  ,                  III  },  /* 204 314 | ***      --> ***      || \grave{I}--> ***      */
       {                  AAA  ,                  III  },  /* 205 315 | ***      --> ***      || \acute{I}--> ***      */
       {                  AAA  ,                  III  },  /* 206 316 | ***      --> ***      || \hat{I}  --> ***      */
       {                  AAA  ,                  III  },  /* 207 317 | ***      --> ***      || \"I      --> ***      */
       {                  AAA  ,                  III  },  /* 208 320 | ***      --> ***      || -D       --> ***      */
       {                  AAA  , (unsigned char)'\245' },  /* 209 321 | ***      --> ***      || \tilde{N}--> \tilde{N}*/
       {                  AAA  ,                  III  },  /* 210 322 | ***      --> ***      || \grave{O}--> ***      */
       {                  AAA  ,                  III  },  /* 211 323 | ***      --> ***      || \acute{O}--> ***      */
       {                  AAA  ,                  III  },  /* 212 324 | ***      --> ***      || \hat{O}  --> ***      */
       {                  AAA  ,                  III  },  /* 213 325 | ***      --> ***      || \tilde{O}--> ***      */
       {                  AAA  , (unsigned char)'\231' },  /* 214 326 | ***      --> ***      || \"O      --> \"O      */
       {                  AAA  ,                  III  },  /* 215 327 | ***      --> ***      || \times   --> ***      */
       {                  AAA  , (unsigned char)'\355' },  /* 216 330 | ***      --> ***      || \O       --> \O       */
       {                  AAA  ,                  III  },  /* 217 331 | ***      --> ***      || \grave{U}--> ***      */
       {                  AAA  ,                  III  },  /* 218 332 | ***      --> ***      || \acute{U}--> ***      */
       {                  AAA  ,                  III  },  /* 219 333 | ***      --> ***      || \hat{U}  --> ***      */
       {                  AAA  , (unsigned char)'\232' },  /* 220 334 | ***      --> ***      || \"U      --> \"U      */
       {                  AAA  ,                  III  },  /* 221 335 | ***      --> ***      || \acute{Y}--> ***      */
       {                  AAA  ,                  III  },  /* 222 336 | ***      --> ***      || |p       --> ***      */
       {                  AAA  , (unsigned char)'\341' },  /* 223 337 | ***      --> ***      || \"s      --> \beta    */
       {                  AAA  , (unsigned char)'\205' },  /* 224 340 | \alpha   --> ***      || \grave{a}--> \grave{a}*/
       { (unsigned char)'\337' , (unsigned char)'\240' },  /* 225 341 | \beta    --> \"s      || \acute{a}--> \acute{a}*/
       {                  AAA  , (unsigned char)'\203' },  /* 226 342 | \Gamma   --> ***      || \hat{a}  --> \hat{a}  */
       {                  AAA  ,                  III  },  /* 227 343 | \pi      --> ***      || \tilde{a}--> ***      */
       {                  AAA  , (unsigned char)'\204' },  /* 228 344 | \Sigma   --> ***      || \"a      --> \"a      */
       {                  AAA  , (unsigned char)'\206' },  /* 229 345 | \sigma   --> ***      || \aa      --> \aa      */
       { (unsigned char)'\265' , (unsigned char)'\221' },  /* 230 346 | \mu      --> \mu      || \ae      --> \ae      */
       {                  AAA  , (unsigned char)'\207' },  /* 231 347 | \tau     --> ***      || \c{c}    --> \c{c}    */
       {                  AAA  , (unsigned char)'\212' },  /* 232 350 | \Phi     --> ***      || \grave{e}--> \grave{e}*/
       {                  AAA  , (unsigned char)'\202' },  /* 233 351 | \Theta   --> ***      || \acute{e}--> \acute{e}*/
       {                  AAA  , (unsigned char)'\210' },  /* 234 352 | \Omega   --> ***      || \hat{e}  --> \at{e}   */
       {                  AAA  , (unsigned char)'\211' },  /* 235 353 | \delta   --> ***      || \"e      --> \"e      */
       {                  AAA  , (unsigned char)'\215' },  /* 236 354 | \infty   --> ***      || \grave{i}--> \grave{i}*/
       { (unsigned char)'\330' , (unsigned char)'\241' },  /* 237 355 | \O       --> \O       || \acute{i}--> \acute{i}*/
       {                  AAA  , (unsigned char)'\214' },  /* 238 356 | \in      --> ***      || \hat{i}  --> \hat{i}  */
       {                  AAA  , (unsigned char)'\213' },  /* 239 357 | \cap     --> ***      || \"i      --> \"i      */
       {                  AAA  ,                  III  },  /* 240 360 | \equiv   --> ***      || -d       --> ***      */
       { (unsigned char)'\261' , (unsigned char)'\244' },  /* 241 361 | \pm      --> \pm      || \tilde{n}--> \tilde{n}*/
       {                  AAA  , (unsigned char)'\225' },  /* 242 362 | \geq     --> ***      || \grave{o}--> \grave{o}*/
       {                  AAA  , (unsigned char)'\242' },  /* 243 363 | \leq     --> ***      || \acute{o}--> \acute{o}*/
       {                  AAA  , (unsigned char)'\223' },  /* 244 364 | 1/2Integr--> ***      || \hat{o}  --> \hat{o}  */
       {                  AAA  ,                  III  },  /* 245 365 | 1/2Integr--> ***      || \tilde{o}--> ***      */
       { (unsigned char)'\367' , (unsigned char)'\224' },  /* 246 366 | \dif     --> \dif     || \"o      --> \"o      */
       {                  AAA  , (unsigned char)'\366' },  /* 247 367 | \approx  --> ***      || \dif     --> \dif     */
       { (unsigned char)'\260' ,                  III  },  /* 248 370 | ^{o}     --> ^{o}     || \o       --> ***      */
       {                  AAA  , (unsigned char)'\227' },  /* 249 371 | \bullet  --> ***      || \grave{u}--> \grave{u}*/
       {                  AAA  , (unsigned char)'\243' },  /* 250 372 | \bullet  --> ***      || \acute{u}--> \acute{u}*/
       {                  AAA  , (unsigned char)'\226' },  /* 251 373 | \sqrt    --> ***      || \hat{u}  --> \hat{u}  */
       {                  AAA  , (unsigned char)'\201' },  /* 252 374 | ^{n}     --> ***      || \"u      --> \"u      */
       { (unsigned char)'\262' ,                  III  },  /* 253 375 | ^{2}     --> ^{2}     || \acute{y}--> ***      */
       {                  AAA  ,                  III  },  /* 254 376 | \box     --> ***      || |P       --> ***      */
       {                  AAA  , (unsigned char)'\230' }   /* 255 377 | ***      --> ***      || \"y      --> \"y      */
     };


  unsigned char c1, c2, cc;
char byt1, byt2;
  int rret, ges, un;
  cc = AAA;
  if (index == 1) cc = III;
  ges = 0; un = 0;
  rret = gchar(&byt1);
  while (rret > 0)
  {
    c1 = (unsigned char) byt1;
    ges++;
    c2 = w[c1][index];
    if (c2 == cc) un++;
    byt2 = (char) c2;
    wchar(&byt2);
    rret = gchar(&byt1);
  };

   printf("\n %d characters read/written", ges);
   if (un > 0)
     printf("\n %d characters could not be translated, changed to '\\%o' (octal)\n",
	     un, cc);
   wchar0();
   return;
}
