
/* This simple program toggles the sensitive second bytes for ChiTeX.
   If the second byte of a Chinese in Big-5 code is \ or { or },
   it is converted to unused bytes.  And vice versa.

   If an optional argument -u is given, all small alphabets a-z are
   also converted to unused bytes (in addition of the above three).
   This is designed to be safe for the TeX commands like \uppercase.

   This program outputs to stdout.  If an input file is given, it takes
   that file; otherwise it takes from stdin.  So "chicode file | chicode"
   should give exactly the same file.

   Created: Shann Wei-Chang , May 23, 1995.
   Version 1: December 21, 1995 
   
   Modified by: Hung-Yih Chen , Mar. 18, 2000  */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int checkarg(char []);

int main (int argc, char *argv[]) {
    int i=0, c, flag_chi=0, flag_stdin=1, flag_u=0;
    char *fname, *fnametex;
    FILE *fp;

    switch(argc) {
    case 1:
	fp = stdin;
	break;
    case 2:
	if (argv[1][0] == '-') {
	    if (checkarg(argv[1])) {
		flag_u = 1;
		fp = stdin;
	    }
	    else {
		fprintf(stderr, "Usage: %s [-u] [filename]\n", argv[0]);
		exit(1);
	    }
	}
	else {
	    flag_stdin=0;
	    fname = argv[1];
	}
	break;
    case 3:
	if (checkarg(argv[1])) {
	    flag_u = 1;
	    flag_stdin=0;
	    fname = argv[2];
	}
	else {
	    fprintf(stderr, "Usage: %s [-u] [filename]\n", argv[0]);
	    exit(1);
	}
	break;
    default:
	fprintf(stderr, "Usage: %s [-u] [filename]\n", argv[0]);
	exit(1);
	break;
    }

    if (!flag_stdin) {
	fp = fopen(fname, "r");
        if (fp == NULL) {
	    if (strchr(fname, '.') == NULL) {
		fnametex = (char *) malloc(strlen(fname)+5);
		while (fname[i] != '\0') {
		    fnametex[i] = fname[i];
		    ++i;
		}
		fnametex[i++] = '.';
		fnametex[i++] = 't';
		fnametex[i++] = 'e';
		fnametex[i++] = 'x';
		fnametex[i++] = '\0';
		fclose(fp);
		fp = fopen(fnametex, "r");
		if (fp == NULL) {
		    fprintf(stderr, "%s[.tex] not opened.\n", fname);
		    exit(-1);
		}
	    }
	    else {
		fprintf(stderr, "%s not opened.\n", fname);
		exit(-1);
	    }
        }
    }
	
    while ((c = getc(fp)) != EOF) {
	if (!flag_chi) {
	    if ((c < 250) && (c > 160))
		flag_chi = 1;
	}
	else {
	    switch(c) {
/*	    case '\\':
		c = 159;
		break;
	    case '{':
		c = 155;
		break;
	    case '}':
		c = 157;
		break;       */
	    case 159:
		c = '\\';
		break;
	    case 155:
		c = '{';
		break;
	    case 157:
		c = '}';    
		break; 
/*	    case 91:
		c = 158;
		break;     
	    case 93:
		c = 160;
		break;        */
	    case 158:
		c = 91;
		break;
	    case 160:
		c = 93;
		break;   
/*	    case '|':
		c = 156;
		break;
	    case '~':
		c = 128;
		break;         */
	    case 156:
		c = '|';
		break;
	    case 128:
		c = '~';
		break;       
	    default:
		if (flag_u) {
/*		    if ((c >= 'a') && (c <= 'z'))
			c = c - 'a' + 129;
		    else if ((c > 128) && (c < 155))
			c = c - 129 + 'a';              */
		    if ((c > 128) && (c < 155))
			c = c - 129 + 'a';
		}
		break;
	    }
	    flag_chi = 0;
	}
	printf("%c", c);
    }
    fclose(fp);
    return 0;
}

int checkarg(char s[]) {
    if (s[0] == '-') {
	if (s[1] == 'u')
	    return 1;
	else
	    return 0;
    }
    else
	return 0;
}
