/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "cpptcl_private.h"
 *                                    created: 31/10/97 {3:51:17 pm} 
 *                                last update: 05/06/98 {16:22:01 PM} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ===================================================================
 * Copyright (c) 1997  Vince Darley
 *  
 * See the file "license.terms" for information on usage and 
 * redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * ===================================================================
 *  Description: 
 * 
 *  History
 * 
 *  modified by  rev reason
 *  -------- --- --- -----------
 *  31/10/97 VMD 1.0 original
 * ###################################################################
 */

#ifndef _Cpptcl_cpptcl_private_
#define _Cpptcl_cpptcl_private_

class tcl_object;

#ifdef __GNUC__
typedef int (tcl_object::*cpp_mptr);
typedef int (tcl_object::*cpp_mfptr)(void);
#else
typedef void (tcl_object::*cpp_mfptr)(void);
typedef void (tcl_object::*cpp_mptr);
#endif

union cpp_private {
  private:
	void* ptr;
	cpp_mptr mptr;
	cpp_mfptr mfptr;
	long tr;
  public:
	cpp_private(void* p):ptr(p) {}
	cpp_private(cpp_mptr m):mptr(m) {}
	cpp_private(cpp_mfptr m):mfptr(m) {}
	cpp_private(long r):tr(r) {}
	bool operator == (void* p) const {return (ptr == p);}
	bool operator == (cpp_mptr m) const {return (mptr == m);}
	bool operator == (cpp_mfptr m) const {return (mfptr == m);}
	bool operator == (long r) const {return (tr == r);}
};

#endif
