/* -*-C++-*-
 * ###################################################################
 *	Cpptcl - Integrating C++ with Tcl
 * 
 *	FILE: "cpptcl_info.h"
 *									  created: 26/6/96 {12:13:07 pm} 
 *								  last update: 19/11/97 {1:58:40 pm} 
 *	Author:	Vince Darley
 *	E-mail:	<darley@fas.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www:	<http://www.fas.harvard.edu/~darley/>
 *	
 * ===================================================================
 * Copyright (c) 1997  Vince Darley
 *  
 * See the file "license.terms" for information on usage and 
 * redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * ===================================================================
 *	Description: Control and utility meta_object for Cpptcl
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	26/6/96	 VMD 1.0 original
 * ###################################################################
 */

#ifndef _Cpptcl_cpptcl_info_
#define _Cpptcl_cpptcl_info_

#include "tcl_object.h"

//@Section: Cpptcl library
///
/**
 * -------------------------------------------------------------------------
 *   
 * "class cpptcl_info" --
 *  
 *  Implements the 'cpptcl' object which supports command completion
 *  in the Cpptcl object system.  Usage is as follows:
 *     
 *     % cpptcl complete object co
 *     Completions:
 *     object command
 *     object compost
 *     
 *  which will return all sub commands of 'object' which begin with 'co'.
 *  To find the maximum common completion, use:
 *     % cpptcl maxCompletion
 *  and to get back the original command, use:
 *     % cpptcl origCommand
 *  For the above example these would return 'm' and 'object co' 
 *  respectively)
 *         
 *  Ideally this should be used transparently in the tcl shell, by     
 *  binding, say 'Tab', to grab the current line, prefix it with       
 *  'cpptcl complete ', evaluate it and then generate the completion.
 *
 *  You can also use 'cpptcl isCpptcl cmd' to check if an tcl command
 *  really is a Cpptcl object.
 *
 * Command Summary:
 *
 *       % cpx::documentObject cpptcl
 *       cpptcl author : name and e-mail address for bug reports
 *       cpptcl cget : return value of a configuration option
 *       cpptcl complete : complete a command on a Cpptcl object
 *       cpptcl config : set a configuration option
 *       cpptcl configure : set a configuration option
 *       cpptcl getType : gets type of the object or one of its members
 *       cpptcl help : find help for a command on a Cpptcl object
 *       cpptcl isCpptcl : is this a Cpptcl object
 *       cpptcl listMembers : lists registered object members
 *       cpptcl maxCompletion : return maximum length common prefix for last completion
 *       cpptcl mconfig : query a member.
 *       cpptcl memberconfigure : query a member
 *       cpptcl origCommand : return length of command which was completed
 *       cpptcl rename : changes the Tcl command name of the object
 *       cpptcl traceset : Set value of enclosed member using syntax of 'trace' call.
 *       cpptcl webPage : web page for online documentation
 *         
 * Side effects:
 *  Issues fake commands to the object being queried, so such objects must
 *  be interfaced correctly to the Cpptcl system, or commands may actually
 *  be carried out.  Make sure you use 'arg >> done' correctly to avoid
 *  any problems (and the 'NO_EXCEPTIONS' macro if required).
 *  
 * --Version--Author------------------Changes-------------------------------  
 *	  1.0	  <darley@fas.harvard.edu> original
 * -------------------------------------------------------------------------
 */
class cpptcl_info: public tcl_object {
  public:
	/// Construct the 'cpptcl' completion object
    /* This is called automatically by the package init procedure */
	cpptcl_info(tcl_obj& i, const char* name)
        :tcl_object(i,name), max_completion(0), orig_command(0) {}
                
	/// Free any allocated memory and delete the object
	~cpptcl_info(void) { free_completion_mem();}
	
	/// Free my memory
	void free_completion_mem(void);	
	/// Implement the 'complete', 'origCommand' and other commands.
	int parse_tcl_command(tcl_args& arg);
	
  protected:
	/// Stores the max completion
  	char* max_completion;
	/// Stores the original command
	char* orig_command;
	
};

#endif
