# Contributing

You can report bugs and request features using the [issues page](https://github.com/sieversMartin/cid/issues).

We love code contributions.
You can easily work on the code if you have a GitHub account ([get one](https://github.com/join)).
For that, please [fork the repository](https://help.github.com/articles/fork-a-repo/), work on the code, and submit a [pull request](https://help.github.com/articles/about-pull-requests/).

## Hints on GitHub usage

Take a look at GitHub's excellent overview on the [GitHub flow](https://guides.github.com/introduction/flow/index.html).
The [Feature Branch Workflow](https://de.atlassian.com/git/tutorials/comparing-workflows#feature-branch-workflow) forms the basis of this kind of development.

In other words:

1. Fork the project
2. Clone the repo:

       git clone git@github.com:your-username/cid.git

3. Create a new branch `patch` (or another speaking name)

       git checkout -b patch

4. Make your changes.
5. Commit your changes.
   Thereby, try to write a [good commit message](https://github.com/joelparkerhenderson/git_commit_message).
6. Push your changes (to your repository)
7. [submit a pull request](https://github.com/sieversMartin/cid/compare/)
8. At this point you're waiting on us.
   We like to at least comment on pull requests as soon as possible.
   We may suggest some changes or improvements or alternatives.
