---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, tables des matières,
              profondeur de table 
---

# Comment changer la profondeur de la table des matières ?

Les compteurs `secnumdepth` et `tocdepth` permettent de contrôler 
respectivement la *profondeur* jusqu'à laquelle les niveaux de sectionnement
d'un document sont numérotés et la profondeur jusqu'à laquelle ils entrent 
dans la table des matières. La profondeur est une valeur numérique associée 
aux différents niveaux de sectionnement :

- une partie (associée à la commande `\part`) a une profondeur égale à -1 ;
- un chapitre (`\chapter`) a une profondeur de 0 ;
- une section (`\section`) a une profondeur de 1 ;
- et ainsi de suite...

Aussi, par exemple, pour que les sections soient incluses dans la table 
des matières, mais pas les sous-sections, il faut écrire :

```{noedit}
\setcounter{tocdepth}{1}
```

Cette modification doit précéder l'appel à la commande 
`\tableofcontents`.

De façon similaire, pour que les sous-sections soient numérotées, 
mais pas les sous-sous-sections, il faut indiquer :

```{noedit}
\setcounter{secnumdepth}{2}
```

Voici un exemple où vous pouvez modifier les valeurs des deux
compteurs pour observer leur impact.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\setcounter{tocdepth}{2}      % Table des matières jusqu'aux sous-sections
\setcounter{secnumdepth}{3}   % Numérotation jusqu'aux sous-sous-sections.
\tableofcontents
\section{Comme dirait l'autre}
\subsection{Je suis venu}
\subsubsection{Par hasard}
\subsection{J'ai vu}
\subsubsection{Que je ne devais pas rester là}
\subsubsection{Que tout partait en vrilles}
\subsection{J'ai vaincu}
\subsubsection{Ma peur de partir immédiatement}
\end{document}
```