---
myst:
  html_meta:
    keywords: LaTeX,dessin,post-it battle,style 8 bits,dessin pixelisé
---
# Comment dessiner en style 8-bits ?

Vous en avez marre de toutes ces [courbes de Bézier](wpfr:Metafont), et vous voulez retrouver le bon vieux style graphique de votre GameBoy ?

## Avec LuaLaTeX : <ctanpkg:PixelArt>

Le package [PixelArt](ctanpkg:pixelart) est fait pour vous. Sa commande `\pixelart` prend une matrice en paramètre, et affiche une image bitmap à gros pixels.

```
%!TEX engine=lualatex
\documentclass{article}
  \usepackage{pixelart}
  \pagestyle{empty}

\begin{document}
I \pixelart[
    colors={
      1=red,
      2={red!50!black},
      3={pink},
      4={pink!50!red},
    },
    tikz={
      scale=.05,
      baseline=.3em,
    }
  ]{
    ..12..12..
    .13411112.
    1341111112
    1341111112
    1341111112
    .11111112.
    ..111112..
    ...1112...
    ....12....
  } \LaTeX
\end{document}
```

Ce paquet utilise [TikZ](ctanpkg:tikz), et [sa documentation](texdoc:pixelart) décrit les options et propose de nombreux exemples.

:::{note}
Ce paquet n'est compatible qu'avec LuaLaTeX (ni latex, ni xelatex, ni pdflatex). Celles et ceux qui ne peuvent pas ou ne veulent pas utiliser lualatex peuvent dessiner en style 8 bits avec [pxpic](ctanpkg:pxpic) (voir section suivante).
:::

## Package <ctanpkg:pxpic>

Le package <ctanpkg:pxpic> s'inspire de PixelArt et propose de faire des dessins en pixels de toutes les couleurs.

[Sa documentation](texdoc:pxpic) est richement illustrée.

:::{sources}
[Style 8 bits](wpfr:Style_8_bits)
:::

## Package <ctanpkg:PixelArtTikz>

Enfin, le package <ctanpkg:pixelarttikz> permet également de faire des dessins en pixels, en prenant en entrée un fichier au format [CSV](wpfr:Comma-separated_values), pour afficher les dessins complétés (comme les paquets précédents), ou pour imprimer et compléter les dessins sur papier.

```
\documentclass{article}

\begin{filecontents}[overwrite,noheader]{coeur.csv}
  -,-,1,2,-,-,1,2,-,-
  -,1,3,4,1,1,1,1,2,-
  1,3,4,1,1,1,1,1,1,2
  1,3,4,1,1,1,1,1,1,2
  1,3,4,1,1,1,1,1,1,2
  -,1,1,1,1,1,1,1,2,-
  -,-,1,1,1,1,1,2,-,-
  -,-,-,1,1,1,2,-,-,-
  -,-,-,-,1,2,-,-,-,-
\end{filecontents}

\usepackage{PixelArtTikz}% "CamelCase" requis sur certains systèmes (dont mac os)

\begin{document}

\PixelArtTikz[Codes=1234,Style=\ttfamily,Unite=0.35]{coeur.csv}
~
\PixelArtTikz[Codes=1234,Couleurs={red,purple,pink,magenta},Correction,Unite=0.35]{coeur.csv}
~
\PixelArtTikz[Codes=1234,Couleurs={red,purple,pink,magenta},Correction,Unite=0.35,BordCases=false]{coeur.csv}

\end{document}
```
