---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, espace vertical, saut de page, 
              changement de page 
---

# Comment insérer un espace vertical dans une page ?

La commande de base est `\vspace`, qui prend en argument la hauteur 
de l'espace voulu :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\textit{L'espace efface le bruit.}

\vspace{1cm}
Victor Hugo.
\end{document}
```

Une version alternative de la commande `\vspace` existe : `\vspace*`. 
Celle-ci force l'insertion d'un espace vertical même si ce dernier 
se situe sur un changement de page.

L'utilisation de `\vspace` n'est cependant pas la plus recommandée. 
Dans la plupart des cas, il est plus simple et préférable d'utiliser 
les commandes prédéfinies `\bigskip`, `\medskip` et `smallskip`. 
Outre qu'elles sont optimisées par les classes, 
elles présentent l'avantage d'être modulables en fonction 
des contraintes typographiques (par exemple, elles peuvent 
être réduites de manière ponctuelle pour éviter de terminer 
le paragraphe qui suit sur la première ligne de la page suivante).

Si vous avez besoin d'un espacement particulier, vous pouvez redéfinir
les longueurs `\bigskipamount`, `\medskipamount` et `\smallskipamount`
ou, mieux, 
[définir une nouvelle longueur](/2_programmation/syntaxe/longueurs/manipuler_des_longueurs).

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

  % Définition de longueurs
  \newlength{\malongueurflexible}
  \setlength{\malongueurflexible}{20pt plus 5pt minus 5pt}

\begin{document}
Un paragraphe normalement espacé avec le suivant.

Longueur de \texttt{\string\medskipamount} :
\the\medskipamount

\medskip

Longueur de \texttt{\string\malongueurflexible} :
\the\malongueurflexible

\vspace{\malongueurflexible}

Fin du texte
\end{document}
```

Si vous voulez en outre indiquer que l'espace que vous avez inséré 
est un endroit adapté pour un changement de page (sans pour autant 
le forcer), vous pouvez aussi utiliser les commandes `\bigbreak`, 
`\medbreak` et `\smallbreak`.