---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, taille de page, format de papier, taille des marges, format A4, réduire les marges
---

# Quelles sont les longueurs modifiables de LaTeX pour la mise en page ?

La structure d'une page LaTeX permet de nombreux ajustements, par exemple en modifiant les grandeurs listées dans le tableau suivant :

```{tabularcolumns} \Y{0.3}>{\RaggedRight\arraybackslash}\Y{0.7}
```

```{rst-class} longtable
```

| Commande            | Définition                                                                                             | 
|---------------------|--------------------------------------------------------------------------------------------------------|
| `\paperwidth`       | Largeur de la page                                                                                     |
| `\paperheight`      | Hauteur de la page                                                                                     |
| `\hoffset`          | Espace horizontal permettant de décaler le point de référence de la page                               |
| `\voffset`          | Espace vertical permettant de décaler le point de référence de la page                                 |
| `\headsep`          | Espace vertical entre l'en-tête et la zone de texte                                                    |
| `\marginparsep`     | Espace horizontal entre la zone de texte et la zone de note marginale                                  |
| `\marginparwidth`   | Largeur de la zone de note marginale                                                                   |
| `\marginparpush`    | Espace vertical minimum entre deux notes marginales                                                    |
| `\topmargin`        | Espace vertical entre le point de référence et le haut de l'en-tête                                    |
| `\textwidth`        | Largeur de la zone de texte                                                                            |
| `\textheight`       | Hauteur de la zone de texte                                                                            |
| `\oddsidemargin`    | Marge gauche des pages impaires (ou celles de toutes les pages d'un document en recto uniquement)      |
| `\evensidemargin`   | Marge gauche des pages paires                                                                          |
| `\topskip`          | Espace entre le haut de la zone de texte et la base de la première ligne de texte                      |
| `\footskip`         | Espace entre le bas de la zone de texte et de la base du pied de page                                  |
| `\headheight`       | Hauteur de l'en-tête de page                                                                           |
| `\topmargin`        | Espace entre le haut de la feuille et l'en-tête de la page                                             |

Quelques valeurs complémentaires gèrent certaines mises en forme particulières :

```{tabularcolumns} \Y{0.3}>{\RaggedRight\arraybackslash}\Y{0.7}
```

```{rst-class} longtable
```

| Commande            | Définition                                                                                             | 
|---------------------|--------------------------------------------------------------------------------------------------------|
| `\columnsep`        | Espace horizontal entre les colonnes pour un document multicolonnes                                    |
| `\columnseprule`    | Largeur du filet qui sépare les colonnes d'un document multicolonnes                                   |
| `\columnwidth`      | Largeur d'une colonne (calculée automatiquement par LaTeX d'après `textwidth` et `columnsep`)          |
| `\linewidth`        | Longueur de la ligne courante, souvent utilisé dans des environnements qui redéfinissent les marges    |

Les définitions données ici sont simplifiées. 
Vous pouvez consulter par exemple la 
[page dédiée à ces paramètres](https://latexref.xyz/fr/Page-layout-parameters.html#Page-layout-parameters) 
sur le [Manuel officieux de LaTeX2e](https://latexref.xyz/fr/) pour avoir des définitions plus précises.

Mais ne vous précipitez pas pour les modifier vous-même ! 
Avant cela, il est en effet recommandé de consulter les pages suivantes de la FAQ :
- "[](structure_d_une_page.md)" ;
- "[](modifier_les_parametres_de_page)" ;
- "[](modifier_les_marges_d_un_document)".

La première évoque en particulier, avec un exemple, 
l'extension <ctanpkg:layout> qui permet de visualiser la plupart des paramètres de la page.


:::{sources}
- [Page size and margins](https://www.overleaf.com/learn/latex/Page_size_and_margins).
:::
