---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, communication, diaporama,
              PowerPoint, slides, diapositives, transparents, présentations,
              support de présentation, Impress, Prezi, keynotes 
---

# Par où commencer une présentation <ctanpkg:beamer> ?

Vous devez préparer une présentation orale, avec des diapositives (*slides*)
comme support ? Vous avez entendu parler de <ctanpkg:beamer> (parmi d'autres 
évoqués à la question 
"[](/4_domaines_specialises/communication/diaporama/classes_pour_des_presentations)")
mais vous ne savez pas trop par où commencer ? 
Voici quelques instructions simples.


## Comment mettre en forme mes premières diapos ?

### La diapo de titre

```
\documentclass[french]{beamer}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)

  \title{Faut-il se coucher de bonne heure ?}
  \author{Marcel \textsc{Proust}}
  \institute{Institut de recherche du Temps Perdu --- Paris, France.}
  \date{14 novembre 1913}

\begin{document}
\begin{frame}
\titlepage
\end{frame}
\end{document}
```

### Les diapositives suivantes

:::{todo} Ajouter un exemple.
:::


## Comment structurer le contenu d'une diapo ?

:::{todo} Ajouter un exemple avec des colonnes.
:::


## Quelques remarques complémentaires

LaTeX est un excellent outil pour écrire des articles ou des livres. 
Mais il faut reconnaître que ses atouts sont moins impressionnants 
lorsqu'il s'agit de préparer une présentation. En effet, 
sur chaque diapositive, les élements doivent être placés de façon 
plutôt visuelle, ce qui vous obligera souvent à compiler plusieurs fois
votre présentation en ajoutant des `\vspace{}` par-ci par-là 
pour que l'ensemble soit harmonieux, voire à utiliser [TikZ](ctanpkg:pgf)
pour placer librement les éléments sur la diapo.

Ainsi, l'usage de LaTeX pour préparer une présentation orale est surtout 
recommandé :

- si vous utilisez couramment LaTeX pour d'autres travaux (dans ce cas, 
  vos habitudes seront une force) ;
- si vous avez déjà du contenu formaté avec LaTeX, que vous récupèrerez 
  pour vos diapos : formules, graphiques, illustrations...
:::


## Comment aller plus loin ?

Vous n'échapperez pas à la lecture de tutoriels plus complets, par exemple :

- [Conférence n°5, de Denis Bitouzé](https://dgxy.link/en-ligne5) ;
- [Tutoriel : Créez vos diaporamas en LaTeX avec beamer !](https://pub.phyks.me/sdz/sdz/creez-vos-diaporamas-en-latex-avec-beamer.html).

Notez que la [documentation](texdoc:beamer) de beamer (en anglais) est 
très bien écrite, et peut faire elle-même office de tutoriel.

Vous pouvez aussi consulter 
[une galerie d'exemples](https://deic.uab.cat/~iblanes/beamer_gallery/) 
pour choisir un thème pour vos diapositives.

Notez enfin que [beamer](ctanpkg:beamer) peut être utilisé avec deux écrans, 
l'un pour le présentateur, l'autre pour le public... et ils ont bien entendu 
un contenu différent ! Ceci est illustré à la question 
"[](/4_domaines_specialises/communication/diaporama/mode_presentateur_pour_beamer)",


:::{sources}
- [Tutoriel : Créez vos diaporamas en LaTeX avec Beamer !](https://pub.phyks.me/sdz/sdz/creez-vos-diaporamas-en-latex-avec-beamer.html)
- [Beamer](wpfr:Beamer)
:::