---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, équations, 
              disposition d'équations, taille d'une formule, fantomes, 
              espace vertical
---

# Comment écraser verticalement des parties d'une équation ?

À l'inverse de l'astuce 
"[](/3_composition/texte/boites/exploiter_les_fantomes)", 
qui vise à réserver de la place pour des éléments invisibles, 
vous pouvez souhaiter que des éléments visibles n'occupent pas (ou moins) 
de place du point de vue de TeX, leur représentation graphique restant 
inchangée.

Ceci s'obtient grâce à la commande `\smash`, 
qui insère son argument comme un objet de hauteur et profondeur nulles 
(sur ce point, vous pouvez consulter la question 
"[](/2_programmation/syntaxe/boites/comprendre_le_modele_de_boites)"). 
Les variantes `\smash[b]` et `\smash[t]` (fournies par <ctanpkg:mathtools> 
ou <ctanpkg:amsmath>) n'annulent respectivement que la profondeur 
ou la hauteur.

Voici un exemple sur ce sujet. Observez bien la profondeur des racines 
du premier et dernier terme par rapport à celui du milieu :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\[
  \sqrt{y} + \sqrt{x} + \sqrt{\smash[b]{y}}
\]
\end{document}
```

Il convient d'utiliser ce genre de commande avec prudence car, 
en mentant à TeX sur la taille des objets qu'il manipule, 
des risques de chevauchement visuels apparaissent.


:::{sources}
- [Écraser verticalement des morceaux de formule](https://www.elzevir.fr/imj/latex/tips.html#smash), 
  par Manuel Pégourié-Gonnard
:::