---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, numérotation, 
              équations, numérotation des équations, numéroter, référence,
              equation, \label, \ref
---

# Comment numéroter les équations ?

## Avec les commandes de base

L'environnement le plus courant pour numéroter des équations simples 
est `equation`. Cependant la numérotation est une fonctionnalité par défaut
de nombreux autres environnements traitant des équations et des 
[groupes d'équation](/4_domaines_specialises/mathematiques/equations/disposition_d_equations/aligner_des_equations).

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Voici un exemple de numérotation classique :
\begin{equation}
  x + 4 = 0
\end{equation}
\begin{equation}
  y - 7 = 0
\end{equation}
\end{document}
```


:::{seealso}
Les autres questions de la section 
[Numérotation des équations](/4_domaines_specialises/mathematiques/equations/numerotation_d_equations/)
approfondissent ce sujet.
:::


:::{sources}
- [FAQ-reuseq](https://texfaq.org/FAQ-reuseq)
:::