---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes, polices de caractères, tables de caractère
---

# Que sont les polices virtuelles ?

Les polices virtuelles permettent de rassembler des éléments pour créer les glyphes d'une police : 
il peut s'agir de glyphes provenant de différentes polices, 
de règles et d'autres commandes de composition "de base", 
ainsi que d'informations de positionnement spécifiant la manière dont tout s'assemble.

Un premier exemple de quelque chose comme les polices virtuelles 
pour TeX a été mis en œuvre par David Fuchs pour utiliser une imprimante inhabituelle. 
Cependant, pour des raisons pratiques pour le reste d'entre nous, les polices virtuelles datent de 1989, 
lorsque Knuth a spécifié un format et écrit un logiciel de support. 
Il a publié un [article dans TUGboat](https://tug.org/TUGboat/tb11-1/tb27knut.pdf) à l'époque 
dont une [copie en texte brut](https://tug.ctan.org/info/virtual-fonts.knuth) se trouve sur le CTAN.

Les polices virtuelles permettent d'indiquer à TeX quelque chose de plus compliqué 
qu'une simple correspondance de caractères un à un. TeX lit le fichier TFM de la police, 
comme auparavant, mais le processeur DVI lira le fichier VF 
et utilisera son contenu pour spécifier comment chaque glyphe doit être traité.

La police virtuelle peut contenir des commandes :

- pour "ouvrir" une ou plusieurs polices (réelles) en vue d'une utilisation ultérieure ;
- pour reclasser un glyphe d'une des polices (réelles) et l'utiliser dans la police virtuelle ;
- pour créer un effet plus complexe (à l'aide de commandes DVI).

En pratique, l'utilisation la plus courante des polices virtuelles consiste à réorganiser 
les glyphes de polices Adobe Type 1 
(voir la question "[](/5_fichiers/formats/fontes/fichiers_de_metriques_pour_les_fontes_t1)"), 
bien qu'il y ait également eu des travaux pour construire de "fausses" polices mathématiques 
(en regroupant les glyphes de plusieurs polices dans une seule police virtuelle). 
Les polices virtuelles *Computer Modern*, qui constituent des polices 
[avec l'encodage de Cork](/5_fichiers/formats/fontes/que_sont_les_fontes_ec) 
à partir des versions originales de Knuth en utilisant le reclassement de glyphes 
et des fragments de code DVI pour les caractères accentués, 
ont été les premières polices *Computer Modern* de format Type 1 à encodage de Cork disponibles.

Les polices virtuelles sont normalement créées dans un seul fichier ASCII VPL (*Virtual Property List*),
qui comprend deux ensembles d'informations. 
L'utilitaire `vptovf` utilisera le fichier VPL pour créer les fichiers binaires TFM et VF.

Un document expliquant comment générer une liste de propriétés virtuelles décrit les heures interminables 
de plaisir que l'on peut passer à faire ce travail à la main. 
Malgré les plaisirs que l'on peut en retirer, la manière la plus courante (de nos jours) 
de générer un fichier VPL est d'utiliser l'extension <ctanpkg:fontinst>, 
décrite plus en détail dans la question "[](/5_fichiers/formats/fontes/fichiers_de_metriques_pour_les_fontes_t1)".
Une autre manière de faire passer par <ctanpkg:qdtexvpl>, 
un utilitaire pour créer des polices virtuelles *ad-hoc*. 
Il utilise TeX pour analyser une description de la police virtuelle 
et `qdtexvpl` traite lui-même le fichier DVI résultant.


:::{sources}
- [What are virtual fonts?](faquk:FAQ-virtualfonts)
- [Virtual Fonts : Great Fun, Not for Wizards Only](https://hal.science/hal-02100361/document) 
  de Yannis Haralambous
- [How to create a virtual font?](https://tex.stackexchange.com/questions/25852/how-to-create-a-virtual-font)
:::