---
myst:
  html_meta:
    keywords: LaTeX,Unix,Linux,GNU/Linux,installer LaTeX,distribution
---
# Quelles sont les distributions TeX pour les systèmes Unix et Linux ?

:::{warning}
Notez que macOS/X, bien qu'il s'agisse d'un système basé sur Unix, dispose de distributions dédiées décrites à la question « [](/6_distributions/installation/latex_sur_mac) ».
:::

Trois [distributions TeX](/1_generalites/glossaire/distribution) sont
actuellement disponibles pour les systèmes [Unix](wpfr:Unix) et
[Linux](wpfr:Linux). Les deux premières, [TeX Live](#tex-live) et
[MiKTeX](#miktex), sont les plus répandues et peuvent convenir à tous les
publics. La dernière, [TeX-FPC](#tex-fpc), est réservée aux utilisateurs avancés
de TeX.

## TeX Live

[TeX Live](https://www.tug.org/texlive/) est la distribution TeX par excellence pour les systèmes Unix (y compris Linux et la plupart des autres systèmes libres de type Unix).

{#guide-pratique-tex-live}
Son guide pratique, traduit français, est disponible au format
[HTML](https://tug.org/texlive/doc/texlive-fr/texlive-fr.html) et
[PDF](https://tug.org/texlive/doc/texlive-fr/texlive-fr.pdf).

Cette distribution TeX peut être installée de façon native ou en passant par le
gestionnaire de paquets du système.

### Installation de TeX Live via le gestionnaire de paquets

Les distributions Linux proposent des paquets dérivés de TeX Live. Ils se
nomment généralement `texlive-⟨truc⟩` et ils peuvent être installés via le
gestionnaire de paquets du système (`apt`, `pacman`, `rpm`, etc.)

:::{attention}

Ces paquets sont basés sur des versions dépassées de TeX Live (voir la [liste
des paquets par distribution](https://repology.org/project/texlive/versions)).
Il est donc recommandé d'installer TeX Live de façon native (« à la vanille »)
pour bénéficier de toutes ses fonctionnalités.

:::

:Avantage: facile à installer.

:Inconvénients: les paquets sont basés sur des versions dépassées et sont
souvent insuffisants.

### Installation de TeX Live « à la vanille » 

Avec une installation « à la vanille », on va en quelque sorte chercher TeX Live
« à la source » : on peut installer la dernière version et elle ne dépendra pas
du reste du système.

Plusieurs méthodes sont possibles. Leur résultat est équivalent.

#### À partir d'Internet

[Cette méthode](https://tug.org/texlive/acquire-netinstall.html) consiste à
télécharger seulement un programme d'installation. Ensuite, c'est ce programme
qui, lors de son exécution, va télécharger (via Internet) TeX Live package par
package. Cette méthode nécessite donc une *connexion internet stable*.

Vous pouvez suivre au choix :
- [cet article](doi:10.60028/lettre.vi52.154) de Maxime Chupin paru dans la
  [*Lettre* GUTenberg](https://publications.gutenberg-asso.fr/lettre/index), qui
  explique pas à pas cette méthode d'installation ;
- la [page d'installation rapide](https://tug.org/texlive/quickinstall.html)
  officielle (en anglais) ;
- la section « Installation » du [guide pratique de TeX
  Live](#guide-pratique-tex-live).
  
:Avantage: après cette installation, votre TeX Live est à jour.

:Inconvénients: elle nécessite une bonne connexion internet. Pour des
installations sur plusieurs ordinateurs, il faut pour chacun tout téléchargé via
Internet.
    
#### À partir de l'image ISO

[Cette méthode](https://tug.org/texlive/acquire-iso.html) consiste à télécharger
(via Internet) [l'image ISO](wpfr:Image_disque) de TeX Live (un gros fichier de
plus de 5,7 GB). Ensuite, l'installation ne nécessite plus de connexion
internet : après avoir lancé le programme d'installation (contenu dans l'image
ISO), le programme va « copier en décompressant » TeX Live package par package,
de l'image ISO vers votre ordinateur.

Cette image ISO contient une version majeure de TeX Live (il en sort une chaque
année). Or, des packages peuvent être ajoutés ou mis à jour entre ces versions
majeures. Ainsi, vous voudrez peut-être mettre à jour votre TeX Live après cette
installation (une connexion internet de qualité médiocre suffit).

```{todo}
Créer une question « Comment mettre à jour TeX Live ? » ?
```

Vous pouvez suivre [ce document](https://dgxy.link/en-ligne0) de Denis Bitouzé
qui explique cette méthode d'installation.

:Inconvénients: avoir une bonne connexion internet pour télécharger l'image ISO.
Mettre à jour TeX Live après l'installation (optionnel).

:Avantages: Pas besoin de connexion internet une fois l'image ISO téléchargée (à
part si on veut un mise à jour après installation). Il est possible de graver
l'image ISO sur un CD ou une clé USB pour l'utiliser pour installations sur des
machines différentes (quel que soit le système d'exploitation).
  
#### À partir du DVD TeX collection

Si vous n'avez pas accès à internet, ou si la qualité de votre connexion ne vous
permet pas de télécharger des gigaoctets de façon fiable, vous pouvez installer
TeX Live avec le [DVD TeX
collection](/6_distributions/installation/dvd_texcollection).

:Inconvénients: se procurer le DVD. Mettre à jour TeX Live après l'installation
(optionnel).

:Avantages: ils sont les mêmes que pour l'installation à partir de l'image ISO.
  
### Version portable

Accessoirement, vous pouvez aussi en faire une [version
portable](http://www.tug.org/texlive/portable.html) sur clé USB pour l'utiliser
sur n'importe quel autre ordinateur. Voir aussi la section « Installations
« portables » de TeX Live » du [guide pratique de TeX
Live](#guide-pratique-tex-live).

## MiKTeX

[MiKTeX](https://miktex.org) est une alternative à TeX Live.

Son manuel (en anglais) est disponible au format
[HTML](https://docs.miktex.org/manual/index.html) et
[PDF](https://miktex.org/download/ctan/systems/win32/miktex/doc/miktex.pdf).

La distribution MiKTeX peut être installée en suivant les instructions
spécifiques à votre distribution Linux (voir la [liste des systèmes
supportées](https://miktex.org/kb/prerequisites)) sur la page :
https://miktex.org/download . Si votre distribution n'est pas (encore) supportée
ou si vous préférez, vous pouvez [compiler les
sources](https://miktex.org/howto/build-unx).

## TeX-FPC

[TeX-FPC](ctanpkg:tex-fpc) (anciennement [TeX-GPC](ctanpkg:tex-gpc)) est une distribution « retour aux sources » des seuls utilitaires TeX (contrairement à TeX Live, aucun ensemble d'extension « sur mesure » n'est fourni). Elle est distribuée en tant que source et se compile avec Free Pascal, se rapprochant ainsi le plus possible de la distribution originale de [Knuth](/1_generalites/glossaire/tex). Elle est réputée bien fonctionner mais l'omission de eTeX et `pdfTeX` lui donne un public assez limité.

:::{seealso}

Si vous venez d'installer une distribution TeX contenant LaTeX vous vous
demandez peut-être : « [](/6_distributions/installation/tester_son_installation) »

Concernant les distributions TeX pous d'autres systèmes d'exploitation :
- « [](/6_distributions/installation/latex_sur_mac) »
- « [](/6_distributions/installation/latex_sous_windows) »
- « [](/6_distributions/installation/latex_pour_d_autres_plateformes) »

:::

:::{sources}

- [Page de TeX Live](https://www.tug.org/texlive/) et son [guide
  pratique](https://tug.org/texlive/doc/texlive-fr/texlive-fr.html)
- [Site de MiKTeX](https://miktex.org) et son
  [manuel](https://docs.miktex.org/manual/)
- <ctanpkg:tex-fpc>

:::
