---
myst:
  html_meta:
    keywords: LaTeX, programmation, commandes, macros, mode mathématique
---
# Que fait `\ensuremath` ?

La commande `\ensuremath` permet de s'assurer que son argument sera composé en [mode mathématique](/4_domaines_specialises/mathematiques/passer_en_mode_mathematique), *quel que soit le mode courant*. Cela permet de définir des commandes qui pourront être utilisées aussi bien en mode mathématique que dans du texte, ce qui simplifie leur utilisation. Par exemple :

```
\documentclass{article}
  \usepackage{lmodern} % Caractères plus lisibles
  \pagestyle{empty}    % N'affiche pas de numéro de page
  \usepackage{amssymb} % Nous donne \mathbb

  \newcommand{\NN}{\ensuremath{\mathbb{N}}}

\begin{document}
Soit l'ensemble des entiers \NN, il a pour cardinal :
\[ \# \NN = \infty \]
\end{document}
```

TeX fournit aussi la valeur booléenne `\ifmmode`, qui est vraie en mode mathématique et fausse ailleurs. On pourra donc définir la commande suivante (en gardant en tête les avertissements de la question "[](/2_programmation/macros/definitions_latex/preferer_newcommand_a_def)" si vous êtes un utilisateur non chevronné).

```
\documentclass{article}
  \usepackage{lmodern} % Caractères plus lisibles
  \pagestyle{empty}    % N'affiche pas de numéro de page

  \def\ssi{\ifmmode \Leftrightarrow \else
    si, et seulement si, \fi}

\begin{document}
Par exemple, A$\times$B vaut 0 \ssi A vaut 0 ou B vaut 0. 
\[ A \times B = 0 \ssi A = 0 \textrm{ ou } B =0  \]
\end{document}
```
