/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.shading.Line;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingResources;
import org.apache.pdfbox.pdmodel.graphics.shading.PDTriangleBasedShadingType;
import org.apache.pdfbox.pdmodel.graphics.shading.ShadedTriangle;
import org.apache.pdfbox.pdmodel.graphics.shading.ShadingContext;
import org.apache.pdfbox.util.Matrix;

abstract class TriangleBasedShadingContext
extends ShadingContext {
    private static final Log LOG = LogFactory.getLog(TriangleBasedShadingContext.class);
    protected int bitsPerCoordinate;
    protected int numberOfColorComponents;
    protected int bitsPerColorComponent;
    protected final boolean hasFunction;

    public TriangleBasedShadingContext(PDShadingResources shading, ColorModel cm, AffineTransform xform, Matrix ctm, int pageHeight, Rectangle dBounds) throws IOException {
        super(shading, cm, xform, ctm, pageHeight, dBounds);
        PDTriangleBasedShadingType triangleBasedShadingType = (PDTriangleBasedShadingType)shading;
        this.hasFunction = shading.getFunction() != null;
        this.bitsPerCoordinate = triangleBasedShadingType.getBitsPerCoordinate();
        LOG.debug((Object)("bitsPerCoordinate: " + (Math.pow(2.0, this.bitsPerCoordinate) - 1.0)));
        this.bitsPerColorComponent = triangleBasedShadingType.getBitsPerComponent();
        LOG.debug((Object)("bitsPerColorComponent: " + this.bitsPerColorComponent));
        int n = this.numberOfColorComponents = this.hasFunction ? 1 : this.colorSpace.getNumberOfComponents();
        if (this.colorSpace instanceof PDSeparation) {
            this.numberOfColorComponents = 1;
        }
    }

    protected void calcPixelTable(ArrayList<ShadedTriangle> triangleList, HashMap<Point, Integer> map) {
        for (ShadedTriangle tri : triangleList) {
            int degree = tri.getDeg();
            if (degree == 2) {
                Line line = tri.getLine();
                for (Point p : line.linePoints) {
                    map.put(p, this.convertToRGB(line.calcColor(p)));
                }
                continue;
            }
            int[] boundary = tri.getBoundary();
            boundary[0] = Math.max(boundary[0], this.deviceBounds.x);
            boundary[1] = Math.min(boundary[1], this.deviceBounds.x + this.deviceBounds.width);
            boundary[2] = Math.max(boundary[2], this.deviceBounds.y);
            boundary[3] = Math.min(boundary[3], this.deviceBounds.y + this.deviceBounds.height);
            for (int x = boundary[0]; x <= boundary[1]; ++x) {
                for (int y = boundary[2]; y <= boundary[3]; ++y) {
                    Point p = new Point(x, y);
                    if (!tri.contains(p)) continue;
                    map.put(p, this.convertToRGB(tri.calcColor(p)));
                }
            }
        }
    }

    protected void transformPoint(Point2D p, Matrix ctm, AffineTransform xform) {
        if (ctm != null) {
            ctm.createAffineTransform().transform(p, p);
        }
        xform.transform(p, p);
    }

    @Override
    protected int convertToRGB(float[] values) {
        if (this.hasFunction) {
            try {
                values = this.shading.evalFunction(values);
            }
            catch (IOException exception) {
                LOG.error((Object)"error while processing a function", (Throwable)exception);
            }
        }
        return super.convertToRGB(values);
    }
}

