| Source:   zeckendorf.dtx
| Version:  0.9d, 2025/11/16
| Author:   Jean-François Burnol
| Keywords: Zeckendorf representation; Knuth Fibonacci multiplication
| License:  LPPL 1.3c

Aim
===

This package extends `\xinteval`'s syntax:
- The four operations are overloaded to do algebra in `Q(phi)`,
  where phi is a variable standing for the golden ratio.
- Functions are available in this syntax to compute:
  - Fibonacci numbers,
  - Zeckendorf representations of positive integers (as lists
    of indices),
  - Bergman phi-representations of positive elements of `Z[phi]`
    (as lists of exponents).
- The `$` character serves as infix operator computing the Knuth
  Fibonacci multiplication of positive  integers.

The macro interface also provides conversion of integers to
Zeckendorf words and Bergman phi-ary representations.

The functionalities can be used in three ways:
- as a LaTeX package: `\usepackage{zeckendorf}`,
- as a Plain e-TeX macro file: `\input zeckendorfcore.tex`,
- or interactively on the command line: `etex zeckendorf`. If
  available use rather `rlwrap etex zeckendorf` for a smoother
  experience.

The package is in alpha stage and its user interface may change
in backwards incompatible ways.
Of course, suggestions are most welcome.

Installation
============

Exert `etex zeckendorf.dtx` to extract macro files.  To build the
documentation run `xelatex` on the extracted `zeckendorf-doc.tex`,
or directly on `zeckendorf.dtx`.

The recommended TDS structure is:

    /tex/generic/zeckendorf/zeckendorfcore.tex
    /tex/generic/zeckendorf/zeckendorf.tex
    /tex/generic/zeckendorf/zeckendorf.sty
    /source/generic/zeckendorf/zeckendorf.dtx
    /doc/generic/zeckendorf/zeckendorf-doc.pdf
    /doc/generic/zeckendorf/README.md

License
=======

Copyright © 2025 Jean-François Burnol

| This Work may be distributed and/or modified under the
| conditions of the LaTeX Project Public License 1.3c.
| This version of this license is in

>   <http://www.latex-project.org/lppl/lppl-1-3c.txt>

| and version 1.3 or later is part of all distributions of
| LaTeX version 2005/12/01 or later.

This Work has the LPPL maintenance status "author-maintained".

The Author and Maintainer of this Work is Jean-François Burnol.

This Work consists of the main source file and its derived files

    zeckendorf.dtx,
    zeckendorfcore.tex, zeckendorf.tex, zeckendorf.sty,
    README.md, zeckendorf-doc.tex, zeckendorf-doc.pdf

