/*
**	mod_std.h	-  Definition of the standard Lite / W3-mSQL library
**
**
** Copyright (c) 1995-96  Hughes Technologies Pty Ltd
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
**
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
**
** This software is provided "as is" without any expressed or implied warranty.
**
*/




/*
** Standard external function prototypes
*/

void doSplit();
void doStrSeg();
void doChop();
void doTr();
void doSub();
void doTest();
void doSubStr();

void doPrintf();
void doFprintf();
void doEcho();
void doFatal();

void doOpen();
void doClose();
void doRead();
void doReadLn();
void doReadTok();
void doIncludeFile();

void doExit();
void doUnlink();
void doUmask();
void doChmod();
void doSleep();
void doSystem();
void doGetpid();
void doGetppid();
void doChdir();
void doMkdir();
void doRmdir();
void doRename();
void doTruncate();
void doLink();
void doSymlink();

void doStat();
void doKill();

void doTime();
void doCTime();

void doGetHostByName();
void doGetHostByAddr();

void doUrlEncode();
void doSetContentType();
void doIncludeFile();

void doTime2UnixTime();
void doUnixTime2Year();
void doUnixTime2Month();
void doUnixTime2Day();
void doUnixTime2Hour();
void doUnixTime2Min();
void doUnixTime2Sec();
void doStrftime();

void doCrypt();

void doGetPwNam();
void doGetPwUid();

void doSrandom();
void doRandom();

void initModStd();

/*
** Standard external function definitions
**
** This table maps from internal function names to the C code.
** The format is :-
**
**	{FunctName, CFunction, NumArgs, { Arg1Type, Arg2Type....., 0}}
**
**	Setting NumArgs to -1 indicates varargs
*/


efunct_t std_efuncts[] = {
	{ "printf", doPrintf, -1, { P_TEXT, 0} },
	{ "fprintf", doFprintf, -1, { P_INT, P_TEXT, 0} },
	{ "echo", doEcho, 1, { P_TEXT, 0} },
	{ "fatal", doFatal, 1, { P_TEXT, 0} },
	{ "open", doOpen, 2, {P_TEXT, P_TEXT, 0} },
	{ "close", doClose, 1, {P_INT, 0} },
	{ "read", doRead, 2, {P_INT, P_INT, 0} },
	{ "readln", doReadLn, 1, {P_INT, 0} },
	{ "readtok", doReadTok, 2, {P_INT, P_TEXT, 0} },

	{ "exit", doExit, 1, {P_INT, 0} },
	{ "split", doSplit, 2, {P_TEXT, P_TEXT, 0}},
	{ "strseg", doStrSeg, 3, {P_TEXT, P_INT, P_INT, 0}},
	{ "chop", doChop, 1, {P_TEXT, 0}},
	{ "tr", doTr, 3, {P_TEXT, P_TEXT, P_TEXT,0}},
	{ "sub", doSub, 3, {P_TEXT, P_TEXT, P_TEXT,0}},
	{ "test", doTest, 2, {P_TEXT, P_TEXT, 0}},
	{ "substr", doSubStr, 3, {P_TEXT,P_TEXT,P_TEXT,0}},

	{ "unlink", doUnlink, 1, {P_TEXT,0} },
	{ "umask", doUmask, 1, {P_INT, 0}},
	{ "chmod", doChmod, 2, {P_TEXT,P_INT,0}},
	{ "mkdir", doMkdir, 1, {P_TEXT,0} },
	{ "chdir", doChdir, 1, {P_TEXT,0} },
	{ "rmdir", doRmdir, 1, {P_TEXT,0} },
	{ "rename", doRename, 2, {P_TEXT, P_TEXT} },
	{ "truncate", doTruncate, 2, {P_TEXT, P_INT} },
	{ "link", doLink, 2, {P_TEXT, P_TEXT} },
	{ "symlink", doSymlink, 2, {P_TEXT, P_TEXT} },
	{ "sleep", doSleep, 1, {P_INT, 0}},
	{ "system", doSystem, 1, {P_TEXT,0}},
	{ "getpid", doGetpid, 0, {0}},
	{ "getppid", doGetppid, 0, {0}},
	{ "stat", doStat, 1, {P_TEXT,0}},
	{ "kill", doKill, 2, {P_INT, P_INT,0}},

	{ "time", doTime, 0, {0}},
	{ "ctime", doCTime, 1, {P_INT,0}},

	{ "gethostbyname", doGetHostByName, 1, {P_TEXT,0}},
	{ "gethostbyaddr", doGetHostByAddr, 1, {P_TEXT,0}},

	{ "urlEncode", doUrlEncode, 1, {P_TEXT,0}},
	{ "setContentType", doSetContentType, 1, {P_TEXT,0}},
	{ "includeFile", doIncludeFile, 1, {P_TEXT,0}},

	{ "time2unixtime", doTime2UnixTime, 6, {P_INT, P_INT, P_INT, P_INT, 
		P_INT, P_INT, 0}},
	{ "unixtime2year", doUnixTime2Year, 1, {P_INT, 0}},
	{ "unixtime2month", doUnixTime2Month, 1, {P_INT, 0}},
	{ "unixtime2day", doUnixTime2Day, 1, {P_INT, 0}},
	{ "unixtime2hour", doUnixTime2Hour, 1, {P_INT, 0}},
	{ "unixtime2min", doUnixTime2Min, 1, {P_INT, 0}},
	{ "unixtime2sec", doUnixTime2Sec, 1, {P_INT, 0}},
	{ "strftime", doStrftime, 2, {P_INT, P_TEXT, 0}},

	{ "crypt", doCrypt, 2, {P_TEXT, P_TEXT, 0}},

	{ "getpwnam", doGetPwNam, 1, {P_TEXT, 0}},
	{ "getpwuid", doGetPwUid, 1, {P_INT, 0}},

	{ "srandom", doSrandom, 1, {P_INT, 0}},
	{ "random", doRandom, 0, {0}},

	{ NULL, 0 }
};
