

#include <sys/types.h>
#include <common/portability.h>



typedef	u_char	*U_C_PTR;

#undef  YYSTYPE
#define	YYSTYPE	U_C_PTR


typedef struct code_s {
	char	op;
	char	*arg;
	u_short	label;
	short	type;
	u_short	line;
	char	file;
	struct code_s *next,
		*prev;
} code_t;



typedef struct _sym {
        char    *name,
                *val;
        short	type;
	char	array;
        int     length,
		source;
        struct _sym *next;
} sym_t;


typedef struct _funct {
	char	*name;
	code_t	*code;
	sym_t	*params;
	struct 	_funct *next;
} funct_t;


typedef	struct array_s {
	sym_t	*sym;
	struct	array_s *next;
} array_t;



typedef struct stack_s {
	u_short	block;
	short	type;
	sym_t	*sym;
	struct	stack_s *next;
} sstack_t;


typedef struct plist_s {
        sym_t    *sym;
        struct  plist_s *next;
} plist_t;


typedef struct efunct_s {
        char    *name;
        void    (*funct) ();
	char	*functName;
        char    numParams;
        int     paramTypes[20];
} efunct_t;



typedef struct fbucket_s {
        efunct_t                *funct;
        struct fbucket_s        *next;
} fbucket_t;


typedef struct lstack_s {
	int	label;
	struct	lstack_s	*next;
} lstack_t;


typedef struct type_s {
	char	*name;
	int	length;
	int	(*pack)();
	int	(*unpack)();
	int	(*read)();
	int	(*write)();
	int	(*compare)();
	int	(*math)();
	int	(*check)();
} type_t;



#define	OP_CALL		1
#define OP_PUSH		2
#define OP_CMP		3
#define OP_JMP		4
#define OP_JMP_FALSE	5
#define OP_JMP_BACK	6
#define OP_LABEL	7
#define OP_STORE	8
#define OP_A_STORE	9
#define OP_DEREF	10
#define OP_ALU		11
#define OP_BLOCK_IN	12
#define OP_BLOCK_OUT	13
#define OP_EXIT		14
#define OP_ECHO		15
#define OP_CAST		16
#define OP_COUNT	17
#define OP_PUSHRET	18
#define OP_RETURN	19

#define	OP_ADD		100
#define OP_SUB		101
#define OP_MUL		102
#define OP_DIV		103
#define OP_AND		105
#define OP_OR		106
#define OP_MOD		107

#define SCALAR		1
#define ARRAY		2
#define	VARIABLE	3

#define	TYPE_REAL	0
#define	TYPE_INT	1
#define	TYPE_CHAR	2


#define	P_TEXT		1
#define	P_INT		2
#define P_ARRAY		3


#define	SRC_POST	1
#define SRC_IMPORT	2
#define SRC_GET		3
#define SRC_SECURE	SRC_IMPORT


/*
** Pre declarations
*/

#if defined(__STDC__) || defined(__cplusplus)
#  define __ANSI_PROTO(x)       x
#else
#  define __ANSI_PROTO(x)       ()
#endif



/* Lexer / Parser */

int	yylex();
int	yyparse();
void	yyerror __ANSI_PROTO((char *));
void	parseError __ANSI_PROTO((char *));
void	runError __ANSI_PROTO((char *));
void 	lexInitScanner __ANSI_PROTO((u_char *));
void 	sendFooter ();


/* Symbol table routines */

void	symFreeSymbol __ANSI_PROTO((sym_t *));
void	symFreeSymbolData __ANSI_PROTO((sym_t *));
void	symClearArray __ANSI_PROTO((sym_t *));
sym_t	*symCreateSymbol __ANSI_PROTO((char *, int, int));
sym_t	*symGetSymbol __ANSI_PROTO((char *));
sym_t 	*symCreateMacroLiteral __ANSI_PROTO((char *));
void	symSetValue __ANSI_PROTO((sym_t *, sym_t *));
void	symSetArrayElement __ANSI_PROTO((sym_t *, int, sym_t *));
sym_t	*symGetArrayElement __ANSI_PROTO((sym_t *, int));
array_t	*symArrayDup __ANSI_PROTO((sym_t *));
int	symSetArray __ANSI_PROTO((char *, sym_t *));
sym_t	*symGetEnvironVariable __ANSI_PROTO((char *));
sym_t	*symCreateLiteral __ANSI_PROTO((char *, int));
sym_t	*symdup __ANSI_PROTO((sym_t *));
char	*symUnpackSymbol __ANSI_PROTO((sym_t *));
char	*expandText __ANSI_PROTO((char *));

/* Code generation routines */

void	codeHtml __ANSI_PROTO((int, int));
void	codeBlockIn ();
void	codeBlockOut ();
void	codeStore __ANSI_PROTO((char *));
void	codeArrayStore __ANSI_PROTO((char *));
void	codeDeref __ANSI_PROTO((char *));
void	codePush __ANSI_PROTO((char *));
void	codeALU __ANSI_PROTO((int));
void	codeCall __ANSI_PROTO((char *));
void	pushLabel __ANSI_PROTO((int));
int	popLabel ();
void	pushBreak __ANSI_PROTO((int));
int	popBreak ();
void	pushContinue __ANSI_PROTO((int));
int	popContinue ();
void	codeLabel __ANSI_PROTO((int));
void	codeJmp __ANSI_PROTO((int));
void	codeJmpBack __ANSI_PROTO((int));
void	codeJmpFalse __ANSI_PROTO((int));
void	codeCmp __ANSI_PROTO((int));
void	codeExit ();
void	dumpCode ();

/* Code simulation routines */

int	getLine();
void	doExit();
void	doBlockIn();
void	doBlockOut();
void	doCall __ANSI_PROTO((code_t *));
void	doEcho __ANSI_PROTO((plist_t *));
void	doPushVar __ANSI_PROTO((code_t *));
void	doPushVal __ANSI_PROTO((code_t *));
void	doPushLiteral __ANSI_PROTO((code_t *));
void	doStore __ANSI_PROTO((code_t *));
void	doArrayStore __ANSI_PROTO((code_t *));
void	doDeref __ANSI_PROTO((code_t *));
int	checkNumeric __ANSI_PROTO((char *));
void	doALU __ANSI_PROTO((code_t *));
void	doCmp __ANSI_PROTO((code_t *));
int	runCode __ANSI_PROTO((char *));



/* External interface routines */

void	setReturnValue __ANSI_PROTO((char *, int));
char	*int2str __ANSI_PROTO((int));
sym_t 	*createArray();
char	*getArrayElement __ANSI_PROTO((array_t *, int));
int	getNumArrayElements __ANSI_PROTO((array_t *));
u_int	storeObject __ANSI_PROTO((char *));
char	*fetchObject __ANSI_PROTO((u_int));
char	*deleteObject __ANSI_PROTO((u_int));
int	calcHash __ANSI_PROTO((char *));
void	addExterns __ANSI_PROTO((efunct_t *));
efunct_t *findExtern __ANSI_PROTO((char *));
int 	oct2dec __ANSI_PROTO((char *));
int 	hex2dec __ANSI_PROTO((char *));
int	str2int __ANSI_PROTO((char *));
void	setupModules ();


/* Type handling routines */

type_t 	*typeGetType __ANSI_PROTO((int));
int 	typeGetTypeIndex __ANSI_PROTO((char *));

sym_t	*createIntSymbol __ANSI_PROTO((int));
sym_t	*createRealSymbol __ANSI_PROTO((double));
sym_t	*createCharSymbol __ANSI_PROTO((char *));


/*
** Inline definitions
*/

/* inlined, unaligned, 4-byte copy */
#define bcopy4(s,d) \
      ((((unsigned char *)d)[0] = ((unsigned char *)s)[0]), \
       (((unsigned char *)d)[1] = ((unsigned char *)s)[1]), \
       (((unsigned char *)d)[2] = ((unsigned char *)s)[2]), \
       (((unsigned char *)d)[3] = ((unsigned char *)s)[3]))
/* inlined, unaligned, 8-byte copy */
#define bcopy8(s,d) \
      ((((unsigned char *)d)[0] = ((unsigned char *)s)[0]), \
       (((unsigned char *)d)[1] = ((unsigned char *)s)[1]), \
       (((unsigned char *)d)[2] = ((unsigned char *)s)[2]), \
       (((unsigned char *)d)[3] = ((unsigned char *)s)[3]), \
       (((unsigned char *)d)[4] = ((unsigned char *)s)[4]), \
       (((unsigned char *)d)[5] = ((unsigned char *)s)[5]), \
       (((unsigned char *)d)[6] = ((unsigned char *)s)[6]), \
       (((unsigned char *)d)[7] = ((unsigned char *)s)[7]))



/*
** Macros for matching character classes.  These are in addition to
** those provided in <ctypes.h>
*/

#ifdef  iswhite
# undef iswhite
#endif
#define iswhite(c)      (c == ' ' || c == '\t' || c == '\n')

#ifdef  iscompop
# undef iscompop
#endif
#define iscompop(c)     (c == '<' || c == '>' || c == '=')

