/*	time.c	- 
**
**
** Copyright (c) 1997  Hughes Technologies Pty Ltd
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
**
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
**
** This software is provided "as is" without any expressed or implied warranty.
**
*/


#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include <common/debug.h>
#include <common/site.h>
#include <common/portability.h>

#include "errmsg.h"

#define REG     register
extern	char    errMsg[];


char *msqlUnixTimeToDate(clock)
	time_t clock;
{
	static char	buf[20];
	struct	tm *locTime;

	locTime = localtime(&clock);
	strftime(buf,sizeof(buf),"%d-%b-%Y",locTime);
	return(buf);
}


time_t msqlDateToUnixTime(date)
	char	*date;
{
	struct	tm locTime;

	bzero(&locTime, sizeof(locTime));
	strptime(date,"%d-%b-%Y", &locTime);
	return(mktime(&locTime));
}



char *msqlUnixTimeToTime(clock)
	time_t clock;
{
	static char	buf[20];
	struct	tm *locTime;

	locTime = localtime(&clock);
	strftime(buf,sizeof(buf),"%H:%M:%S",locTime);
	return(buf);
}


time_t msqlTimeToUnixTime(date)
	char	*date;
{
	struct	tm locTime;
	time_t	res;

	bzero(&locTime, sizeof(locTime));
	strptime(date,"%H:%M:%S", &locTime);
	locTime.tm_year = 70;
	locTime.tm_mday = 1;
	res = mktime(&locTime);
	return(res);
}

