/*
 * Copyright (c) 1987, 1988, 1989, 1990, 1991 Stanford University
 * Copyright (c) 1991 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Stanford and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Stanford and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */

/*
 * C++ interface to internet definitions.
 */

#ifndef netinet_in_h

/*
 * Don't try to hide the ntohl prototypes because they may be
 * defined as macros, but don't define them as extern "C" either.
 */

#include <netinet/in.h>

#ifndef __lucid

#ifndef ntohl

/*
 * The operations are defined as functions, possibly without prototypes,
 * so we provide our own extern "C" declarations.
 */

#ifndef __GNUC__    /* hleitner: (16.3.94) gnus provides prototypes in .../byteorder.h */
#ifndef __DECCXX    /* mpichler, 19950424: defined with unsigned int in a system header file */
#ifndef __MIPSEL    /* mpichler, 19950731: DEC: defined in netinet/in.h */
extern "C" {
    unsigned long ntohl(unsigned long);
    unsigned long htonl(unsigned long);
    unsigned short ntohs(unsigned short);
    unsigned short htons(unsigned short);
}
#endif
#endif
#endif

#endif

#endif

#endif
