/*
 * File :       hgserver.C
 *
 * Purpose :    Implementation of class HgServer
 *
 * Created :    23 Apr 92    Keith Andrews, IICM
 *
 * Modified :   12 May 92    Keith Andrews, IICM
 *
 */


#include "hgserver.h"
#include <hyperg/utils/options.h>

#ifndef __osf__
#  if !defined(hpux) && !defined(UnixWare)
#    include <osfcn.h>
#  endif
#endif



HgServer::HgServer( int port ) : RpcService( port )
{
  _newfd = 0 ;
}


void HgServer::createReader( int fd )
{
  long pid ;

  // Fork to create son

  if ( !(pid = fork()) ) {
    // this is the son
    _newfd = fd ;                 // pass file descriptor to son
    quitRunning() ;               // quit the wait loop
  }
  else { 
    // this is the father
    close( fd ) ;                 // father no longer needs file descriptor
  }
}
