package Amazon::API::CloudWatchLogs;

use strict;
use warnings;

use parent qw( Amazon::API );

our $VERSION = '1.3.3';

our @API_METHODS = qw{
  AssociateKmsKey
  CancelExportTask
  CreateExportTask
  CreateLogGroup
  CreateLogStream
  DeleteDestination
  DeleteLogGroup
  DeleteLogStream
  DeleteMetricFilter
  DeleteQueryDefinition
  DeleteResourcePolicy
  DeleteRetentionPolicy
  DeleteSubscriptionFilter
  DescribeDestinations
  DescribeExportTasks
  DescribeLogGroups
  DescribeLogStreams
  DescribeMetricFilters
  DescribeQueries
  DescribeQueryDefinitions
  DescribeResourcePolicies
  DescribeSubscriptionFilters
  DisassociateKmsKey
  FilterLogEvents
  GetLogEvents
  GetLogGroupFields
  GetLogRecord
  GetQueryResults
  ListTagsLogGroup
  PutDestination
  PutDestinationPolicy
  PutLogEvents
  PutMetricFilter
  PutQueryDefinition
  PutResourcePolicy
  PutRetentionPolicy
  PutSubscriptionFilter
  StartQuery
  StopQuery
  TagLogGroup
  TestMetricFilter
  UntagLogGroup
};

sub new {
  my ( $class, @options ) = @_;
  $class = ref($class) || $class;

  my %options = ref( $options[0] ) ? %{ $options[0] } : @options;

  return $class->SUPER::new(
    { service     => 'logs',
      api         => 'Logs',
      version     => '20140328',
      api_methods => \@API_METHODS,
      %options
    }
  );
} ## end sub new

1;
