######################################################################
#
# 0121_cp932_vs_jef_test.t
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

# Linkexpress operation manual J2X1-5930-03Z2(00) FUJITSU LIMITED
# http://software.fujitsu.com/jp/manual/manualfiles/M080093/J2X15930/03Z200/index.html
# http://software.fujitsu.com/jp/manual/manualfiles/M070086/J2X15930/01Z200/unyo05/unyo0416.html
# http://software.fujitsu.com/jp/manual/manualfiles/M070086/J2X15930/01Z200/unyo05/unyo0420.html
# http://software.fujitsu.com/jp/manual/manualfiles/M070086/J2X15930/01Z200/unyo05/unyo0421.html
# http://software.fujitsu.com/jp/manual/manualfiles/m120010/b1fw5691/05z200/index.html
# http://software.fujitsu.com/jp/manual/manualfiles/m120010/b1fw5691/05z200/index.html
# http://software.fujitsu.com/jp/manual/manualfiles/m120010/b1fw5691/05z200/index.html
# http://software.fujitsu.com/jp/manual/manualfiles/m120010/b1fw5691/05z200/index.html
# http://software.fujitsu.com/jp/manual/manualfiles/m120010/b1fw5691/05z200/b5691-g-00-00.html

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x8B\xC4",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x47\xC8"], #  8BC4 47C8
        ["\x96\x8A",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x54\xC4"], #  968A 54C4
        ["\x97\x79",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xEB"], # y 9779 70EB
        ["\xE0\xF4",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xA2"], #  E0F4 59A2
        ["\xEA\x9F",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\xB6\xC6"], #  EA9F B6C6
        ["\xEA\xA0",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\xCB\xEA"], #  EAA0 CBEA
        ["\xEA\xA1",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\xCD\xDA"], #  EAA1 CDDA
        ["\xEA\xA2",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"], #  EAA2 E0F6
        ["\xEA\xA3",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x44\xA4"], #  EAA3 44A4
        ["\xEA\xA4",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x58\xA8"], #  EAA4 58A8
        ["\x92\xCB",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x47\xC9"], #  92CB 47C9
        ["\xFA\x9C",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\xC4\xCD"], #  FA9C C4CD
        ["\x8D\x56",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x50\xFC"], # V 8D56 50FC
        ["\xFA\xD0",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\xB9\xB7"], #  FAD0 B9B7
        ["\x87\x40",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xC9"], # @ 8740 77C9
        ["\x87\x41",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xCA"], # A 8741 77CA
        ["\x87\x42",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xCB"], # B 8742 77CB
        ["\x87\x43",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xCC"], # C 8743 77CC
        ["\x87\x44",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xCD"], # D 8744 77CD
        ["\x87\x45",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xCE"], # E 8745 77CE
        ["\x87\x46",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xCF"], # F 8746 77CF
        ["\x87\x47",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xD0"], # G 8747 77D0
        ["\x87\x48",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xD1"], # H 8748 77D1
        ["\x87\x49",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xD2"], # I 8749 77D2
        ["\x87\x4A",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xD3"], # J 874A 77D3
        ["\x87\x4B",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xD4"], # K 874B 77D4
        ["\x87\x4C",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xD5"], # L 874C 77D5
        ["\x87\x4D",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xD6"], # M 874D 77D6
        ["\x87\x4E",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xD7"], # N 874E 77D7
        ["\x87\x4F",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xD8"], # O 874F 77D8
        ["\x87\x50",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xD9"], # P 8750 77D9
        ["\x87\x51",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xDA"], # Q 8751 77DA
        ["\x87\x52",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xDB"], # R 8752 77DB
        ["\x87\x53",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xDC"], # S 8753 77DC
        ["\x87\x54",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xDE"], # T 8754 77DE
        ["\x87\x55",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xDF"], # U 8755 77DF
        ["\x87\x56",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xE0"], # V 8756 77E0
        ["\x87\x57",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xE1"], # W 8757 77E1
        ["\x87\x58",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xE2"], # X 8758 77E2
        ["\x87\x59",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xE3"], # Y 8759 77E3
        ["\x87\x5A",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xE4"], # Z 875A 77E4
        ["\x87\x5B",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xE5"], # [ 875B 77E5
        ["\x87\x5C",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xE6"], # \ 875C 77E6
        ["\x87\x5D",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xE7"], # ] 875D 77E7
        ["\x87\x5F",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xDA"], # _ 875F 76DA
        ["\x87\x60",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xDC"], # ` 8760 76DC
        ["\x87\x61",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xDB"], # a 8761 76DB
        ["\x87\x62",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xD9"], # b 8762 76D9
        ["\x87\x63",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xDE"], # c 8763 76DE
        ["\x87\x64",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xE0"], # d 8764 76E0
        ["\x87\x65",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xE1"], # e 8765 76E1
        ["\x87\x66",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xE2"], # f 8766 76E2
        ["\x87\x68",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xE7"], # h 8768 76E7
        ["\x87\x69",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xE6"], # i 8769 76E6
        ["\x87\x6A",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xE3"], # j 876A 76E3
        ["\x87\x6B",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xE4"], # k 876B 76E4
        ["\x87\x6C",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xE5"], # l 876C 76E5
        ["\x87\x6D",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xE9"], # m 876D 76E9
        ["\x87\x6E",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xEB"], # n 876E 76EB
        ["\x87\x6F",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xBC"], # o 876F 76BC
        ["\x87\x70",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xBD"], # p 8770 76BD
        ["\x87\x71",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xBE"], # q 8771 76BE
        ["\x87\x72",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xC4"], # r 8772 76C4
        ["\x87\x73",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xC5"], # s 8773 76C5
        ["\x87\x74",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xC6"], # t 8774 76C6
        ["\x87\x75",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xC0"], # u 8775 76C0
        ["\x87\x82",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xFA"], #  8782 76FA
        ["\x87\x83",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xF4"], #  8783 76F4
        ["\x87\x84",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xF6"], #  8784 76F6
        ["\x87\x8A",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x78\xD5"], #  878A 78D5
        ["\x87\x8B",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x78\xCF"], #  878B 78CF
        ["\x87\x8C",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x78\xCB"], #  878C 78CB
        ["\x87\x9A",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xA8"], #  879A 76A8
        ["\x87\x90",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xA9"], #  8790 76A9
        ["\x87\x91",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xAA"], #  8791 76AA
        ["\x87\x92",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x7F\xE8"], #  8792 7FE8
        ["\x87\x95",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x7F\xE5"], #  8795 7FE5
        ["\x87\x96",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x7F\xDF"], #  8796 7FDF
        ["\x87\x97",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x7F\xDE"], #  8797 7FDE
        ["\x87\x9B",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x7F\xD7"], #  879B 7FD7
        ["\x87\x9C",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x7F\xD6"], #  879C 7FD6
        ["\xFA\x40",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xEB"], # @ FA40 77EB
        ["\xFA\x41",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xEC"], # A FA41 77EC
        ["\xFA\x42",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xED"], # B FA42 77ED
        ["\xFA\x43",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xEE"], # C FA43 77EE
        ["\xFA\x44",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xEF"], # D FA44 77EF
        ["\xFA\x45",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xF0"], # E FA45 77F0
        ["\xFA\x46",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xF1"], # F FA46 77F1
        ["\xFA\x47",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xF2"], # G FA47 77F2
        ["\xFA\x48",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xF3"], # H FA48 77F3
        ["\xFA\x49",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x77\xF4"], # I FA49 77F4
        ["\xFA\x54",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xA7"], # T FA54 76A7
        ["\xFA\x55",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xA1"], # U FA55 76A1
        ["\xFA\x56",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xA2"], # V FA56 76A2
        ["\xFA\x57",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x76\xA3"], # W FA57 76A3
        ["\xFA\x5C",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5F\xDC"], # \ FA5C 5FDC
        ["\xFA\x5D",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xB5"], # ] FA5D 64B5
        ["\xFA\x5E",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xD9"], # ^ FA5E 6AD9
        ["\xFA\x5F",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xFE"], # _ FA5F 69FE
        ["\xFA\x60",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xC4"], # ` FA60 62C4
        ["\xFA\x61",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x42\xC7"], # a FA61 42C7
        ["\xFA\x62",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xE1"], # b FA62 70E1
        ["\xFA\x63",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x51\xA3"], # c FA63 51A3
        ["\xFA\x64",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xCD"], # d FA64 70CD
        ["\xFA\x65",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xC9"], # e FA65 6AC9
        ["\xFA\x66",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x51\xFC"], # f FA66 51FC
        ["\xFA\x67",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4C\xF6"], # g FA67 4CF6
        ["\xFA\x68",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x41\xAC"], # h FA68 41AC
        ["\xFA\x69",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x41\xE8"], # i FA69 41E8
        ["\xFA\x6A",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x43\xCF"], # j FA6A 43CF
        ["\xFA\x6B",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x41\xEF"], # k FA6B 41EF
        ["\xFA\x6C",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x41\xF0"], # l FA6C 41F0
        ["\xFA\x6D",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x41\xFB"], # m FA6D 41FB
        ["\xFA\x6E",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x42\xA8"], # n FA6E 42A8
        ["\xFA\x6F",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x42\xB5"], # o FA6F 42B5
        ["\xFA\x70",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x42\xB3"], # p FA70 42B3
        ["\xFA\x71",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x42\xB9"], # q FA71 42B9
        ["\xFA\x72",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x42\xB7"], # r FA72 42B7
        ["\xFA\x73",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x42\xCA"], # s FA73 42CA
        ["\xFA\x74",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x42\xE7"], # t FA74 42E7
        ["\xFA\x75",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x42\xDF"], # u FA75 42DF
        ["\xFA\x76",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x43\xD0"], # v FA76 43D0
        ["\xFA\x77",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x42\xDE"], # w FA77 42DE
        ["\xFA\x78",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x42\xE9"], # x FA78 42E9
        ["\xFA\x79",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x42\xF5"], # y FA79 42F5
        ["\xFA\x7A",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x42\xE8"], # z FA7A 42E8
        ["\xFA\x7B",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x42\xFC"], # { FA7B 42FC
        ["\xFA\x7C",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x43\xB9"], # | FA7C 43B9
        ["\xFA\x7D",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x43\xB2"], # } FA7D 43B2
        ["\xFA\x7E",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x43\xD3"], # ~ FA7E 43D3
        ["\xFA\x80",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x43\xD9"], #  FA80 43D9
        ["\xFA\x81",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x43\xF2"], #  FA81 43F2
        ["\xFA\x82",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x43\xF7"], #  FA82 43F7
        ["\xFA\x83",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x44\xAC"], #  FA83 44AC
        ["\xFA\x84",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x44\xB4"], #  FA84 44B4
        ["\xFA\x85",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x44\xF7"], #  FA85 44F7
        ["\xFA\x86",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x44\xD2"], #  FA86 44D2
        ["\xFA\x87",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x44\xFA"], #  FA87 44FA
        ["\xFA\x88",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x44\xED"], #  FA88 44ED
        ["\xFA\x89",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x45\xA3"], #  FA89 45A3
        ["\xFA\x8A",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x45\xA8"], #  FA8A 45A8
        ["\xFA\x8B",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x45\xB3"], #  FA8B 45B3
        ["\xFA\x8C",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x45\xD2"], #  FA8C 45D2
        ["\xFA\x8D",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x45\xDB"], #  FA8D 45DB
        ["\xFA\x8E",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x45\xE2"], #  FA8E 45E2
        ["\xFA\x8F",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x45\xF3"], #  FA8F 45F3
        ["\xFA\x90",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x45\xF2"], #  FA90 45F2
        ["\xFA\x91",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x46\xC4"], #  FA91 46C4
        ["\xFA\x92",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x46\xC1"], #  FA92 46C1
        ["\xFA\x93",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x46\xC9"], #  FA93 46C9
        ["\xFA\x94",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x45\xFA"], #  FA94 45FA
        ["\xFA\x95",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x45\xF6"], #  FA95 45F6
        ["\xFA\x96",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x48\xC9"], #  FA96 48C9
        ["\xFA\x97",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x48\xCA"], #  FA97 48CA
        ["\xFA\x98",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x48\xCB"], #  FA98 48CB
        ["\xFA\x99",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x47\xF7"], #  FA99 47F7
        ["\xFA\x9A",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x47\xF6"], #  FA9A 47F6
        ["\xFA\x9B",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x48\xCC"], #  FA9B 48CC
        ["\xFA\x9D",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x48\xBB"], #  FA9D 48BB
        ["\xFA\x9E",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x48\xCD"], #  FA9E 48CD
        ["\xFA\x9F",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x48\xD0"], #  FA9F 48D0
        ["\xFA\xA0",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x48\xE3"], #  FAA0 48E3
        ["\xFA\xA1",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x48\xE4"], #  FAA1 48E4
        ["\xFA\xA2",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x48\xE5"], #  FAA2 48E5
        ["\xFA\xA3",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x48\xEB"], #  FAA3 48EB
        ["\xFA\xA4",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x49\xA3"], #  FAA4 49A3
        ["\xFA\xA5",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x49\xF0"], #  FAA5 49F0
        ["\xFA\xA6",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x49\xF2"], #  FAA6 49F2
        ["\xFA\xA7",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4A\xC9"], #  FAA7 4AC9
        ["\xFA\xA8",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4A\xBD"], #  FAA8 4ABD
        ["\xFA\xA9",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4A\xC0"], #  FAA9 4AC0
        ["\xFA\xAA",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4A\xC6"], #  FAAA 4AC6
        ["\xFA\xAB",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4A\xD4"], #  FAAB 4AD4
        ["\xFA\xAC",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4A\xF1"], #  FAAC 4AF1
        ["\xFA\xAD",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4A\xF3"], #  FAAD 4AF3
        ["\xFA\xAE",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4B\xE4"], #  FAAE 4BE4
        ["\xFA\xAF",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4A\xFB"], #  FAAF 4AFB
        ["\xFA\xB0",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4B\xA3"], #  FAB0 4BA3
        ["\xFA\xB1",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4B\xD0"], #  FAB1 4BD0
        ["\xFA\xB2",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4B\xA2"], #  FAB2 4BA2
        ["\xFA\xB3",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4B\xD3"], #  FAB3 4BD3
        ["\xFA\xB4",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4B\xDF"], #  FAB4 4BDF
        ["\xFA\xB5",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4B\xE0"], #  FAB5 4BE0
        ["\xFA\xB6",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4B\xE5"], #  FAB6 4BE5
        ["\xFA\xB7",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4C\xEB"], #  FAB7 4CEB
        ["\xFA\xB8",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4C\xEE"], #  FAB8 4CEE
        ["\xFA\xB9",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4D\xA2"], #  FAB9 4DA2
        ["\xFA\xBA",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4D\xC0"], #  FABA 4DC0
        ["\xFA\xBB",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4D\xC7"], #  FABB 4DC7
        ["\xFA\xBC",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4D\xCC"], #  FABC 4DCC
        ["\xFA\xBD",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4E\xA8"], #  FABD 4EA8
        ["\xFA\xBE",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4D\xD0"], #  FABE 4DD0
        ["\xFA\xBF",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4E\xC1"], #  FABF 4EC1
        ["\xFA\xC0",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4E\xBD"], #  FAC0 4EBD
        ["\xFA\xC1",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4E\xED"], #  FAC1 4EED
        ["\xFA\xC2",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4E\xC2"], #  FAC2 4EC2
        ["\xFA\xC3",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4E\xEE"], #  FAC3 4EEE
        ["\xFA\xC4",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4E\xD0"], #  FAC4 4ED0
        ["\xFA\xC5",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4E\xCE"], #  FAC5 4ECE
        ["\xFA\xC6",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4E\xDB"], #  FAC6 4EDB
        ["\xFA\xC7",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4E\xF7"], #  FAC7 4EF7
        ["\xFA\xC8",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4F\xB5"], #  FAC8 4FB5
        ["\xFA\xC9",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4F\xED"], #  FAC9 4FED
        ["\xFA\xCA",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4F\xFA"], #  FACA 4FFA
        ["\xFA\xCB",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x50\xA2"], #  FACB 50A2
        ["\xFA\xCC",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x4F\xA7"], #  FACC 4FA7
        ["\xFA\xCD",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x50\xC9"], #  FACD 50C9
        ["\xFA\xCE",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x51\xBD"], #  FACE 51BD
        ["\xFA\xCF",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x51\xC4"], #  FACF 51C4
        ["\xFA\xD1",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x51\xC0"], #  FAD1 51C0
        ["\xFA\xD2",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x51\xA1"], #  FAD2 51A1
        ["\xFA\xD3",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x51\xC7"], #  FAD3 51C7
        ["\xFA\xD4",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x51\xCA"], #  FAD4 51CA
        ["\xFA\xD5",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x51\xD9"], #  FAD5 51D9
        ["\xFA\xD6",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x52\xA1"], #  FAD6 52A1
        ["\xFA\xD7",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x51\xD4"], #  FAD7 51D4
        ["\xFA\xD8",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x51\xDE"], #  FAD8 51DE
        ["\xFA\xD9",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x51\xB3"], #  FAD9 51B3
        ["\xFA\xDA",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x51\xE5"], #  FADA 51E5
        ["\xFA\xDB",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x51\xAB"], #  FADB 51AB
        ["\xFA\xDC",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x51\xEB"], #  FADC 51EB
        ["\xFA\xDD",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x51\xF1"], #  FADD 51F1
        ["\xFA\xDE",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x52\xA2"], #  FADE 52A2
        ["\xFA\xDF",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x52\xBC"], #  FADF 52BC
        ["\xFA\xE0",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x52\xAD"], #  FAE0 52AD
        ["\xFA\xE1",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xCE"], #  FAE1 70CE
        ["\xFA\xE2",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x53\xB2"], #  FAE2 53B2
        ["\xFA\xE3",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x52\xEE"], #  FAE3 52EE
        ["\xFA\xE4",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x53\xB4"], #  FAE4 53B4
        ["\xFA\xE5",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x53\xC0"], #  FAE5 53C0
        ["\xFA\xE6",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x53\xC7"], #  FAE6 53C7
        ["\xFA\xE7",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xCF"], #  FAE7 70CF
        ["\xFA\xE8",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xD0"], #  FAE8 70D0
        ["\xFA\xE9",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x53\xED"], #  FAE9 53ED
        ["\xFA\xEA",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xD1"], #  FAEA 70D1
        ["\xFA\xEB",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x52\xF4"], #  FAEB 52F4
        ["\xFA\xEC",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xD2"], #  FAEC 70D2
        ["\xFA\xED",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xD3"], #  FAED 70D3
        ["\xFA\xEE",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x54\xAD"], #  FAEE 54AD
        ["\xFA\xEF",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x52\xE8"], #  FAEF 52E8
        ["\xFA\xF0",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x54\xAF"], #  FAF0 54AF
        ["\xFA\xF1",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x54\xB0"], #  FAF1 54B0
        ["\xFA\xF2",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x54\xBC"], #  FAF2 54BC
        ["\xFA\xF3",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x54\xBD"], #  FAF3 54BD
        ["\xFA\xF4",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x54\xF8"], #  FAF4 54F8
        ["\xFA\xF5",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x55\xB5"], #  FAF5 55B5
        ["\xFA\xF6",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x55\xBD"], #  FAF6 55BD
        ["\xFA\xF7",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x55\xC3"], #  FAF7 55C3
        ["\xFA\xF8",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x55\xBF"], #  FAF8 55BF
        ["\xFA\xF9",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x55\xD3"], #  FAF9 55D3
        ["\xFA\xFA",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x55\xDE"], #  FAFA 55DE
        ["\xFA\xFB",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x56\xA3"], #  FAFB 56A3
        ["\xFA\xFC",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xDE"], #  FAFC 70DE
        ["\xFB\x40",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x56\xA7"], # @ FB40 56A7
        ["\xFB\x41",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x56\xAD"], # A FB41 56AD
        ["\xFB\x42",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x56\xB2"], # B FB42 56B2
        ["\xFB\x43",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x56\xB8"], # C FB43 56B8
        ["\xFB\x44",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xDF"], # D FB44 70DF
        ["\xFB\x45",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x55\xB1"], # E FB45 55B1
        ["\xFB\x46",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x56\xC2"], # F FB46 56C2
        ["\xFB\x47",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x56\xCF"], # G FB47 56CF
        ["\xFB\x48",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x56\xBE"], # H FB48 56BE
        ["\xFB\x49",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x56\xC3"], # I FB49 56C3
        ["\xFB\x4A",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x56\xDF"], # J FB4A 56DF
        ["\xFB\x4B",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x56\xFE"], # K FB4B 56FE
        ["\xFB\x4C",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x57\xAE"], # L FB4C 57AE
        ["\xFB\x4D",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x57\xB8"], # M FB4D 57B8
        ["\xFB\x4E",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x57\xB9"], # N FB4E 57B9
        ["\xFB\x4F",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x57\xBA"], # O FB4F 57BA
        ["\xFB\x50",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x57\xBC"], # P FB50 57BC
        ["\xFB\x51",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x57\xD1"], # Q FB51 57D1
        ["\xFB\x52",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x57\xDE"], # R FB52 57DE
        ["\xFB\x53",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x58\xA6"], # S FB53 58A6
        ["\xFB\x54",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x58\xA5"], # T FB54 58A5
        ["\xFB\x55",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x57\xF1"], # U FB55 57F1
        ["\xFB\x56",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x57\xEB"], # V FB56 57EB
        ["\xFB\x57",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x57\xEC"], # W FB57 57EC
        ["\xFB\x58",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xE3"], # X FB58 70E3
        ["\xFB\x59",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x57\xF6"], # Y FB59 57F6
        ["\xFB\x5A",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x58\xA9"], # Z FB5A 58A9
        ["\xFB\x5B",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x58\xFA"], # [ FB5B 58FA
        ["\xFB\x5C",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x58\xD6"], # \ FB5C 58D6
        ["\xFB\x5D",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x58\xED"], # ] FB5D 58ED
        ["\xFB\x5E",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x58\xEF"], # ^ FB5E 58EF
        ["\xFB\x5F",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x58\xF6"], # _ FB5F 58F6
        ["\xFB\x60",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xBA"], # ` FB60 59BA
        ["\xFB\x61",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xBC"], # a FB61 59BC
        ["\xFB\x62",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xC0"], # b FB62 59C0
        ["\xFB\x63",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xC3"], # c FB63 59C3
        ["\xFB\x64",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5A\xAC"], # d FB64 5AAC
        ["\xFB\x65",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xD0"], # e FB65 59D0
        ["\xFB\x66",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xC7"], # f FB66 59C7
        ["\xFB\x67",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xD7"], # g FB67 59D7
        ["\xFB\x68",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xDA"], # h FB68 59DA
        ["\xFB\x69",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xD9"], # i FB69 59D9
        ["\xFB\x6A",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xDD"], # j FB6A 59DD
        ["\xFB\x6B",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5A\xAD"], # k FB6B 5AAD
        ["\xFB\x6C",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xF4"], # l FB6C 59F4
        ["\xFB\x6D",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x59\xFB"], # m FB6D 59FB
        ["\xFB\x6E",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5A\xB8"], # n FB6E 5AB8
        ["\xFB\x6F",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5A\xD0"], # o FB6F 5AD0
        ["\xFB\x70",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5A\xFE"], # p FB70 5AFE
        ["\xFB\x71",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5B\xA4"], # q FB71 5BA4
        ["\xFB\x72",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5B\xA5"], # r FB72 5BA5
        ["\xFB\x73",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5A\xFD"], # s FB73 5AFD
        ["\xFB\x74",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5B\xA9"], # t FB74 5BA9
        ["\xFB\x75",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5B\xB7"], # u FB75 5BB7
        ["\xFB\x76",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5B\xCC"], # v FB76 5BCC
        ["\xFB\x77",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x44\xDC"], # w FB77 44DC
        ["\xFB\x78",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5B\xFC"], # x FB78 5BFC
        ["\xFB\x79",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xA7"], # y FB79 5CA7
        ["\xFB\x7A",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xAE"], # z FB7A 5CAE
        ["\xFB\x7B",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xB2"], # { FB7B 5CB2
        ["\xFB\x7C",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xCE"], # | FB7C 5CCE
        ["\xFB\x7D",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xE5"], # } FB7D 70E5
        ["\xFB\x7E",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xDA"], # ~ FB7E 5CDA
        ["\xFB\x80",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xDC"], #  FB80 5CDC
        ["\xFB\x81",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xE6"], #  FB81 5CE6
        ["\xFB\x82",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xE4"], #  FB82 5CE4
        ["\xFB\x83",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xE8"], #  FB83 5CE8
        ["\xFB\x84",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5D\xDD"], #  FB84 5DDD
        ["\xFB\x85",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5D\xE1"], #  FB85 5DE1
        ["\xFB\x86",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5D\xE5"], #  FB86 5DE5
        ["\xFB\x87",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5D\xE4"], #  FB87 5DE4
        ["\xFB\x88",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5E\xA3"], #  FB88 5EA3
        ["\xFB\x89",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5E\xD3"], #  FB89 5ED3
        ["\xFB\x8A",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5E\xFD"], #  FB8A 5EFD
        ["\xFB\x8B",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5E\xE0"], #  FB8B 5EE0
        ["\xFB\x8C",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5F\xE4"], #  FB8C 5FE4
        ["\xFB\x8D",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5F\xB6"], #  FB8D 5FB6
        ["\xFB\x8E",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5F\xBE"], #  FB8E 5FBE
        ["\xFB\x8F",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5F\xD6"], #  FB8F 5FD6
        ["\xFB\x90",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5F\xE8"], #  FB90 5FE8
        ["\xFB\x91",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5F\xF7"], #  FB91 5FF7
        ["\xFB\x92",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x60\xA1"], #  FB92 60A1
        ["\xFB\x93",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x61\xD9"], #  FB93 61D9
        ["\xFB\x94",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xE7"], #  FB94 70E7
        ["\xFB\x95",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x61\xF0"], #  FB95 61F0
        ["\xFB\x96",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x61\xFE"], #  FB96 61FE
        ["\xFB\x97",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xAA"], #  FB97 62AA
        ["\xFB\x98",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xE8"], #  FB98 70E8
        ["\xFB\x99",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xE9"], #  FB99 70E9
        ["\xFB\x9A",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xD1"], #  FB9A 62D1
        ["\xFB\x9B",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xD4"], #  FB9B 62D4
        ["\xFB\x9C",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xD9"], #  FB9C 62D9
        ["\xFB\x9D",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xE4"], #  FB9D 62E4
        ["\xFB\x9E",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x62\xE5"], #  FB9E 62E5
        ["\xFB\x9F",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xEA"], #  FB9F 70EA
        ["\xFB\xA0",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x63\xDF"], #  FBA0 63DF
        ["\xFB\xA1",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x63\xE0"], #  FBA1 63E0
        ["\xFB\xA2",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x63\xF9"], #  FBA2 63F9
        ["\xFB\xA3",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xE4"], #  FBA3 64E4
        ["\xFB\xA4",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xEC"], #  FBA4 64EC
        ["\xFB\xA5",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x64\xDA"], #  FBA5 64DA
        ["\xFB\xA6",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xA7"], #  FBA6 65A7
        ["\xFB\xA7",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xEA"], #  FBA7 6BEA
        ["\xFB\xA8",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xB3"], #  FBA8 65B3
        ["\xFB\xA9",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xB7"], #  FBA9 65B7
        ["\xFB\xAA",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xB6"], #  FBAA 65B6
        ["\xFB\xAB",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xC7"], #  FBAB 65C7
        ["\xFB\xAC",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xD1"], #  FBAC 65D1
        ["\xFB\xAD",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x66\xAB"], #  FBAD 66AB
        ["\xFB\xAE",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xF9"], #  FBAE 65F9
        ["\xFB\xAF",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x65\xF8"], #  FBAF 65F8
        ["\xFB\xB0",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x66\xB9"], #  FBB0 66B9
        ["\xFB\xB1",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x66\xC3"], #  FBB1 66C3
        ["\xFB\xB2",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x66\xED"], #  FBB2 66ED
        ["\xFB\xB3",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xF9"], #  FBB3 70F9
        ["\xFB\xB4",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xFB"], #  FBB4 70FB
        ["\xFB\xB5",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x70\xFA"], #  FBB5 70FA
        ["\xFB\xB6",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x68\xA6"], #  FBB6 68A6
        ["\xFB\xB7",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x68\xA8"], #  FBB7 68A8
        ["\xFB\xB8",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x68\xDF"], #  FBB8 68DF
        ["\xFB\xB9",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x68\xB0"], #  FBB9 68B0
        ["\xFB\xBA",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xBE"], #  FBBA 69BE
        ["\xFB\xBB",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xBC"], #  FBBB 69BC
        ["\xFB\xBC",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xBF"], #  FBBC 69BF
        ["\xFB\xBD",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xC5"], #  FBBD 69C5
        ["\xFB\xBE",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xC6"], #  FBBE 69C6
        ["\xFB\xBF",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xC0"], #  FBBF 69C0
        ["\xFB\xC0",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xC1"], #  FBC0 69C1
        ["\xFB\xC1",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xCD"], #  FBC1 69CD
        ["\xFB\xC2",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xD1"], #  FBC2 69D1
        ["\xFB\xC3",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xD0"], #  FBC3 69D0
        ["\xFB\xC4",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xE1"], #  FBC4 69E1
        ["\xFB\xC5",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xE4"], #  FBC5 69E4
        ["\xFB\xC6",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xE2"], #  FBC6 69E2
        ["\xFB\xC7",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xE8"], #  FBC7 69E8
        ["\xFB\xC8",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xEE"], #  FBC8 69EE
        ["\xFB\xC9",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xEA"], #  FBC9 69EA
        ["\xFB\xCA",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xE0"], #  FBCA 69E0
        ["\xFB\xCB",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xD2"], #  FBCB 6BD2
        ["\xFB\xCC",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xA7"], #  FBCC 6AA7
        ["\xFB\xCD",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xF7"], #  FBCD 69F7
        ["\xFB\xCE",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xF8"], #  FBCE 69F8
        ["\xFB\xCF",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xC4"], #  FBCF 6AC4
        ["\xFB\xD0",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xBC"], #  FBD0 6ABC
        ["\xFB\xD1",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xBE"], #  FBD1 6ABE
        ["\xFB\xD2",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xB8"], #  FBD2 6AB8
        ["\xFB\xD3",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xD3"], #  FBD3 6BD3
        ["\xFB\xD4",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xBB"], #  FBD4 6ABB
        ["\xFB\xD5",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xC2"], #  FBD5 6AC2
        ["\xFB\xD6",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xBA"], #  FBD6 6ABA
        ["\xFB\xD7",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xD5"], #  FBD7 6AD5
        ["\xFB\xD8",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xD3"], #  FBD8 6AD3
        ["\xFB\xD9",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x69\xB3"], #  FBD9 69B3
        ["\xFB\xDA",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xD4"], #  FBDA 6BD4
        ["\xFB\xDB",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xD1"], #  FBDB 6AD1
        ["\xFB\xDC",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xCA"], #  FBDC 6ACA
        ["\xFB\xDD",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xD0"], #  FBDD 6AD0
        ["\xFB\xDE",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xCC"], #  FBDE 6ACC
        ["\xFB\xDF",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xE4"], #  FBDF 6AE4
        ["\xFB\xE0",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xDE"], #  FBE0 6ADE
        ["\xFB\xE1",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xF2"], #  FBE1 6AF2
        ["\xFB\xE2",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A\xF9"], #  FBE2 6AF9
        ["\xFB\xE3",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xA3"], #  FBE3 6BA3
        ["\xFB\xE4",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xAE"], #  FBE4 6BAE
        ["\xFB\xE5",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xBD"], #  FBE5 6BBD
        ["\xFB\xE6",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xC5"], #  FBE6 6BC5
        ["\xFB\xE7",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xC6"], #  FBE7 6BC6
        ["\xFB\xE8",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B\xE1"], #  FBE8 6BE1
        ["\xFB\xE9",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x68\xCC"], #  FBE9 68CC
        ["\xFB\xEA",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x68\xE0"], #  FBEA 68E0
        ["\xFB\xEB",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x68\xD4"], #  FBEB 68D4
        ["\xFB\xEC",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x68\xDB"], #  FBEC 68DB
        ["\xFB\xED",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xAC"], #  FBED 6CAC
        ["\xFB\xEE",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xAD"], #  FBEE 6CAD
        ["\xFB\xEF",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xB0"], #  FBEF 6CB0
        ["\xFB\xF0",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xB1"], #  FBF0 6CB1
        ["\xFB\xF1",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xAE"], #  FBF1 6CAE
        ["\xFB\xF2",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xB3"], #  FBF2 6CB3
        ["\xFB\xF3",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xB5"], #  FBF3 6CB5
        ["\xFB\xF4",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xF3"], #  FBF4 6CF3
        ["\xFB\xF5",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C\xF7"], #  FBF5 6CF7
        ["\xFB\xF6",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xB3"], #  FBF6 6DB3
        ["\xFB\xF7",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xB4"], #  FBF7 6DB4
        ["\xFB\xF8",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xBD"], #  FBF8 6DBD
        ["\xFB\xF9",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xBE"], #  FBF9 6DBE
        ["\xFB\xFA",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C\xF3"], #  FBFA 5CF3
        ["\xFB\xFB",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D\xF6"], #  FBFB 6DF6
        ["\xFB\xFC",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6E\xA4"], #  FBFC 6EA4
        ["\xFC\x40",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6E\xA7"], # @ FC40 6EA7
        ["\xFC\x41",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6E\xD0"], # A FC41 6ED0
        ["\xFC\x42",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6E\xEE"], # B FC42 6EEE
        ["\xFC\x43",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6E\xD8"], # C FC43 6ED8
        ["\xFC\x44",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6E\xDB"], # D FC44 6EDB
        ["\xFC\x45",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6E\xEF"], # E FC45 6EEF
        ["\xFC\x46",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6E\xE3"], # F FC46 6EE3
        ["\xFC\x47",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6F\xA3"], # G FC47 6FA3
        ["\xFC\x48",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6F\xA1"], # H FC48 6FA1
        ["\xFC\x49",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6F\xB2"], # I FC49 6FB2
        ["\xFC\x4A",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6F\xAE"], # J FC4A 6FAE
        ["\xFC\x4B",'jef','cp932',{'INPUT_LAYOUT'=>'D'},"\x6F\xD6"], # K FC4B 6FD6
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e::RoundTrip;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::RoundTrip::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
