/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.salt.Cell;
import net.sourceforge.plantuml.salt.Terminated;
import net.sourceforge.plantuml.salt.Terminator;
import net.sourceforge.plantuml.salt.element.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Positionner2 {
    private int row;
    private int col;
    private int maxRow;
    private int maxCol;
    private final Map<Element, Cell> positions = new LinkedHashMap<Element, Cell>();
    private Cell last;

    public void add(Terminated<Element> terminated) {
        this.addWithoutMove(terminated.getElement());
        Terminator terminator = terminated.getTerminator();
        if (terminator == Terminator.NEWCOL) {
            this.moveNextColumn();
        } else {
            this.moveNextRow();
        }
    }

    private void moveNextColumn() {
        ++this.col;
    }

    private void moveNextRow() {
        ++this.row;
        this.col = 0;
    }

    private void addWithoutMove(Element element) {
        this.last = new Cell(this.row, this.col);
        this.positions.put(element, this.last);
        this.updateMax();
    }

    public void mergeLeft(Terminator terminator) {
        this.updateMax();
        if (terminator == Terminator.NEWCOL) {
            ++this.col;
        } else {
            ++this.row;
            this.col = 0;
        }
        this.last.mergeLeft();
    }

    private void updateMax() {
        if (this.row > this.maxRow) {
            this.maxRow = this.row;
        }
        if (this.col > this.maxCol) {
            this.maxCol = this.col;
        }
    }

    public Map<Element, Cell> getAll() {
        return Collections.unmodifiableMap(this.positions);
    }

    public final int getNbRows() {
        return this.maxRow + 1;
    }

    public final int getNbCols() {
        return this.maxCol + 1;
    }
}

