package Number::Phone::NO::Data;

use strict;
use warnings;

use DBM::Deep;
our $db = DBM::Deep->new( { fh => \*DATA, type => DBM::Deep->TYPE_ARRAY, locking => 0 });
our $count = 1164;
our $DEBUG = 0;
sub lookup {
    my $nr = shift;
    my $f = shift;
    my $t = shift;
    $f = 0 unless defined $f;
    $t = $count unless defined $t;
    
    my $delta = sprintf("%d", ($t - $f) / 2);
    my $bucket_id = $f + $delta;
    die "bad bucket_id: $bucket_id out of range" if ($bucket_id > $count);
    warn "lookup: $nr  -- $f - $t, looking in $bucket_id" if $DEBUG;
    my $bucket = $db->get($bucket_id);
    
    warn $bucket->{from} . " - " . $bucket->{to} if $DEBUG;
    
    if ($nr < $bucket->{from}) {
        
        my $new_id = $f + $delta;
        warn "below our bucket, looking in $f - $new_id" if $DEBUG;
        return unless $delta; # if $delta is 0 we are in the last possible bucket
        return lookup($nr, $f, $new_id);
        
    } elsif ($nr > $bucket->{to}) {
        
        my $new_id = $bucket_id;
        warn "above our bucket, looking in $new_id - $t" if $DEBUG;
        return unless $delta; # if $delta is 0 we are in the last possible bucket
        return lookup($nr, $new_id, $t);
    } else {
#        # YAY :p
        return $bucket;
        warn "our bucket, yay" if $DEBUG;
    }
}
1;

__DATA__
DPDBh      ?             A    yN                                                        H    !                                                        B ^\Q6ԂSM    q=`-<]#y    O:-h}    DEֳ     KX3vv{<>
Y    Dqc}G΅>    D5 1    DيI!N\<    ^<Q    Dm<!j9QR    W5?Q
z    D_kVܕOFLA                                                                                                    D      0                                                       D     0                                                       D      length                                                  D     0                                                       B  ^\Q6ԂSM    a=`-<]#y  $  O:-h}    d_W
\IIݏ  $  Eֳ     dD5 1  $  qc}G΅>    dيI!N\<  $  ^<Q    dW5?Q
z  	$  _kVܕOFLA  	  	d                                                                                                                        D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      is_network_service                                      D      0                                                       D      
is_geographic                                           D      199                                                     D      to                                                      D      0                                                       D      	is_mobile                                               D      100                                                     D      from                                                    D      1                                                       D      is_specialrate                                          N                                                               D      is_tollfree                                             D      1                                                       D      is_valid                                                H    
                                                        D      1                                                       D     0                                                       B  ^\Q6ԂSM  '  =`-<]#y    gO:-h}  
'  Eֳ   
  
gqc}G΅>  '  
D5 1    gيI!N\<  '  ^<Q    gW5?Q
z  '  _kVܕOFLA    g                                                                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      0                                                       D      	is_mobile                                               D      9999                                                    D      to                                                      D      2000                                                    D      from                                                    D      1                                                       D      is_specialrate                                          N                                                               D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                            D      2                                                       D     0                                                       B  ^\Q6ԂSM  *  
d=`-<]#y    jO:-h}  *  Eֳ     jKX3vv{<>
Y  *  qc}G΅>    jD5 1  *  يI!N\<    j^<Q  *  m<!j9QR    jW5?Q
z  *  _kVܕOFLA    j                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      20999999                                                D      to                                                      D      20000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                            D      3                                                       D     0                                                       B  ^\Q6ԂSM  -  g=`-<]#y    mO:-h}  -  Eֳ     mKX3vv{<>
Y  -  qc}G΅>    mD5 1  -  يI!N\<    m^<Q  -  m<!j9QR    mW5?Q
z   -  _kVܕOFLA      m                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      21099999                                                D      to                                                      D      21000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H    !                                                        D      4                                                       D     0                                                       B  ^\Q6ԂSM  #0  j=`-<]#y  #  #pO:-h}  $0  #Eֳ   $  $pKX3vv{<>
Y  %0  $qc}G΅>  %  %pD5 1  &0  %يI!N\<  &  &p^<Q  '0  &m<!j9QR  '  'pW5?Q
z  (0  '_kVܕOFLA  (  (p                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      21299999                                                D      to                                                      D      21100000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H    )                                                        D      5                                                       D     0                                                       B  ^\Q6ԂSM  +3  !m=`-<]#y  +  +sO:-h}  ,3  +Eֳ   ,  ,sKX3vv{<>
Y  -3  ,qc}G΅>  -  -sD5 1  .3  -يI!N\<  .  .s^<Q  /3  .m<!j9QR  /  /sW5?Q
z  03  /_kVܕOFLA  0  0s                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Tele2 Norge AS                                          D      operator                                                D      0                                                       D      	is_mobile                                               D      21319999                                                D      to                                                      D      21300000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H    1                                                        D      6                                                       D     0                                                       B  ^\Q6ԂSM  36  )p=`-<]#y  3  3vO:-h}  46  3Eֳ   4  4vKX3vv{<>
Y  56  4qc}G΅>  5  5vD5 1  66  5يI!N\<  6  6v^<Q  76  6m<!j9QR  7  7vW5?Q
z  86  7_kVܕOFLA  8  8v                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      21379999                                                D      to                                                      D      21320000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H    9                                                        D      7                                                       D     0                                                       B  ^\Q6ԂSM  ;9  1s=`-<]#y  ;  ;yO:-h}  <9  ;Eֳ   <  <yKX3vv{<>
Y  =9  <qc}G΅>  =  =yD5 1  >9  =يI!N\<  >  >y^<Q  ?9  >m<!j9QR  ?  ?yW5?Q
z  @9  ?_kVܕOFLA  @  @y                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telio Telecom AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      21389999                                                D      to                                                      D      21380000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H    A                                                        D      8                                                       D     0                                                       B  ^\Q6ԂSM  C<  9v=`-<]#y  C  C|O:-h}  D<  CEֳ   D  D|KX3vv{<>
Y  E<  Dqc}G΅>  E  E|D5 1  F<  EيI!N\<  F  F|^<Q  G<  Fm<!j9QR  G  G|W5?Q
z  H<  G_kVܕOFLA  H  H|                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telio Telecom AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      21399999                                                D      to                                                      D      21390000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H    I                                                        D      9                                                       D     0                                                       B  ^\Q6ԂSM  K?  Ay=`-<]#y  K  KO:-h}  L?  KEֳ   L  LKX3vv{<>
Y  M?  Lqc}G΅>  M  MD5 1  N?  MيI!N\<  N  N^<Q  O?  Nm<!j9QR  O  OW5?Q
z  P?  O_kVܕOFLA  P  P                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D       PowerTech Information Systems AS                        D      operator                                                D      0                                                       D      	is_mobile                                               D      21409999                                                D      to                                                      D      21400000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H    Q                                                        D      10                                                      D     0                                                       B  ^\Q6ԂSM  SB  I|=`-<]#y  S  SO:-h}  TB  TEֳ   T  TKX3vv{<>
Y  UB  Uqc}G΅>  U  UD5 1  VB  VيI!N\<  V  V^<Q  WB  Wm<!j9QR  W  WW5?Q
z  XB  X_kVܕOFLA  X  X                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      	Comvie AS                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      21419999                                                D      to                                                      D      21410000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H    Y                                                        D      11                                                      D     0                                                       B  ^\Q6ԂSM  [E  Q=`-<]#y  [  [O:-h}  \E  \Eֳ   \  \KX3vv{<>
Y  ]E  ]qc}G΅>  ]  ]D5 1  ^E  ^يI!N\<  ^  ^^<Q  _E  _m<!j9QR  _  _W5?Q
z  `E  `_kVܕOFLA  `  `                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Network Norway AS                                       D      operator                                                D      0                                                       D      	is_mobile                                               D      21424999                                                D      to                                                      D      21420000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H    a                                                        D      12                                                      D     0                                                       B  ^\Q6ԂSM  cH  Y=`-<]#y  c  cO:-h}  dH  dEֳ   d  dKX3vv{<>
Y  eH  eqc}G΅>  e  eD5 1  fH  fيI!N\<  f  f^<Q  gH  gm<!j9QR  g  gW5?Q
z  hH  h_kVܕOFLA  h  h                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      21439999                                                D      to                                                      D      21425000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H    i                                                        D      13                                                      D     0                                                       B  ^\Q6ԂSM  kK  a=`-<]#y  k  kO:-h}  lK  lEֳ   l  lKX3vv{<>
Y  mK  mqc}G΅>  m  mD5 1  nK  nيI!N\<  n  n^<Q  oK  om<!j9QR  o  oW5?Q
z  pK  p_kVܕOFLA  p  p                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      21444999                                                D      to                                                      D      21440000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H    q                                                        D      14                                                      D     0                                                       B  ^\Q6ԂSM  sN  i=`-<]#y  s  sO:-h}  tN  tEֳ   t  tKX3vv{<>
Y  uN  uqc}G΅>  u  uD5 1  vN  vيI!N\<  v  v^<Q  wN  wm<!j9QR  w  wW5?Q
z  xN  x_kVܕOFLA  x  x                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      
NextGenTel AS                                           D      operator                                                D      0                                                       D      	is_mobile                                               D      21447999                                                D      to                                                      D      21445000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                             I      W k "  :  0 1 ]  
   J      
 6 ~J    = Zy h  P     x q +  = }     @ / @k & ,  ~ . d s I !U  
  .    Y  " P % 
e <   x M  o 	j T 
 
A { 
9 e   = 
 g 	

 u g X ]1 jB       (. 
k 
 U6  J    i 4a 8  u 't  
 m 	 {       
   }* 	 ## J%  [ W= 	~ %   {R g D  C x 
   S  t < 8  	3 K3    i (!  f / 
l 
 R:   Ü ] P     uf h oA  p  " c \ H&      
  Q : J  d 
A Q  
  ֨ l N   
/ t  - 8 D *   q
  W  {         T ~ W R  }Q  l    ! J u 1  , \5 	L 
9      n  7* B Gm  c 	E% 9 ^ Ӈ  ` A&  ] R  
c&   ^? { Ѿ N L   ^ 
  ] j c  B   efd  !   ^'ocHT^.1  ĶϠçc-SI 	 	P OvO%.&  h9C^ȓ4 9 9wg5Z33CCa.  ϼ%ko+ c b                                                                                                                                                                                                                        B  /|ecr^8D   %/+&V%jgRy * /Up}A'W  /71򤃨 [=  R/].6>U  b                                                                                                                                                                                                                                                                        B  B8#
Pou  
$  	QG)1 9Fď 9# 8 >=E'\  [6kHqI޾y cf c&ĳ\up # #n                                                                                                                                                                                                                                                                        B  rL/co,  '  饇&R=FE M 
j~UՎ5Jo+ 
[ 
[B!Og;H 	 	j^A 3 JgZt b  k                                                                                                                                                                                                                                                B  ~K\(0  *  Vczx{їw^ j *]^ָ.~{ \ 櫳R[Qrj' n .Z`A_	ڈ                                                                                                                                                                                                                                                                            B  y{uB,  !-   eTci"   ި^ڀ
q:܀ qK qȊ U6cjڷ 
 
(K['|   plEv7dU4 ) )$e&3Ra8 m lǨdLW--
 * 캺Q}Ov7  Ǩ%M1^K " "G$#^I:0`ul % %g                                                                                                                        B  ;#Ew+t  )0  (",[47T O Q mἪ٥O
/
 
 
O;S;uXW p] pLQs@ ( (J䛋@Sߕ:p  ބ                                                                                                                                                                                                                                                B  y	Zo~  13  0ͮ6+'ǷC0 	 	Q
/s}zޫ9۫  j"PXgȫlW > >L2'5 k k2mh&`*a %ǭ %m                                                                                                                                                                                                                                                B  _zZ6K%C  96  8Qygy^l"_x [ [S)Zs鼍O c c}tq~!"E! 	^ 	^q	;
o1GKvNj ;b ;"t=`  }~S\ j *F:2 PE p 0CbƻX

\H $7 $6                                                                                                                                                                        B  Y)~#m  A9  @O[?Rr  ҳɉ*2vNp 1 1Z
ZRș3_g $ $                                                                                                                                                                                                                                                                                                B  EČ.-Qƭ&  I<  HE^6B2-  EdZ'ȧ5`dm , EX۶.;n, /. .EjɰZq2! "fi "f)Et}L?
 %O %O@EXoþrS % %X                                                                                                                                                                                                                        B  DhBYu]8c   Q?  PӕwRD 	 	Ji5(                                                                                                                                                                                                                                                                                                                          B  eCʦ,
e-  YB  Yek*Guo  ڶe5<^}Hő0  ƮeeX<+nQ2|  e,]sy:c !n !m                                                                                                                                                                                                                                                                        B  
owY'ɛg  aE  aLnf褛(  ءQa*E~MgcZ  vbmQoK h h®aWx/q k	 j*y[/ | <d[;9c $G $                                                                                                                                                                                                                        B  $
¯9  iH  i/lbؿ':  %C?L8gRF{ W ū
ǒp? HJ H
                                                                                                                                                                                                                                                                                                B  #"Zo`n%V  qK  q*H@6 M MI <+x| * h\Jwhk/v    噪Igm $ $                                                                                                                                                                                                                                                                        B  bjȽ/  D  y%|pwsZ e %R^x9@m % %a[b,id  ܛpbW
2/e > >rqTfX
D# 6 6Ii[%(= _                                                                                                                                                                                                                         D     0                                                       D      15                                                      D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Get AS                                                  D      operator                                                D      0                                                       D      	is_mobile                                               D      21449999                                                D      to                                                      D      21448000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                            B  M%~D[{    D$퐌#kљm 8 8\[oL#3| < n n^c[$,$ $D $                                                                                                                                                                                                                                                                                                D      16                                                      D     0                                                       B  ^\Q6ԂSM  
  =`-<]#y    JO:-h}  
  Eֳ     JKX3vv{<>
Y  
  qc}G΅>    JD5 1  
  يI!N\<    J^<Q  
  m<!j9QR    JW5?Q
z  
  _kVܕOFLA    J                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Lyse Tele AS                                            D      operator                                                D      0                                                       D      	is_mobile                                               D      21455999                                                D      to                                                      D      21450000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H    
                                                        B  p.ɰBckU    p_!rFfx5   p9^0DLY+ 
} 
|pJ9</w3o : :p<
^qK} # #n                                                                                                                                                                                                                                                                        D      17                                                      D     0                                                       B  ^\Q6ԂSM    G=`-<]#y    O:-h}    PEֳ     KX3vv{<>
Y    Pqc}G΅>    D5 1    PيI!N\<    ^<Q    Pm<!j9QR    W5?Q
z    P_kVܕOFLA                                                                                                    D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      21489999                                                D      to                                                      D      21456000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                            B  oI"UhJ)m#    Po>zaoW nD no@ 9c-Ju a `o"h=>Mk]	% V                                                                                                                                                                                                                                                                                                 D      18                                                      D     0                                                       B  ^\Q6ԂSM    =`-<]#y    VO:-h}    Eֳ     VKX3vv{<>
Y    qc}G΅>    VD5 1    يI!N\<    V^<Q    m<!j9QR    VW5?Q
z    _kVܕOFLA    V                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Consorte Group ASA                                      D      operator                                                D      0                                                       D      	is_mobile                                               D      21499999                                                D      to                                                      D      21490000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                            B  =EC    w@)Ce_    tz}Z)K ( (h L>2;K  uP?փ
bv_rB 
 
Dwׯ63+N r 2                                                                                                                                                                                                                                                D      19                                                      D     0                                                       B  ^\Q6ԂSM    S=`-<]#y    O:-h}    \Eֳ     KX3vv{<>
Y    \qc}G΅>    D5 1    \يI!N\<    ^<Q    \m<!j9QR    W5?Q
z    \_kVܕOFLA                                                                                                    D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      21589999                                                D      to                                                      D      21500000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H    ş                                                        B  7!uh{j;    \={cF|R p= or/q1` a ! A$p&V&C o /k: a4  Ґ                                                                                                                                                                                                                                                                        D      20                                                      D     0                                                       B  ^\Q6ԂSM  "  =`-<]#y  Ǣ  bO:-h}  "  Eֳ   Ȣ  bKX3vv{<>
Y  "  qc}G΅>  ɢ  bD5 1  "  يI!N\<  ʢ  b^<Q  "  m<!j9QR  ˢ  bW5?Q
z  "  _kVܕOFLA  ̢  b                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Verizon Norway AS                                       D      operator                                                D      0                                                       D      	is_mobile                                               D      21599999                                                D      to                                                      D      21590000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H    %                                                        B  <YP$;\ty  Υ  <_[R?_CK f &<wklp {z {:<fƷ?Og0  ?<ɸ]#0! 3 3t                                                                                                                                                                                                                                                                        D      21                                                      D     0                                                       B  ^\Q6ԂSM  Ш  _=`-<]#y  (  O:-h}  Ѩ  hEֳ   (  KX3vv{<>
Y  Ҩ  hqc}G΅>  (  D5 1  Ө  hيI!N\<  (  ^<Q  Ԩ  hm<!j9QR  (  W5?Q
z  ը  h_kVܕOFLA  (                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      21639999                                                D      to                                                      D      21600000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H    ث                                                        B  g]!KXh  +  hG}$IuCa$Y'r [n [.6]mx$׻" 
 ͶZ'{uP} '                                                                                                                                                                                                                                                                                                 D      22                                                      D     0                                                       B  ^\Q6ԂSM  .  =`-<]#y  ڮ  nO:-h}  .  Eֳ   ۮ  nKX3vv{<>
Y  .  qc}G΅>  ܮ  nD5 1  .  يI!N\<  ݮ  n^<Q  .  m<!j9QR  ޮ  nW5?Q
z  .  _kVܕOFLA  ߮  n                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telio Telecom AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      21649999                                                D      to                                                      D      21640000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H    1                                                        B  7i<tI]ع    7IdSR< yN y7/uE
A 6L 
; 
7}8;7  7g@
<  ٟ                                                                                                                                                                                                                                                                        D      23                                                      D     0                                                       B  ^\Q6ԂSM    k=`-<]#y  4  O:-h}    tEֳ   4  KX3vv{<>
Y    tqc}G΅>  4  D5 1    tيI!N\<  4  ^<Q    tm<!j9QR  4  W5?Q
z    t_kVܕOFLA  4                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      21655999                                                D      to                                                      D      21650000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H    4                                                        D      24                                                      D     0                                                       B  ^\Q6ԂSM    =`-<]#y  7  O:-h}    wEֳ   7  KX3vv{<>
Y    wqc}G΅>  7  D5 1    wيI!N\<  7  ^<Q    wm<!j9QR  7  W5?Q
z    w_kVܕOFLA  7                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telio Telecom AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      21658999                                                D      to                                                      D      21656000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                            B  )jz7V3p_Z;  :  w0Iu̲37Wa 
 

)\i	1"/F{ 
K| 
K<kBdN'4^a   ߎYAo?p! Q @Ms6Ihjh {v {6rCmvg x x                                                                                                                                                                                                                        D      25                                                      D     0                                                       B  ^\Q6ԂSM  =  =`-<]#y    }O:-h}  =  Eֳ     }KX3vv{<>
Y  =  qc}G΅>    }D5 1  =  يI!N\<    }^<Q  =  m<!j9QR    }W5?Q
z  =  _kVܕOFLA    }                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      21659999                                                D      to                                                      D      21659000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H    @                                                        B  Ns,4cmʚ6w    NK_`+m5F
 N NoР` ]P  N	(U8œڻ^  N_F..x j *N%E =J` # #ΰ                                                                                                                                                                                                                                                D      26                                                      D     0                                                       B  ^\Q6ԂSM    z=`-<]#y  C  O:-h}    Eֳ   C  KX3vv{<>
Y    qc}G΅> C D5 1  يI!N\< C ^<Q  m<!j9QR C W5?Q
z  _kVܕOFLA C                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      
NextGenTel AS                                           D      operator                                                D      0                                                       D      	is_mobile                                               D      21669999                                                D      to                                                      D      21660000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  O2zh8 F R*+'&
RM  ִf=?TlCjye} `  *fo| p 0Mz# [ Z~qMSo ! !                                                                                                                                                                                                                                                D      27                                                      D     0                                                       B  ^\Q6ԂSM I   =`-<]#y  O:-h} 	I 		Eֳ  	 	KX3vv{<>
Y 
I 
	qc}G΅> 
 
D5 1 I 	يI!N\<  ^<Q I 	m<!j9QR  W5?Q
z 
I 
	_kVܕOFLA 
 
                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      21678999                                                D      to                                                      D      21670000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   L                                                        B  3_59!  	3_SR}AL s s3^pUdK  3(PK(BD l ,                                                                                                                                                                                                                                                                                                D      28                                                      D     0                                                       B  ^\Q6ԂSM  =`-<]#y O O:-h}  Eֳ  O KX3vv{<>
Y  qc}G΅> O D5 1  يI!N\< O ^<Q  m<!j9QR O W5?Q
z  _kVܕOFLA O                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telio Telecom AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      21679999                                                D      to                                                      D      21679000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  n	D@ R nnY҄Z7΍  nsrJ{݅ I I}n'c,T ? n!Ɨq5(kI 3 n{3:܀Hf[  n}-ӕ0XuqJ  % %y                                                                                                                                                                                                                        D      29                                                      D     0                                                       B  ^\Q6ԂSM U =`-<]#y  O:-h} U Eֳ   KX3vv{<>
Y U qc}G΅>  D5 1 U يI!N\<  ^<Q U m<!j9QR  W5?Q
z  U  _kVܕOFLA                                                                                                    D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telio Telecom AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      21699999                                                D      to                                                      D      21680000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   #X                                                        B  4<¬(0? " !4_L	P|  4mxɹ$v9 
v2 
u4Old3c ٷ w45xv5s$~i                                                                                                                                                                                                                                                                          D      30                                                      D     0                                                       B  ^\Q6ԂSM $ =`-<]#y %[ %O:-h} % %Eֳ  &[ &KX3vv{<>
Y & &qc}G΅> '[ 'D5 1 ' 'يI!N\< ([ (^<Q ( (m<!j9QR )[ )W5?Q
z ) )_kVܕOFLA *[ *                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      21709999                                                D      to                                                      D      21700000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   ,                                                        B  jS GU0X<45n ,^ *]nh7/
 %H %                                                                                                                                                                                                                                                                                                                                                D      31                                                      D     0                                                       B  ^\Q6ԂSM .a #=`-<]#y . .O:-h} /a /!Eֳ  / /KX3vv{<>
Y 0a 0!qc}G΅> 0 0D5 1 1a 1!يI!N\< 1 1^<Q 2a 2!m<!j9QR 2 2W5?Q
z 3a 3!_kVܕOFLA 3 3                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      21895999                                                D      to                                                      D      21710000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   6d                                                        B  cdύ;\n 5 4!c~
<;it  c?I$CzjQ 	I 		cS3Z>  c,m>zR^o5 ?4 >cx^Ϻ9EO [ [                                                                                                                                                                                                                                                D      32                                                      D     0                                                       B  ^\Q6ԂSM 7 ,=`-<]#y 8g 8'O:-h} 8 8Eֳ  9g 9'KX3vv{<>
Y 9 9qc}G΅> :g :'D5 1 : :يI!N\< ;g ;'^<Q ; ;m<!j9QR <g <'W5?Q
z < <_kVܕOFLA =g ='                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Carrot Communications ASA                               D      operator                                                D      0                                                       D      	is_mobile                                               D      21898999                                                D      to                                                      D      21896000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   ?                                                        B  +PrdM=n ?j =#,'b 
& 
w3%9U3c  \)$2Y47|AL  / ^e@X)Xތ ξ ~B`46UO7Wrn %'q %'1                                                                                                                                                                                                                                                D      33                                                      D     0                                                       B  ^\Q6ԂSM Am 6$=`-<]#y A AO:-h} Bm B-Eֳ  B BKX3vv{<>
Y Cm C-qc}G΅> C CD5 1 Dm D-يI!N\< D D^<Q Em E-m<!j9QR E EW5?Q
z Fm F-_kVܕOFLA F F                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Combitel Networks AS                                    D      operator                                                D      0                                                       D      	is_mobile                                               D      21899999                                                D      to                                                      D      21899000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   Ip                                                        B  i=fDc H G-yj8]7 	 	ɞ                                                                                                                                                                                                                                                                                                                                                D      34                                                      D     0                                                       B  ^\Q6ԂSM J ?=`-<]#y Ks K3O:-h} K KEֳ  Ls L3KX3vv{<>
Y L Lqc}G΅> Ms M3D5 1 M MيI!N\< Ns N3^<Q N Nm<!j9QR Os O3W5?Q
z O O_kVܕOFLA Ps P3                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Hafslund Telekom AS                                     D      operator                                                D      0                                                       D      	is_mobile                                               D      21999999                                                D      to                                                      D      21900000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   R                                                        B  8<|){ Rv PsDZ `  c<W݉^d!c { ;M C Cz'u@jJ^h                                                                                                                                                                                                                                                                          D      35                                                      D     0                                                       B  ^\Q6ԂSM Ty I0=`-<]#y T TO:-h} Uy U9Eֳ  U UKX3vv{<>
Y Vy V9qc}G΅> V VD5 1 Wy W9يI!N\< W W^<Q Xy X9m<!j9QR X XW5?Q
z Yy Y9_kVܕOFLA Y Y                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      23415999                                                D      to                                                      D      22000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   \|                                                        B  c(.=X^L" [ Z90U	Ԗ  ѵ/DMOܟ3 M3 Lai8,o~yA L ڹ$whU  Pf%7a5  r                                                                                                                                                                                                                                                D      36                                                      D     0                                                       B  ^\Q6ԂSM ] R=`-<]#y ^ ^?O:-h} ^ ^Eֳ  _ _?KX3vv{<>
Y _ _qc}G΅> ` `?D5 1 ` `يI!N\< a a?^<Q a am<!j9QR b b?W5?Q
z b b_kVܕOFLA c c?                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      23419999                                                D      to                                                      D      23416000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   f                                                        B  yd޹_ń͖] e cwΓ o|ު m mE27:p1 ه{ C0 Bh[ ]J  ¥|)B7+  2@.w+oF PM P
Ԫ H/禧   bEo= # #޶                                                                                                                                                                                                D      37                                                      D     0                                                       B  ^\Q6ԂSM g \<=`-<]#y h gO:-h} h hEEֳ  i hKX3vv{<>
Y i iEqc}G΅> j iD5 1 j jEيI!N\< k j^<Q k kEm<!j9QR l kW5?Q
z l lE_kVܕOFLA m l                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      23499999                                                D      to                                                      D      23420000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   n                                                        D      38                                                      D     0                                                       B  ^\Q6ԂSM o e=`-<]#y p oO:-h} p pHEֳ  q pKX3vv{<>
Y q qHqc}G΅> r qD5 1 r rHيI!N\< s r^<Q s sHm<!j9QR t sW5?Q
z t tH_kVܕOFLA u t                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Equant Norway AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      23509999                                                D      to                                                      D      23500000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   w                                                        B  }*Sxy< w uHE9_{?  ~ֺ^$wpl 	=" 	<Kce&:| F FJ4c?SmVt(T  Q͗;.@FB1b k khr>|s] # #ƭ_1[b쇜 $_& $^                                                                                                                                                                                                D      39                                                      D     0                                                       B  ^\Q6ԂSM y m=`-<]#y y yNO:-h} z yEֳ  z zNKX3vv{<>
Y { zqc}G΅> { {ND5 1 | {يI!N\< | |N^<Q } |m<!j9QR } }NW5?Q
z ~ }_kVܕOFLA ~ ~N                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      23599999                                                D      to                                                      D      23510000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      40                                                      D     0                                                       B  ^\Q6ԂSM  wK=`-<]#y  QO:-h}  Eֳ   QKX3vv{<>
Y  qc}G΅>  QD5 1  يI!N\<  Q^<Q  m<!j9QR  QW5?Q
z  _kVܕOFLA  Q                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      23619999                                                D      to                                                      D      23600000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      41                                                      D     0                                                       B  ^\Q6ԂSM  N=`-<]#y  TO:-h}  Eֳ   TKX3vv{<>
Y  qc}G΅>  TD5 1  يI!N\<  T^<Q  m<!j9QR  TW5?Q
z  _kVܕOFLA  T                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      23622999                                                D      to                                                      D      23620000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  ?s'FcX  ԡ=
 TCPk\  S  
=
$M^&  u  uoQK1 # #hBl
t %g %gI                                                                                                                                                                                                                                                                        D      42                                                      D     0                                                       B  ^\Q6ԂSM  Q=`-<]#y  O:-h}  ZEֳ   KX3vv{<>
Y  Zqc}G΅>  D5 1  ZيI!N\<  ^<Q  Zm<!j9QR  W5?Q
z  Z_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telio Telecom AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      23627999                                                D      to                                                      D      23623000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  !fߤѼB  Z  )c5Brk{X 
) 
)N;%&G>7+  (ｨ(+BW: T v#FvS~V ^ ^|IxIg1qL%j4 * *                                                                                                                                                                                                                                                D      43                                                      D     0                                                       B  ^\Q6ԂSM   =`-<]#y  `O:-h}   Eֳ   `KX3vv{<>
Y   qc}G΅>  `D5 1   يI!N\<  `^<Q   m<!j9QR  `W5?Q
z   _kVܕOFLA  `                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      23629999                                                D      to                                                      D      23628000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   #                                                        B  qc3҇/  UnD,w| 0 0kIg0\  f@`Ro=bܔ 	N 	Nk;vΉI)*S|B 
u 
tI	Q@e  p+*fu6n Y YjˑABΟ9 y 9!@wv>* u 5QdB`K : :W X %7w %77                                                                                                                        D      44                                                      D     0                                                       B  ^\Q6ԂSM  ]=`-<]#y & O:-h}  fEֳ  & KX3vv{<>
Y  fqc}G΅> & D5 1  fيI!N\< & ^<Q  fm<!j9QR & W5?Q
z  f_kVܕOFLA &                                                                                                 D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      23669999                                                D      to                                                      D      23630000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  lIr`b9h19 ) flKv(4? · c #l` EznLTҞ  lp%'vX  ɲlRO]p'EJx<Pq = =l)y:
E:( c cQl}oP{.HL s sWl<}Rdm8!E  la'%*g m -l4%j4Qr "ƍ "M                                                                                                                                                D      45                                                      D     0                                                       B  ^\Q6ԂSM , =`-<]#y  lO:-h} , Eֳ   lKX3vv{<>
Y , qc}G΅>  lD5 1 , يI!N\<  l^<Q , m<!j9QR  lW5?Q
z , _kVܕOFLA  l                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Satellite Services AS                           D      operator                                                D      0                                                       D      	is_mobile                                               D      23679999                                                D      to                                                      D      23670000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   /                                                        B  uuw  d	Bhk$5f 	 	G
G}pq!O 	F 	[s׏=m8Np 
S 
S?>նۃxZ   M  M`MAΜ #~ #~                                                                                                                                                                                                                                                D      46                                                      D     0                                                       B  ^\Q6ԂSM  i=`-<]#y 2 O:-h}  rEֳ  2 KX3vv{<>
Y  rqc}G΅> 2 D5 1  rيI!N\< 2 ^<Q  rm<!j9QR 2 W5?Q
z  r_kVܕOFLA 2                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      23699999                                                D      to                                                      D      23680000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  gơVtٯ? 5 rg>)Rj3 & &gf'P//6J 8D 8gv`h>Y pY pgmE!y.mYD ' gCFʗᑉ  g~	rO- []
 G7 Fgm  Q(oY  gQKF $M $
                                                                                                                                                                        D      47                                                      D     0                                                       B  ^\Q6ԂSM 8 =`-<]#y ¸ xO:-h} 8 Eֳ  ø xKX3vv{<>
Y 8 qc}G΅> ĸ xD5 1 8 يI!N\< Ÿ x^<Q 8 m<!j9QR Ƹ xW5?Q
z 8 _kVܕOFLA Ǹ x                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      BaneTele AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      23709999                                                D      to                                                      D      23700000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   ;                                                        B  d.﷔!sH> ɻ d{4C	UQ ^ ^Xd"<pZ:Jά7  e                                                                                                                                                                                                                                                                                                                        D      48                                                      D     0                                                       B  ^\Q6ԂSM ˾ u=`-<]#y > O:-h} ̾ ~Eֳ  > KX3vv{<>
Y ; ~qc}G΅> > D5 1 ξ ~يI!N\< > ^<Q Ͼ ~m<!j9QR > W5?Q
z о ~_kVܕOFLA >                                                                                                 D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      23879999                                                D      to                                                      D      23710000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  WE؏GZr A ~0h)cb x@ x +[fE  
 
~ '>کJ,  ќU&qH^ ;  B}
LIPUۘ - v\g5X "nl "n,                                                                                                                                                                                                                        D      49                                                      D     0                                                       B  ^\Q6ԂSM D =`-<]#y  ՄO:-h} D Eֳ   քKX3vv{<>
Y D qc}G΅>  ׄD5 1 D يI!N\<  ؄^<Q D m<!j9QR  لW5?Q
z D _kVܕOFLA  ڄ                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      
NetCom GSM AS                                           D      operator                                                D      1                                                       D      	is_mobile                                               D      23899999                                                D      to                                                      D      23880000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   G                                                        B  m0=o@'[
  &~6p]zH
 k +Bh4τ y$ xXD7x-S-L U UmږfWZ($  {  ;hΉ Vw                                                                                                                                                                                                                                                  D      50                                                      D     0                                                       B  ^\Q6ԂSM  Ӂ=`-<]#y J 
O:-h}  ߊEֳ  J 
KX3vv{<>
Y  qc}G΅> J 
D5 1  يI!N\< J 
^<Q  m<!j9QR J 
W5?Q
z  _kVܕOFLA J 
                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      23909999                                                D      to                                                      D      23900000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  (8:w!'! M (,yUΒdV$/  ڣ(fz#/q) @ @p(dYU{$N 
 
(^}!Q\	  K(#yq5m  _  ((w=K6] 	 (&zHSè ~ ~(~.ېyB  5  5W(_eE\׏* % %a                                                                                                                                                D      51                                                      D     0                                                       B  ^\Q6ԂSM P =`-<]#y  O:-h} P Eֳ   KX3vv{<>
Y P qc}G΅>  D5 1 P يI!N\<  ^<Q P m<!j9QR  W5?Q
z P _kVܕOFLA                                                                                                  D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      23969999                                                D      to                                                      D      23910000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   S                                                        B  XMBݽ  n/=E,a 6 6֪Q;s}I
2  Y؄1s)WԤi    yGL}: "N "                                                                                                                                                                                                                                                                        D      52                                                      D     0                                                       B  ^\Q6ԂSM  =`-<]#y V O:-h}  Eֳ  V KX3vv{<>
Y  qc}G΅> V D5 1  يI!N\< V ^<Q  m<!j9QR V W5?Q
z  _kVܕOFLA V                                                                                                 D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      23989999                                                D      to                                                      D      23970000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  ,veE<.U Y d$_I  Q n`Bm ;^ ;@]l>7LN i ip8̟047 "{ ";                                                                                                                                                                                                                                                                        D      53                                                      D     0                                                       B  ^\Q6ԂSM \ =`-<]#y  O:-h} \ Eֳ   KX3vv{<>
Y \ qc}G΅>  D5 1 \ يI!N\<  ^<Q \ m<!j9QR  W5?Q
z  \  _kVܕOFLA                                                                                                    D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      23999999                                                D      to                                                      D      23990000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   _                                                        B  o"w26  fXz'J6WU' F E̦	h	A\m'h Z ZcL6@2N0                                                                                                                                                                                                                                                                                                  D      54                                                      D     0                                                       B  ^\Q6ԂSM  =`-<]#y b "O:-h}  Eֳ  b "KX3vv{<>
Y  qc}G΅> b "D5 1  يI!N\< b "^<Q  m<!j9QR 	b 	"W5?Q
z 	 	_kVܕOFLA 
b 
"                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      24044999                                                D      to                                                      D      24000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  ;:=j&) e 
4h#kCD+ v 6aWg>˒j  HN]I]En> E0 Dj0kS2 B ^R Vs5d  _gjGXBfpκ $G $F                                                                                                                                                                                                                        D      55                                                      D     0                                                       B  ^\Q6ԂSM h =`-<]#y  O:-h} h (Eֳ   KX3vv{<>
Y h (qc}G΅>  D5 1 h (يI!N\<  ^<Q h (m<!j9QR  W5?Q
z h (_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      24045999                                                D      to                                                      D      24045000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   k                                                        B  a@:c>P
f  (+3jg6yC  αC /&t5u 
S  
R9oN|hs^%˭ v vY:3g\d  W S>iPP}W ~ >6@~)oh #n #n                                                                                                                                                                                                                        D      56                                                      D     0                                                       B  ^\Q6ԂSM  =`-<]#y n .O:-h}  Eֳ  n .KX3vv{<>
Y  qc}G΅> n .D5 1  يI!N\< n .^<Q  m<!j9QR n .W5?Q
z  _kVܕOFLA n .                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      24199999                                                D      to                                                      D      24046000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  r*uK6l q r0,
d6 0 rP듳ڢ                                                                                                                                                                                                                                                                                                                          D      57                                                      D     0                                                       B  ^\Q6ԂSM !t +=`-<]#y ! !O:-h} "t "4Eֳ  " "KX3vv{<>
Y #t #4qc}G΅> # #D5 1 $t $4يI!N\< $ $^<Q %t %4m<!j9QR % %W5?Q
z &t &4_kVܕOFLA & &                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Catch Communications AS                                 D      operator                                                D      0                                                       D      	is_mobile                                               D      24201999                                                D      to                                                      D      24200000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   )w                                                        B  fAj`(7 ( '4f2}ǝ[s +\ +f6pXy?-  f)KWٌMT y 9                                                                                                                                                                                                                                                                                                D      58                                                      D     0                                                       B  ^\Q6ԂSM * =`-<]#y +z +:O:-h} + +Eֳ  ,z ,:KX3vv{<>
Y , ,qc}G΅> -z -:D5 1 - -يI!N\< .z .:^<Q . .m<!j9QR /z /:W5?Q
z / /_kVܕOFLA 0z 0:                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Choice Telenet AS                                       D      operator                                                D      0                                                       D      	is_mobile                                               D      24202999                                                D      to                                                      D      24202000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   2                                                        B  	?ekW"j 2} 0	XOBeM;? \ \{	x;JpMO%8G %w %wO                                                                                                                                                                                                                                                                                                                        D      59                                                      D     0                                                       B  ^\Q6ԂSM 4 )7=`-<]#y 5  4O:-h} 5 5@Eֳ  6  5KX3vv{<>
Y 6 6@qc}G΅> 7  6D5 1 7 7@يI!N\< 8  7^<Q 8 8@m<!j9QR 9  8W5?Q
z 9 9@_kVܕOFLA :  9                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor ASA                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      24203999                                                D      to                                                      D      24203000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   <                                                        B  +&7O4+D < :@}ʉgBGq? T2 Sw}@f*mFo  ؾ~)
~.ʻ}0  #7;Ƴ7%"W 	 	V:?㺄CU  jМ>R+  ka	|T֤t9 x 8ŀ}
}	`$  O qrWJ S  Rh(ڟ'\9c !v !u                                                                                                                        D      60                                                      D     0                                                       B  ^\Q6ԂSM > 2=`-<]#y > >FO:-h} ? >Eֳ  ? ?FKX3vv{<>
Y @ ?qc}G΅> @ @FD5 1 A @يI!N\< A AF^<Q B Am<!j9QR B BFW5?Q
z C B_kVܕOFLA C CF                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      24207999                                                D      to                                                      D      24204000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   F	                                                        B  91(% E Co@"T!  Tm"h ~T  ޷{6	/mO6	1 	v 	vzД l ,$@R9!^ - ]щ߶4[٭ r 2qx
!B{  2CE& sl s,ZVae젳| !% !%0mf[Hҹn "vo "v/                                                                                                                        D      61                                                      D     0                                                       B  ^\Q6ԂSM G <C=`-<]#y H GO:-h} H HLEֳ  I HKX3vv{<>
Y I ILqc}G΅> J ID5 1 J JLيI!N\< K J^<Q K KLm<!j9QR L KW5?Q
z L LL_kVܕOFLA M L                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      	Phonzo AS                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      24209999                                                D      to                                                      D      24208000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   O                                                        B  DAcR:W O MLDs2!$6Ko Sg S'D<8V
r
l n .                                                                                                                                                                                                                                                                                                                        D      62                                                      D     0                                                       B  ^\Q6ԂSM Q E=`-<]#y Q QRO:-h} R QEֳ  R RRKX3vv{<>
Y S Rqc}G΅> S SRD5 1 T SيI!N\< T TR^<Q U Tm<!j9QR U URW5?Q
z V U_kVܕOFLA V VR                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      CBK Tele AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      24215999                                                D      to                                                      D      24210000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   Y                                                        B  ny)%Yx4 X V6ܺ[ZOC3e  ưiRP=c`  ٸSLվz  r 2pKVí3 !f	 !eDa9REX # #                                                                                                                                                                                                                                                D      63                                                      D     0                                                       B  ^\Q6ԂSM Z OO=`-<]#y [ ZO:-h} [ [XEֳ  \ [KX3vv{<>
Y \ \Xqc}G΅> ] \D5 1 ] ]XيI!N\< ^ ]^<Q ^ ^Xm<!j9QR _ ^W5?Q
z _ _X_kVܕOFLA ` _                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      24999999                                                D      to                                                      D      24216000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Oslo                                                    D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   b                                                        B  ]/F#.Ӫ=Q5 b `X}w 0n=-}i D Dr3M.ݝ                                                                                                                                                                                                                                                                                                                           D      64                                                      D     0                                                       B  ^\Q6ԂSM d X=`-<]#y d d^O:-h} e dEֳ  e e^KX3vv{<>
Y f eqc}G΅> f f^D5 1 g fيI!N\< g g^^<Q h gm<!j9QR h h^W5?Q
z i h_kVܕOFLA i i^                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      25999999                                                D      to                                                      D      25000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   l!                                                        B  I\ $5T k i"	t`UEqр uL u`Q-Py
d  g<ܚ
E`& ] 4V4=) 6 <RڄvR%Ό s 3I0m`,Ѿ^ j ji,|Gג߶ " "_                                                                                                                                                                                                D      65                                                      D     0                                                       B  ^\Q6ԂSM m b[=`-<]#y n$ mO:-h} n ndEֳ  o$ nKX3vv{<>
Y o odqc}G΅> p$ oD5 1 p pdيI!N\< q$ p^<Q q qdm<!j9QR r$ qW5?Q
z r rd_kVܕOFLA s$ r                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      26999999                                                D      to                                                      D      26000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   u                                                        B  2jʮ<6, u' sd2jRf  2"TQ?$xU7 w 72
%
c1:*FcF 
                                                                                                                                                                                                                                                                                                 D      66                                                      D     0                                                       B  ^\Q6ԂSM w* k=`-<]#y w wjO:-h} x* wEֳ  x xjKX3vv{<>
Y y* xqc}G΅> y yjD5 1 z* yيI!N\< z zj^<Q {* zm<!j9QR { {jW5?Q
z |* {_kVܕOFLA | |j                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      27999999                                                D      to                                                      D      27000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   -                                                        B  s[V%l?gX ~ |s'JWji  Wsg2&G3 y 9sۍ/  <7@ #N #N                                                                                                                                                                                                                                                                                                D      67                                                      D     0                                                       B  ^\Q6ԂSM  ug=`-<]#y 0 O:-h}  pEֳ  0 KX3vv{<>
Y  pqc}G΅> 0 D5 1  pيI!N\< 0 ^<Q  pm<!j9QR 0 W5?Q
z  p_kVܕOFLA 0                                                                                                 D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      29999999                                                D      to                                                      D      28000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  ؎LAt{/_ 3 p\)t'Г}  B֋FS><b ; ;wK9#w,6gH !9 !                                                                                                                                                                                                                                                                                                D      68                                                      D     0                                                       B  ^\Q6ԂSM 6 ~=`-<]#y  vO:-h} 6 Eֳ   vKX3vv{<>
Y 6 qc}G΅>  vD5 1 6 يI!N\<  v^<Q 6 m<!j9QR  vW5?Q
z 6 _kVܕOFLA  v                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      30999999                                                D      to                                                      D      30000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   9                                                        B  ^E(ӀF  ii!?1H.F i )wBD!=h  )IVྋS                                                                                                                                                                                                                                                                                                   D      69                                                      D     0                                                       B  ^\Q6ԂSM  s=`-<]#y < O:-h}  |Eֳ  < KX3vv{<>
Y  |qc}G΅> < D5 1  |يI!N\< < ^<Q  |m<!j9QR < W5?Q
z  |_kVܕOFLA <                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      31019999                                                D      to                                                      D      31000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  |	ǌu ? ||YI*Pp ]] ]|(Kt:ހٮ  B B|SϐWtBw p# "N` "N |{^ʌ>ڡ $b $"                                                                                                                                                                                                                                                                        D      70                                                      D     0                                                       B  ^\Q6ԂSM B =`-<]#y  O:-h} B Eֳ   KX3vv{<>
Y B qc}G΅>  D5 1 B يI!N\<  ^<Q B m<!j9QR  W5?Q
z B _kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      31024999                                                D      to                                                      D      31020000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   E                                                        B   (Կ.7  RO=ըܜ O $V
x©л 4 4l#5]ytOL 8  7jE3,u/.Gl '+ &*]qѴ`3_ ? #>aW`PE % %d                                                                                                                                                                                                                        D      71                                                      D     0                                                       B  ^\Q6ԂSM  =`-<]#y H O:-h}  Eֳ  H KX3vv{<>
Y  qc}G΅> H D5 1  يI!N\< H ^<Q  m<!j9QR H W5?Q
z  _kVܕOFLA H                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Lyse Tele AS                                            D      operator                                                D      0                                                       D      	is_mobile                                               D      31027999                                                D      to                                                      D      31025000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   H                                                        D      72                                                      D     0                                                       B  ^\Q6ԂSM  =`-<]#y K O:-h}  Eֳ  K KX3vv{<>
Y  qc}G΅> K D5 1  يI!N\< K ^<Q  m<!j9QR K W5?Q
z  _kVܕOFLA K                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      31029999                                                D      to                                                      D      31028000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  eΆ#k N ҖڨQʌǛP 
K 
JE+N  A@ӊ쭆3ǌ { {                                                                                                                                                                                                                                                                                                D      73                                                      D     0                                                       B  ^\Q6ԂSM Q =`-<]#y  O:-h} Q Eֳ   KX3vv{<>
Y Q qc}G΅>  D5 1 Q يI!N\<  ^<Q Q m<!j9QR  W5?Q
z Q _kVܕOFLA                                                                                                  D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      31091999                                                D      to                                                      D      31030000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   T                                                        B  a2#$X;Q  |d)YLt
 
b 
"/Io3f I 	ߩ4%M& B BZ                                                                                                                                                                                                                                                                                                D      74                                                      D     0                                                       B  ^\Q6ԂSM  =`-<]#y W O:-h}  Eֳ  W KX3vv{<>
Y  ×qc}G΅> W D5 1  ėيI!N\< W ^<Q  ŗm<!j9QR W W5?Q
z  Ɨ_kVܕOFLA W                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Lyse Tele AS                                            D      operator                                                D      0                                                       D      	is_mobile                                               D      31094999                                                D      to                                                      D      31092000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  ЛD6ZF~^5 Z Ǘ~pϫsD i )EŚX}g_ZN| u 5                                                                                                                                                                                                                                                                                                                        D      75                                                      D     0                                                       B  ^\Q6ԂSM ] =`-<]#y  ˝O:-h} ] Eֳ   ̝KX3vv{<>
Y ] qc}G΅>  ͝D5 1 ] يI!N\<  Ν^<Q ] m<!j9QR  ϝW5?Q
z ] _kVܕOFLA  Н                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Combitel Networks AS                                    D      operator                                                D      0                                                       D      	is_mobile                                               D      31095999                                                D      to                                                      D      31095000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   `                                                        B  דgIʹi-4ކ3  {TbL_N~ E EpZC n 1 1؁dp"2    ݖ                                                                                                                                                                                                                                                                                                D      76                                                      D     0                                                       B  ^\Q6ԂSM  ɚ=`-<]#y c #O:-h}  գEֳ  c #KX3vv{<>
Y  ֣qc}G΅> c #D5 1  ףيI!N\< c #^<Q  أm<!j9QR c #W5?Q
z  ٣_kVܕOFLA c #                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      31098999                                                D      to                                                      D      31096000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   c                                                        D      77                                                      D     0                                                       B  ^\Q6ԂSM   =`-<]#y f &O:-h}  ݦEֳ  f &KX3vv{<>
Y  ަqc}G΅> f &D5 1  ߦيI!N\< f &^<Q  m<!j9QR f &W5?Q
z  _kVܕOFLA f &                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Get AS                                                  D      operator                                                D      0                                                       D      	is_mobile                                               D      31099999                                                D      to                                                      D      31099000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  5e_=XQ i 5zovBZ,D} 3 5/]hkNܢ#! 
# 
5pr},&A0 s 35φY"LG:4X e` e 5$"wn1C衠Wx                                                                                                                                                                                                                                                  D      78                                                      D     0                                                       B  ^\Q6ԂSM l #=`-<]#y  O:-h} l ,Eֳ   KX3vv{<>
Y l ,qc}G΅>  D5 1 l ,يI!N\<  ^<Q l ,m<!j9QR  W5?Q
z l ,_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Tele2 Norge AS                                          D      operator                                                D      0                                                       D      	is_mobile                                               D      31109999                                                D      to                                                      D      31100000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   o                                                        B  =Y9z4~  ,օH>\<% b "Ê	HEƾ:zZ  CUs.~ Kh K(яe\?f@_8 A AzB fsĐ88T(L R                                                                                                                                                                                                                                                 D      79                                                      D     0                                                       B  ^\Q6ԂSM  =`-<]#y r 2O:-h}  Eֳ  r 2KX3vv{<>
Y  qc}G΅> r 2D5 1  يI!N\< r 2^<Q  m<!j9QR r 2W5?Q
z  _kVܕOFLA r 2                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      31199999                                                D      to                                                      D      31110000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  37?$I7 u ^LՒ
ɖS  +'֡ssS Kx K8ȃK,QU %                                                                                                                                                                                                                                                                                                 D      80                                                      D     0                                                       B  ^\Q6ԂSM x /=`-<]#y  O:-h} x 8Eֳ   KX3vv{<>
Y x 8qc}G΅>  D5 1 x 8يI!N\<  ^<Q x 8m<!j9QR  W5?Q
z x 8_kVܕOFLA                                                                                                  D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      31259999                                                D      to                                                      D      31200000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   {                                                        B  CQ}h[>ܚ6{   8C*:4^35e q 1CXǬ"	4.b  C{/.&G}  ʍC6&y ]Aar S` S C}}|'Jj6  C5Ԗ<6  BCIe>F "ޖ "VCv/;9%S
 #F #F}                                                                                                                                                                        D      81                                                      D     0                                                       B  ^\Q6ԂSM  =`-<]#y ~ >O:-h}  Eֳ  ~ >KX3vv{<>
Y  qc}G΅> ~ >D5 1  يI!N\< ~ >^<Q  m<!j9QR ~ >W5?Q
z  _kVܕOFLA ~ >                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      31299999                                                D      to                                                      D      31260000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  xj)3 
 fR+]>ԧ3w~  GG*Kd{w  Rz8B V VU                                                                                                                                                                                                                                                                                                D      82                                                      D     0                                                       B  ^\Q6ԂSM  ;=`-<]#y 
 O:-h} 
 
DEֳ   
KX3vv{<>
Y  Dqc}G΅>  D5 1  DيI!N\<  ^<Q  Dm<!j9QR  W5?Q
z  D_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      31309999                                                D      to                                                      D      31300000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  
BӾ#  DZk8<g1l  sR!Ns i h l^ݷ6n5  H}A+=(Zz  =  =Z~Yr!Ą
  ]  ]f3ӤIz8uJ    peN#w $Y $[zQkS9X %W %WC                                                                                                                                                                        D      83                                                      D     0                                                       B  ^\Q6ԂSM 
 
=`-<]#y  JO:-h} 
 Eֳ   JKX3vv{<>
Y 
 qc}G΅>  JD5 1 
 يI!N\<  J^<Q 
 m<!j9QR  JW5?Q
z 
 _kVܕOFLA  J                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      31399999                                                D      to                                                      D      31310000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        B  h
rÚKK1!  ho))Æ 
9 
9ThUEn/jIӯOWD= 0 hQu
MbU ˄ Dh&Ke~x4U<  Xh:>  L<ƣ -K -hnJIs/< # #                                                                                                                                                                                                                        D      84                                                      D     0                                                       B  ^\Q6ԂSM  G=`-<]#y   O:-h}    PEֳ  !  KX3vv{<>
Y ! !Pqc}G΅> " !D5 1 " "PيI!N\< # "^<Q # #Pm<!j9QR $ #W5?Q
z $ $P_kVܕOFLA % $                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      31409999                                                D      to                                                      D      31400000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   '                                                        B  >AowPp\a ' %P>I
9H CZ C                                                                                                                                                                                                                                                                                                                                                D      85                                                      D     0                                                       B  ^\Q6ԂSM ) =`-<]#y ) )VO:-h} * )Eֳ  * *VKX3vv{<>
Y + *qc}G΅> + +VD5 1 , +يI!N\< , ,V^<Q - ,m<!j9QR - -VW5?Q
z . -_kVܕOFLA . .V                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telio Telecom AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      31419999                                                D      to                                                      D      31410000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   1                                                        B  ۅ퐜\ϩL 0 .֓HT*J|^-    ~VA?aL$l !~ !}                                                                                                                                                                                                                                                                                                                        D      86                                                      D     0                                                       B  ^\Q6ԂSM 2 'S=`-<]#y 3 2O:-h} 3 3\Eֳ  4 3KX3vv{<>
Y 4 4\qc}G΅> 5 4D5 1 5 5\يI!N\< 6 5^<Q 6 6\m<!j9QR 7 6W5?Q
z 7 7\_kVܕOFLA 8 7                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      31899999                                                D      to                                                      D      31420000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   9                                                        D      87                                                      D     0                                                       B  ^\Q6ԂSM : 0=`-<]#y ; :O:-h} ; ;_Eֳ  < ;KX3vv{<>
Y < <_qc}G΅> = <D5 1 = =_يI!N\< > =^<Q > >_m<!j9QR ? >W5?Q
z ? ?__kVܕOFLA @ ?                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Hafslund Telekom AS                                     D      operator                                                D      0                                                       D      	is_mobile                                               D      31909999                                                D      to                                                      D      31900000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   B                                                        B  *81lI3Q|Ep B" @_*y'yqрb
 ] *Egd*U'$ML  *NU{ڭb b bf*á+kר E *d>1$m[    N                                                                                                                                                                                                                                                D      88                                                      D     0                                                       B  ^\Q6ԂSM D% 8=`-<]#y D DeO:-h} E% DEֳ  E EeKX3vv{<>
Y F% Eqc}G΅> F FeD5 1 G% FيI!N\< G Ge^<Q H% Gm<!j9QR H HeW5?Q
z I% H_kVܕOFLA I Ie                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      31999999                                                D      to                                                      D      31910000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   L(                                                        B  vGksCHg2R6 K Ivanlq\ _ vnՖ!==2 ( v4e?}3J K vmn/ؔA^k != !=                                                                                                                                                                                                                                                                        D      89                                                      D     0                                                       B  ^\Q6ԂSM M Bb=`-<]#y N+ MO:-h} N NkEֳ  O+ NKX3vv{<>
Y O Okqc}G΅> P+ OD5 1 P PkيI!N\< Q+ P^<Q Q Qkm<!j9QR R+ QW5?Q
z R Rk_kVܕOFLA S+ R                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      32187999                                                D      to                                                      D      32000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   U                                                        B  ^ĞWd9y* U. Sk"5W4|]  Ն Pw1yN#    x                                                                                                                                                                                                                                                                                                                        D      90                                                      D     0                                                       B  ^\Q6ԂSM W1 K=`-<]#y W WqO:-h} X1 WEֳ  X XqKX3vv{<>
Y Y1 Xqc}G΅> Y YqD5 1 Z1 YيI!N\< Z Zq^<Q [1 Zm<!j9QR [ [qW5?Q
z \1 [_kVܕOFLA \ \q                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      32188999                                                D      to                                                      D      32188000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   _4                                                        B  T"ϥdp=uR ^ \T1[Yf    GTg)+rIᇳ  U  Uc                                                                                                                                                                                                                                                                                                                        D      91                                                      D     0                                                       B  ^\Q6ԂSM ` Un=`-<]#y a7 `O:-h} a awEֳ  b7 aKX3vv{<>
Y b bwqc}G΅> c7 bD5 1 c cwيI!N\< d7 c^<Q d dwm<!j9QR e7 dW5?Q
z e ew_kVܕOFLA f7 e                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      32299999                                                D      to                                                      D      32189000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   h                                                        B  "u2~VyT߭ h: fwnL7wv҂3 	 	mX&R< " "N&+K3;  \2"[:(p S SzҺ!BZYi¡N    EFDMT(&V                                                                                                                                                                                                                            D      92                                                      D     0                                                       B  ^\Q6ԂSM j= ^=`-<]#y j j}O:-h} k= jEֳ  k k}KX3vv{<>
Y l= kqc}G΅> l l}D5 1 m= lيI!N\< m m}^<Q n= mm<!j9QR n n}W5?Q
z o= n_kVܕOFLA o o}                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      32309999                                                D      to                                                      D      32300000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   p                                                        D      93                                                      D     0                                                       B  ^\Q6ԂSM r@ hz=`-<]#y r rO:-h} s@ s Eֳ  s sKX3vv{<>
Y t@ t qc}G΅> t tD5 1 u@ u يI!N\< u u^<Q v@ v m<!j9QR v vW5?Q
z w@ w _kVܕOFLA w w                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      
NextGenTel AS                                           D      operator                                                D      0                                                       D      	is_mobile                                               D      32319999                                                D      to                                                      D      32310000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   x                                                        D      94                                                      D     0                                                       B  ^\Q6ԂSM zC p}=`-<]#y z zO:-h} {C {Eֳ  { {KX3vv{<>
Y |C |qc}G΅> | |D5 1 }C }يI!N\< } }^<Q ~C ~m<!j9QR ~ ~W5?Q
z C _kVܕOFLA                                                                                                  D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      32698999                                                D      to                                                      D      32320000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   F                                                        B  +K;[  F,%v:Ud$"dC 6 k,a79H 
) 
D8cۤƘ N NRMgzrO  ӁFT9G  #^ #^                                                                                                                                                                                                                                                D      95                                                      D     0                                                       B  ^\Q6ԂSM  x=`-<]#y I 	O:-h}  Eֳ  I 	KX3vv{<>
Y  qc}G΅> I 	D5 1  يI!N\< I 	^<Q  m<!j9QR I 	W5?Q
z  _kVܕOFLA I 	                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Network Norway AS                                       D      operator                                                D      0                                                       D      	is_mobile                                               D      32699999                                                D      to                                                      D      32699000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  &e}_
*U L &Y8`W 
[# 
Z&3sS/S=xb7;3  &
n?LCtR=j% 0A 0&@p:rJo3 	                                                                                                                                                                                                                                                                         D      96                                                      D     0                                                       B  ^\Q6ԂSM O =`-<]#y  O:-h} O Eֳ   KX3vv{<>
Y O qc}G΅>  D5 1 O يI!N\<  ^<Q O m<!j9QR  W5?Q
z O _kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      32899999                                                D      to                                                      D      32700000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      97                                                      D     0                                                       B  ^\Q6ԂSM R =`-<]#y  O:-h} R Eֳ   KX3vv{<>
Y R qc}G΅>  D5 1 R يI!N\<  ^<Q R m<!j9QR  W5?Q
z R _kVܕOFLA                                                                                                  D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      32983999                                                D      to                                                      D      32900000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   U                                                        B  =,!;^  
=[4K;OeW 	V 	Vnި*u[$h.@ 
 
&[>dm. f f[ϒF
@M' ) :A7  ~ېJmsu](W !? !                                                                                                                                                                                                                        D      98                                                      D     0                                                       B  ^\Q6ԂSM  =`-<]#y X O:-h}  Eֳ  X KX3vv{<>
Y  qc}G΅> X D5 1  يI!N\< X ^<Q  m<!j9QR X W5?Q
z  _kVܕOFLA X                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Lyse Tele AS                                            D      operator                                                D      0                                                       D      	is_mobile                                               D      32988999                                                D      to                                                      D      32984000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  bz̽.np/B[ [ 	^]n(Y b? a@FFu,O  }=P=Rĺuݿm !                                                                                                                                                                                                                                                                                                 D      99                                                      D     0                                                       B  ^\Q6ԂSM ^ =`-<]#y  O:-h} ^ Eֳ   KX3vv{<>
Y ^ qc}G΅>  D5 1 ^ يI!N\<  ^<Q ^ m<!j9QR  W5?Q
z ^ _kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      32992999                                                D      to                                                      D      32989000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   a                                                        B  Cp  =jyf 
 
TT'\}$<^ kt k4                                                                                                                                                                                                                                                                                                                        D      100                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y d $O:-h}  Eֳ  d $KX3vv{<>
Y  qc}G΅> d $D5 1  يI!N\< d $^<Q  m<!j9QR d $W5?Q
z  _kVܕOFLA d $                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      CBK Tele AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      32994999                                                D      to                                                      D      32993000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  8f'GjpNR g 8Ke=0vD. J7 I8:*Y̽j c #8ǻ*^~w#* 0 /8>j{UOgYV y y{8qd!R?? ֝ ]8sK%l'ƿ& !$ !8ʉVK"Y@zK %׳ %s                                                                                                                                                                                                D      101                                                     D     0                                                       B  ^\Q6ԂSM j !=`-<]#y  O:-h} j *Eֳ   KX3vv{<>
Y j *qc}G΅>  D5 1 j *يI!N\<  ^<Q j *m<!j9QR  W5?Q
z j *_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      32996999                                                D      to                                                      D      32995000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      102                                                     D     0                                                       B  ^\Q6ԂSM m =`-<]#y  íO:-h} m -Eֳ   ĭKX3vv{<>
Y m -qc}G΅>  ŭD5 1 m -يI!N\<  ƭ^<Q m -m<!j9QR  ǭW5?Q
z m -_kVܕOFLA  ȭ                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      	Comvie AS                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      32998999                                                D      to                                                      D      32997000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   p                                                        B  itZ`aDٹH  -iQI{ph  Qi5׺CB T Txi>,NaCe 
, 
iB$p  8ێ$  i/zAR\ vϴ    uiQj4xza $S $                                                                                                                                                                                                                        D      103                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y s 3O:-h}  ͳEֳ  s 3KX3vv{<>
Y  γqc}G΅> s 3D5 1  ϳيI!N\< s 3^<Q  гm<!j9QR s 3W5?Q
z  ѳ_kVܕOFLA s 3                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      	Phonzo AS                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      32999999                                                D      to                                                      D      32999000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Buskerud                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   s                                                        D      104                                                     D     0                                                       B  ^\Q6ԂSM  0=`-<]#y v 6O:-h}  նEֳ  v 6KX3vv{<>
Y  ֶqc}G΅> v 6D5 1  ׶يI!N\< v 6^<Q  ضm<!j9QR v 6W5?Q
z  ٶ_kVܕOFLA v 6                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      33023999                                                D      to                                                      D      33000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   v                                                        D      105                                                     D     0                                                       B  ^\Q6ԂSM  3=`-<]#y y 9O:-h}  ݹEֳ  y 9KX3vv{<>
Y  ޹qc}G΅> y 9D5 1  ߹يI!N\< y 9^<Q  m<!j9QR y 9W5?Q
z  _kVܕOFLA y 9                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      33024999                                                D      to                                                      D      33024000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   y                                                        D      106                                                     D     0                                                       B  ^\Q6ԂSM  6=`-<]#y | <O:-h}  Eֳ  | <KX3vv{<>
Y  qc}G΅> | <D5 1  يI!N\< | <^<Q  m<!j9QR | <W5?Q
z  _kVܕOFLA | <                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      33199999                                                D      to                                                      D      33025000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  })\)M>F9  꼩ke!av  G  e>Ha8m'r@ H 1z334O  _px;a~M.    ͐                                                                                                                                                                                                                                                                        D      107                                                     D     0                                                       B  ^\Q6ԂSM  9=`-<]#y  O:-h}  BEֳ   KX3vv{<>
Y  Bqc}G΅>  D5 1  BيI!N\<  ^<Q  Bm<!j9QR  W5?Q
z  B_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      33209999                                                D      to                                                      D      33200000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      108                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y  O:-h}  EEֳ   KX3vv{<>
Y  Eqc}G΅>  D5 1  EيI!N\<  ^<Q  Em<!j9QR  W5?Q
z  E_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      
NextGenTel AS                                           D      operator                                                D      0                                                       D      	is_mobile                                               D      33219999                                                D      to                                                      D      33210000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  '#В8` ~  E'Jxl:Xg٤ < <o'PVns" "E "                                                                                                                                                                                                                                                                                                                        D      109                                                     D     0                                                       B  ^\Q6ԂSM   =`-<]#y    KO:-h}   Eֳ   KKX3vv{<>
Y  qc}G΅>  KD5 1  يI!N\<  K^<Q  m<!j9QR  KW5?Q
z  _kVܕOFLA  K                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      33279999                                                D      to                                                      D      33220000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  _RM=FDiϟ>  _г|ۻ {ΒZ ' 'Z_,"JS|V"Bi  _^_3Q5t4O ƻ {                                                                                                                                                                                                                                                                                                D      110                                                     D     0                                                       B  ^\Q6ԂSM 	 H=`-<]#y 
 	O:-h} 
 
QEֳ   
KX3vv{<>
Y  Qqc}G΅>  D5 1  QيI!N\< 
 ^<Q 
 
Qm<!j9QR  
W5?Q
z  Q_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Hafslund Telekom AS                                     D      operator                                                D      0                                                       D      	is_mobile                                               D      33299999                                                D      to                                                      D      33280000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      111                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y  O:-h}  TEֳ   KX3vv{<>
Y  Tqc}G΅>  D5 1  TيI!N\<  ^<Q  Tm<!j9QR  W5?Q
z  T_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      33499999                                                D      to                                                      D      33300000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      112                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y  O:-h}  WEֳ   KX3vv{<>
Y  Wqc}G΅>  D5 1  WيI!N\<  ^<Q  Wm<!j9QR  W5?Q
z  W_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      33519999                                                D      to                                                      D      33500000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                            D      113                                                     D     0                                                       B  ^\Q6ԂSM ! =`-<]#y " !O:-h} " "ZEֳ  # "KX3vv{<>
Y # #Zqc}G΅> $ #D5 1 $ $ZيI!N\< % $^<Q % %Zm<!j9QR & %W5?Q
z & &Z_kVܕOFLA ' &                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Lyse Tele AS                                            D      operator                                                D      0                                                       D      	is_mobile                                               D      33529999                                                D      to                                                      D      33520000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   (                                                        D      114                                                     D     0                                                       B  ^\Q6ԂSM ) =`-<]#y * )O:-h} * *]Eֳ  + *KX3vv{<>
Y + +]qc}G΅> , +D5 1 , ,]يI!N\< - ,^<Q - -]m<!j9QR . -W5?Q
z . .]_kVܕOFLA / .                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      33599999                                                D      to                                                      D      33530000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   1                                                        B  +D8LLg|H 1  /]+$ԕ*cXWk ;- :+aYKLM*9\ i iu+2<wIeX  +d< 1$k( s s+ʹ5d4h=ъ    +8jIpn䍆 % %R                                                                                                                                                                                                                        D      115                                                     D     0                                                       B  ^\Q6ԂSM 3# '=`-<]#y 3 3cO:-h} 4# 3Eֳ  4 4cKX3vv{<>
Y 5# 4qc}G΅> 5 5cD5 1 6# 5يI!N\< 6 6c^<Q 7# 6m<!j9QR 7 7cW5?Q
z 8# 7_kVܕOFLA 8 8c                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Tele2 Norge AS                                          D      operator                                                D      0                                                       D      	is_mobile                                               D      33609999                                                D      to                                                      D      33600000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   9                                                        D      116                                                     D     0                                                       B  ^\Q6ԂSM ;& 1`=`-<]#y ; ;fO:-h} <& ;Eֳ  < <fKX3vv{<>
Y =& <qc}G΅> = =fD5 1 >& =يI!N\< > >f^<Q ?& >m<!j9QR ? ?fW5?Q
z @& ?_kVܕOFLA @ @f                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telio Telecom AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      33619999                                                D      to                                                      D      33610000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   C)                                                        B  
މh B @7'|Td>t vG v0+͚'?r:h{ i ibî^f  ~o639l&  Q                                                                                                                                                                                                                                                                        D      117                                                     D     0                                                       B  ^\Q6ԂSM D 9c=`-<]#y E, DO:-h} E ElEֳ  F, EKX3vv{<>
Y F Flqc}G΅> G, FD5 1 G GlيI!N\< H, G^<Q H Hlm<!j9QR I, HW5?Q
z I Il_kVܕOFLA J, I                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      33696999                                                D      to                                                      D      33620000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   L                                                        B  ^YEb L/ Jl^͟P>1Z`  ^Z~F  + ^d13`T8ߙj>Y  ^8ګvs 6 ^kʻER e %^0/A@2]	 z zo                                                                                                                                                                                                                        D      118                                                     D     0                                                       B  ^\Q6ԂSM N2 B=`-<]#y N NrO:-h} O2 NEֳ  O OrKX3vv{<>
Y P2 Oqc}G΅> P PrD5 1 Q2 PيI!N\< Q Qr^<Q R2 Qm<!j9QR R RrW5?Q
z S2 R_kVܕOFLA S Sr                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Network Norway AS                                       D      operator                                                D      0                                                       D      	is_mobile                                               D      33699999                                                D      to                                                      D      33697000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   T                                                        D      119                                                     D     0                                                       B  ^\Q6ԂSM V5 Lo=`-<]#y V VuO:-h} W5 VEֳ  W WuKX3vv{<>
Y X5 Wqc}G΅> X XuD5 1 Y5 XيI!N\< Y Yu^<Q Z5 Ym<!j9QR Z ZuW5?Q
z [5 Z_kVܕOFLA [ [u                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      33799999                                                D      to                                                      D      33700000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   ^8                                                        B  O>t߅'Y&B ] [A!K9fgM	@ + ڌ<$ pliČՈ MW M
]HB 3T 3                                                                                                                                                                                                                                                                                                D      120                                                     D     0                                                       B  ^\Q6ԂSM _ Tr=`-<]#y `; _O:-h} ` `{Eֳ  a; `KX3vv{<>
Y a a{qc}G΅> b; aD5 1 b b{يI!N\< c; b^<Q c c{m<!j9QR d; cW5?Q
z d d{_kVܕOFLA e; d                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      33809999                                                D      to                                                      D      33800000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   g                                                        B  LVLW:ߙz g> e{L[teht/7	 }O }L'ΨRj;წ XP XL'7*T|I)? "x "8                                                                                                                                                                                                                                                                                                D      121                                                     D     0                                                       B  ^\Q6ԂSM iA ]=`-<]#y i iO:-h} jA jEֳ  j jKX3vv{<>
Y kA kqc}G΅> k kD5 1 lA lيI!N\< l l^<Q mA mm<!j9QR m mW5?Q
z nA n_kVܕOFLA n n                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      33899999                                                D      to                                                      D      33810000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   qD                                                        B  .o?0 p o/Fۏ@Y 
^ 
<aB&1	 
c 
cEc}rJǀ "6W "6	p@pEuԙɗ # #                                                                                                                                                                                                                                                                        D      122                                                     D     0                                                       B  ^\Q6ԂSM r g~=`-<]#y sG sO:-h} s sEֳ  tG tKX3vv{<>
Y t tqc}G΅> uG uD5 1 u uيI!N\< vG v^<Q v vm<!j9QR wG wW5?Q
z w w_kVܕOFLA xG x                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      33909999                                                D      to                                                      D      33900000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   z                                                        B   ,bY[K-#Kp zJ x u 7͢ 	 	 P<Xt̡Ltb %  d7U0P   φz<0! "F] "F 5򁅸JLQ  $O  $N C\Lxۃ҈ %G} %G=                                                                                                                                                                                                                        D      123                                                     D     0                                                       B  ^\Q6ԂSM |M q=`-<]#y | |O:-h} }M }
Eֳ  } }KX3vv{<>
Y ~M ~
qc}G΅> ~ ~D5 1 M 
يI!N\<  ^<Q M 
m<!j9QR  W5?Q
z M 
_kVܕOFLA                                                                                                  D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      33919999                                                D      to                                                      D      33910000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      124                                                     D     0                                                       B  ^\Q6ԂSM P z=`-<]#y  O:-h} P Eֳ   KX3vv{<>
Y P qc}G΅>  D5 1 P يI!N\<  ^<Q P m<!j9QR  W5?Q
z P _kVܕOFLA                                                                                                  D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      33982999                                                D      to                                                      D      33920000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   S                                                        B  =Ju_i.s  =Ԋo3+<  =ćo? |vq9 Y Yo=-7ߗ|l?:  =(1:UL.g v 6=ԹmvY9>g  V                                                                                                                                                                                                                                                D      125                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y V O:-h}  Eֳ  V KX3vv{<>
Y  qc}G΅> V D5 1  يI!N\< V ^<Q  m<!j9QR V W5?Q
z  _kVܕOFLA V                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      CBK Tele AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      33985999                                                D      to                                                      D      33983000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  Yt7 Y @c"jDN
# f &
$}A
ttw q 1ů`#dn|u 	f 	fta9|g̰ 
 
;	Y }
 |ےFj+n- Q Q<%vUw  -lrskb c #6 #6w                                                                                                                                                                        D      126                                                     D     0                                                       B  ^\Q6ԂSM \ =`-<]#y  O:-h} \ Eֳ   KX3vv{<>
Y \ qc}G΅>  D5 1 \ يI!N\<  ^<Q \ m<!j9QR  W5?Q
z \ _kVܕOFLA                                                                                                  D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      33988999                                                D      to                                                      D      33986000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      127                                                     D     0                                                       B  ^\Q6ԂSM _ =`-<]#y  O:-h} _ Eֳ   KX3vv{<>
Y _ qc}G΅>  D5 1 _ يI!N\<  ^<Q _ m<!j9QR  W5?Q
z _ _kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      33992999                                                D      to                                                      D      33989000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      128                                                     D     0                                                       B  ^\Q6ԂSM b =`-<]#y  O:-h} b "Eֳ   KX3vv{<>
Y b "qc}G΅>  D5 1 b "يI!N\<  ^<Q b "m<!j9QR  W5?Q
z b "_kVܕOFLA                                                                                                  D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      33993999                                                D      to                                                      D      33993000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      129                                                     D     0                                                       B  ^\Q6ԂSM e =`-<]#y  O:-h} e %Eֳ   KX3vv{<>
Y e %qc}G΅>  D5 1 e %يI!N\<  ^<Q e %m<!j9QR  W5?Q
z e %_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Combitel Networks AS                                    D      operator                                                D      0                                                       D      	is_mobile                                               D      33994999                                                D      to                                                      D      33994000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      130                                                     D     0                                                       B  ^\Q6ԂSM h =`-<]#y  O:-h} h (Eֳ   KX3vv{<>
Y h (qc}G΅>  D5 1 h (يI!N\<  ^<Q h (m<!j9QR  W5?Q
z h (_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      33996999                                                D      to                                                      D      33995000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   k                                                        B  4۰Ԕ.  ([MeZ'[SP . .Ĉɸ;~                                                                                                                                                                                                                                                                                                                          D      131                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y n .O:-h}  Eֳ  n .KX3vv{<>
Y  ®qc}G΅> n .D5 1  îيI!N\< n .^<Q  Įm<!j9QR n .W5?Q
z  Ů_kVܕOFLA n .                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      	Comvie AS                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      33998999                                                D      to                                                      D      33997000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   n                                                        D      132                                                     D     0                                                       B  ^\Q6ԂSM  +=`-<]#y q 1O:-h}  ɱEֳ  q 1KX3vv{<>
Y  ʱqc}G΅> q 1D5 1  ˱يI!N\< q 1^<Q  ̱m<!j9QR q 1W5?Q
z  ͱ_kVܕOFLA q 1                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      	Phonzo AS                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      33999999                                                D      to                                                      D      33999000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Vestfold                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   q                                                        D      133                                                     D     0                                                       B  ^\Q6ԂSM  .=`-<]#y t 4O:-h}  ѴEֳ  t 4KX3vv{<>
Y  Ҵqc}G΅> t 4D5 1  ӴيI!N\< t 4^<Q  Դm<!j9QR t 4W5?Q
z  մ_kVܕOFLA t 4                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      34999999                                                D      to                                                      D      34000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   t                                                        D      134                                                     D     0                                                       B  ^\Q6ԂSM  1=`-<]#y w 7O:-h}  ٷEֳ  w 7KX3vv{<>
Y  ڷqc}G΅> w 7D5 1  ۷يI!N\< w 7^<Q  ܷm<!j9QR w 7W5?Q
z  ݷ_kVܕOFLA w 7                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      35099999                                                D      to                                                      D      35000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   w                                                        D      135                                                     D     0                                                       B  ^\Q6ԂSM  4=`-<]#y z :O:-h}  Eֳ  z :KX3vv{<>
Y  qc}G΅> z :D5 1  يI!N\< z :^<Q  m<!j9QR z :W5?Q
z  _kVܕOFLA z :                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      35119999                                                D      to                                                      D      35100000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  B;[׆"'|N } B窨HzN% 3_ 3B-U#CF8- f &Bʛ%\  B{ccz_( 2                                                                                                                                                                                                                                                                         D      136                                                     D     0                                                       B  ^\Q6ԂSM  7=`-<]#y   O:-h}  @Eֳ    KX3vv{<>
Y  @qc}G΅>   D5 1  @يI!N\<   ^<Q  @m<!j9QR   W5?Q
z  @_kVܕOFLA                                                                                                   D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      35122999                                                D      to                                                      D      35120000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  9l2W2  @9$:i]AFf 	n 	nw9F߳ve!H 
Cy 
C99%(
+STb # #k                                                                                                                                                                                                                                                                                                D      137                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y  FO:-h}  Eֳ   FKX3vv{<>
Y  qc}G΅>  FD5 1  يI!N\<  F^<Q  m<!j9QR  FW5?Q
z  _kVܕOFLA  F                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Combitel Networks AS                                    D      operator                                                D      0                                                       D      	is_mobile                                               D      35123999                                                D      to                                                      D      35123000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	                                                        B  =@qfOnჹ  mEݏM P Pv8k«L|}D{ Z 8^v2X?$  &XPa` * : o9.U  %|2
ڙ!G                                                                                                                                                                                                                          D      138                                                     D     0                                                       B  ^\Q6ԂSM  C=`-<]#y  O:-h}  LEֳ   KX3vv{<>
Y  Lqc}G΅>   D5 1    LيI!N\<   ^<Q  Lm<!j9QR  W5?Q
z  L_kVܕOFLA                                                                                                  D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      35189999                                                D      to                                                      D      35124000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  
;hZ
я=  LA['B[VV=$ cq c1t5HuVtp $ G[&sG  E>(aXC                                                                                                                                                                                                                                                                          D      139                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y  RO:-h}  Eֳ   RKX3vv{<>
Y 	 qc}G΅> 	 	RD5 1 
 	يI!N\< 
 
R^<Q  
m<!j9QR  RW5?Q
z  _kVܕOFLA  R                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Hafslund Telekom AS                                     D      operator                                                D      0                                                       D      	is_mobile                                               D      35199999                                                D      to                                                      D      35190000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  NՐJC{?t9  1w:mM2  @my(!A T ie83U)* % %όSR.XG>i  y J\;   ə                                                                                                                                                                                                                                                D      140                                                     D     0                                                       B  ^\Q6ԂSM  O=`-<]#y  O:-h}  XEֳ   KX3vv{<>
Y  Xqc}G΅>  D5 1  XيI!N\<  ^<Q  Xm<!j9QR  W5?Q
z  X_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Tele2 Norge AS                                          D      operator                                                D      0                                                       D      	is_mobile                                               D      35209999                                                D      to                                                      D      35200000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  (ԛ0 ͕ L  XIȝr0x՝H 	g 	'yw_  a25)cq{u `S `Q@ɪ@> h (<C|!>97U  UM?[Y!U                                                                                                                                                                                                                          D      141                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y  ^O:-h}  Eֳ   ^KX3vv{<>
Y  qc}G΅>  ^D5 1  يI!N\<  ^^<Q  m<!j9QR  ^W5?Q
z  _kVܕOFLA  ^                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      35288999                                                D      to                                                      D      35210000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                            D      142                                                     D     0                                                       B  ^\Q6ԂSM "! [=`-<]#y " "aO:-h} #! "Eֳ  # #aKX3vv{<>
Y $! #qc}G΅> $ $aD5 1 %! $يI!N\< % %a^<Q &! %m<!j9QR & &aW5?Q
z '! &_kVܕOFLA ' 'a                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Lyse Tele AS                                            D      operator                                                D      0                                                       D      	is_mobile                                               D      35292999                                                D      to                                                      D      35289000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   *$                                                        B  <"_>*D ) 'yN;ST➗z ˍ M                                                                                                                                                                                                                                                                                                                                                D      143                                                     D     0                                                       B  ^\Q6ԂSM +  ^=`-<]#y ,' +O:-h} , ,gEֳ  -' ,KX3vv{<>
Y - -gqc}G΅> .' -D5 1 . .gيI!N\< /' .^<Q / /gm<!j9QR 0' /W5?Q
z 0 0g_kVܕOFLA 1' 0                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Lyse Tele AS                                            D      operator                                                D      0                                                       D      	is_mobile                                               D      35294999                                                D      to                                                      D      35293000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   3                                                        B  
	ȄKl y0ֶ 3* 1g
<d<={
  ̹
> ڥa J J                                                                                                                                                                                                                                                                                                                        D      144                                                     D     0                                                       B  ^\Q6ԂSM 5- )=`-<]#y 5 5mO:-h} 6- 5Eֳ  6 6mKX3vv{<>
Y 7- 6qc}G΅> 7 7mD5 1 8- 7يI!N\< 8 8m^<Q 9- 8m<!j9QR 9 9mW5?Q
z :- 9_kVܕOFLA : :m                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      CBK Tele AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      35296999                                                D      to                                                      D      35295000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   ;                                                        D      145                                                     D     0                                                       B  ^\Q6ԂSM =0 3j=`-<]#y = =pO:-h} >0 =Eֳ  > >pKX3vv{<>
Y ?0 >qc}G΅> ? ?pD5 1 @0 ?يI!N\< @ @p^<Q A0 @m<!j9QR A ApW5?Q
z B0 A_kVܕOFLA B Bp                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      35299999                                                D      to                                                      D      35297000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   C                                                        D      146                                                     D     0                                                       B  ^\Q6ԂSM E3 ;m=`-<]#y E EsO:-h} F3 EEֳ  F FsKX3vv{<>
Y G3 Fqc}G΅> G GsD5 1 H3 GيI!N\< H Hs^<Q I3 Hm<!j9QR I IsW5?Q
z J3 I_kVܕOFLA J Js                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      35309999                                                D      to                                                      D      35300000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   M6                                                        B  ^)xH{ُ0d L J;t%ɌP,-75 t 4ԍj.,!1y,< - -}i]V~ 	 ɍ4 [	lr6 v vaHzTn U 1{"wm  ցm^Po3Ihڻd  Y                                                                                                                                                                                                D      147                                                     D     0                                                       B  ^\Q6ԂSM N Cp=`-<]#y O9 NO:-h} O OyEֳ  P9 OKX3vv{<>
Y P Pyqc}G΅> Q9 PD5 1 Q QyيI!N\< R9 Q^<Q R Rym<!j9QR S9 RW5?Q
z S Sy_kVܕOFLA T9 S                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      35319999                                                D      to                                                      D      35310000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   V                                                        B  GX<gBM64r V< TyG4o==1v'<m 	C 	GzOzTvo (b ("GX"62ȄB %h %(                                                                                                                                                                                                                                                                                                D      148                                                     D     0                                                       B  ^\Q6ԂSM X? L=`-<]#y X XO:-h} Y? XEֳ  Y YKX3vv{<>
Y Z? Yqc}G΅> Z ZD5 1 [? ZيI!N\< [ [^<Q \? [m<!j9QR \ \W5?Q
z ]? \_kVܕOFLA ] ]                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      35498999                                                D      to                                                      D      35320000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   `B                                                        B  !pb飗ܤ) _ ]eĝQ2 4 4C!ԉx1r4{ | < Q,ů>	F z y                                                                                                                                                                                                                                                                                                D      149                                                     D     0                                                       B  ^\Q6ԂSM a V|=`-<]#y bE bO:-h} b bEֳ  cE cKX3vv{<>
Y c cqc}G΅> dE dD5 1 d dيI!N\< eE e^<Q e em<!j9QR fE fW5?Q
z f f_kVܕOFLA gE g                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Network Norway AS                                       D      operator                                                D      0                                                       D      	is_mobile                                               D      35499999                                                D      to                                                      D      35499000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   i                                                        B  ~T%֖_L iH g~wW*6uOaz  J~d+?.e L Lu~2W'#u_ Sk S+                                                                                                                                                                                                                                                                                                D      150                                                     D     0                                                       B  ^\Q6ԂSM kK `=`-<]#y k kO:-h} lK lEֳ  l lKX3vv{<>
Y mK mqc}G΅> m mD5 1 nK nيI!N\< n n^<Q oK om<!j9QR o oW5?Q
z pK p_kVܕOFLA p p                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      35599999                                                D      to                                                      D      35500000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   q                                                        D      151                                                     D     0                                                       B  ^\Q6ԂSM sN i=`-<]#y s sO:-h} tN tEֳ  t tKX3vv{<>
Y uN uqc}G΅> u uD5 1 vN vيI!N\< v v^<Q wN wm<!j9QR w wW5?Q
z xN x_kVܕOFLA x x                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telio Telecom AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      35609999                                                D      to                                                      D      35600000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   y                                                        D      152                                                     D     0                                                       B  ^\Q6ԂSM {Q q=`-<]#y { {O:-h} |Q |Eֳ  | |KX3vv{<>
Y }Q }qc}G΅> } }D5 1 ~Q ~يI!N\< ~ ~^<Q Q m<!j9QR  W5?Q
z Q _kVܕOFLA                                                                                                  D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      35689999                                                D      to                                                      D      35610000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   T                                                        B  ~5)  z¦4%0Z N 7Mu+'#c  N                                                                                                                                                                                                                                                                                                                        D      153                                                     D     0                                                       B  ^\Q6ԂSM  y=`-<]#y W O:-h}  Eֳ  W KX3vv{<>
Y  qc}G΅> W D5 1  يI!N\< W ^<Q  m<!j9QR W W5?Q
z  _kVܕOFLA W                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      35692999                                                D      to                                                      D      35690000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  z9uS Z                                                                                                                                                                                                                                                                                                                                                                         D      154                                                     D     0                                                       B  ^\Q6ԂSM ] =`-<]#y  O:-h} ] Eֳ   KX3vv{<>
Y ] qc}G΅>  D5 1 ] يI!N\<  ^<Q ] m<!j9QR  W5?Q
z ] _kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Lyse Tele AS                                            D      operator                                                D      0                                                       D      	is_mobile                                               D      35694999                                                D      to                                                      D      35693000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      155                                                     D     0                                                       B  ^\Q6ԂSM ` =`-<]#y  O:-h} `  Eֳ   KX3vv{<>
Y `  qc}G΅>  D5 1 `  يI!N\<  ^<Q `  m<!j9QR  W5?Q
z `  _kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      35696999                                                D      to                                                      D      35695000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      156                                                     D     0                                                       B  ^\Q6ԂSM c =`-<]#y  O:-h} c #Eֳ   KX3vv{<>
Y c #qc}G΅>  D5 1 c #يI!N\<  ^<Q c #m<!j9QR  W5?Q
z c #_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      	Comvie AS                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      35698999                                                D      to                                                      D      35697000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      157                                                     D     0                                                       B  ^\Q6ԂSM f =`-<]#y  O:-h} f &Eֳ   KX3vv{<>
Y f &qc}G΅>  D5 1 f &يI!N\<  ^<Q f &m<!j9QR  W5?Q
z f &_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      	Phonzo AS                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      35699999                                                D      to                                                      D      35699000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      158                                                     D     0                                                       B  ^\Q6ԂSM i =`-<]#y  O:-h} i )Eֳ   KX3vv{<>
Y i )qc}G΅>  D5 1 i )يI!N\<  ^<Q i )m<!j9QR  W5?Q
z i )_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      35709999                                                D      to                                                      D      35700000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      159                                                     D     0                                                       B  ^\Q6ԂSM l =`-<]#y  O:-h} l ,Eֳ   KX3vv{<>
Y l ,qc}G΅>  D5 1 l ,يI!N\<  ^<Q l ,m<!j9QR  W5?Q
z l ,_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      
NextGenTel AS                                           D      operator                                                D      0                                                       D      	is_mobile                                               D      35719999                                                D      to                                                      D      35710000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   o                                                        B  <ßPja'}:  ,nό7#Y8`qp 
  
=%qL70 Ɨ W5*-p  ; o_C΄  Ϸ/	_hocUȕ Ӑ P]+NPoX*gj    ō                                                                                                                                                                                                                        D      160                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y r 2O:-h}  Eֳ  r 2KX3vv{<>
Y  qc}G΅> r 2D5 1  ²يI!N\< r 2^<Q  òm<!j9QR r 2W5?Q
z  Ĳ_kVܕOFLA r 2                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      35899999                                                D      to                                                      D      35720000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  L0Q2
 u Ųho@	  ܿVNFĈ
 !6 !                                                                                                                                                                                                                                                                                                                        D      161                                                     D     0                                                       B  ^\Q6ԂSM x /=`-<]#y  ɸO:-h} x 8Eֳ   ʸKX3vv{<>
Y x 8qc}G΅>  ˸D5 1 x 8يI!N\<  ̸^<Q x 8m<!j9QR  ͸W5?Q
z x 8_kVܕOFLA  θ                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      35915999                                                D      to                                                      D      35900000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   {                                                        B  K
L#bi
  8B{p>jϜriB B4 A`(|~tb4 5 5KP?|lShE x` x ð7*/ ! !H7$U0Ǧ7S UZ UCIACʇ ! !ۂHR˛A?? %/t %/4                                                                                                                                                                                                D      162                                                     D     0                                                       B  ^\Q6ԂSM  ǵ=`-<]#y ~ >O:-h}  ӾEֳ  ~ >KX3vv{<>
Y  Ծqc}G΅> ~ >D5 1  վيI!N\< ~ >^<Q  ־m<!j9QR ~ >W5?Q
z  ׾_kVܕOFLA ~ >                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      35916999                                                D      to                                                      D      35916000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   ~                                                        D      163                                                     D     0                                                       B  ^\Q6ԂSM  ;=`-<]#y ہ AO:-h}  Eֳ  ܁ AKX3vv{<>
Y  qc}G΅> ݁ AD5 1  يI!N\< ށ A^<Q  m<!j9QR ߁ AW5?Q
z  _kVܕOFLA  A                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      35999999                                                D      to                                                      D      35917000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Telemark                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  |߭Zpz  I/)3w sw s7|ErggNS =- </AM=\i 8h 8(:<@7U]@35 ` `Zz m -                                                                                                                                                                                                                                                D      164                                                     D     0                                                       B  ^\Q6ԂSM  >=`-<]#y  O:-h}  GEֳ   KX3vv{<>
Y  Gqc}G΅>  D5 1  GيI!N\<  ^<Q  Gm<!j9QR  W5?Q
z  G_kVܕOFLA                                                                                                  D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      36999999                                                D      to                                                      D      36000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      165                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y 
 O:-h}  JEֳ  
 KX3vv{<>
Y  Jqc}G΅> 
 D5 1  JيI!N\< 
 ^<Q  Jm<!j9QR 
 W5?Q
z  J_kVܕOFLA 
                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      37099999                                                D      to                                                      D      37000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        D      166                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y 
 O:-h}  MEֳ  
 KX3vv{<>
Y  Mqc}G΅> 
 D5 1  MيI!N\< 
 ^<Q  Mm<!j9QR 
 W5?Q
z  M_kVܕOFLA 
                                                                                                 D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      37109999                                                D      to                                                      D      37100000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  XxC@!uer  MXnӟЃ]Am  ԼX#0]y4"  ʅXt%6􆼅 K X{%г~Ї  BXѩ;Y5Vl a aXNU
~=kٰ + +qXH&	#5:4 "Vc "V#                                                                                                                                                                                                D      167                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y  SO:-h}  Eֳ   SKX3vv{<>
Y   qc}G΅>    SD5 1   يI!N\<  S^<Q  m<!j9QR  SW5?Q
z  _kVܕOFLA  S                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      37119999                                                D      to                                                      D      37110000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B   oR*;V+   A`-!$~_ z zS Sh-65J{ 
d 
$ Ӵ2{N+
  ss s3                                                                                                                                                                                                                                                                                                D      168                                                     D     0                                                       B  ^\Q6ԂSM  P=`-<]#y  O:-h}  YEֳ  	 KX3vv{<>
Y 	 	Yqc}G΅> 
 	D5 1 
 
YيI!N\<  
^<Q  Ym<!j9QR  W5?Q
z  Y_kVܕOFLA 
                                                                                                 D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      37129999                                                D      to                                                      D      37120000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  66cw.Btq  
Y6D"<q;ww   6fYkM!N' 	+ 	+Y6!ELS6R E 6.C:T6& 
 
E6j%6+n:V #V #V                                                                                                                                                                                                                                                D      169                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y  _O:-h}  Eֳ   _KX3vv{<>
Y  qc}G΅>  _D5 1  يI!N\<  _^<Q  m<!j9QR  _W5?Q
z  _kVܕOFLA  _                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      37199999                                                D      to                                                      D      37130000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      170                                                     D     0                                                       B  ^\Q6ԂSM " \=`-<]#y  bO:-h} " Eֳ   bKX3vv{<>
Y " qc}G΅>  bD5 1 " يI!N\<  b^<Q " m<!j9QR  bW5?Q
z " _kVܕOFLA  b                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      37229999                                                D      to                                                      D      37200000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   !%                                                        B  BOֿwȡe:   6p??|]f 	 	SO>К
  ۤ0 +Ϸ)]Rߔ <                                                                                                                                                                                                                                                                                                 D      171                                                     D     0                                                       B  ^\Q6ԂSM " _=`-<]#y #( "O:-h} # #hEֳ  $( #KX3vv{<>
Y $ $hqc}G΅> %( $D5 1 % %hيI!N\< &( %^<Q & &hm<!j9QR '( &W5?Q
z ' 'h_kVܕOFLA (( '                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      37299999                                                D      to                                                      D      37230000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   )(                                                        D      172                                                     D     0                                                       B  ^\Q6ԂSM *  =`-<]#y ++ *O:-h} + +kEֳ  ,+ +KX3vv{<>
Y , ,kqc}G΅> -+ ,D5 1 - -kيI!N\< .+ -^<Q . .km<!j9QR /+ .W5?Q
z / /k_kVܕOFLA 0+ /                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      37309999                                                D      to                                                      D      37300000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   1+                                                        D      173                                                     D     0                                                       B  ^\Q6ԂSM 2 (=`-<]#y 3. 2O:-h} 3 3nEֳ  4. 3KX3vv{<>
Y 4 4nqc}G΅> 5. 4D5 1 5 5nيI!N\< 6. 5^<Q 6 6nm<!j9QR 7. 6W5?Q
z 7 7n_kVܕOFLA 8. 7                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      
NextGenTel AS                                           D      operator                                                D      0                                                       D      	is_mobile                                               D      37319999                                                D      to                                                      D      37310000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   :                                                        B  )ioz;p? :1 8nbvkl;[ѡE 0e 0%                                                                                                                                                                                                                                                                                                                                                D      174                                                     D     0                                                       B  ^\Q6ԂSM <4 0=`-<]#y < <tO:-h} =4 <Eֳ  = =tKX3vv{<>
Y >4 =qc}G΅> > >tD5 1 ?4 >يI!N\< ? ?t^<Q @4 ?m<!j9QR @ @tW5?Q
z A4 @_kVܕOFLA A At                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      37322999                                                D      to                                                      D      37320000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   B                                                        D      175                                                     D     0                                                       B  ^\Q6ԂSM D7 :q=`-<]#y D DwO:-h} E7 DEֳ  E EwKX3vv{<>
Y F7 Eqc}G΅> F FwD5 1 G7 FيI!N\< G Gw^<Q H7 Gm<!j9QR H HwW5?Q
z I7 H_kVܕOFLA I Iw                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      37389999                                                D      to                                                      D      37323000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   J                                                        D      176                                                     D     0                                                       B  ^\Q6ԂSM L: Bt=`-<]#y L LzO:-h} M: LEֳ  M MzKX3vv{<>
Y N: Mqc}G΅> N NzD5 1 O: NيI!N\< O Oz^<Q P: Om<!j9QR P PzW5?Q
z Q: P_kVܕOFLA Q Qz                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Hafslund Telekom AS                                     D      operator                                                D      0                                                       D      	is_mobile                                               D      37399999                                                D      to                                                      D      37390000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   T=                                                        B  /Y$kG S Qd/rˊ ET Eyc                                                                                                                                                                                                                                                                                                                          D      177                                                     D     0                                                       B  ^\Q6ԂSM U Jw=`-<]#y V@ V O:-h} V VEֳ  W@ W KX3vv{<>
Y W Wqc}G΅> X@ X D5 1 X XيI!N\< Y@ Y ^<Q Y Ym<!j9QR Z@ Z W5?Q
z Z Z_kVܕOFLA [@ [                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      37409999                                                D      to                                                      D      37400000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   \@                                                        D      178                                                     D     0                                                       B  ^\Q6ԂSM ] S=`-<]#y ^C ^O:-h} ^ ^Eֳ  _C _KX3vv{<>
Y _ _qc}G΅> `C `D5 1 ` `يI!N\< aC a^<Q a am<!j9QR bC bW5?Q
z b b_kVܕOFLA cC c                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      37418999                                                D      to                                                      D      37410000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   dC                                                        D      179                                                     D     0                                                       B  ^\Q6ԂSM e \ =`-<]#y fF fO:-h} f fEֳ  gF gKX3vv{<>
Y g gqc}G΅> hF hD5 1 h hيI!N\< iF i^<Q i im<!j9QR jF jW5?Q
z j j_kVܕOFLA kF k                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      37419999                                                D      to                                                      D      37419000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   m                                                        B  Q$+e眿? mI kYY?O	@Q_ 9 (Plor,Eݼ  <=~Hi7  D                                                                                                                                                                                                                                                                                                D      180                                                     D     0                                                       B  ^\Q6ԂSM oL d=`-<]#y o oO:-h} pL pEֳ  p pKX3vv{<>
Y qL qqc}G΅> q qD5 1 rL rيI!N\< r r^<Q sL sm<!j9QR s sW5?Q
z tL t_kVܕOFLA t t                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      37499999                                                D      to                                                      D      37420000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   u                                                        D      181                                                     D     0                                                       B  ^\Q6ԂSM wO m=`-<]#y w wO:-h} xO xEֳ  x xKX3vv{<>
Y yO yqc}G΅> y yD5 1 zO zيI!N\< z z^<Q {O {m<!j9QR { {W5?Q
z |O |_kVܕOFLA | |                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      37509999                                                D      to                                                      D      37500000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   }                                                        D      182                                                     D     0                                                       B  ^\Q6ԂSM R u=`-<]#y  O:-h} R Eֳ   KX3vv{<>
Y R qc}G΅>  D5 1 R يI!N\<  ^<Q R m<!j9QR  W5?Q
z R _kVܕOFLA                                                                                                  D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      37697999                                                D      to                                                      D      37510000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   U                                                        B  ޻n/S?t  1.#/:/ț  Bx%LC#w_ p pQ@Fh}&K ! !                                                                                                                                                                                                                                                                                                D      183                                                     D     0                                                       B  ^\Q6ԂSM  }=`-<]#y X O:-h}  Eֳ  X KX3vv{<>
Y  qc}G΅> X D5 1  يI!N\< X ^<Q  m<!j9QR X W5?Q
z  _kVܕOFLA X                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Network Norway AS                                       D      operator                                                D      0                                                       D      	is_mobile                                               D      37699999                                                D      to                                                      D      37698000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   X                                                        D      184                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y [ O:-h}  Eֳ  [ KX3vv{<>
Y  qc}G΅> [ D5 1  يI!N\< [ ^<Q  m<!j9QR [ W5?Q
z  _kVܕOFLA [                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      37709999                                                D      to                                                      D      37700000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  ̥6]Z3ib4 ^ կjݕ%'9$  mJ#3+-' Y Y<# Ekj_Ab	8Q g '                                                                                                                                                                                                                                                                                                D      185                                                     D     0                                                       B  ^\Q6ԂSM a =`-<]#y  O:-h} a !Eֳ   KX3vv{<>
Y a !qc}G΅>  D5 1 a !يI!N\<  ^<Q a !m<!j9QR  W5?Q
z a !_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telio Telecom AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      37714999                                                D      to                                                      D      37710000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      186                                                     D     0                                                       B  ^\Q6ԂSM d =`-<]#y  O:-h} d $Eֳ   KX3vv{<>
Y d $qc}G΅>  D5 1 d $يI!N\<  ^<Q d $m<!j9QR  W5?Q
z d $_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Combitel Networks AS                                    D      operator                                                D      0                                                       D      	is_mobile                                               D      37715999                                                D      to                                                      D      37715000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   g                                                        B  1W*mK8I
  $1
˿LbbHV ' 1ocl?G:̵ " 1/7|
 ! !1{D@rt-J " "Y                                                                                                                                                                                                                                                                        D      187                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y j *O:-h}  Eֳ  j *KX3vv{<>
Y  qc}G΅> j *D5 1  يI!N\< j *^<Q  m<!j9QR j *W5?Q
z  _kVܕOFLA j *                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      37799999                                                D      to                                                      D      37716000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  ˈvIYuSr@ m XߠJ77 
 
ǓOԼU[f 
 
                                                                                                                                                                                                                                                                                                                        D      188                                                     D     0                                                       B  ^\Q6ԂSM p '=`-<]#y  O:-h} p 0Eֳ   KX3vv{<>
Y p 0qc}G΅>  D5 1 p 0يI!N\<  ^<Q p 0m<!j9QR  W5?Q
z p 0_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Tele2 Norge AS                                          D      operator                                                D      0                                                       D      	is_mobile                                               D      37809999                                                D      to                                                      D      37800000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   s                                                        B  Uz{.gg  0z*Pˈ "֓ "Scܦ{IlT # #                                                                                                                                                                                                                                                                                                                        D      189                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y v 6O:-h}  Eֳ  v 6KX3vv{<>
Y  qc}G΅> v 6D5 1  يI!N\< v 6^<Q  ¶m<!j9QR v 6W5?Q
z  ö_kVܕOFLA v 6                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      CBK Tele AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      37810999                                                D      to                                                      D      37810000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   v                                                        D      190                                                     D     0                                                       B  ^\Q6ԂSM  3=`-<]#y y 9O:-h}  ǹEֳ  y 9KX3vv{<>
Y  ȹqc}G΅> y 9D5 1  ɹيI!N\< y 9^<Q  ʹm<!j9QR y 9W5?Q
z  ˹_kVܕOFLA y 9                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      37883999                                                D      to                                                      D      37811000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   y                                                        D      191                                                     D     0                                                       B  ^\Q6ԂSM  6=`-<]#y | <O:-h}  ϼEֳ  | <KX3vv{<>
Y  мqc}G΅> | <D5 1  ѼيI!N\< | <^<Q  Ҽm<!j9QR | <W5?Q
z  Ӽ_kVܕOFLA | <                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Lyse Tele AS                                            D      operator                                                D      0                                                       D      	is_mobile                                               D      37885999                                                D      to                                                      D      37884000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   |                                                        D      192                                                     D     0                                                       B  ^\Q6ԂSM  9=`-<]#y  ?O:-h}  ׿Eֳ   ?KX3vv{<>
Y  ؿqc}G΅>  ?D5 1  ٿيI!N\<  ?^<Q  ڿm<!j9QR  ?W5?Q
z  ۿ_kVܕOFLA  ?                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      37892999                                                D      to                                                      D      37886000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      193                                                     D     0                                                       B  ^\Q6ԂSM  <=`-<]#y ߂ BO:-h}  Eֳ   BKX3vv{<>
Y  qc}G΅>  BD5 1  يI!N\<  B^<Q  m<!j9QR  BW5?Q
z  _kVܕOFLA  B                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      37894999                                                D      to                                                      D      37893000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      194                                                     D     0                                                       B  ^\Q6ԂSM  ?=`-<]#y  EO:-h}  Eֳ   EKX3vv{<>
Y  qc}G΅>  ED5 1  يI!N\<  E^<Q  m<!j9QR  EW5?Q
z  _kVܕOFLA  E                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      37896999                                                D      to                                                      D      37895000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      195                                                     D     0                                                       B  ^\Q6ԂSM  B=`-<]#y  HO:-h}  Eֳ   HKX3vv{<>
Y  qc}G΅>  HD5 1  يI!N\<  H^<Q  m<!j9QR  HW5?Q
z  _kVܕOFLA  H                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      	Comvie AS                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      37898999                                                D      to                                                      D      37897000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  Korڌ=?Z:  tR,1_ @# ?U+XR`6 Ѵ tC:`\2OFu 	 	ن8є cD c #A@S!T(8R&  &!.5%j !N  !M                                                                                                                                                                                                                        D      196                                                     D     0                                                       B  ^\Q6ԂSM  E=`-<]#y  O:-h}  NEֳ   KX3vv{<>
Y  Nqc}G΅>  D5 1  NيI!N\<  ^<Q  Nm<!j9QR  W5?Q
z  N_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      	Phonzo AS                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      37899999                                                D      to                                                      D      37899000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                            B  Y
ؘ(oyT   NMo^)g|ssD , ,iM`!]YUa  B*F~V:*Q  PX"c4Jؙ  ?7W	t%/ǯii Κ ZϧM0Gȑ׏ $5 $                                                                                                                                                                                                                        D      197                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y  TO:-h}  Eֳ   TKX3vv{<>
Y  qc}G΅>  TD5 1  يI!N\<  T^<Q  m<!j9QR  TW5?Q
z  _kVܕOFLA  T                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      37909999                                                D      to                                                      D      37900000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        B  e-h-9g 	 Ċ,_" r- 	 	2#
SJK` 2 2'$<3܋ $w/ $v                                                                                                                                                                                                                                                                                                D      198                                                     D     0                                                       B  ^\Q6ԂSM   Q=`-<]#y  O:-h}  ZEֳ  
 KX3vv{<>
Y 
 
Zqc}G΅>  
D5 1  ZيI!N\<  ^<Q  Zm<!j9QR  W5?Q
z  Z_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      37949999                                                D      to                                                      D      37910000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  DW,O%܏e  ZruZ{ 5* 4l&
q^[O
Ql  iީ*UW  ?|[p2mؗ󼨥 R R` K #=9 !' !                                                                                                                                                                                                                                                D      199                                                     D     0                                                       B  ^\Q6ԂSM   	=`-<]#y  `O:-h}   Eֳ   `KX3vv{<>
Y   qc}G΅>  `D5 1   يI!N\<  `^<Q   m<!j9QR  `W5?Q
z   _kVܕOFLA  `                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      37959999                                                D      to                                                      D      37950000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      200                                                     D     0                                                       B  ^\Q6ԂSM # ]=`-<]#y  cO:-h} # Eֳ   cKX3vv{<>
Y # qc}G΅>  cD5 1  # يI!N\<    c^<Q !#  m<!j9QR ! !cW5?Q
z "# !_kVܕOFLA " "c                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      37979999                                                D      to                                                      D      37960000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   %&                                                        B  u{P\4L[VR $ "ut[Ó	Ng+ 
_ 
u	<Bڡ?  uc :n`  uMKLo]hS+ # #                                                                                                                                                                                                                                                                        D      201                                                     D     0                                                       B  ^\Q6ԂSM & `=`-<]#y ') &O:-h} ' 'iEֳ  () 'KX3vv{<>
Y ( (iqc}G΅> )) (D5 1 ) )iيI!N\< *) )^<Q * *im<!j9QR +) *W5?Q
z + +i_kVܕOFLA ,) +                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      37999999                                                D      to                                                      D      37980000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   -)                                                        D      202                                                     D     0                                                       B  ^\Q6ԂSM . $=`-<]#y /, .O:-h} / /lEֳ  0, /KX3vv{<>
Y 0 0lqc}G΅> 1, 0D5 1 1 1lيI!N\< 2, 1^<Q 2 2lm<!j9QR 3, 2W5?Q
z 3 3l_kVܕOFLA 4, 3                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      38199999                                                D      to                                                      D      38000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   5,                                                        D      203                                                     D     0                                                       B  ^\Q6ԂSM 6 ,=`-<]#y 7/ 6O:-h} 7 7oEֳ  8/ 7KX3vv{<>
Y 8 8oqc}G΅> 9/ 8D5 1 9 9oيI!N\< :/ 9^<Q : :om<!j9QR ;/ :W5?Q
z ; ;o_kVܕOFLA </ ;                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      38239999                                                D      to                                                      D      38200000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   =/                                                        D      204                                                     D     0                                                       B  ^\Q6ԂSM > 4=`-<]#y ?2 >O:-h} ? ?rEֳ  @2 ?KX3vv{<>
Y @ @rqc}G΅> A2 @D5 1 A ArيI!N\< B2 A^<Q B Brm<!j9QR C2 BW5?Q
z C Cr_kVܕOFLA D2 C                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      38289999                                                D      to                                                      D      38240000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   E2                                                        D      205                                                     D     0                                                       B  ^\Q6ԂSM F <=`-<]#y G5 FO:-h} G GuEֳ  H5 GKX3vv{<>
Y H Huqc}G΅> I5 HD5 1 I IuيI!N\< J5 I^<Q J Jum<!j9QR K5 JW5?Q
z K Ku_kVܕOFLA L5 K                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      38319999                                                D      to                                                      D      38290000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   M5                                                        D      206                                                     D     0                                                       B  ^\Q6ԂSM N D=`-<]#y O8 NO:-h} O OxEֳ  P8 OKX3vv{<>
Y P Pxqc}G΅> Q8 PD5 1 Q QxيI!N\< R8 Q^<Q R Rxm<!j9QR S8 RW5?Q
z S Sx_kVܕOFLA T8 S                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      38359999                                                D      to                                                      D      38320000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   U8                                                        D      207                                                     D     0                                                       B  ^\Q6ԂSM V L=`-<]#y W; VO:-h} W W{Eֳ  X; WKX3vv{<>
Y X X{qc}G΅> Y; XD5 1 Y Y{يI!N\< Z; Y^<Q Z Z{m<!j9QR [; ZW5?Q
z [ [{_kVܕOFLA \; [                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      38369999                                                D      to                                                      D      38360000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Aust-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   ];                                                        D      208                                                     D     0                                                       B  ^\Q6ԂSM ^ T=`-<]#y _> ^O:-h} _ _~Eֳ  `> _KX3vv{<>
Y ` `~qc}G΅> a> `D5 1 a a~يI!N\< b> a^<Q b b~m<!j9QR c> bW5?Q
z c c~_kVܕOFLA d> c                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      38399999                                                D      to                                                      D      38370000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   f                                                        B  {B fA d~1_ɣ ,㋾ 	# 	#V<rj`UKǅ, c ce7V6_u  M 
V:xY3uci # #                                                                                                                                                                                                                                                                        D      209                                                     D     0                                                       B  ^\Q6ԂSM hD \=`-<]#y h hO:-h} iD iEֳ  i iKX3vv{<>
Y jD jqc}G΅> j jD5 1 kD kيI!N\< k k^<Q lD lm<!j9QR l lW5?Q
z mD m_kVܕOFLA m m                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      38499999                                                D      to                                                      D      38400000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   n                                                        D      210                                                     D     0                                                       B  ^\Q6ԂSM pG f=`-<]#y p pO:-h} qG qEֳ  q qKX3vv{<>
Y rG rqc}G΅> r rD5 1 sG sيI!N\< s s^<Q tG tm<!j9QR t tW5?Q
z uG u_kVܕOFLA u u                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Tele2 Norge AS                                          D      operator                                                D      0                                                       D      	is_mobile                                               D      38509999                                                D      to                                                      D      38500000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   v                                                        D      211                                                     D     0                                                       B  ^\Q6ԂSM xJ n=`-<]#y x xO:-h} yJ y
Eֳ  y yKX3vv{<>
Y zJ z
qc}G΅> z zD5 1 {J {
يI!N\< { {^<Q |J |
m<!j9QR | |W5?Q
z }J }
_kVܕOFLA } }                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      38519999                                                D      to                                                      D      38510000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   M                                                        B  4m2ZYR1  ~
0i5ܰ$" 
\ 
C:G#*:[ 
 
ׄ|˰H3  s!p|?o?7 9 d5\wQ3 `  _ԵBJO
 !
 !
ywΞۘ݅`o, ">Z ">                                                                                                                                                                                                D      212                                                     D     0                                                       B  ^\Q6ԂSM  v=`-<]#y P O:-h}  Eֳ  P KX3vv{<>
Y  qc}G΅> P D5 1  يI!N\< P ^<Q  m<!j9QR P W5?Q
z  _kVܕOFLA P                                                                                                 D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      38529999                                                D      to                                                      D      38520000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   P                                                        D      213                                                     D     0                                                       B  ^\Q6ԂSM  
=`-<]#y S O:-h}  Eֳ  S KX3vv{<>
Y  qc}G΅> S D5 1  يI!N\< S ^<Q  m<!j9QR S W5?Q
z  _kVܕOFLA S                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      38531999                                                D      to                                                      D      38530000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  FQ*z<Zne V ߵ
A0\ z :ʜ&}Ѧ0*Ü Z ʁU YSחKp  {ufFU3k	  ?                                                                                                                                                                                                                                                                        D      214                                                     D     0                                                       B  ^\Q6ԂSM Y =`-<]#y  O:-h} Y Eֳ   KX3vv{<>
Y Y qc}G΅>  D5 1 Y يI!N\<  ^<Q Y m<!j9QR  W5?Q
z Y _kVܕOFLA                                                                                                  D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      38593999                                                D      to                                                      D      38532000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   \                                                        B  ;aB&S͕&  ;]P{_N# ( ;=jZRT-v  x;q-7W/8IVf $> $                                                                                                                                                                                                                                                                                                D      215                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y _ O:-h}  Eֳ  _ KX3vv{<>
Y  qc}G΅> _ D5 1  يI!N\< _ ^<Q  m<!j9QR _ W5?Q
z  _kVܕOFLA _                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Lyse Tele AS                                            D      operator                                                D      0                                                       D      	is_mobile                                               D      38594999                                                D      to                                                      D      38594000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   _                                                        D      216                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y b "O:-h}  Eֳ  b "KX3vv{<>
Y  qc}G΅> b "D5 1  يI!N\< b "^<Q  m<!j9QR b "W5?Q
z  _kVܕOFLA b "                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      CBK Tele AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      38596999                                                D      to                                                      D      38595000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   b                                                        D      217                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y e %O:-h}  Eֳ  e %KX3vv{<>
Y  qc}G΅> e %D5 1  يI!N\< e %^<Q  m<!j9QR e %W5?Q
z  _kVܕOFLA e %                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      38599999                                                D      to                                                      D      38597000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  nxڸYZ} h V}dq)׿ k kTEP<H+49;  r~M	_ܔYa y 9                                                                                                                                                                                                                                                                                                D      218                                                     D     0                                                       B  ^\Q6ԂSM k "=`-<]#y  O:-h} k +Eֳ   KX3vv{<>
Y k +qc}G΅>  D5 1 k +يI!N\<  ^<Q k +m<!j9QR  W5?Q
z k +_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      38619999                                                D      to                                                      D      38600000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      219                                                     D     0                                                       B  ^\Q6ԂSM n =`-<]#y  O:-h} n .Eֳ   KX3vv{<>
Y n .qc}G΅>  D5 1 n .يI!N\<  ^<Q n .m<!j9QR  ®W5?Q
z n ._kVܕOFLA  î                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telio Telecom AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      38629999                                                D      to                                                      D      38620000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      220                                                     D     0                                                       B  ^\Q6ԂSM q =`-<]#y  ƱO:-h} q 1Eֳ   ǱKX3vv{<>
Y q 1qc}G΅>  ȱD5 1 q 1يI!N\<  ɱ^<Q q 1m<!j9QR  ʱW5?Q
z q 1_kVܕOFLA  ˱                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      38698999                                                D      to                                                      D      38630000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      221                                                     D     0                                                       B  ^\Q6ԂSM t Į=`-<]#y  δO:-h} t 4Eֳ   ϴKX3vv{<>
Y t 4qc}G΅>  дD5 1 t 4يI!N\<  Ѵ^<Q t 4m<!j9QR  ҴW5?Q
z t 4_kVܕOFLA  Ӵ                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Network Norway AS                                       D      operator                                                D      0                                                       D      	is_mobile                                               D      38699999                                                D      to                                                      D      38699000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   w                                                        B  3e欕,C9X4  4mċt=/ , ,@.A{3Xw 
a 
!                                                                                                                                                                                                                                                                                                                        D      222                                                     D     0                                                       B  ^\Q6ԂSM  ̱=`-<]#y z :O:-h}  غEֳ  z :KX3vv{<>
Y  ٺqc}G΅> z :D5 1  ںيI!N\< z :^<Q  ۺm<!j9QR z :W5?Q
z  ܺ_kVܕOFLA z :                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      38709999                                                D      to                                                      D      38700000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  _P18Aj$/@}3 } ݺ.
'R>q2h 
8 
!w6ute@ < A±?U$_                                                                                                                                                                                                                                                                                                  D      223                                                     D     0                                                       B  ^\Q6ԂSM  7=`-<]#y   O:-h}  @Eֳ    KX3vv{<>
Y  @qc}G΅>   D5 1  @يI!N\<   ^<Q  @m<!j9QR   W5?Q
z  @_kVܕOFLA                                                                                                   D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      
NextGenTel AS                                           D      operator                                                D      0                                                       D      	is_mobile                                               D      38719999                                                D      to                                                      D      38710000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                            D      224                                                     D     0                                                       B  ^\Q6ԂSM  ߽=`-<]#y  O:-h}  CEֳ   KX3vv{<>
Y  Cqc}G΅>  D5 1  CيI!N\<  ^<Q  Cm<!j9QR  W5?Q
z  C_kVܕOFLA                                                                                                  D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      38789999                                                D      to                                                      D      38720000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      225                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y  O:-h}  FEֳ   KX3vv{<>
Y  Fqc}G΅>  D5 1  FيI!N\<  ^<Q  Fm<!j9QR  W5?Q
z  F_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      38799999                                                D      to                                                      D      38790000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  GK 	 F.E/Ngd 
! 
!K&R)NVs Ca C!8b@ک-P 8 <+qœٍ	? 4 -ۘkϾQk5  
  
H;0Q<øKvc]2 $W# $V                                                                                                                                                                                                                        D      226                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y  LO:-h}  Eֳ   LKX3vv{<>
Y  qc}G΅>  LD5 1  يI!N\<  L^<Q  m<!j9QR  LW5?Q
z   _kVܕOFLA    L                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      38809999                                                D      to                                                      D      38800000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      227                                                     D     0                                                       B  ^\Q6ԂSM  I=`-<]#y  OO:-h}  Eֳ   OKX3vv{<>
Y  qc}G΅>  OD5 1  يI!N\<  O^<Q  m<!j9QR  OW5?Q
z  _kVܕOFLA  O                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      38899999                                                D      to                                                      D      38810000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  t
VFZ0Nm 
 tg3tY_N	 1 1tt'(^(jm ۓ S                                                                                                                                                                                                                                                                                                                        D      228                                                     D     0                                                       B  ^\Q6ԂSM  L=`-<]#y 
 O:-h} 
 
UEֳ   
KX3vv{<>
Y  Uqc}G΅>  D5 1  UيI!N\<  ^<Q  Um<!j9QR  W5?Q
z  U_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Hafslund Telekom AS                                     D      operator                                                D      0                                                       D      	is_mobile                                               D      38909999                                                D      to                                                      D      38900000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  W5ɂ	8  UW~O2@[A:4j H HsW{̑OU/  
~5 
}W7.ا
 $} $=W7EW[e . .FWQ>Ou.x%
 B AWJ`} 7  W~-.sC! $\ $                                                                                                                                                                                                D      229                                                     D     0                                                       B  ^\Q6ԂSM  
=`-<]#y  [O:-h}  Eֳ   [KX3vv{<>
Y  qc}G΅>  [D5 1  يI!N\<  [^<Q  m<!j9QR  [W5?Q
z  _kVܕOFLA  [                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      38989999                                                D      to                                                      D      38910000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  m ;t;eҕHNW  m}٪U7]J q! pmcHV2)g4ѧ K] KmpeRrmq !B !                                                                                                                                                                                                                                                                                                D      230                                                     D     0                                                       B  ^\Q6ԂSM  X=`-<]#y  ! O:-h}    aEֳ  !!  KX3vv{<>
Y ! !aqc}G΅> "! !D5 1 " "aيI!N\< #! "^<Q # #am<!j9QR $! #W5?Q
z $ $a_kVܕOFLA %! $                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      38992999                                                D      to                                                      D      38990000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   &!                                                        D      231                                                     D     0                                                       B  ^\Q6ԂSM ' =`-<]#y ($ 'O:-h} ( (dEֳ  )$ (KX3vv{<>
Y ) )dqc}G΅> *$ )D5 1 * *dيI!N\< +$ *^<Q + +dm<!j9QR ,$ +W5?Q
z , ,d_kVܕOFLA -$ ,                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Combitel Networks AS                                    D      operator                                                D      0                                                       D      	is_mobile                                               D      38993999                                                D      to                                                      D      38993000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   /                                                        B  >
s-x6 /' -d`+n[V 
) 
)1YVK۞2  ^/U3 m mc m#[0a{PB^T ki k)                                                                                                                                                                                                                                                                        D      232                                                     D     0                                                       B  ^\Q6ԂSM 1* %=`-<]#y 1 1jO:-h} 2* 1Eֳ  2 2jKX3vv{<>
Y 3* 2qc}G΅> 3 3jD5 1 4* 3يI!N\< 4 4j^<Q 5* 4m<!j9QR 5 5jW5?Q
z 6* 5_kVܕOFLA 6 6j                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      38994999                                                D      to                                                      D      38994000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   9-                                                        B  eB	7<[C 8 6.#^pe a aq
9BNSm !3 !G_Z $g) $f                                                                                                                                                                                                                                                                                                D      233                                                     D     0                                                       B  ^\Q6ԂSM : /g=`-<]#y ;0 :O:-h} ; ;pEֳ  <0 ;KX3vv{<>
Y < <pqc}G΅> =0 <D5 1 = =pيI!N\< >0 =^<Q > >pm<!j9QR ?0 >W5?Q
z ? ?p_kVܕOFLA @0 ?                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      38996999                                                D      to                                                      D      38995000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   A0                                                        D      234                                                     D     0                                                       B  ^\Q6ԂSM B 8=`-<]#y C3 BO:-h} C CsEֳ  D3 CKX3vv{<>
Y D Dsqc}G΅> E3 DD5 1 E EsيI!N\< F3 E^<Q F Fsm<!j9QR G3 FW5?Q
z G Gs_kVܕOFLA H3 G                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      	Comvie AS                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      38998999                                                D      to                                                      D      38997000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   I3                                                        D      235                                                     D     0                                                       B  ^\Q6ԂSM J @=`-<]#y K6 JO:-h} K KvEֳ  L6 KKX3vv{<>
Y L Lvqc}G΅> M6 LD5 1 M MvيI!N\< N6 M^<Q N Nvm<!j9QR O6 NW5?Q
z O Ov_kVܕOFLA P6 O                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      	Phonzo AS                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      38999999                                                D      to                                                      D      38999000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      
Vest-Agder                                              D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   Q6                                                        D      236                                                     D     0                                                       B  ^\Q6ԂSM R H=`-<]#y S9 RO:-h} S SyEֳ  T9 SKX3vv{<>
Y T Tyqc}G΅> U9 TD5 1 U UyيI!N\< V9 U^<Q V Vym<!j9QR W9 VW5?Q
z W Wy_kVܕOFLA X9 W                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      39999999                                                D      to                                                      D      39000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   Z                                                        B  S;YZ. Z< XySünCO VQ/T 
1 
1QSoKL-w9 #$I  SBehMa  DS}lr#ǖ) "H "SA,K84; "u "5SIMȞmscnE " "\                                                                                                                                                                                                                        D      237                                                     D     0                                                       B  ^\Q6ԂSM \? P=`-<]#y \ \O:-h} ]? \Eֳ  ] ]KX3vv{<>
Y ^? ]qc}G΅> ^ ^D5 1 _? ^يI!N\< _ _^<Q `? _m<!j9QR ` `W5?Q
z a? `_kVܕOFLA a a                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
NetCom GSM AS                                           D      operator                                                D      1                                                       D      	is_mobile                                               D      40019999                                                D      to                                                      D      40000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   b                                                        D      238                                                     D     0                                                       B  ^\Q6ԂSM dB Z|=`-<]#y d dO:-h} eB eEֳ  e eKX3vv{<>
Y fB fqc}G΅> f fD5 1 gB gيI!N\< g g^<Q hB hm<!j9QR h hW5?Q
z iB i_kVܕOFLA i i                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      1                                                       D      	is_mobile                                               D      40039999                                                D      to                                                      D      40020000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   lE                                                        B  U]gP)fPJ5 k jU
cA[
C5   |Uu!  UϜqĕA?MѡX  U|\']Ǔט q 1Ut<9;}	HЗ  Uo979^
!w i )UH;]a` % %[                                                                                                                                                                                                D      239                                                     D     0                                                       B  ^\Q6ԂSM m b=`-<]#y nH nO:-h} n nEֳ  oH oKX3vv{<>
Y o oqc}G΅> pH pD5 1 p pيI!N\< qH q^<Q q qm<!j9QR rH rW5?Q
z r r_kVܕOFLA sH s                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
Mobyson AS                                              D      operator                                                D      1                                                       D      	is_mobile                                               D      40049999                                                D      to                                                      D      40040000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   tH                                                        D      240                                                     D     0                                                       B  ^\Q6ԂSM u l=`-<]#y vK vO:-h} v vEֳ  wK wKX3vv{<>
Y w wqc}G΅> xK xD5 1 x xيI!N\< yK y^<Q y ym<!j9QR zK zW5?Q
z z z_kVܕOFLA {K {                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Telenordic Norge AS                                     D      operator                                                D      1                                                       D      	is_mobile                                               D      40099999                                                D      to                                                      D      40050000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   }                                                        B  @[mM }N {z2G6a /om q qxbMR΢i^ 3 ;^;*F !- !-                                                                                                                                                                                                                                                                                                D      241                                                     D     0                                                       B  ^\Q6ԂSM Q t=`-<]#y  O:-h} Q Eֳ   KX3vv{<>
Y Q qc}G΅>  D5 1 Q يI!N\<  ^<Q Q m<!j9QR  W5?Q
z Q _kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
NetCom GSM AS                                           D      operator                                                D      1                                                       D      	is_mobile                                               D      40119999                                                D      to                                                      D      40100000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      242                                                     D     0                                                       B  ^\Q6ԂSM T }=`-<]#y  O:-h} T Eֳ   KX3vv{<>
Y T qc}G΅>  D5 1 T يI!N\<  ^<Q T m<!j9QR  W5?Q
z T _kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      1                                                       D      	is_mobile                                               D      40139999                                                D      to                                                      D      40120000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   W                                                        B  p7VbWkѬZ  X.IbXmK_  W  ˶:=D6 {o {/                                                                                                                                                                                                                                                                                                                        D      243                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y Z O:-h}  Eֳ  Z KX3vv{<>
Y  qc}G΅> Z D5 1  يI!N\< Z ^<Q  m<!j9QR Z W5?Q
z  _kVܕOFLA Z                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
Mobyson AS                                              D      operator                                                D      1                                                       D      	is_mobile                                               D      40149999                                                D      to                                                      D      40140000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  ^tHDT ] y1Ҕ^ 	 	-+{(&8.| P                                                                                                                                                                                                                                                                                                                         D      244                                                     D     0                                                       B  ^\Q6ԂSM ` =`-<]#y  O:-h} `  Eֳ   KX3vv{<>
Y `  qc}G΅>  D5 1 `  يI!N\<  ^<Q `  m<!j9QR  W5?Q
z `  _kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Telenordic Norge AS                                     D      operator                                                D      1                                                       D      	is_mobile                                               D      40199999                                                D      to                                                      D      40150000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      245                                                     D     0                                                       B  ^\Q6ԂSM c =`-<]#y  O:-h} c #Eֳ   KX3vv{<>
Y c #qc}G΅>  D5 1 c #يI!N\<  ^<Q c #m<!j9QR  W5?Q
z c #_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Chess Communication AS                                  D      operator                                                D      1                                                       D      	is_mobile                                               D      40249999                                                D      to                                                      D      40200000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      246                                                     D     0                                                       B  ^\Q6ԂSM f =`-<]#y  O:-h} f &Eֳ   KX3vv{<>
Y f &qc}G΅>  D5 1 f &يI!N\<  ^<Q f &m<!j9QR  W5?Q
z f &_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Wireless Maingate AS                                    D      operator                                                D      1                                                       D      	is_mobile                                               D      40279999                                                D      to                                                      D      40250000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      247                                                     D     0                                                       B  ^\Q6ԂSM i =`-<]#y  O:-h} i )Eֳ   KX3vv{<>
Y i )qc}G΅>  D5 1 i )يI!N\<  ^<Q i )m<!j9QR  W5?Q
z i )_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Chess Communication AS                                  D      operator                                                D      1                                                       D      	is_mobile                                               D      40299999                                                D      to                                                      D      40280000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   l                                                        B  bm|**}i  )ba% 6                                                                                                                                                                                                                                                                                                                                                 D      248                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y o /O:-h}  Eֳ  o /KX3vv{<>
Y  qc}G΅> o /D5 1  يI!N\< o /^<Q  m<!j9QR o /W5?Q
z  _kVܕOFLA o /                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Chess Communication AS                                  D      operator                                                D      1                                                       D      	is_mobile                                               D      40349999                                                D      to                                                      D      40300000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   o                                                        D      249                                                     D     0                                                       B  ^\Q6ԂSM  ,=`-<]#y r 2O:-h}  ĲEֳ  r 2KX3vv{<>
Y  Ųqc}G΅> r 2D5 1  ƲيI!N\< r 2^<Q  ǲm<!j9QR r 2W5?Q
z  Ȳ_kVܕOFLA r 2                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Wireless Maingate AS                                    D      operator                                                D      1                                                       D      	is_mobile                                               D      40379999                                                D      to                                                      D      40350000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   r                                                        D      250                                                     D     0                                                       B  ^\Q6ԂSM  /=`-<]#y u 5O:-h}  ̵Eֳ  u 5KX3vv{<>
Y  ͵qc}G΅> u 5D5 1  εيI!N\< u 5^<Q  ϵm<!j9QR u 5W5?Q
z  е_kVܕOFLA u 5                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Chess Communication AS                                  D      operator                                                D      1                                                       D      	is_mobile                                               D      40399999                                                D      to                                                      D      40380000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   u                                                        D      251                                                     D     0                                                       B  ^\Q6ԂSM  2=`-<]#y x 8O:-h}  ԸEֳ  x 8KX3vv{<>
Y  ոqc}G΅> x 8D5 1  ָيI!N\< x 8^<Q  ׸m<!j9QR x 8W5?Q
z  ظ_kVܕOFLA x 8                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      1                                                       D      	is_mobile                                               D      40449999                                                D      to                                                      D      40400000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   x                                                        D      252                                                     D     0                                                       B  ^\Q6ԂSM  5=`-<]#y { ;O:-h}  ܻEֳ  { ;KX3vv{<>
Y  ݻqc}G΅> { ;D5 1  ޻يI!N\< { ;^<Q  ߻m<!j9QR { ;W5?Q
z  _kVܕOFLA { ;                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
NetCom GSM AS                                           D      operator                                                D      1                                                       D      	is_mobile                                               D      40499999                                                D      to                                                      D      40450000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   {                                                        D      253                                                     D     0                                                       B  ^\Q6ԂSM  8=`-<]#y ~ >O:-h}  Eֳ  ~ >KX3vv{<>
Y  qc}G΅> ~ >D5 1  يI!N\< ~ >^<Q  m<!j9QR ~ >W5?Q
z  _kVܕOFLA ~ >                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      1                                                       D      	is_mobile                                               D      40549999                                                D      to                                                      D      40500000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   ~                                                        D      254                                                     D     0                                                       B  ^\Q6ԂSM  ;=`-<]#y  AO:-h}  Eֳ   AKX3vv{<>
Y  qc}G΅>  AD5 1  يI!N\<  A^<Q  m<!j9QR  AW5?Q
z  _kVܕOFLA  A                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
NetCom GSM AS                                           D      operator                                                D      1                                                       D      	is_mobile                                               D      40599999                                                D      to                                                      D      40550000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      255                                                     D     0                                                       B  ^\Q6ԂSM  >=`-<]#y  DO:-h}  Eֳ   DKX3vv{<>
Y  qc}G΅>  DD5 1  يI!N\<  D^<Q  m<!j9QR  DW5?Q
z  _kVܕOFLA  D                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
NetCom GSM AS                                           D      operator                                                D      1                                                       D      	is_mobile                                               D      40649999                                                D      to                                                      D      40600000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      256                                                     D     0                                                       B  ^\Q6ԂSM  A=`-<]#y  GO:-h}  Eֳ   GKX3vv{<>
Y  qc}G΅>  GD5 1  يI!N\<  G^<Q 	  m<!j9QR 	  	 GW5?Q
z 	 	 _kVܕOFLA 	 	G                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Talkmore AS                                             D      operator                                                D      1                                                       D      	is_mobile                                               D      40669999                                                D      to                                                      D      40650000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	                                                        D      257                                                     D     0                                                       B  ^\Q6ԂSM 	
 D=`-<]#y 	 	JO:-h} 	
 	Eֳ  	 	JKX3vv{<>
Y 	
 	qc}G΅> 	 	JD5 1 	
 	يI!N\< 	 	J^<Q 	
 	m<!j9QR 	 	JW5?Q
z 		
 	_kVܕOFLA 		 		J                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
Vitel Tele AS                                           D      operator                                                D      1                                                       D      	is_mobile                                               D      40679999                                                D      to                                                      D      40670000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	
                                                        B  P.JAA"W 	 		Pu6-}/]6 7 PaICj"yڳ  PU??~#6s "^f "^&                                                                                                                                                                                                                                                                                                D      258                                                     D     0                                                       B  ^\Q6ԂSM 	
 	G=`-<]#y 	 	
O:-h} 	 	PEֳ  	 	KX3vv{<>
Y 	 	Pqc}G΅> 	 	D5 1 	 	PيI!N\< 	 	^<Q 	 	Pm<!j9QR 	 	W5?Q
z 	 	P_kVܕOFLA 	 	                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Choice Telenet AS                                       D      operator                                                D      1                                                       D      	is_mobile                                               D      40689999                                                D      to                                                      D      40680000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	                                                        D      259                                                     D     0                                                       B  ^\Q6ԂSM 	 	=`-<]#y 	 	O:-h} 	 	SEֳ  	 	KX3vv{<>
Y 	 	Sqc}G΅> 	 	D5 1 	 	SيI!N\< 	 	^<Q 	 	Sm<!j9QR 	 	W5?Q
z 	 	S_kVܕOFLA 	 	                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      40699999                                                D      to                                                      D      40690000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	                                                        D      260                                                     D     0                                                       B  ^\Q6ԂSM 	 	=`-<]#y 	 	O:-h} 	 	VEֳ  	 	KX3vv{<>
Y 	 	Vqc}G΅> 	  	D5 1 	  	 VيI!N\< 	! 	 ^<Q 	! 	!Vm<!j9QR 	" 	!W5?Q
z 	" 	"V_kVܕOFLA 	# 	"                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
NetCom GSM AS                                           D      operator                                                D      1                                                       D      	is_mobile                                               D      40799999                                                D      to                                                      D      40700000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	$                                                        D      261                                                     D     0                                                       B  ^\Q6ԂSM 	% 	=`-<]#y 	& 	%O:-h} 	& 	&YEֳ  	' 	&KX3vv{<>
Y 	' 	'Yqc}G΅> 	( 	'D5 1 	( 	(YيI!N\< 	) 	(^<Q 	) 	)Ym<!j9QR 	* 	)W5?Q
z 	* 	*Y_kVܕOFLA 	+ 	*                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      1                                                       D      	is_mobile                                               D      40824999                                                D      to                                                      D      40800000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	,                                                        D      262                                                     D     0                                                       B  ^\Q6ԂSM 	- 	#=`-<]#y 	. 	-O:-h} 	. 	.\Eֳ  	/ 	.KX3vv{<>
Y 	/ 	/\qc}G΅> 	0 	/D5 1 	0 	0\يI!N\< 	1 	0^<Q 	1 	1\m<!j9QR 	2 	1W5?Q
z 	2 	2\_kVܕOFLA 	3 	2                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Combitel Networks AS                                    D      operator                                                D      1                                                       D      	is_mobile                                               D      40839999                                                D      to                                                      D      40825000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	5                                                        B  qQ6m^ 	5 	3\+{B.퍢 
 
{{YuHm b "gD.˞OD  ތ#_:(~X J J]yƩNeF/ %?z %?:                                                                                                                                                                                                                                                D      263                                                     D     0                                                       B  ^\Q6ԂSM 	7" 	+=`-<]#y 	7 	7bO:-h} 	8" 	7Eֳ  	8 	8bKX3vv{<>
Y 	9" 	8qc}G΅> 	9 	9bD5 1 	:" 	9يI!N\< 	: 	:b^<Q 	;" 	:m<!j9QR 	; 	;bW5?Q
z 	<" 	;_kVܕOFLA 	< 	<b                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Telenordic Norge AS                                     D      operator                                                D      1                                                       D      	is_mobile                                               D      40899999                                                D      to                                                      D      40840000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	=                                                        D      264                                                     D     0                                                       B  ^\Q6ԂSM 	?% 	5_=`-<]#y 	? 	?eO:-h} 	@% 	?Eֳ  	@ 	@eKX3vv{<>
Y 	A% 	@qc}G΅> 	A 	AeD5 1 	B% 	AيI!N\< 	B 	Be^<Q 	C% 	Bm<!j9QR 	C 	CeW5?Q
z 	D% 	C_kVܕOFLA 	D 	De                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      1                                                       D      	is_mobile                                               D      40924999                                                D      to                                                      D      40900000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	G(                                                        B  iT4~Dj 	F 	Dlt~; Cu C5UBo+1^  Am$q'B='k S S_|kje!lz  
 */λ)WC; !* !=+|t #f #fʔ'
 $' $&                                                                                                                                                                                                D      265                                                     D     0                                                       B  ^\Q6ԂSM 	H 	=b=`-<]#y 	I+ 	HO:-h} 	I 	IkEֳ  	J+ 	IKX3vv{<>
Y 	J 	Jkqc}G΅> 	K+ 	JD5 1 	K 	KkيI!N\< 	L+ 	K^<Q 	L 	Lkm<!j9QR 	M+ 	LW5?Q
z 	M 	Mk_kVܕOFLA 	N+ 	M                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Combitel Networks AS                                    D      operator                                                D      1                                                       D      	is_mobile                                               D      40939999                                                D      to                                                      D      40925000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	O+                                                        D      266                                                     D     0                                                       B  ^\Q6ԂSM 	P 	F=`-<]#y 	Q. 	PO:-h} 	Q 	QnEֳ  	R. 	QKX3vv{<>
Y 	R 	Rnqc}G΅> 	S. 	RD5 1 	S 	SnيI!N\< 	T. 	S^<Q 	T 	Tnm<!j9QR 	U. 	TW5?Q
z 	U 	Un_kVܕOFLA 	V. 	U                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Telenordic Norge AS                                     D      operator                                                D      1                                                       D      	is_mobile                                               D      40999999                                                D      to                                                      D      40940000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	W.                                                        D      267                                                     D     0                                                       B  ^\Q6ԂSM 	X 	N=`-<]#y 	Y1 	XO:-h} 	Y 	YqEֳ  	Z1 	YKX3vv{<>
Y 	Z 	Zqqc}G΅> 	[1 	ZD5 1 	[ 	[qيI!N\< 	\1 	[^<Q 	\ 	\qm<!j9QR 	]1 	\W5?Q
z 	] 	]q_kVܕOFLA 	^1 	]                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Chess Communication AS                                  D      operator                                                D      1                                                       D      	is_mobile                                               D      41079999                                                D      to                                                      D      41000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	_1                                                        D      268                                                     D     0                                                       B  ^\Q6ԂSM 	` 	V=`-<]#y 	a4 	`O:-h} 	a 	atEֳ  	b4 	aKX3vv{<>
Y 	b 	btqc}G΅> 	c4 	bD5 1 	c 	ctيI!N\< 	d4 	c^<Q 	d 	dtm<!j9QR 	e4 	dW5?Q
z 	e 	et_kVܕOFLA 	f4 	e                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Chess Communication AS                                  D      operator                                                D      1                                                       D      	is_mobile                                               D      41099999                                                D      to                                                      D      41080000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	g4                                                        D      269                                                     D     0                                                       B  ^\Q6ԂSM 	h 	^=`-<]#y 	i7 	hO:-h} 	i 	iwEֳ  	j7 	iKX3vv{<>
Y 	j 	jwqc}G΅> 	k7 	jD5 1 	k 	kwيI!N\< 	l7 	k^<Q 	l 	lwm<!j9QR 	m7 	lW5?Q
z 	m 	mw_kVܕOFLA 	n7 	m                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Chess Communication AS                                  D      operator                                                D      1                                                       D      	is_mobile                                               D      41199999                                                D      to                                                      D      41100000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	o7                                                        D      270                                                     D     0                                                       B  ^\Q6ԂSM 	p 	f=`-<]#y 	q: 	pO:-h} 	q 	qzEֳ  	r: 	qKX3vv{<>
Y 	r 	rzqc}G΅> 	s: 	rD5 1 	s 	szيI!N\< 	t: 	s^<Q 	t 	tzm<!j9QR 	u: 	tW5?Q
z 	u 	uz_kVܕOFLA 	v: 	u                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Tele2 Norge AS                                          D      operator                                                D      1                                                       D      	is_mobile                                               D      41399999                                                D      to                                                      D      41200000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	w:                                                        D      271                                                     D     0                                                       B  ^\Q6ԂSM 	x 	n=`-<]#y 	y= 	xO:-h} 	y 	y}Eֳ  	z= 	yKX3vv{<>
Y 	z 	z}qc}G΅> 	{= 	zD5 1 	{ 	{}يI!N\< 	|= 	{^<Q 	| 	|}m<!j9QR 	}= 	|W5?Q
z 	} 	}}_kVܕOFLA 	~= 	}                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Telenor Mobil AS                                        D      operator                                                D      1                                                       D      	is_mobile                                               D      41799999                                                D      to                                                      D      41400000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	                                                        B  zaOl2Th 	@ 	~}zS1,n&A                                                                                                                                                                                                                                                                                                                                                  D      272                                                     D     0                                                       B  ^\Q6ԂSM 	C 	v=`-<]#y 	 	O:-h} 	C 	Eֳ  	 	KX3vv{<>
Y 	C 	qc}G΅> 	 	D5 1 	C 	يI!N\< 	 	^<Q 	C 	m<!j9QR 	 	W5?Q
z 	C 	_kVܕOFLA 	 	                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Chess Communication AS                                  D      operator                                                D      1                                                       D      	is_mobile                                               D      41839999                                                D      to                                                      D      41800000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	                                                        D      273                                                     D     0                                                       B  ^\Q6ԂSM 	F 	=`-<]#y 	 	O:-h} 	F 	Eֳ  	 	KX3vv{<>
Y 	F 	qc}G΅> 	 	D5 1 	F 	يI!N\< 	 	^<Q 	F 	m<!j9QR 	 	W5?Q
z 	F 	_kVܕOFLA 	 	                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Telenor Mobil AS                                        D      operator                                                D      1                                                       D      	is_mobile                                               D      41859999                                                D      to                                                      D      41840000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	                                                        D      274                                                     D     0                                                       B  ^\Q6ԂSM 	I 	=`-<]#y 	 	O:-h} 	I 		Eֳ  	 	KX3vv{<>
Y 	I 		qc}G΅> 	 	D5 1 	I 		يI!N\< 	 	^<Q 	I 		m<!j9QR 	 	W5?Q
z 	I 		_kVܕOFLA 	 	                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      	Bellit AS                                               D      operator                                                D      1                                                       D      	is_mobile                                               D      41899999                                                D      to                                                      D      41860000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	                                                        D      275                                                     D     0                                                       B  ^\Q6ԂSM 	L 	=`-<]#y 	 	O:-h} 	L 	Eֳ  	 	KX3vv{<>
Y 	L 	qc}G΅> 	 	D5 1 	L 	يI!N\< 	 	^<Q 	L 	m<!j9QR 	 	W5?Q
z 	L 	_kVܕOFLA 	 	                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Chess Communication AS                                  D      operator                                                D      1                                                       D      	is_mobile                                               D      41999999                                                D      to                                                      D      41900000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	O                                                        B  ێ:$ E) 	 	ۅYa	=β Z rK@^d  zWj}$SW_)괺Ǉ "~r "~2+Ak/x`@ # #ֳ                                                                                                                                                                                                                                                                        D      276                                                     D     0                                                       B  ^\Q6ԂSM 	 	=`-<]#y 	R 	O:-h} 	 	Eֳ  	R 	KX3vv{<>
Y 	 	qc}G΅> 	R 	D5 1 	 	يI!N\< 	R 	^<Q 	 	m<!j9QR 	R 	W5?Q
z 	 	_kVܕOFLA 	R 	                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      42999999                                                D      to                                                      D      42000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	R                                                        D      277                                                     D     0                                                       B  ^\Q6ԂSM 	 	=`-<]#y 	U 	O:-h} 	 	Eֳ  	U 	KX3vv{<>
Y 	 	qc}G΅> 	U 	D5 1 	 	يI!N\< 	U 	^<Q 	 	m<!j9QR 	U 	W5?Q
z 	 	_kVܕOFLA 	U 	                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      43999999                                                D      to                                                      D      43000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	U                                                        D      278                                                     D     0                                                       B  ^\Q6ԂSM 	 	=`-<]#y 	X 	O:-h} 	 	Eֳ  	X 	KX3vv{<>
Y 	 	qc}G΅> 	X 	D5 1 	 	يI!N\< 	X 	^<Q 	 	m<!j9QR 	X 	W5?Q
z 	 	_kVܕOFLA 	X 	                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      44999999                                                D      to                                                      D      44000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	X                                                        D      279                                                     D     0                                                       B  ^\Q6ԂSM 	 	=`-<]#y 	[ 	O:-h} 	 	Eֳ  	[ 	KX3vv{<>
Y 	 	qc}G΅> 	[ 	D5 1 	 	يI!N\< 	[ 	^<Q 	 	m<!j9QR 	[ 	W5?Q
z 	 	_kVܕOFLA 	[ 	                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Chess Communication AS                                  D      operator                                                D      1                                                       D      	is_mobile                                               D      45199999                                                D      to                                                      D      45000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	[                                                        D      280                                                     D     0                                                       B  ^\Q6ԂSM 	 	=`-<]#y 	^ 	O:-h} 	 	ĞEֳ  	^ 	KX3vv{<>
Y 	 	Şqc}G΅> 	^ 	D5 1 	 	ƞيI!N\< 	^ 	^<Q 	 	Ǟm<!j9QR 	^ 	W5?Q
z 	 	Ȟ_kVܕOFLA 	^ 	                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
NetCom GSM AS                                           D      operator                                                D      1                                                       D      	is_mobile                                               D      45599999                                                D      to                                                      D      45200000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	^                                                        D      281                                                     D     0                                                       B  ^\Q6ԂSM 	 	=`-<]#y 	a 	!O:-h} 	 	̡Eֳ  	a 	!KX3vv{<>
Y 	 	͡qc}G΅> 	a 	!D5 1 	 	ΡيI!N\< 	a 	!^<Q 	 	ϡm<!j9QR 	a 	!W5?Q
z 	 	С_kVܕOFLA 	a 	!                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      ACN Norge AS                                            D      operator                                                D      1                                                       D      	is_mobile                                               D      45659999                                                D      to                                                      D      45600000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	                                                        B  jƉëe 	d 	ѡjʗ \h h#_f(c  jԀW=::EK @G @jpf|%fi  E  E]j/jmk?0!P # #                                                                                                                                                                                                                                                                        D      282                                                     D     0                                                       B  ^\Q6ԂSM 	g 	=`-<]#y 	 	էO:-h} 	g 	'Eֳ  	 	֧KX3vv{<>
Y 	g 	'qc}G΅> 	 	קD5 1 	g 	'يI!N\< 	 	ا^<Q 	g 	'm<!j9QR 	 	٧W5?Q
z 	g 	'_kVܕOFLA 	 	ڧ                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Chess Communication AS                                  D      operator                                                D      1                                                       D      	is_mobile                                               D      45699999                                                D      to                                                      D      45660000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	                                                        D      283                                                     D     0                                                       B  ^\Q6ԂSM 	j 	Ӥ=`-<]#y 	 	ݪO:-h} 	j 	*Eֳ  	 	ުKX3vv{<>
Y 	j 	*qc}G΅> 	 	ߪD5 1 	j 	*يI!N\< 	 	^<Q 	j 	*m<!j9QR 	 	W5?Q
z 	j 	*_kVܕOFLA 	 	                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      ACN Norge AS                                            D      operator                                                D      1                                                       D      	is_mobile                                               D      45759999                                                D      to                                                      D      45700000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	m                                                        B  F*ivWS >GB 	 	*F*i˵+  VF&1X/@&tc@ #& #&q                                                                                                                                                                                                                                                                                                                        D      284                                                     D     0                                                       B  ^\Q6ԂSM 	 	ۧ=`-<]#y 	p 	0O:-h} 	 	Eֳ  	p 	0KX3vv{<>
Y 	 	qc}G΅> 	p 	0D5 1 	 	يI!N\< 	p 	0^<Q 	 	m<!j9QR 	p 	0W5?Q
z 	 	_kVܕOFLA 	p 	0                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Chess Communication AS                                  D      operator                                                D      1                                                       D      	is_mobile                                               D      45799999                                                D      to                                                      D      45760000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	p                                                        D      285                                                     D     0                                                       B  ^\Q6ԂSM 	 	-=`-<]#y 	s 	3O:-h} 	 	Eֳ  	s 	3KX3vv{<>
Y 	 	qc}G΅> 	s 	3D5 1 	 	يI!N\< 	s 	3^<Q 	 	m<!j9QR 	s 	3W5?Q
z 	 	_kVܕOFLA 	s 	3                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
Mobyson AS                                              D      operator                                                D      1                                                       D      	is_mobile                                               D      45809999                                                D      to                                                      D      45800000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	s                                                        D      286                                                     D     0                                                       B  ^\Q6ԂSM 	 	0=`-<]#y 	v 	6O:-h} 	 	Eֳ  	v 	6KX3vv{<>
Y 	 	qc}G΅> 	v 	6D5 1 	 	يI!N\< 	v 	6^<Q 	 	m<!j9QR 	v 	6W5?Q
z 	 	_kVܕOFLA 	v 	6                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
Mobyson AS                                              D      operator                                                D      1                                                       D      	is_mobile                                               D      45829999                                                D      to                                                      D      45810000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   	v                                                        D      287                                                     D     0                                                       B  ^\Q6ԂSM 	 	3=`-<]#y 	y 	9O:-h} 	 	Eֳ  
 y 
 9KX3vv{<>
Y 
  
 qc}G΅> 
y 
9D5 1 
 
يI!N\< 
y 
9^<Q 
 
m<!j9QR 
y 
9W5?Q
z 
 
_kVܕOFLA 
y 
9                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Newphone Norge AS                                       D      operator                                                D      1                                                       D      	is_mobile                                               D      45849999                                                D      to                                                      D      45830000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        B  HۈʸV7I> 
| 
H/Ezt ^g`  c                                                                                                                                                                                                                                                                                                                                                D      288                                                     D     0                                                       B  ^\Q6ԂSM 
 	6=`-<]#y 
 
O:-h} 
	 
	?Eֳ  
	 
	KX3vv{<>
Y 

 

?qc}G΅> 

 

D5 1 
 
?يI!N\< 
 
^<Q 
 
?m<!j9QR 
 
W5?Q
z 

 

?_kVܕOFLA 

 

                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
Mobyson AS                                              D      operator                                                D      1                                                       D      	is_mobile                                               D      45859999                                                D      to                                                      D      45850000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        B  h $( 
 
?ZC*\%=`qg# !< !                                                                                                                                                                                                                                                                                                                                                D      289                                                     D     0                                                       B  ^\Q6ԂSM 
 
=`-<]#y 
 
EO:-h} 
 
Eֳ  
 
EKX3vv{<>
Y 
 
qc}G΅> 
 
ED5 1 
 
يI!N\< 
 
E^<Q 
 
m<!j9QR 
 
EW5?Q
z 
 
_kVܕOFLA 
 
E                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
NetCom GSM AS                                           D      operator                                                D      1                                                       D      	is_mobile                                               D      45869999                                                D      to                                                      D      45860000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        B  *\dТ:7 
 
2MЍT - K웅+
T./9 g '
G0lF; r rl                                                                                                                                                                                                                                                                                                D      290                                                     D     0                                                       B  ^\Q6ԂSM 
 
B=`-<]#y 
 
O:-h} 
 
KEֳ  
 
KX3vv{<>
Y 
 
Kqc}G΅> 
 
D5 1 
 
KيI!N\< 
 
^<Q 
 
Km<!j9QR 
  
W5?Q
z 
  
 K_kVܕOFLA 
! 
                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      1                                                       D      	is_mobile                                               D      45879999                                                D      to                                                      D      45870000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
"                                                        D      291                                                     D     0                                                       B  ^\Q6ԂSM 
# 
=`-<]#y 
$ 
#O:-h} 
$ 
$NEֳ  
% 
$KX3vv{<>
Y 
% 
%Nqc}G΅> 
& 
%D5 1 
& 
&NيI!N\< 
' 
&^<Q 
' 
'Nm<!j9QR 
( 
'W5?Q
z 
( 
(N_kVܕOFLA 
) 
(                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
Mobyson AS                                              D      operator                                                D      1                                                       D      	is_mobile                                               D      45889999                                                D      to                                                      D      45880000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
*                                                        D      292                                                     D     0                                                       B  ^\Q6ԂSM 
+ 
!=`-<]#y 
, 
+O:-h} 
, 
,QEֳ  
- 
,KX3vv{<>
Y 
- 
-Qqc}G΅> 
. 
-D5 1 
. 
.QيI!N\< 
/ 
.^<Q 
/ 
/Qm<!j9QR 
0 
/W5?Q
z 
0 
0Q_kVܕOFLA 
1 
0                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Telenordic Norge AS                                     D      operator                                                D      1                                                       D      	is_mobile                                               D      45899999                                                D      to                                                      D      45890000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
2                                                        D      293                                                     D     0                                                       B  ^\Q6ԂSM 
3 
)=`-<]#y 
4 
3O:-h} 
4 
4TEֳ  
5 
4KX3vv{<>
Y 
5 
5Tqc}G΅> 
6 
5D5 1 
6 
6TيI!N\< 
7 
6^<Q 
7 
7Tm<!j9QR 
8 
7W5?Q
z 
8 
8T_kVܕOFLA 
9 
8                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
Vitel Tele AS                                           D      operator                                                D      1                                                       D      	is_mobile                                               D      45909999                                                D      to                                                      D      45900000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
:                                                        D      294                                                     D     0                                                       B  ^\Q6ԂSM 
; 
1=`-<]#y 
< 
;O:-h} 
< 
<WEֳ  
= 
<KX3vv{<>
Y 
= 
=Wqc}G΅> 
> 
=D5 1 
> 
>WيI!N\< 
? 
>^<Q 
? 
?Wm<!j9QR 
@ 
?W5?Q
z 
@ 
@W_kVܕOFLA 
A 
@                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Choice Telenet AS                                       D      operator                                                D      1                                                       D      	is_mobile                                               D      45919999                                                D      to                                                      D      45910000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
C                                                        B  I/<ꤖd 
C 
AWInᮠeX 觹( 
> 
II?gYOǑ* hZ hIɭDNpB0                                                                                                                                                                                                                                                                                                  D      295                                                     D     0                                                       B  ^\Q6ԂSM 
E 
9=`-<]#y 
E 
E]O:-h} 
F 
EEֳ  
F 
F]KX3vv{<>
Y 
G 
Fqc}G΅> 
G 
G]D5 1 
H 
GيI!N\< 
H 
H]^<Q 
I 
Hm<!j9QR 
I 
I]W5?Q
z 
J 
I_kVܕOFLA 
J 
J]                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      45929999                                                D      to                                                      D      45920000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
K                                                        D      296                                                     D     0                                                       B  ^\Q6ԂSM 
M  
CZ=`-<]#y 
M 
M`O:-h} 
N  
MEֳ  
N 
N`KX3vv{<>
Y 
O  
Nqc}G΅> 
O 
O`D5 1 
P  
OيI!N\< 
P 
P`^<Q 
Q  
Pm<!j9QR 
Q 
Q`W5?Q
z 
R  
Q_kVܕOFLA 
R 
R`                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Newphone Norge AS                                       D      operator                                                D      1                                                       D      	is_mobile                                               D      45949999                                                D      to                                                      D      45930000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
S                                                        D      297                                                     D     0                                                       B  ^\Q6ԂSM 
U# 
K]=`-<]#y 
U 
UcO:-h} 
V# 
UEֳ  
V 
VcKX3vv{<>
Y 
W# 
Vqc}G΅> 
W 
WcD5 1 
X# 
WيI!N\< 
X 
Xc^<Q 
Y# 
Xm<!j9QR 
Y 
YcW5?Q
z 
Z# 
Y_kVܕOFLA 
Z 
Zc                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
Mobyson AS                                              D      operator                                                D      1                                                       D      	is_mobile                                               D      45959999                                                D      to                                                      D      45950000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
[                                                        D      298                                                     D     0                                                       B  ^\Q6ԂSM 
]& 
S`=`-<]#y 
] 
]fO:-h} 
^& 
]Eֳ  
^ 
^fKX3vv{<>
Y 
_& 
^qc}G΅> 
_ 
_fD5 1 
`& 
_يI!N\< 
` 
`f^<Q 
a& 
`m<!j9QR 
a 
afW5?Q
z 
b& 
a_kVܕOFLA 
b 
bf                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
NetCom GSM AS                                           D      operator                                                D      1                                                       D      	is_mobile                                               D      45969999                                                D      to                                                      D      45960000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
e)                                                        B  
90[ҳ.Y 
d 
b7xWBPھ#  W^7eh<- wB " N;w\Mq-v c cP5̩@V6> !^ !]                                                                                                                                                                                                                                                                        D      299                                                     D     0                                                       B  ^\Q6ԂSM 
f 
[c=`-<]#y 
g, 
fO:-h} 
g 
glEֳ  
h, 
gKX3vv{<>
Y 
h 
hlqc}G΅> 
i, 
hD5 1 
i 
ilيI!N\< 
j, 
i^<Q 
j 
jlm<!j9QR 
k, 
jW5?Q
z 
k 
kl_kVܕOFLA 
l, 
k                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      1                                                       D      	is_mobile                                               D      45979999                                                D      to                                                      D      45970000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
n                                                        B  JME 50 
n/ 
llX[+bJ:Za XT X1'>P~`@}E	 `W `a⎾>vK5i Q QǻXó7uӂr 0                                                                                                                                                                                                                                                                         D      300                                                     D     0                                                       B  ^\Q6ԂSM 
p2 
d=`-<]#y 
p 
prO:-h} 
q2 
pEֳ  
q 
qrKX3vv{<>
Y 
r2 
qqc}G΅> 
r 
rrD5 1 
s2 
rيI!N\< 
s 
sr^<Q 
t2 
sm<!j9QR 
t 
trW5?Q
z 
u2 
t_kVܕOFLA 
u 
ur                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
Mobyson AS                                              D      operator                                                D      1                                                       D      	is_mobile                                               D      45989999                                                D      to                                                      D      45980000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
v                                                        D      301                                                     D     0                                                       B  ^\Q6ԂSM 
x5 
no=`-<]#y 
x 
xuO:-h} 
y5 
xEֳ  
y 
yuKX3vv{<>
Y 
z5 
yqc}G΅> 
z 
zuD5 1 
{5 
zيI!N\< 
{ 
{u^<Q 
|5 
{m<!j9QR 
| 
|uW5?Q
z 
}5 
|_kVܕOFLA 
} 
}u                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Telenordic Norge AS                                     D      operator                                                D      1                                                       D      	is_mobile                                               D      45999999                                                D      to                                                      D      45990000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
~                                                        D      302                                                     D     0                                                       B  ^\Q6ԂSM 
8 
vr=`-<]#y 
 
xO:-h} 
8 
Eֳ  
 
xKX3vv{<>
Y 
8 
qc}G΅> 
 
xD5 1 
8 
يI!N\< 
 
x^<Q 
8 
m<!j9QR 
 
xW5?Q
z 
8 
_kVܕOFLA 
 
x                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Teletopia Gruppen AS                                    D      operator                                                D      1                                                       D      	is_mobile                                               D      46159999                                                D      to                                                      D      46000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        D      303                                                     D     0                                                       B  ^\Q6ԂSM 
; 
~u=`-<]#y 
 
{O:-h} 
; 
Eֳ  
 
{KX3vv{<>
Y 
; 
qc}G΅> 
 
{D5 1 
; 
يI!N\< 
 
{^<Q 
; 
m<!j9QR 
 
{W5?Q
z 
; 
_kVܕOFLA 
 
{                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      46369999                                                D      to                                                      D      46160000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        D      304                                                     D     0                                                       B  ^\Q6ԂSM 
> 
x=`-<]#y 
 
~O:-h} 
> 
Eֳ  
 
~KX3vv{<>
Y 
> 
qc}G΅> 
 
~D5 1 
> 
يI!N\< 
 
~^<Q 
> 
m<!j9QR 
 
~W5?Q
z 
> 
_kVܕOFLA 
 
~                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Chess Communication AS                                  D      operator                                                D      1                                                       D      	is_mobile                                               D      46399999                                                D      to                                                      D      46370000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        D      305                                                     D     0                                                       B  ^\Q6ԂSM 
A 
{=`-<]#y 
 
O:-h} 
A 
Eֳ  
 
KX3vv{<>
Y 
A 
qc}G΅> 
 
D5 1 
A 
يI!N\< 
 
^<Q 
A 
m<!j9QR 
 
W5?Q
z 
A 
_kVܕOFLA 
 
                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
NetCom GSM AS                                           D      operator                                                D      1                                                       D      	is_mobile                                               D      46639999                                                D      to                                                      D      46400000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
D                                                        B  sIWT;W.(A 
 
6.=ǁ:gO
  'F<D.+= +X +                                                                                                                                                                                                                                                                                                                        D      306                                                     D     0                                                       B  ^\Q6ԂSM 
 
~=`-<]#y 
G 
O:-h} 
 
Eֳ  
G 
KX3vv{<>
Y 
 
qc}G΅> 
G 
D5 1 
 
يI!N\< 
G 
^<Q 
 
m<!j9QR 
G 
W5?Q
z 
 
_kVܕOFLA 
G 
                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      One Call AS                                             D      operator                                                D      1                                                       D      	is_mobile                                               D      46659999                                                D      to                                                      D      46640000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
G                                                        D      307                                                     D     0                                                       B  ^\Q6ԂSM 
 
=`-<]#y 
J 

O:-h} 
 
Eֳ  
J 

KX3vv{<>
Y 
 
qc}G΅> 
J 

D5 1 
 
يI!N\< 
J 

^<Q 
 
m<!j9QR 
J 

W5?Q
z 
 
_kVܕOFLA 
J 

                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Talkmore AS                                             D      operator                                                D      1                                                       D      	is_mobile                                               D      46679999                                                D      to                                                      D      46660000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
J                                                        D      308                                                     D     0                                                       B  ^\Q6ԂSM 
 
=`-<]#y 
M 

O:-h} 
 
Eֳ  
M 

KX3vv{<>
Y 
 
qc}G΅> 
M 

D5 1 
 
يI!N\< 
M 

^<Q 
 
m<!j9QR 
M 

W5?Q
z 
 
_kVܕOFLA 
M 

                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      One Call AS                                             D      operator                                                D      1                                                       D      	is_mobile                                               D      46699999                                                D      to                                                      D      46680000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
M                                                        D      309                                                     D     0                                                       B  ^\Q6ԂSM 
 

=`-<]#y 
P 
O:-h} 
 
Eֳ  
P 
KX3vv{<>
Y 
 
qc}G΅> 
P 
D5 1 
 
يI!N\< 
P 
^<Q 
 
m<!j9QR 
P 
W5?Q
z 
 
_kVܕOFLA 
P 
                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
NetCom GSM AS                                           D      operator                                                D      1                                                       D      	is_mobile                                               D      46759999                                                D      to                                                      D      46700000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
P                                                        D      310                                                     D     0                                                       B  ^\Q6ԂSM 
 

=`-<]#y 
S 
O:-h} 
 
Eֳ  
S 
KX3vv{<>
Y 
 
Óqc}G΅> 
S 
D5 1 
 
ēيI!N\< 
S 
^<Q 
 
œm<!j9QR 
S 
W5?Q
z 
 
Ɠ_kVܕOFLA 
S 
                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Talkmore AS                                             D      operator                                                D      1                                                       D      	is_mobile                                               D      46779999                                                D      to                                                      D      46760000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
S                                                        D      311                                                     D     0                                                       B  ^\Q6ԂSM 
 
=`-<]#y 
V 
O:-h} 
 
ʖEֳ  
V 
KX3vv{<>
Y 
 
˖qc}G΅> 
V 
D5 1 
 
̖يI!N\< 
V 
^<Q 
 
͖m<!j9QR 
V 
W5?Q
z 
 
Ζ_kVܕOFLA 
V 
                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      One Call AS                                             D      operator                                                D      1                                                       D      	is_mobile                                               D      46799999                                                D      to                                                      D      46780000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        B  
AR´:׋k6ly 
Y 
ϖU_kATK! r  q                                                                                                                                                                                                                                                                                                                                                D      312                                                     D     0                                                       B  ^\Q6ԂSM 
\ 
=`-<]#y 
 
ӜO:-h} 
\ 
Eֳ  
 
ԜKX3vv{<>
Y 
\ 
qc}G΅> 
 
՜D5 1 
\ 
يI!N\< 
 
֜^<Q 
\ 
m<!j9QR 
 
לW5?Q
z 
\ 
_kVܕOFLA 
 
؜                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Telenor Mobil AS                                        D      operator                                                D      1                                                       D      	is_mobile                                               D      46899999                                                D      to                                                      D      46800000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        D      313                                                     D     0                                                       B  ^\Q6ԂSM 
_ 
љ=`-<]#y 
 
۟O:-h} 
_ 
Eֳ  
 
ܟKX3vv{<>
Y 
_ 
qc}G΅> 
 
ݟD5 1 
_ 
يI!N\< 
 
ޟ^<Q 
_ 
m<!j9QR 
 
ߟW5?Q
z 
_ 
_kVܕOFLA 
 
                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Telenor Mobil AS                                        D      operator                                                D      1                                                       D      	is_mobile                                               D      46969999                                                D      to                                                      D      46900000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        D      314                                                     D     0                                                       B  ^\Q6ԂSM 
b 
ٜ=`-<]#y 
 
O:-h} 
b 
"Eֳ  
 
KX3vv{<>
Y 
b 
"qc}G΅> 
 
D5 1 
b 
"يI!N\< 
 
^<Q 
b 
"m<!j9QR 
 
W5?Q
z 
b 
"_kVܕOFLA 
 
                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      46999999                                                D      to                                                      D      46970000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        D      315                                                     D     0                                                       B  ^\Q6ԂSM 
e 
=`-<]#y 
 
O:-h} 
e 
%Eֳ  
 
KX3vv{<>
Y 
e 
%qc}G΅> 
 
D5 1 
e 
%يI!N\< 
 
^<Q 
e 
%m<!j9QR 
 
W5?Q
z 
e 
%_kVܕOFLA 
 
                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Chess Communication AS                                  D      operator                                                D      1                                                       D      	is_mobile                                               D      47139999                                                D      to                                                      D      47000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
h                                                        B  ?J #%i
 
 
%?犊_ڙޕ09@B $P $                                                                                                                                                                                                                                                                                                                                                D      316                                                     D     0                                                       B  ^\Q6ԂSM 
 
=`-<]#y 
k 
+O:-h} 
 
Eֳ  
k 
+KX3vv{<>
Y 
 
qc}G΅> 
k 
+D5 1 
 
يI!N\< 
k 
+^<Q 
 
m<!j9QR 
k 
+W5?Q
z 
 
_kVܕOFLA 
k 
+                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Chess Communication AS                                  D      operator                                                D      1                                                       D      	is_mobile                                               D      47179999                                                D      to                                                      D      47140000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        B  [*]R-- 
n 
[i˃]@8is^  E                                                                                                                                                                                                                                                                                                                                                D      317                                                     D     0                                                       B  ^\Q6ԂSM 
q 
(=`-<]#y 
 
O:-h} 
q 
1Eֳ  
 
KX3vv{<>
Y  q  1qc}G΅>    D5 1 q 1يI!N\<  ^<Q q 1m<!j9QR  W5?Q
z q 1_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Chess Communication AS                                  D      operator                                                D      1                                                       D      	is_mobile                                               D      47199999                                                D      to                                                      D      47180000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      318                                                     D     0                                                       B  ^\Q6ԂSM t 
=`-<]#y  O:-h} t 4Eֳ   KX3vv{<>
Y t 4qc}G΅>  D5 1 	t 	4يI!N\< 	 	^<Q 
t 
4m<!j9QR 
 
W5?Q
z t 4_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Newphone Norge AS                                       D      operator                                                D      1                                                       D      	is_mobile                                               D      47229999                                                D      to                                                      D      47200000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      319                                                     D     0                                                       B  ^\Q6ԂSM w =`-<]#y  O:-h} w 7Eֳ   KX3vv{<>
Y w 7qc}G΅>  D5 1 w 7يI!N\<  ^<Q w 7m<!j9QR  W5?Q
z w 7_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Tele2 Norge AS                                          D      operator                                                D      1                                                       D      	is_mobile                                               D      47399999                                                D      to                                                      D      47230000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      320                                                     D     0                                                       B  ^\Q6ԂSM z =`-<]#y  O:-h} z :Eֳ   KX3vv{<>
Y z :qc}G΅>  D5 1 z :يI!N\<  ^<Q z :m<!j9QR  W5?Q
z z :_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Chess Communication AS                                  D      operator                                                D      1                                                       D      	is_mobile                                               D      47439999                                                D      to                                                      D      47400000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      321                                                     D     0                                                       B  ^\Q6ԂSM } =`-<]#y  O:-h} } =Eֳ   KX3vv{<>
Y  }  =qc}G΅>    D5 1 !} !=يI!N\< ! !^<Q "} "=m<!j9QR " "W5?Q
z #} #=_kVܕOFLA # #                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Chess Communication AS                                  D      operator                                                D      1                                                       D      	is_mobile                                               D      47449999                                                D      to                                                      D      47440000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   $                                                        D      322                                                     D     0                                                       B  ^\Q6ԂSM & =`-<]#y '  &O:-h} ' '@Eֳ  (  'KX3vv{<>
Y ( (@qc}G΅> )  (D5 1 ) )@يI!N\< *  )^<Q * *@m<!j9QR +  *W5?Q
z + +@_kVܕOFLA ,  +                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      1                                                       D      	is_mobile                                               D      47499999                                                D      to                                                      D      47450000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   -                                                         D      323                                                     D     0                                                       B  ^\Q6ԂSM . $=`-<]#y / .O:-h} / /CEֳ  0 /KX3vv{<>
Y 0 0Cqc}G΅> 1 0D5 1 1 1CيI!N\< 2 1^<Q 2 2Cm<!j9QR 3 2W5?Q
z 3 3C_kVܕOFLA 4 3                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Lyse Tele AS                                            D      operator                                                D      1                                                       D      	is_mobile                                               D      47599999                                                D      to                                                      D      47500000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   5                                                        D      324                                                     D     0                                                       B  ^\Q6ԂSM 6 ,=`-<]#y 7 6O:-h} 7 7FEֳ  8 7KX3vv{<>
Y 8 8Fqc}G΅> 9 8D5 1 9 9FيI!N\< : 9^<Q : :Fm<!j9QR ; :W5?Q
z ; ;F_kVܕOFLA < ;                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Telenor Mobil AS                                        D      operator                                                D      1                                                       D      	is_mobile                                               D      47769999                                                D      to                                                      D      47600000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   >                                                        B  \}FmnɢO >	 <F,S߁ٛ $  x[KB v 6                                                                                                                                                                                                                                                                                                                        D      325                                                     D     0                                                       B  ^\Q6ԂSM @ 4=`-<]#y @ @LO:-h} A @Eֳ  A ALKX3vv{<>
Y B Aqc}G΅> B BLD5 1 C BيI!N\< C CL^<Q D Cm<!j9QR D DLW5?Q
z E D_kVܕOFLA E EL                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      1                                                       D      	is_mobile                                               D      47779999                                                D      to                                                      D      47770000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   F                                                        D      326                                                     D     0                                                       B  ^\Q6ԂSM H >I=`-<]#y H HOO:-h} I HEֳ  I IOKX3vv{<>
Y J Iqc}G΅> J JOD5 1 K JيI!N\< K KO^<Q L Km<!j9QR L LOW5?Q
z M L_kVܕOFLA M MO                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
NetCom GSM AS                                           D      operator                                                D      1                                                       D      	is_mobile                                               D      47789999                                                D      to                                                      D      47780000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   P                                                        B  :#R2<5)P O Mϸn-ehuU| | <~3W    Փ                                                                                                                                                                                                                                                                                                                        D      327                                                     D     0                                                       B  ^\Q6ԂSM Q FL=`-<]#y R QO:-h} R RUEֳ  S RKX3vv{<>
Y S SUqc}G΅> T SD5 1 T TUيI!N\< U T^<Q U UUm<!j9QR V UW5?Q
z V VU_kVܕOFLA W V                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      ACN Norge AS                                            D      operator                                                D      1                                                       D      	is_mobile                                               D      47799999                                                D      to                                                      D      47790000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   Y                                                        B   i,;Y&}^ϬS(l Y WU:hT_  T͉I
 5Gr+  " "J                                                                                                                                                                                                                                                                                                                        D      328                                                     D     0                                                       B  ^\Q6ԂSM [ O=`-<]#y [ [[O:-h} \ [Eֳ  \ \[KX3vv{<>
Y ] \qc}G΅> ] ][D5 1 ^ ]يI!N\< ^ ^[^<Q _ ^m<!j9QR _ _[W5?Q
z ` __kVܕOFLA ` `[                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Telenor Mobil AS                                        D      operator                                                D      1                                                       D      	is_mobile                                               D      47899999                                                D      to                                                      D      47800000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   a                                                        D      329                                                     D     0                                                       B  ^\Q6ԂSM c YX=`-<]#y c c^O:-h} d cEֳ  d d^KX3vv{<>
Y e dqc}G΅> e e^D5 1 f eيI!N\< f f^^<Q g fm<!j9QR g g^W5?Q
z h g_kVܕOFLA h h^                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Telenor Mobil AS                                        D      operator                                                D      1                                                       D      	is_mobile                                               D      47909999                                                D      to                                                      D      47900000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   i                                                        D      330                                                     D     0                                                       B  ^\Q6ԂSM k! a[=`-<]#y k kaO:-h} l! kEֳ  l laKX3vv{<>
Y m! lqc}G΅> m maD5 1 n! mيI!N\< n na^<Q o! nm<!j9QR o oaW5?Q
z p! o_kVܕOFLA p pa                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Network Norway AS                                       D      operator                                                D      1                                                       D      	is_mobile                                               D      47939999                                                D      to                                                      D      47910000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   q                                                        D      331                                                     D     0                                                       B  ^\Q6ԂSM s$ i^=`-<]#y s sdO:-h} t$ sEֳ  t tdKX3vv{<>
Y u$ tqc}G΅> u udD5 1 v$ uيI!N\< v vd^<Q w$ vm<!j9QR w wdW5?Q
z x$ w_kVܕOFLA x xd                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Barablu Mobile Norway Ltd.                              D      operator                                                D      1                                                       D      	is_mobile                                               D      47969999                                                D      to                                                      D      47940000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   y                                                        D      332                                                     D     0                                                       B  ^\Q6ԂSM {' qa=`-<]#y { {gO:-h} |' {Eֳ  | |gKX3vv{<>
Y }' |qc}G΅> } }gD5 1 ~' }يI!N\< ~ ~g^<Q ' ~m<!j9QR  gW5?Q
z ' _kVܕOFLA  g                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Telio Telecom AS                                        D      operator                                                D      1                                                       D      	is_mobile                                               D      47979999                                                D      to                                                      D      47970000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      333                                                     D     0                                                       B  ^\Q6ԂSM * yd=`-<]#y  jO:-h} * Eֳ   jKX3vv{<>
Y * qc}G΅>  jD5 1 * يI!N\<  j^<Q * m<!j9QR  jW5?Q
z * _kVܕOFLA  j                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Telenor Cinclus AS                                      D      operator                                                D      1                                                       D      	is_mobile                                               D      47999999                                                D      to                                                      D      47980000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      334                                                     D     0                                                       B  ^\Q6ԂSM - g=`-<]#y  mO:-h} - Eֳ   mKX3vv{<>
Y - qc}G΅>  mD5 1 - يI!N\<  m^<Q - m<!j9QR  mW5?Q
z - _kVܕOFLA  m                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Telenor Mobil AS                                        D      operator                                                D      1                                                       D      	is_mobile                                               D      48299999                                                D      to                                                      D      48000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      335                                                     D     0                                                       B  ^\Q6ԂSM 0 j=`-<]#y  pO:-h} 0 Eֳ   pKX3vv{<>
Y 0 qc}G΅>  pD5 1 0 يI!N\<  p^<Q 0 m<!j9QR  pW5?Q
z 0 _kVܕOFLA  p                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Telenor Mobil AS                                        D      operator                                                D      1                                                       D      	is_mobile                                               D      48329999                                                D      to                                                      D      48300000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      336                                                     D     0                                                       B  ^\Q6ԂSM 3 m=`-<]#y  sO:-h} 3 Eֳ   sKX3vv{<>
Y 3 qc}G΅>  sD5 1 3 يI!N\<  s^<Q 3 m<!j9QR  sW5?Q
z 3 _kVܕOFLA  s                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Chess Communication AS                                  D      operator                                                D      1                                                       D      	is_mobile                                               D      48349999                                                D      to                                                      D      48330000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      337                                                     D     0                                                       B  ^\Q6ԂSM 6 p=`-<]#y  vO:-h} 6 Eֳ   vKX3vv{<>
Y 6 qc}G΅>  vD5 1 6 يI!N\<  v^<Q 6 m<!j9QR  vW5?Q
z 6 _kVܕOFLA  v                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      One Call AS                                             D      operator                                                D      1                                                       D      	is_mobile                                               D      48359999                                                D      to                                                      D      48350000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      338                                                     D     0                                                       B  ^\Q6ԂSM 9 s=`-<]#y  yO:-h} 9 Eֳ   yKX3vv{<>
Y 9 qc}G΅>  yD5 1 9 يI!N\<  y^<Q 9 m<!j9QR  yW5?Q
z 9 _kVܕOFLA  y                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Talkmore AS                                             D      operator                                                D      1                                                       D      	is_mobile                                               D      48369999                                                D      to                                                      D      48360000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      339                                                     D     0                                                       B  ^\Q6ԂSM < v=`-<]#y  |O:-h} < Eֳ   |KX3vv{<>
Y < qc}G΅>  |D5 1 < يI!N\<  |^<Q < m<!j9QR  |W5?Q
z < _kVܕOFLA  |                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Newphone Norge AS                                       D      operator                                                D      1                                                       D      	is_mobile                                               D      48379999                                                D      to                                                      D      48370000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   ?                                                        B  @ S9v|[                                                                                                                                                                                                                                                                                                                                                                          D      340                                                     D     0                                                       B  ^\Q6ԂSM  y=`-<]#y B O:-h}  Eֳ  B KX3vv{<>
Y  qc}G΅> B D5 1  يI!N\< B ^<Q  m<!j9QR B W5?Q
z  _kVܕOFLA B                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      ACN Norge AS                                            D      operator                                                D      1                                                       D      	is_mobile                                               D      48399999                                                D      to                                                      D      48380000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   B                                                        D      341                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y E O:-h}  ŅEֳ  E KX3vv{<>
Y  ƅqc}G΅> E D5 1  ǅيI!N\< E ^<Q  ȅm<!j9QR E W5?Q
z  Ʌ_kVܕOFLA E                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
TrigCom AS                                              D      operator                                                D      1                                                       D      	is_mobile                                               D      48409999                                                D      to                                                      D      48400000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   E                                                        D      342                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y H O:-h}  ͈Eֳ  H KX3vv{<>
Y  Έqc}G΅> H D5 1  ψيI!N\< H ^<Q  Јm<!j9QR H W5?Q
z  ш_kVܕOFLA H                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Nutel AS                                                D      operator                                                D      1                                                       D      	is_mobile                                               D      48419999                                                D      to                                                      D      48410000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  :o˧͠T K ҈:rD:9B/ E :kڌGQ/
C  [:]2u\C^e  :л vh $; $                                                                                                                                                                                                                                                                        D      343                                                     D     0                                                       B  ^\Q6ԂSM N =`-<]#y  ֎O:-h} N Eֳ   ׎KX3vv{<>
Y N qc}G΅>  ؎D5 1 N يI!N\<  َ^<Q N m<!j9QR  ڎW5?Q
z N _kVܕOFLA  ێ                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
Mobyson AS                                              D      operator                                                D      1                                                       D      	is_mobile                                               D      48429999                                                D      to                                                      D      48420000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      344                                                     D     0                                                       B  ^\Q6ԂSM Q ԋ=`-<]#y  ޑO:-h} Q Eֳ   ߑKX3vv{<>
Y Q qc}G΅>  D5 1 Q يI!N\<  ^<Q Q m<!j9QR  W5?Q
z Q _kVܕOFLA                                                                                                  D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      48479999                                                D      to                                                      D      48430000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      345                                                     D     0                                                       B  ^\Q6ԂSM T ܎=`-<]#y  O:-h} T Eֳ   KX3vv{<>
Y T qc}G΅>  D5 1 T يI!N\<  ^<Q T m<!j9QR  W5?Q
z T _kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      815Mobil AS                                             D      operator                                                D      1                                                       D      	is_mobile                                               D      48489999                                                D      to                                                      D      48480000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      346                                                     D     0                                                       B  ^\Q6ԂSM W =`-<]#y  O:-h} W Eֳ   KX3vv{<>
Y W qc}G΅>  D5 1 W يI!N\<  ^<Q W m<!j9QR  W5?Q
z W _kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
Phonect AS                                              D      operator                                                D      1                                                       D      	is_mobile                                               D      48499999                                                D      to                                                      D      48490000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      347                                                     D     0                                                       B  ^\Q6ԂSM Z =`-<]#y  O:-h} Z Eֳ   KX3vv{<>
Y Z qc}G΅>  D5 1 Z يI!N\<  ^<Q Z m<!j9QR  W5?Q
z Z _kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
TrigCom AS                                              D      operator                                                D      1                                                       D      	is_mobile                                               D      48509999                                                D      to                                                      D      48500000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      348                                                     D     0                                                       B  ^\Q6ԂSM ] =`-<]#y  O:-h} ] Eֳ   KX3vv{<>
Y  ]  qc}G΅>    D5 1 ] يI!N\<  ^<Q ] m<!j9QR  W5?Q
z ] _kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Nutel AS                                                D      operator                                                D      1                                                       D      	is_mobile                                               D      48519999                                                D      to                                                      D      48510000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   `                                                        B  q!.bD  8a|^_&                                                                                                                                                                                                                                                                                                                                                    D      349                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y c #O:-h}  Eֳ  	c 	#KX3vv{<>
Y 	 	qc}G΅> 
c 
#D5 1 
 
يI!N\< c #^<Q  m<!j9QR c #W5?Q
z  _kVܕOFLA 
c 
#                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
Mobyson AS                                              D      operator                                                D      1                                                       D      	is_mobile                                               D      48529999                                                D      to                                                      D      48520000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   c                                                        D      350                                                     D     0                                                       B  ^\Q6ԂSM   =`-<]#y f &O:-h}  Eֳ  f &KX3vv{<>
Y  qc}G΅> f &D5 1  يI!N\< f &^<Q  m<!j9QR f &W5?Q
z  _kVܕOFLA f &                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      48579999                                                D      to                                                      D      48530000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   f                                                        D      351                                                     D     0                                                       B  ^\Q6ԂSM  #=`-<]#y i )O:-h}  Eֳ  i )KX3vv{<>
Y  qc}G΅> i )D5 1  يI!N\< i )^<Q  m<!j9QR i )W5?Q
z  _kVܕOFLA i )                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      815Mobil AS                                             D      operator                                                D      1                                                       D      	is_mobile                                               D      48589999                                                D      to                                                      D      48580000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   i                                                        D      352                                                     D     0                                                       B  ^\Q6ԂSM  &=`-<]#y  l  ,O:-h}    Eֳ  !l !,KX3vv{<>
Y ! !qc}G΅> "l ",D5 1 " "يI!N\< #l #,^<Q # #m<!j9QR $l $,W5?Q
z $ $_kVܕOFLA %l %,                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      
Phonect AS                                              D      operator                                                D      1                                                       D      	is_mobile                                               D      48599999                                                D      to                                                      D      48590000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   &l                                                        D      353                                                     D     0                                                       B  ^\Q6ԂSM ' )=`-<]#y (o (/O:-h} ( (Eֳ  )o )/KX3vv{<>
Y ) )qc}G΅> *o */D5 1 * *يI!N\< +o +/^<Q + +m<!j9QR ,o ,/W5?Q
z , ,_kVܕOFLA -o -/                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      One Call AS                                             D      operator                                                D      1                                                       D      	is_mobile                                               D      48609999                                                D      to                                                      D      48600000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   .o                                                        D      354                                                     D     0                                                       B  ^\Q6ԂSM / &,=`-<]#y 0r 02O:-h} 0 0Eֳ  1r 12KX3vv{<>
Y 1 1qc}G΅> 2r 22D5 1 2 2يI!N\< 3r 32^<Q 3 3m<!j9QR 4r 42W5?Q
z 4 4_kVܕOFLA 5r 52                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      48839999                                                D      to                                                      D      48610000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   6r                                                        D      355                                                     D     0                                                       B  ^\Q6ԂSM 7 ./=`-<]#y 8u 85O:-h} 8 8Eֳ  9u 95KX3vv{<>
Y 9 9qc}G΅> :u :5D5 1 : :يI!N\< ;u ;5^<Q ; ;m<!j9QR <u <5W5?Q
z < <_kVܕOFLA =u =5                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      1                                                       D      	is_mobile                                               D      48899999                                                D      to                                                      D      48840000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   >u                                                        D      356                                                     D     0                                                       B  ^\Q6ԂSM ? 62=`-<]#y @x @8O:-h} @ @Eֳ  Ax A8KX3vv{<>
Y A Aqc}G΅> Bx B8D5 1 B BيI!N\< Cx C8^<Q C Cm<!j9QR Dx D8W5?Q
z D D_kVܕOFLA Ex E8                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Barablu Mobile Norway Ltd.                              D      operator                                                D      1                                                       D      	is_mobile                                               D      48929999                                                D      to                                                      D      48900000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   Fx                                                        D      357                                                     D     0                                                       B  ^\Q6ԂSM G >5=`-<]#y H{ H;O:-h} H HEֳ  I{ I;KX3vv{<>
Y I Iqc}G΅> J{ J;D5 1 J JيI!N\< K{ K;^<Q K Km<!j9QR L{ L;W5?Q
z L L_kVܕOFLA M{ M;                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Chess Communication AS                                  D      operator                                                D      1                                                       D      	is_mobile                                               D      48939999                                                D      to                                                      D      48930000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   N{                                                        D      358                                                     D     0                                                       B  ^\Q6ԂSM O F8=`-<]#y P~ P>O:-h} P PEֳ  Q~ Q>KX3vv{<>
Y Q Qqc}G΅> R~ R>D5 1 R RيI!N\< S~ S>^<Q S Sm<!j9QR T~ T>W5?Q
z T T_kVܕOFLA U~ U>                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      1                                                       D      	is_mobile                                               D      48999999                                                D      to                                                      D      48940000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   V~                                                        D      359                                                     D     0                                                       B  ^\Q6ԂSM X N;=`-<]#y X XAO:-h} Y XEֳ  Y YAKX3vv{<>
Y Z Yqc}G΅> Z ZAD5 1 [ ZيI!N\< [ [A^<Q \ [m<!j9QR \ \AW5?Q
z ] \_kVܕOFLA ] ]A                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      49999999                                                D      to                                                      D      49000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   `                                                        B  K*D _ ]='`Ȼ4F F w[!D X D)byF' s 3                                                                                                                                                                                                                                                                                                D      360                                                     D     0                                                       B  ^\Q6ԂSM a V>=`-<]#y b aO:-h} b bGEֳ  c bKX3vv{<>
Y c cGqc}G΅> d cD5 1 d dGيI!N\< e d^<Q e eGm<!j9QR f eW5?Q
z f fG_kVܕOFLA g f                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      50999999                                                D      to                                                      D      50000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   i                                                        B  Rr 5Ga^Z i
 gGR*驘Ӟ]Su #> #>z                                                                                                                                                                                                                                                                                                                                                D      361                                                     D     0                                                       B  ^\Q6ԂSM k
 _=`-<]#y k kMO:-h} l
 kEֳ  l lMKX3vv{<>
Y m
 lqc}G΅> m mMD5 1 n
 mيI!N\< n nM^<Q o
 nm<!j9QR o oMW5?Q
z p
 o_kVܕOFLA p pM                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      51009999                                                D      to                                                      D      51000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   s                                                        B  xRzMv r pŞ_>S?MC[S  Ù-;kvCnJh[  Ù.hŮHy
 3[ 3a{,:cKn Kd K$-z=cpb  %  %Q.sAs %n %.                                                                                                                                                                                                                        D      362                                                     D     0                                                       B  ^\Q6ԂSM t iJ=`-<]#y u tO:-h} u uSEֳ  v uKX3vv{<>
Y v vSqc}G΅> w vD5 1 w wSيI!N\< x w^<Q x xSm<!j9QR y xW5?Q
z y yS_kVܕOFLA z y                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      
NextGenTel AS                                           D      operator                                                D      0                                                       D      	is_mobile                                               D      51019999                                                D      to                                                      D      51010000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   {                                                        D      363                                                     D     0                                                       B  ^\Q6ԂSM | r=`-<]#y } |O:-h} } }VEֳ  ~ }KX3vv{<>
Y ~ ~Vqc}G΅>  ~D5 1  VيI!N\<  ^<Q  Vm<!j9QR  W5?Q
z  V_kVܕOFLA                                                                                                  D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      51099999                                                D      to                                                      D      51020000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  +GoȤҥ=Q  V/ܪR<h  8f`5@|u
 [ [N                                                                                                                                                                                                                                                                                                                        D      364                                                     D     0                                                       B  ^\Q6ԂSM  z=`-<]#y  \O:-h}  Eֳ   \KX3vv{<>
Y  qc}G΅>  \D5 1  يI!N\<  \^<Q  m<!j9QR  \W5?Q
z  _kVܕOFLA  \                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      	Comvie AS                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      51109999                                                D      to                                                      D      51100000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      365                                                     D     0                                                       B  ^\Q6ԂSM  Y=`-<]#y  _O:-h}  Eֳ   _KX3vv{<>
Y  qc}G΅>  _D5 1  يI!N\<  _^<Q  m<!j9QR  _W5?Q
z  _kVܕOFLA  _                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telio Telecom AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      51119999                                                D      to                                                      D      51110000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      366                                                     D     0                                                       B  ^\Q6ԂSM " \=`-<]#y  bO:-h} " Eֳ   bKX3vv{<>
Y " qc}G΅>  bD5 1 " يI!N\<  b^<Q " m<!j9QR  bW5?Q
z " _kVܕOFLA  b                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telio Telecom AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      51129999                                                D      to                                                      D      51120000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   %                                                        B  OP9j˴  V\K{P(-[ 
1 
1qke].&s1 | <N{ٍ<y 5 7@Y\+T  x                                                                                                                                                                                                                                                                        D      367                                                     D     0                                                       B  ^\Q6ԂSM  _=`-<]#y ( O:-h}  hEֳ  ( KX3vv{<>
Y  hqc}G΅> ( D5 1  hيI!N\< ( ^<Q  hm<!j9QR ( W5?Q
z  h_kVܕOFLA (                                                                                                 D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      51189999                                                D      to                                                      D      51130000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   (                                                        D      368                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y + O:-h}  kEֳ  + KX3vv{<>
Y  kqc}G΅> + D5 1  kيI!N\< + ^<Q  km<!j9QR + W5?Q
z  k_kVܕOFLA +                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Consorte Group ASA                                      D      operator                                                D      0                                                       D      	is_mobile                                               D      51199999                                                D      to                                                      D      51190000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  t	*,LZ\ . k)礙Hz 0 0M:CNIU$~8 % %j                                                                                                                                                                                                                                                                                                                        D      369                                                     D     0                                                       B  ^\Q6ԂSM 1 =`-<]#y  qO:-h} 1 Eֳ   qKX3vv{<>
Y 1 qc}G΅>  qD5 1 1 يI!N\<  q^<Q 1 m<!j9QR  qW5?Q
z 1 _kVܕOFLA  q                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      51229999                                                D      to                                                      D      51200000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   4                                                        B  	Xn  ק(}qLt, kp k02Ub
  ךY0</6QH  -  -T2.*7{ ! !6:JΓT "K "                                                                                                                                                                                                                                                D      370                                                     D     0                                                       B  ^\Q6ԂSM  n=`-<]#y 7 O:-h}  wEֳ  7 KX3vv{<>
Y  wqc}G΅> 7 D5 1  wيI!N\< 7 ^<Q  wm<!j9QR 7 W5?Q
z  w_kVܕOFLA 7                                                                                                 D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      51289999                                                D      to                                                      D      51230000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   º                                                        B  AvӃH
e%n : wA6칳	[B" Ce C%A
8uU0 # #                                                                                                                                                                                                                                                                                                                        D      371                                                     D     0                                                       B  ^\Q6ԂSM = =`-<]#y Ľ }O:-h} = Eֳ  Ž }KX3vv{<>
Y = qc}G΅> ƽ }D5 1 = يI!N\< ǽ }^<Q = m<!j9QR Ƚ }W5?Q
z = _kVܕOFLA ɽ }                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      51299999                                                D      to                                                      D      51290000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   @                                                        B  $o|Q  $C6y~Ʉx^v&J  $!&;0߈玥 ޤ d$h(B_Z3PMh f &$nRcVxRA> #N #$mHL
 ! !                                                                                                                                                                                                                                                D      372                                                     D     0                                                       B  ^\Q6ԂSM  z=`-<]#y C O:-h}  ΃Eֳ  C KX3vv{<>
Y  σqc}G΅> C D5 1  ЃيI!N\< C ^<Q  уm<!j9QR C W5?Q
z  ҃_kVܕOFLA C                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      51309999                                                D      to                                                      D      51300000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  /<~CZrJ0ݜ F ӃM_ߗl2  T"=˚>nSD S{ S;L|{Kׂu $J $
                                                                                                                                                                                                                                                                                                D      373                                                     D     0                                                       B  ^\Q6ԂSM I  =`-<]#y  ׉O:-h} I 	Eֳ   ؉KX3vv{<>
Y I 	qc}G΅>  ىD5 1 I 	يI!N\<  ډ^<Q I 	m<!j9QR  ۉW5?Q
z I 	_kVܕOFLA  ܉                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      51313999                                                D      to                                                      D      51310000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      374                                                     D     0                                                       B  ^\Q6ԂSM L Ն=`-<]#y  ߌO:-h} L Eֳ   KX3vv{<>
Y L qc}G΅>  D5 1 L يI!N\<  ^<Q L m<!j9QR  W5?Q
z L _kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Combitel Networks AS                                    D      operator                                                D      0                                                       D      	is_mobile                                               D      51314999                                                D      to                                                      D      51314000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   O                                                        B  iGF|:$25  N͏os s sk                                                                                                                                                                                                                                                                                                                                                D      375                                                     D     0                                                       B  ^\Q6ԂSM  ݉=`-<]#y R O:-h}  Eֳ  R KX3vv{<>
Y  qc}G΅> R D5 1  يI!N\< R ^<Q  m<!j9QR R W5?Q
z  _kVܕOFLA R                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Lyse Tele AS                                            D      operator                                                D      0                                                       D      	is_mobile                                               D      51329999                                                D      to                                                      D      51315000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   R                                                        D      376                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y U O:-h}  Eֳ  U KX3vv{<>
Y  qc}G΅> U D5 1  يI!N\< U ^<Q  m<!j9QR U W5?Q
z  _kVܕOFLA U                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      51370999                                                D      to                                                      D      51330000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   U                                                        D      377                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y X O:-h}  Eֳ  X KX3vv{<>
Y  qc}G΅> X D5 1  يI!N\< X ^<Q  m<!j9QR X W5?Q
z  _kVܕOFLA X                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      51371999                                                D      to                                                      D      51371000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                         B  !ԷE(; 
 [ VL{吵B ! !mۚg0oY, 9 P@s㩹 H @fUG0&cF # #                                                                                                                                                                                                                                                                        D      378                                                     D     0                                                       B  ^\Q6ԂSM 
^ =`-<]#y 
 
O:-h} 
^ 
Eֳ  
 
KX3vv{<>
Y 
^ 
qc}G΅> 
 
D5 1 
^ 
يI!N\< 
 
^<Q 
^ 
m<!j9QR 
 
W5?Q
z 
^ 
_kVܕOFLA 
 
                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      51999999                                                D      to                                                      D      51372000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        D      379                                                     D     0                                                       B  ^\Q6ԂSM 
a 
 =`-<]#y 
 
O:-h} 
a 
!Eֳ  
 
KX3vv{<>
Y 
a 
!qc}G΅> 
 
D5 1 

a 

!يI!N\< 

 

^<Q 
a 
!m<!j9QR 
 
W5?Q
z 
a 
!_kVܕOFLA 
 
                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      52049999                                                D      to                                                      D      52000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        D      380                                                     D     0                                                       B  ^\Q6ԂSM 
d 
=`-<]#y 
 
O:-h} 
d 
$Eֳ  
 
KX3vv{<>
Y 
d 
$qc}G΅> 
 
D5 1 
d 
$يI!N\< 
 
^<Q 
d 
$m<!j9QR 
 
W5?Q
z 
d 
$_kVܕOFLA 
 
                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      52099999                                                D      to                                                      D      52050000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        D      381                                                     D     0                                                       B  ^\Q6ԂSM 
g 
=`-<]#y 
 
O:-h} 
g 
'Eֳ  
 
KX3vv{<>
Y 
g 
'qc}G΅> 
 
D5 1 
g 
'يI!N\< 
 
^<Q 
g 
'm<!j9QR 
 
W5?Q
z 
g 
'_kVܕOFLA 
 
                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Tele2 Norge AS                                          D      operator                                                D      0                                                       D      	is_mobile                                               D      52109999                                                D      to                                                      D      52100000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
"j                                                        B  Oo[-j9#+9" 
! 
 'OJܿof2+
 
ֵ 
uOM!ILm hV hO
-*  }  }rO]hgǽț #v #v                                                                                                                                                                                                                                                                        D      382                                                     D     0                                                       B  ^\Q6ԂSM 
# 
=`-<]#y 
$m 
$-O:-h} 
$ 
$Eֳ  
%m 
%-KX3vv{<>
Y 
% 
%qc}G΅> 
&m 
&-D5 1 
& 
&يI!N\< 
'm 
'-^<Q 
' 
'm<!j9QR 
(m 
(-W5?Q
z 
( 
(_kVܕOFLA 
)m 
)-                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      52119999                                                D      to                                                      D      52110000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
*m                                                        D      383                                                     D     0                                                       B  ^\Q6ԂSM 
+ 
"*=`-<]#y 
,p 
,0O:-h} 
, 
,Eֳ  
-p 
-0KX3vv{<>
Y 
- 
-qc}G΅> 
.p 
.0D5 1 
. 
.يI!N\< 
/p 
/0^<Q 
/ 
/m<!j9QR 
0p 
00W5?Q
z 
0 
0_kVܕOFLA 
1p 
10                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      52199999                                                D      to                                                      D      52120000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
2p                                                        D      384                                                     D     0                                                       B  ^\Q6ԂSM 
3 
*-=`-<]#y 
4s 
43O:-h} 
4 
4Eֳ  
5s 
53KX3vv{<>
Y 
5 
5qc}G΅> 
6s 
63D5 1 
6 
6يI!N\< 
7s 
73^<Q 
7 
7m<!j9QR 
8s 
83W5?Q
z 
8 
8_kVܕOFLA 
9s 
93                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      52209999                                                D      to                                                      D      52200000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
;                                                        B  ܑ*%=,Y~7f@ 
;v 
9jdd+
Bھk  ܂2wǒD [j [*jpq*%!#
*ۦ  Vy..!IL[  XEg
p " "b                                                                                                                                                                                                                                                D      385                                                     D     0                                                       B  ^\Q6ԂSM 
=y 
20=`-<]#y 
= 
=O:-h} 
>y 
>9Eֳ  
> 
>KX3vv{<>
Y 
?y 
?9qc}G΅> 
? 
?D5 1 
@y 
@9يI!N\< 
@ 
@^<Q 
Ay 
A9m<!j9QR 
A 
AW5?Q
z 
By 
B9_kVܕOFLA 
B 
B                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      52219999                                                D      to                                                      D      52210000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
C                                                        D      386                                                     D     0                                                       B  ^\Q6ԂSM 
E| 
;=`-<]#y 
E 
EO:-h} 
F| 
F<Eֳ  
F 
FKX3vv{<>
Y 
G| 
G<qc}G΅> 
G 
GD5 1 
H| 
H<يI!N\< 
H 
H^<Q 
I| 
I<m<!j9QR 
I 
IW5?Q
z 
J| 
J<_kVܕOFLA 
J 
J                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Haugaland Kraft AS                                      D      operator                                                D      0                                                       D      	is_mobile                                               D      52229999                                                D      to                                                      D      52220000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
K                                                        D      387                                                     D     0                                                       B  ^\Q6ԂSM 
M 
C=`-<]#y 
M 
MO:-h} 
N 
N?Eֳ  
N 
NKX3vv{<>
Y 
O 
O?qc}G΅> 
O 
OD5 1 
P 
P?يI!N\< 
P 
P^<Q 
Q 
Q?m<!j9QR 
Q 
QW5?Q
z 
R 
R?_kVܕOFLA 
R 
R                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      52694999                                                D      to                                                      D      52230000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
S                                                        D      388                                                     D     0                                                       B  ^\Q6ԂSM 
U 
K=`-<]#y 
V 
UO:-h} 
V 
VBEֳ  
W 
VKX3vv{<>
Y 
W 
WBqc}G΅> 
X 
WD5 1 
X 
XBيI!N\< 
Y 
X^<Q 
Y 
YBm<!j9QR 
Z 
YW5?Q
z 
Z 
ZB_kVܕOFLA 
[ 
Z                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Network Norway AS                                       D      operator                                                D      0                                                       D      	is_mobile                                               D      52699999                                                D      to                                                      D      52695000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
\                                                        D      389                                                     D     0                                                       B  ^\Q6ԂSM 
] 
S=`-<]#y 
^ 
]O:-h} 
^ 
^EEֳ  
_ 
^KX3vv{<>
Y 
_ 
_Eqc}G΅> 
` 
_D5 1 
` 
`EيI!N\< 
a 
`^<Q 
a 
aEm<!j9QR 
b 
aW5?Q
z 
b 
bE_kVܕOFLA 
c 
b                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      52879999                                                D      to                                                      D      52700000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
d                                                        D      390                                                     D     0                                                       B  ^\Q6ԂSM 
e 
[=`-<]#y 
f 
eO:-h} 
f 
fHEֳ  
g 
fKX3vv{<>
Y 
g 
gHqc}G΅> 
h 
gD5 1 
h 
hHيI!N\< 
i 
h^<Q 
i 
iHm<!j9QR 
j 
iW5?Q
z 
j 
jH_kVܕOFLA 
k 
j                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      52889999                                                D      to                                                      D      52880000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
m                                                        B  ZK%%trN 
m 
kH                                                                                                                                                                                                                                                                                                                                                                        D      391                                                     D     0                                                       B  ^\Q6ԂSM 
o 
c=`-<]#y 
o 
oNO:-h} 
p 
oEֳ  
p 
pNKX3vv{<>
Y 
q 
pqc}G΅> 
q 
qND5 1 
r 
qيI!N\< 
r 
rN^<Q 
s 
rm<!j9QR 
s 
sNW5?Q
z 
t 
s_kVܕOFLA 
t 
tN                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      52899999                                                D      to                                                      D      52890000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
u                                                        D      392                                                     D     0                                                       B  ^\Q6ԂSM 
w 
mK=`-<]#y 
w 
wQO:-h} 
x 
wEֳ  
x 
xQKX3vv{<>
Y 
y 
xqc}G΅> 
y 
yQD5 1 
z 
yيI!N\< 
z 
zQ^<Q 
{ 
zm<!j9QR 
{ 
{QW5?Q
z 
| 
{_kVܕOFLA 
| 
|Q                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Hafslund Telekom AS                                     D      operator                                                D      0                                                       D      	is_mobile                                               D      52909999                                                D      to                                                      D      52900000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
}                                                        D      393                                                     D     0                                                       B  ^\Q6ԂSM 
 
uN=`-<]#y 
 
TO:-h} 
 
Eֳ  
 
TKX3vv{<>
Y 
 
qc}G΅> 
 
TD5 1 
 
يI!N\< 
 
T^<Q 
 
m<!j9QR 
 
TW5?Q
z 
 
_kVܕOFLA 
 
T                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      52972999                                                D      to                                                      D      52910000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        D      394                                                     D     0                                                       B  ^\Q6ԂSM 
 
}Q=`-<]#y 
 
WO:-h} 
 
Eֳ  
 
WKX3vv{<>
Y 
 
qc}G΅> 
 
WD5 1 
 
يI!N\< 
 
W^<Q 
 
m<!j9QR 
 
WW5?Q
z 
 
_kVܕOFLA 
 
W                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Lyse Tele AS                                            D      operator                                                D      0                                                       D      	is_mobile                                               D      52979999                                                D      to                                                      D      52973000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        D      395                                                     D     0                                                       B  ^\Q6ԂSM 
 
T=`-<]#y 
 
ZO:-h} 
 
Eֳ  
 
ZKX3vv{<>
Y 
 
qc}G΅> 
 
ZD5 1 
 
يI!N\< 
 
Z^<Q 
 
m<!j9QR 
 
ZW5?Q
z 
 
_kVܕOFLA 
 
Z                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Lyse Tele AS                                            D      operator                                                D      0                                                       D      	is_mobile                                               D      52984999                                                D      to                                                      D      52980000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        D      396                                                     D     0                                                       B  ^\Q6ԂSM 
 
W=`-<]#y 
 
]O:-h} 
 
Eֳ  
 
]KX3vv{<>
Y 
 
qc}G΅> 
 
]D5 1 
 
يI!N\< 
 
]^<Q 
 
m<!j9QR 
 
]W5?Q
z 
 
_kVܕOFLA 
 
]                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      CBK Tele AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      52986999                                                D      to                                                      D      52985000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        D      397                                                     D     0                                                       B  ^\Q6ԂSM 
  
Z=`-<]#y 
 
`O:-h} 
  
Eֳ  
 
`KX3vv{<>
Y 
  
qc}G΅> 
 
`D5 1 
  
يI!N\< 
 
`^<Q 
  
m<!j9QR 
 
`W5?Q
z 
  
_kVܕOFLA 
 
`                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      	Phonzo AS                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      52988999                                                D      to                                                      D      52987000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        D      398                                                     D     0                                                       B  ^\Q6ԂSM 
# 
]=`-<]#y 
 
cO:-h} 
# 
Eֳ  
 
cKX3vv{<>
Y 
# 
qc}G΅> 
 
cD5 1 
# 
يI!N\< 
 
c^<Q 
# 
m<!j9QR 
 
cW5?Q
z 
# 
_kVܕOFLA 
 
c                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      52992999                                                D      to                                                      D      52989000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        D      399                                                     D     0                                                       B  ^\Q6ԂSM 
& 
`=`-<]#y 
 
fO:-h} 
& 
Eֳ  
 
fKX3vv{<>
Y 
& 
qc}G΅> 
 
fD5 1 
& 
يI!N\< 
 
f^<Q 
& 
m<!j9QR 
 
fW5?Q
z 
& 
_kVܕOFLA 
 
f                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      52995999                                                D      to                                                      D      52993000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        D      400                                                     D     0                                                       B  ^\Q6ԂSM 
) 
c=`-<]#y 
 
iO:-h} 
) 
Eֳ  
 
iKX3vv{<>
Y 
) 
qc}G΅> 
 
iD5 1 
) 
يI!N\< 
 
i^<Q 
) 
m<!j9QR 
 
iW5?Q
z 
) 
_kVܕOFLA 
 
i                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      52998999                                                D      to                                                      D      52996000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        D      401                                                     D     0                                                       B  ^\Q6ԂSM 
, 
f=`-<]#y 
 
lO:-h} 
, 
Eֳ  
 
lKX3vv{<>
Y 
, 
qc}G΅> 
 
lD5 1 
, 
يI!N\< 
¬ 
l^<Q 
, 
m<!j9QR 
ì 
lW5?Q
z 
, 
_kVܕOFLA 
Ĭ 
l                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      52999999                                                D      to                                                      D      52999000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Rogaland                                                D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
Ŭ                                                        D      402                                                     D     0                                                       B  ^\Q6ԂSM 
/ 
i=`-<]#y 
ǯ 
oO:-h} 
/ 
Eֳ  
ȯ 
oKX3vv{<>
Y 
/ 
qc}G΅> 
ɯ 
oD5 1 
/ 
يI!N\< 
ʯ 
o^<Q 
/ 
m<!j9QR 
˯ 
oW5?Q
z 
/ 
_kVܕOFLA 
̯ 
o                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      53059999                                                D      to                                                      D      53000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
2                                                        B  K42&WPb} 
β 
\F]( 
޸ 
x                                                                                                                                                                                                                                                                                                                                                D      403                                                     D     0                                                       B  ^\Q6ԂSM 
е 
l=`-<]#y 
5 
O:-h} 
ѵ 
uEֳ  
5 
KX3vv{<>
Y 
ҵ 
uqc}G΅> 
5 
D5 1 
ӵ 
uيI!N\< 
5 
^<Q 
Ե 
um<!j9QR 
5 
W5?Q
z 
յ 
u_kVܕOFLA 
5 
                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      53199999                                                D      to                                                      D      53060000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
5                                                        D      404                                                     D     0                                                       B  ^\Q6ԂSM 
ظ 
=`-<]#y 
8 
O:-h} 
ٸ 
xEֳ  
8 
KX3vv{<>
Y 
ڸ 
xqc}G΅> 
8 
D5 1 
۸ 
xيI!N\< 
8 
^<Q 
ܸ 
xm<!j9QR 
8 
W5?Q
z 
ݸ 
x_kVܕOFLA 
8 
                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      53209999                                                D      to                                                      D      53200000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
8                                                        D      405                                                     D     0                                                       B  ^\Q6ԂSM 
 
=`-<]#y 
; 
O:-h} 
 
{Eֳ  
; 
KX3vv{<>
Y 
 
{qc}G΅> 
; 
D5 1 
 
{يI!N\< 
; 
^<Q 
 
{m<!j9QR 
; 
W5?Q
z 
 
{_kVܕOFLA 
; 
                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      53219999                                                D      to                                                      D      53210000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
;                                                        D      406                                                     D     0                                                       B  ^\Q6ԂSM 
 
=`-<]#y 
> 
O:-h} 
 
~Eֳ  
> 
KX3vv{<>
Y 
 
~qc}G΅> 
> 
D5 1 
 
~يI!N\< 
> 
^<Q 
 
~m<!j9QR 
> 
W5?Q
z 
 
~_kVܕOFLA 
> 
                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Haugaland Kraft AS                                      D      operator                                                D      0                                                       D      	is_mobile                                               D      53229999                                                D      to                                                      D      53220000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
>                                                        D      407                                                     D     0                                                       B  ^\Q6ԂSM 
 
=`-<]#y 
A 
O:-h} 
 
Eֳ  
A 
KX3vv{<>
Y 
 
qc}G΅> 
A 
D5 1 
 
يI!N\< 
A 
^<Q 
 
m<!j9QR 
A 
W5?Q
z 
 
_kVܕOFLA 
A 
                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Lyse Tele AS                                            D      operator                                                D      0                                                       D      	is_mobile                                               D      53233999                                                D      to                                                      D      53230000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
                                                        B  
Puh 
D 

TCʚf;% #Y #
}ᬩ)?> A&8 ~ ~
1rLS6 ) )
qn2	"RP x 8                                                                                                                                                                                                                                                                        D      408                                                     D     0                                                       B  ^\Q6ԂSM 
G 
=`-<]#y 
 
O:-h} 
G 
Eֳ  
 
KX3vv{<>
Y 
G 
qc}G΅> 
 
D5 1 
G 
يI!N\< 
 
^<Q 
G 
m<!j9QR 
 
W5?Q
z 
G 
_kVܕOFLA 
 
                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      53399999                                                D      to                                                      D      53234000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                            D      409                                                     D     0                                                       B  ^\Q6ԂSM J 
=`-<]#y  O:-h} J 
Eֳ   KX3vv{<>
Y J 
qc}G΅>  D5 1 J 
يI!N\<  ^<Q J 
m<!j9QR  W5?Q
z J 
_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      53499999                                                D      to                                                      D      53400000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   
M                                                        B  hN.1 	 
p\U㵟 Q Ql'e7
\= o /-ުԬ ~ >	\_UFc? ".T ".                                                                                                                                                                                                                                                                        D      410                                                     D     0                                                       B  ^\Q6ԂSM   =`-<]#y P O:-h}  Eֳ  
P 
KX3vv{<>
Y 
 
qc}G΅> P D5 1  يI!N\< P ^<Q  m<!j9QR P W5?Q
z  _kVܕOFLA P                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telio Telecom AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      53509999                                                D      to                                                      D      53500000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   P                                                        D      411                                                     D     0                                                       B  ^\Q6ԂSM  

=`-<]#y S O:-h}  Eֳ  S KX3vv{<>
Y  qc}G΅> S D5 1  يI!N\< S ^<Q  m<!j9QR S W5?Q
z  _kVܕOFLA S                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telio Telecom AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      53519999                                                D      to                                                      D      53510000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  "	b/O  V v48"lr "&Q "&ԇ.\"e+ $/ $.                                                                                                                                                                                                                                                                                                                        D      412                                                     D     0                                                       B  ^\Q6ԂSM Y =`-<]#y  O:-h} Y Eֳ   KX3vv{<>
Y Y qc}G΅>  D5 1  Y  يI!N\<    ^<Q !Y !m<!j9QR ! !W5?Q
z "Y "_kVܕOFLA " "                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      53639999                                                D      to                                                      D      53520000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   #                                                        D      413                                                     D     0                                                       B  ^\Q6ԂSM %\ =`-<]#y % %O:-h} &\ &Eֳ  & &KX3vv{<>
Y '\ 'qc}G΅> ' 'D5 1 (\ (يI!N\< ( (^<Q )\ )m<!j9QR ) )W5?Q
z *\ *_kVܕOFLA * *                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      53679999                                                D      to                                                      D      53640000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   +                                                        D      414                                                     D     0                                                       B  ^\Q6ԂSM -_ #=`-<]#y - -O:-h} ._ .Eֳ  . .KX3vv{<>
Y /_ /qc}G΅> / /D5 1 0_ 0يI!N\< 0 0^<Q 1_ 1m<!j9QR 1 1W5?Q
z 2_ 2_kVܕOFLA 2 2                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      53694999                                                D      to                                                      D      53680000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   3                                                        D      415                                                     D     0                                                       B  ^\Q6ԂSM 5b +=`-<]#y 5 5O:-h} 6b 6"Eֳ  6 6KX3vv{<>
Y 7b 7"qc}G΅> 7 7D5 1 8b 8"يI!N\< 8 8^<Q 9b 9"m<!j9QR 9 9W5?Q
z :b :"_kVܕOFLA : :                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Network Norway AS                                       D      operator                                                D      0                                                       D      	is_mobile                                               D      53699999                                                D      to                                                      D      53695000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   ;                                                        D      416                                                     D     0                                                       B  ^\Q6ԂSM =e 3=`-<]#y = =O:-h} >e >%Eֳ  > >KX3vv{<>
Y ?e ?%qc}G΅> ? ?D5 1 @e @%يI!N\< @ @^<Q Ae A%m<!j9QR A AW5?Q
z Be B%_kVܕOFLA B B                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      53739999                                                D      to                                                      D      53700000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   C                                                        D      417                                                     D     0                                                       B  ^\Q6ԂSM Eh ;=`-<]#y E EO:-h} Fh F(Eֳ  F FKX3vv{<>
Y Gh G(qc}G΅> G GD5 1 Hh H(يI!N\< H H^<Q Ih I(m<!j9QR I IW5?Q
z Jh J(_kVܕOFLA J J                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      53779999                                                D      to                                                      D      53740000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   K                                                        D      418                                                     D     0                                                       B  ^\Q6ԂSM Mk C=`-<]#y M MO:-h} Nk N+Eֳ  N NKX3vv{<>
Y Ok O+qc}G΅> O OD5 1 Pk P+يI!N\< P P^<Q Qk Q+m<!j9QR Q QW5?Q
z Rk R+_kVܕOFLA R R                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      53799999                                                D      to                                                      D      53780000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   S                                                        D      419                                                     D     0                                                       B  ^\Q6ԂSM Un K=`-<]#y U UO:-h} Vn V.Eֳ  V VKX3vv{<>
Y Wn W.qc}G΅> W WD5 1 Xn X.يI!N\< X X^<Q Yn Y.m<!j9QR Y YW5?Q
z Zn Z._kVܕOFLA Z Z                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      53809999                                                D      to                                                      D      53800000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   [                                                        D      420                                                     D     0                                                       B  ^\Q6ԂSM ]q S=`-<]#y ] ]O:-h} ^q ^1Eֳ  ^ ^KX3vv{<>
Y _q _1qc}G΅> _ _D5 1 `q `1يI!N\< ` `^<Q aq a1m<!j9QR a aW5?Q
z bq b1_kVܕOFLA b b                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      53999999                                                D      to                                                      D      53810000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   c                                                        D      421                                                     D     0                                                       B  ^\Q6ԂSM et [=`-<]#y e eO:-h} ft f4Eֳ  f fKX3vv{<>
Y gt g4qc}G΅> g gD5 1 ht h4يI!N\< h h^<Q it i4m<!j9QR i iW5?Q
z jt j4_kVܕOFLA j j                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      0                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      54999999                                                D      to                                                      D      54000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          N                                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   k                                                        D      422                                                     D     0                                                       B  ^\Q6ԂSM mw c=`-<]#y m mO:-h} nw n7Eֳ  n nKX3vv{<>
Y ow o7qc}G΅> o oD5 1 pw p7يI!N\< p p^<Q qw q7m<!j9QR q qW5?Q
z rw r7_kVܕOFLA r r                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Tele2 Norge AS                                          D      operator                                                D      0                                                       D      	is_mobile                                               D      55009999                                                D      to                                                      D      55000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   s                                                        D      423                                                     D     0                                                       B  ^\Q6ԂSM uz k=`-<]#y u uO:-h} vz v:Eֳ  v vKX3vv{<>
Y wz w:qc}G΅> w wD5 1 xz x:يI!N\< x x^<Q yz y:m<!j9QR y yW5?Q
z zz z:_kVܕOFLA z z                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      
NextGenTel AS                                           D      operator                                                D      0                                                       D      	is_mobile                                               D      55019999                                                D      to                                                      D      55010000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   {                                                        D      424                                                     D     0                                                       B  ^\Q6ԂSM }} s=`-<]#y } }O:-h} ~} ~=Eֳ  ~ ~KX3vv{<>
Y } =qc}G΅>  D5 1 } =يI!N\<  ^<Q } =m<!j9QR  W5?Q
z } =_kVܕOFLA                                                                                                  D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      55079999                                                D      to                                                      D      55020000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  %,/Z20Gn   =%w??ȴz c #%.o< ( %1UB u
 t                                                                                                                                                                                                                                                                                                D      425                                                     D     0                                                       B  ^\Q6ԂSM  {=`-<]#y  CO:-h}  Eֳ   CKX3vv{<>
Y  qc}G΅>  CD5 1  يI!N\<  C^<Q  m<!j9QR  CW5?Q
z  _kVܕOFLA  C                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      55099999                                                D      to                                                      D      55080000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      426                                                     D     0                                                       B  ^\Q6ԂSM  @=`-<]#y  FO:-h}  Eֳ   FKX3vv{<>
Y  qc}G΅>  FD5 1  يI!N\<  F^<Q  m<!j9QR  FW5?Q
z  _kVܕOFLA  F                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      55399999                                                D      to                                                      D      55100000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      427                                                     D     0                                                       B  ^\Q6ԂSM 	 C=`-<]#y  IO:-h} 	 Eֳ   IKX3vv{<>
Y 	 qc}G΅>  ID5 1 	 يI!N\<  I^<Q 	 m<!j9QR  IW5?Q
z 	 _kVܕOFLA  I                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      55499999                                                D      to                                                      D      55400000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      428                                                     D     0                                                       B  ^\Q6ԂSM  F=`-<]#y  LO:-h}  Eֳ   LKX3vv{<>
Y  qc}G΅>  LD5 1  يI!N\<  L^<Q  m<!j9QR  LW5?Q
z  _kVܕOFLA  L                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      55599999                                                D      to                                                      D      55500000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      429                                                     D     0                                                       B  ^\Q6ԂSM  I=`-<]#y  OO:-h}  Eֳ   OKX3vv{<>
Y  qc}G΅>  OD5 1  يI!N\<  O^<Q  m<!j9QR  OW5?Q
z  _kVܕOFLA  O                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      55629999                                                D      to                                                      D      55600000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      430                                                     D     0                                                       B  ^\Q6ԂSM  L=`-<]#y  RO:-h}  Eֳ   RKX3vv{<>
Y  qc}G΅>  RD5 1  يI!N\<  R^<Q  m<!j9QR  RW5?Q
z  _kVܕOFLA  R                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      55689999                                                D      to                                                      D      55630000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      431                                                     D     0                                                       B  ^\Q6ԂSM  O=`-<]#y  UO:-h}  Eֳ   UKX3vv{<>
Y  qc}G΅>  UD5 1  يI!N\<  U^<Q  m<!j9QR  UW5?Q
z  _kVܕOFLA  U                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      55699999                                                D      to                                                      D      55690000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      432                                                     D     0                                                       B  ^\Q6ԂSM  R=`-<]#y  XO:-h}  Eֳ   XKX3vv{<>
Y  qc}G΅>  XD5 1  يI!N\<  X^<Q  m<!j9QR Ø XW5?Q
z  _kVܕOFLA Ę X                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      
NetCom GSM AS                                           D      operator                                                D      1                                                       D      	is_mobile                                               D      55709999                                                D      to                                                      D      55700000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   Ř                                                        D      433                                                     D     0                                                       B  ^\Q6ԂSM  U=`-<]#y Ǜ [O:-h}  Eֳ  ț [KX3vv{<>
Y  qc}G΅> ɛ [D5 1  يI!N\< ʛ [^<Q  m<!j9QR ˛ [W5?Q
z  _kVܕOFLA ̛ [                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      55899999                                                D      to                                                      D      55710000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   ͛                                                        D      434                                                     D     0                                                       B  ^\Q6ԂSM  X=`-<]#y Ϟ ^O:-h}  Eֳ  О ^KX3vv{<>
Y  qc}G΅> ў ^D5 1  يI!N\< Ҟ ^^<Q  m<!j9QR Ӟ ^W5?Q
z  _kVܕOFLA Ԟ ^                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      55999999                                                D      to                                                      D      55900000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   !                                                        B  ݳW~Ϟm ֡ Et)A!}Y9B@  E_h۟Tg2  ݎ?6-  w'}2^?g/j $o, $n                                                                                                                                                                                                                                                                        D      435                                                     D     0                                                       B  ^\Q6ԂSM ؤ [=`-<]#y $ O:-h} ٤ dEֳ  $ KX3vv{<>
Y ڤ dqc}G΅> $ D5 1 ۤ dيI!N\< $ ^<Q ܤ dm<!j9QR $ W5?Q
z ݤ d_kVܕOFLA $                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      	Comvie AS                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      56009999                                                D      to                                                      D      56000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   $                                                        D      436                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y ' O:-h}  gEֳ  ' KX3vv{<>
Y  gqc}G΅> ' D5 1  gيI!N\< ' ^<Q  gm<!j9QR ' W5?Q
z  g_kVܕOFLA '                                                                                                 D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      56036999                                                D      to                                                      D      56010000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   '                                                        D      437                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y * O:-h}  jEֳ  * KX3vv{<>
Y  jqc}G΅> * D5 1  jيI!N\< * ^<Q  jm<!j9QR * W5?Q
z  j_kVܕOFLA *                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Get AS                                                  D      operator                                                D      0                                                       D      	is_mobile                                               D      56037999                                                D      to                                                      D      56037000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   *                                                        D      438                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y - O:-h}  mEֳ  - KX3vv{<>
Y  mqc}G΅> - D5 1  mيI!N\< - ^<Q  mm<!j9QR - W5?Q
z  m_kVܕOFLA -                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      	Phonzo AS                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      56039999                                                D      to                                                      D      56038000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   -                                                        D      439                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y 0 O:-h}  pEֳ  0 KX3vv{<>
Y  pqc}G΅> 0 D5 1  pيI!N\< 0 ^<Q  pm<!j9QR 0 W5?Q
z  p_kVܕOFLA 0                                                                                                 D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      56089999                                                D      to                                                      D      56040000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   0                                                        D      440                                                     D     0                                                       B  ^\Q6ԂSM   =`-<]#y 3  O:-h}  sEֳ  3 KX3vv{<>
Y  sqc}G΅> 3 D5 1  sيI!N\< 3 ^<Q  sm<!j9QR 3 W5?Q
z  s_kVܕOFLA 3                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Consorte Group ASA                                      D      operator                                                D      0                                                       D      	is_mobile                                               D      56099999                                                D      to                                                      D      56090000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   3                                                        D      441                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y 	6 O:-h} 	 	vEֳ  
6 	KX3vv{<>
Y 
 
vqc}G΅> 6 
D5 1  vيI!N\< 6 ^<Q  vm<!j9QR 
6 W5?Q
z 
 
v_kVܕOFLA 6 
                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      56130999                                                D      to                                                      D      56100000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   6                                                        D      442                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y 9 O:-h}  yEֳ  9 KX3vv{<>
Y  yqc}G΅> 9 D5 1  yيI!N\< 9 ^<Q  ym<!j9QR 9 W5?Q
z  y_kVܕOFLA 9                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      56131999                                                D      to                                                      D      56131000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   9                                                        D      443                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y < O:-h}  |Eֳ  < KX3vv{<>
Y  |qc}G΅> < D5 1  |يI!N\< < ^<Q  |m<!j9QR < W5?Q
z  |_kVܕOFLA <                                                                                                 D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      56199999                                                D      to                                                      D      56132000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   <                                                        D      444                                                     D     0                                                       B  ^\Q6ԂSM   =`-<]#y !?  O:-h} ! !Eֳ  "? !KX3vv{<>
Y " "qc}G΅> #? "D5 1 # #يI!N\< $? #^<Q $ $m<!j9QR %? $W5?Q
z % %_kVܕOFLA &? %                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      56299999                                                D      to                                                      D      56200000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   '?                                                        D      445                                                     D     0                                                       B  ^\Q6ԂSM ( =`-<]#y )B )O:-h} ) )Eֳ  *B *KX3vv{<>
Y * *qc}G΅> +B +D5 1 + +يI!N\< ,B ,^<Q , ,m<!j9QR -B -W5?Q
z - -_kVܕOFLA .B .                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      56399999                                                D      to                                                      D      56300000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   /B                                                        D      446                                                     D     0                                                       B  ^\Q6ԂSM 0 &=`-<]#y 1E 1O:-h} 1 1Eֳ  2E 2KX3vv{<>
Y 2 2qc}G΅> 3E 3D5 1 3 3يI!N\< 4E 4^<Q 4 4m<!j9QR 5E 5W5?Q
z 5 5_kVܕOFLA 6E 6                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      56499999                                                D      to                                                      D      56400000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   7E                                                        D      447                                                     D     0                                                       B  ^\Q6ԂSM 8 /=`-<]#y 9H 9O:-h} 9 9Eֳ  :H :KX3vv{<>
Y : :qc}G΅> ;H ;D5 1 ; ;يI!N\< <H <^<Q < <m<!j9QR =H =W5?Q
z = =_kVܕOFLA >H >                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      56509999                                                D      to                                                      D      56500000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   ?H                                                        D      448                                                     D     0                                                       B  ^\Q6ԂSM @ 7=`-<]#y AK AO:-h} A AEֳ  BK BKX3vv{<>
Y B Bqc}G΅> CK CD5 1 C CيI!N\< DK D^<Q D Dm<!j9QR EK EW5?Q
z E E_kVܕOFLA FK F                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      56599999                                                D      to                                                      D      56510000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   GK                                                        D      449                                                     D     0                                                       B  ^\Q6ԂSM H ?=`-<]#y IN IO:-h} I IEֳ  JN JKX3vv{<>
Y J Jqc}G΅> KN KD5 1 K KيI!N\< LN L^<Q L Lm<!j9QR MN MW5?Q
z M M_kVܕOFLA NN N                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      56899999                                                D      to                                                      D      56600000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   P                                                        B  YՊTCw. PQ NޮSY$/  \z/U{	CiPK 0                                                                                                                                                                                                                                                                                                                         D      450                                                     D     0                                                       B  ^\Q6ԂSM RT G=`-<]#y R RO:-h} ST SEֳ  S SKX3vv{<>
Y TT Tqc}G΅> T TD5 1 UT UيI!N\< U U^<Q VT Vm<!j9QR V VW5?Q
z WT W_kVܕOFLA W W                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Hafslund Telekom AS                                     D      operator                                                D      0                                                       D      	is_mobile                                               D      56909999                                                D      to                                                      D      56900000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   X                                                        D      451                                                     D     0                                                       B  ^\Q6ԂSM ZW P=`-<]#y Z ZO:-h} [W [Eֳ  [ [KX3vv{<>
Y \W \qc}G΅> \ \D5 1 ]W ]يI!N\< ] ]^<Q ^W ^m<!j9QR ^ ^W5?Q
z _W __kVܕOFLA _ _                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      56979999                                                D      to                                                      D      56910000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   `                                                        D      452                                                     D     0                                                       B  ^\Q6ԂSM bZ X=`-<]#y b bO:-h} cZ cEֳ  c cKX3vv{<>
Y dZ dqc}G΅> d dD5 1 eZ eيI!N\< e e^<Q fZ fm<!j9QR f fW5?Q
z gZ g_kVܕOFLA g g                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      CBK Tele AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      56982999                                                D      to                                                      D      56980000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   h                                                        D      453                                                     D     0                                                       B  ^\Q6ԂSM j] `=`-<]#y j jO:-h} k] kEֳ  k kKX3vv{<>
Y l] lqc}G΅> l lD5 1 m] mيI!N\< m m^<Q n] nm<!j9QR n nW5?Q
z o] o_kVܕOFLA o o                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Combitel Networks AS                                    D      operator                                                D      0                                                       D      	is_mobile                                               D      56983999                                                D      to                                                      D      56983000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   p                                                        D      454                                                     D     0                                                       B  ^\Q6ԂSM r` h=`-<]#y r rO:-h} s` s Eֳ  s sKX3vv{<>
Y t` t qc}G΅> t tD5 1 u` u يI!N\< u u^<Q v` v m<!j9QR v vW5?Q
z w` w _kVܕOFLA w w                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      56987999                                                D      to                                                      D      56984000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   x                                                        D      455                                                     D     0                                                       B  ^\Q6ԂSM zc p=`-<]#y z zO:-h} {c {#Eֳ  { {KX3vv{<>
Y |c |#qc}G΅> | |D5 1 }c }#يI!N\< } }^<Q ~c ~#m<!j9QR ~ ~W5?Q
z c #_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      56992999                                                D      to                                                      D      56988000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      456                                                     D     0                                                       B  ^\Q6ԂSM f x=`-<]#y  O:-h} f &Eֳ   KX3vv{<>
Y f &qc}G΅>  D5 1 f &يI!N\<  ^<Q f &m<!j9QR  W5?Q
z f &_kVܕOFLA                                                                                                  D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      56995999                                                D      to                                                      D      56993000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      457                                                     D     0                                                       B  ^\Q6ԂSM i =`-<]#y  O:-h} i )Eֳ   KX3vv{<>
Y i )qc}G΅>  D5 1 i )يI!N\<  ^<Q i )m<!j9QR  W5?Q
z i )_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      56998999                                                D      to                                                      D      56996000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      458                                                     D     0                                                       B  ^\Q6ԂSM l =`-<]#y  O:-h} l ,Eֳ   KX3vv{<>
Y l ,qc}G΅>  D5 1 l ,يI!N\<  ^<Q l ,m<!j9QR  W5?Q
z l ,_kVܕOFLA                                                                                                  D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      56999999                                                D      to                                                      D      56999000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      	Hordaland                                               D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      459                                                     D     0                                                       B  ^\Q6ԂSM o =`-<]#y  O:-h} o /Eֳ   KX3vv{<>
Y o /qc}G΅>  D5 1 o /يI!N\<  ^<Q o /m<!j9QR  W5?Q
z o /_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      57019999                                                D      to                                                      D      57000000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Sogn og Fjordane                                        D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      460                                                     D     0                                                       B  ^\Q6ԂSM r =`-<]#y  O:-h} r 2Eֳ   KX3vv{<>
Y r 2qc}G΅>  D5 1 r 2يI!N\<  ^<Q r 2m<!j9QR  W5?Q
z r 2_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Ventelo Norge AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      57022999                                                D      to                                                      D      57020000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Sogn og Fjordane                                        D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      461                                                     D     0                                                       B  ^\Q6ԂSM u =`-<]#y  O:-h} u 5Eֳ   KX3vv{<>
Y u 5qc}G΅>  D5 1 u 5يI!N\<  ^<Q u 5m<!j9QR  W5?Q
z u 5_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Combitel Networks AS                                    D      operator                                                D      0                                                       D      	is_mobile                                               D      57023999                                                D      to                                                      D      57023000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Sogn og Fjordane                                        D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   x                                                        B  Q+
}[&  5Qn Vr5Y  ړ                                                                                                                                                                                                                                                                                                                                                D      462                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y { ;O:-h}  Eֳ  { ;KX3vv{<>
Y  qc}G΅> { ;D5 1  يI!N\< { ;^<Q  m<!j9QR { ;W5?Q
z  _kVܕOFLA { ;                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      57099999                                                D      to                                                      D      57024000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Sogn og Fjordane                                        D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   {                                                        D      463                                                     D     0                                                       B  ^\Q6ԂSM  8=`-<]#y ~ >O:-h}  Eֳ  ~ >KX3vv{<>
Y  qc}G΅> ~ >D5 1  يI!N\< ~ >^<Q  m<!j9QR ~ >W5?Q
z  _kVܕOFLA ~ >                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Tele2 Norge AS                                          D      operator                                                D      0                                                       D      	is_mobile                                               D      57109999                                                D      to                                                      D      57100000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Sogn og Fjordane                                        D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  M<pA Á Y%A43 !  +SFFc % %U                                                                                                                                                                                                                                                                                                                        D      464                                                     D     0                                                       B  ^\Q6ԂSM ń ;=`-<]#y  O:-h} Ƅ DEֳ   KX3vv{<>
Y Ǆ Dqc}G΅>  D5 1 Ȅ DيI!N\<  ^<Q Ʉ Dm<!j9QR  W5?Q
z ʄ D_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telio Telecom AS                                        D      operator                                                D      0                                                       D      	is_mobile                                               D      57114999                                                D      to                                                      D      57110000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Sogn og Fjordane                                        D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      465                                                     D     0                                                       B  ^\Q6ԂSM ͇ =`-<]#y  O:-h} · GEֳ   KX3vv{<>
Y χ Gqc}G΅>  D5 1 Ї GيI!N\<  ^<Q ч Gm<!j9QR  W5?Q
z ҇ G_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      
NextGenTel AS                                           D      operator                                                D      0                                                       D      	is_mobile                                               D      57117999                                                D      to                                                      D      57115000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Sogn og Fjordane                                        D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   Պ                                                        B  6C%/ʎߴ 
 Ge?āYOx  Q _{(-~ Ê J_nj5$ % %^                                                                                                                                                                                                                                                                                                D      466                                                     D     0                                                       B  ^\Q6ԂSM 
 =`-<]#y ׍ MO:-h} 
 Eֳ  ؍ MKX3vv{<>
Y 
 qc}G΅> ٍ MD5 1 
 يI!N\< ڍ M^<Q 
 m<!j9QR ۍ MW5?Q
z 
 _kVܕOFLA ܍ M                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      57199999                                                D      to                                                      D      57118000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Sogn og Fjordane                                        D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  |IϜOhwJ  ސ ͫ(k z: (> '#;h.UdxlT  ë]m(oq5  W3CX`E a !G$.k},t
 %߶ %v                                                                                                                                                                                                                                                D      467                                                     D     0                                                       B  ^\Q6ԂSM  J=`-<]#y  O:-h}  SEֳ   KX3vv{<>
Y  Sqc}G΅>  D5 1  SيI!N\<  ^<Q  Sm<!j9QR  W5?Q
z  S_kVܕOFLA                                                                                                  D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      57209999                                                D      to                                                      D      57200000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Sogn og Fjordane                                        D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           B  zu
I?X  SW
콉D,M # #a$-MU/ Y                                                                                                                                                                                                                                                                                                                         D      468                                                     D     0                                                       B  ^\Q6ԂSM  =`-<]#y  YO:-h}  Eֳ   YKX3vv{<>
Y  qc}G΅>  YD5 1  يI!N\<  Y^<Q  m<!j9QR  YW5?Q
z  _kVܕOFLA  Y                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Hafslund Telekom AS                                     D      operator                                                D      0                                                       D      	is_mobile                                               D      57219999                                                D      to                                                      D      57210000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Sogn og Fjordane                                        D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      469                                                     D     0                                                       B  ^\Q6ԂSM  V=`-<]#y  \O:-h}  Eֳ   \KX3vv{<>
Y  qc}G΅>  \D5 1  يI!N\<  \^<Q  m<!j9QR  \W5?Q
z  _kVܕOFLA  \                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      57299999                                                D      to                                                      D      57220000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Sogn og Fjordane                                        D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      470                                                     D     0                                                       B  ^\Q6ԂSM  Y=`-<]#y  _O:-h}  Eֳ   _KX3vv{<>
Y  qc}G΅>  _D5 1  يI!N\<  _^<Q  m<!j9QR  _W5?Q
z  _kVܕOFLA  _                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      TDC Song AS                                             D      operator                                                D      0                                                       D      	is_mobile                                               D      57309999                                                D      to                                                      D      57300000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Sogn og Fjordane                                        D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                            D      471                                                     D     0                                                       B  ^\Q6ԂSM " \=`-<]#y  bO:-h} " Eֳ   bKX3vv{<>
Y " qc}G΅>  bD5 1 " يI!N\<  b^<Q " m<!j9QR  bW5?Q
z " _kVܕOFLA  b                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      57319999                                                D      to                                                      D      57310000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Sogn og Fjordane                                        D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      472                                                     D     0                                                       B  ^\Q6ԂSM 
%  _=`-<]#y 
 
eO:-h} % 
Eֳ   eKX3vv{<>
Y % qc}G΅>  eD5 1 
% يI!N\< 
 
e^<Q % 
m<!j9QR  eW5?Q
z % _kVܕOFLA  e                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      57599999                                                D      to                                                      D      57320000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Sogn og Fjordane                                        D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      473                                                     D     0                                                       B  ^\Q6ԂSM ( b=`-<]#y  hO:-h} ( Eֳ   hKX3vv{<>
Y ( qc}G΅>  hD5 1 ( يI!N\<  h^<Q ( m<!j9QR  hW5?Q
z ( _kVܕOFLA  h                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      57609999                                                D      to                                                      D      57600000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Sogn og Fjordane                                        D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                           D      474                                                     D     0                                                       B  ^\Q6ԂSM + e=`-<]#y  kO:-h} + Eֳ   kKX3vv{<>
Y + qc}G΅>  kD5 1 + يI!N\<  k^<Q + m<!j9QR  kW5?Q
z + _kVܕOFLA  k                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      57610999                                                D      to                                                      D      57610000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Sogn og Fjordane                                        D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H                                                            D      475                                                     D     0                                                       B  ^\Q6ԂSM ". h=`-<]#y " "nO:-h} #. "Eֳ  # #nKX3vv{<>
Y $. #qc}G΅> $ $nD5 1 %. $يI!N\< % %n^<Q &. %m<!j9QR & &nW5?Q
z '. &_kVܕOFLA ' 'n                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      57611999                                                D      to                                                      D      57611000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Sogn og Fjordane                                        D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   *1                                                        B  Y>q7>
rv ) 'Y B띕 a arY0JbkuW S SK                                                                                                                                                                                                                                                                                                                        D      476                                                     D     0                                                       B  ^\Q6ԂSM +  k=`-<]#y ,4 +O:-h} , ,tEֳ  -4 ,KX3vv{<>
Y - -tqc}G΅> .4 -D5 1 . .tيI!N\< /4 .^<Q / /tm<!j9QR 04 /W5?Q
z 0 0t_kVܕOFLA 14 0                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      57799999                                                D      to                                                      D      57612000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Sogn og Fjordane                                        D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   24                                                        D      477                                                     D     0                                                       B  ^\Q6ԂSM 3 )=`-<]#y 47 3O:-h} 4 4wEֳ  57 4KX3vv{<>
Y 5 5wqc}G΅> 67 5D5 1 6 6wيI!N\< 77 6^<Q 7 7wm<!j9QR 87 7W5?Q
z 8 8w_kVܕOFLA 97 8                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      57809999                                                D      to                                                      D      57800000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Sogn og Fjordane                                        D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   :7                                                        D      478                                                     D     0                                                       B  ^\Q6ԂSM ; 1=`-<]#y <: ;O:-h} < <zEֳ  =: <KX3vv{<>
Y = =zqc}G΅> >: =D5 1 > >zيI!N\< ?: >^<Q ? ?zm<!j9QR @: ?W5?Q
z @ @z_kVܕOFLA A: @                                                                                                D      is_voip                                                 D      1                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           D      Telenor Telecom Solutions AS                            D      operator                                                D      0                                                       D      	is_mobile                                               D      57899999                                                D      to                                                      D      57810000                                                D      from                                                    D      0                                                       D      is_specialrate                                          D      Sogn og Fjordane                                        D      areaname                                                D      0                                                       D      is_tollfree                                             D      1                                                       D      is_valid                                                H   B:                                                        D      479                                                     D     0                                                       B  ^\Q6ԂSM C 9=`-<]#y D= CO:-h} D D}Eֳ  E= DKX3vv{<>
Y E E}qc}G΅> F= ED5 1 F F}يI!N\< G= F^<Q G G}m<!j9QR H= GW5?Q
z H H}_kVܕOFLA I= H                                                                                                D      is_voip                                                 D      0                                                       D      is_allocated                                            D      0                                                       D      is_adult                                                D      1                                                       D      
is_geographic                                           N                                                               D      operator                                                D      0                                                       D      	is_mobile                                               D      57987999                                                D      to                                                      D      57900000                             