package Games::ABC_Path::Generator::FinalLayoutObj;
$Games::ABC_Path::Generator::FinalLayoutObj::VERSION = '0.4.1';
use 5.006;

use strict;
use warnings;

use integer;

use parent 'Games::ABC_Path::Generator::Base';

use Games::ABC_Path::Solver::Constants;


sub _s
{
    my $self = shift;

    if (@_)
    {
        $self->{_s} = shift;
    }

    return $self->{_s};
}

sub _init
{
    my $self = shift;
    my $args = shift;

    $self->_s($args->{layout_string});

    return;
}


sub get_A_pos
{
    my ($self) = @_;

    return index($self->_s, chr(1));
}


sub get_A_xy
{
    my ($self) = @_;

    my ($y, $x) = $self->_to_xy($self->get_A_pos());

    return {y => $y, x => $x,};
}


sub get_cell_contents
{
    my ($self, $index) = @_;

    return vec($self->_s, $index, 8) ;
}


sub get_letter_at_pos
{
    my ($self, $pos) = @_;

    return $letters[
        $self->get_cell_contents(
            $self->_xy_to_int(
                [$pos->{'y'},$pos->{'x'}],
            )
        )-1,
    ];
}


sub as_string
{
    my ($l, $args) = @_;

    my $render_row = sub {
        my $y = shift;

        return join(" | ",
            map {
                my $x = $_;
                my $v = $l->get_cell_contents($l->_xy_to_int([$y,$x]));
            $v ? $letters[$v-1] : '*' } (0 .. $LEN - 1));
    };

    return join('', map { $render_row->($_) . "\n" } (0 .. $LEN-1));
}


1; # End of Games::ABC_Path::Generator

__END__

=pod

=encoding UTF-8

=head1 NAME

Games::ABC_Path::Generator::FinalLayoutObj - represents a final layout.

=head1 VERSION

version 0.4.1

=head1 SYNOPSIS

    use Games::ABC_Path::Generator;

    my $gen = Games::ABC_Path::Generator->new({seed => 1});

    # Returns a Games::ABC_Path::Generator::FinalLayoutObj object.
    my $layout = $gen->calc_final_layout();

    my $A_xy = $layout->get_A_xy();

=head1 VERSION

version 0.4.1

=head1 SUBROUTINES/METHODS

=head2 my $layout = Games::ABC_Path::Generator::FinalLayoutObj->new({%args});

Initializes a new layout. B<For internal use.>.

=head2 $layout->get_A_pos()

Returns the position of the letter 'A'.

=head2 $layout->get_A_xy()

Returns the (X,Y) coordinates of the letter A as a C<< {x => $x, y => $y} >>
hash reference.

=head2 $layout->get_cell_contents($index)

Returns the cell at index L<$index> (where index is C< $Y*5 + $X>).

=head2 my $letter = $layout->get_letter_at_pos({y => $y, x => $x});

Returns the letter at $y and $x .

=head2 $layout->as_string($args);

Represents the layout as string.

=head1 AUTHOR

Shlomi Fish, L<http://www.shlomifish.org/> .

=head1 BUGS

Please report any bugs or feature requests to C<bug-games-abc_path-generator at rt.cpan.org>, or through
the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Games-ABC_Path-Generator>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Games::ABC_Path::Generator

You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Games-ABC_Path-Generator>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Games-ABC_Path-Generator>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Games-ABC_Path-Generator>

=item * Search CPAN

L<http://search.cpan.org/dist/Games-ABC_Path-Generator/>

=back

=head1 ACKNOWLEDGEMENTS

=head1 LICENSE AND COPYRIGHT

Copyright 2011 Shlomi Fish.

This program is distributed under the MIT (X11) License:
L<http://www.opensource.org/licenses/mit-license.php>

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation
files (the "Software"), to deal in the Software without
restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following
conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

=head1 AUTHOR

Shlomi Fish <shlomif@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018 by Shlomi Fish.

This is free software, licensed under:

  The MIT (X11) License

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/shlomif/abc-path/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=for :stopwords cpan testmatrix url annocpan anno bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan

=head1 SUPPORT

=head2 Perldoc

You can find documentation for this module with the perldoc command.

  perldoc Games::ABC_Path::Generator::FinalLayoutObj

=head2 Websites

The following websites have more information about this module, and may be of help to you. As always,
in addition to those websites please use your favorite search engine to discover more resources.

=over 4

=item *

MetaCPAN

A modern, open-source CPAN search engine, useful to view POD in HTML format.

L<https://metacpan.org/release/Games-ABC_Path-Generator>

=item *

Search CPAN

The default CPAN search engine, useful to view POD in HTML format.

L<http://search.cpan.org/dist/Games-ABC_Path-Generator>

=item *

RT: CPAN's Bug Tracker

The RT ( Request Tracker ) website is the default bug/issue tracking system for CPAN.

L<https://rt.cpan.org/Public/Dist/Display.html?Name=Games-ABC_Path-Generator>

=item *

AnnoCPAN

The AnnoCPAN is a website that allows community annotations of Perl module documentation.

L<http://annocpan.org/dist/Games-ABC_Path-Generator>

=item *

CPAN Ratings

The CPAN Ratings is a website that allows community ratings and reviews of Perl modules.

L<http://cpanratings.perl.org/d/Games-ABC_Path-Generator>

=item *

CPANTS

The CPANTS is a website that analyzes the Kwalitee ( code metrics ) of a distribution.

L<http://cpants.cpanauthors.org/dist/Games-ABC_Path-Generator>

=item *

CPAN Testers

The CPAN Testers is a network of smoke testers who run automated tests on uploaded CPAN distributions.

L<http://www.cpantesters.org/distro/G/Games-ABC_Path-Generator>

=item *

CPAN Testers Matrix

The CPAN Testers Matrix is a website that provides a visual overview of the test results for a distribution on various Perls/platforms.

L<http://matrix.cpantesters.org/?dist=Games-ABC_Path-Generator>

=item *

CPAN Testers Dependencies

The CPAN Testers Dependencies is a website that shows a chart of the test results of all dependencies for a distribution.

L<http://deps.cpantesters.org/?module=Games::ABC_Path::Generator>

=back

=head2 Bugs / Feature Requests

Please report any bugs or feature requests by email to C<bug-games-abc_path-generator at rt.cpan.org>, or through
the web interface at L<https://rt.cpan.org/Public/Bug/Report.html?Queue=Games-ABC_Path-Generator>. You will be automatically notified of any
progress on the request by the system.

=head2 Source Code

The code is open to the world, and available for you to hack on. Please feel free to browse it and play
with it, or whatever. If you want to contribute patches, please send me a diff or prod me to pull
from your repository :)

L<https://github.com/shlomif/abc-path>

  git clone https://github.com/shlomif/abc-path

=cut
