## Terminal::ANSI

ANSI Escape Sequences

This module exports functions for emitting ANSI escape sequences.

It also maintains some state about the screen, such as a currently active scroll region.

It can optionally maintain the state of all of the characters on the screen, by writing to a virtual screen.

## Exported Functions

[atomically(&callable)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L205) Combine a series of outputs into one.

[bold()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L187) Bold (increased intensity)

[clear-screen()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L43) Clear the screen.

[cursor-down($amt = 1)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L121) Move cursor down.

[cursor-left($amt = 1)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L136) Move cursor left.

[cursor-off()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L111) Turn off cursor (civis).

[cursor-on()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L116) Turn on cursor (cnorm).

[cursor-right($amt = 1)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L131) Move cursor right.

[cursor-up($amt = 1)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L126) Move cursor up.

[disable-output()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L224) Suppress all output

[enable-output()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L230) Enable output

[enable-virtual()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L214) Send commands to a virtual screen

[erase-to-end-of-line()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L172) Erase to end of line.

[faint()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L192) Faint (lower intensity)

[hide-cursor()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L91) Hide the cursor.

[home()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L54) Move to home (0,0).

[move-to($l, $c = 1)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L49) Move the cursor to line, column.

[normal-video()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L182) Normal video

[parse-input($str)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L235) Return a description of the given input sequence

[print-at($r, $c, $str)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L141) Atomic move + print.

[reset-scroll-region()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L66) Reset the scroll region.

[restore-cursor()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L162) restore the cursor position.

[restore-screen()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L106) Restore screen (rmcup).

[reverse-video()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L177) Reverse video

[save-cursor()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L157) Save the cursor position.

[save-screen()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L101) Save screen state (smcup).

[scroll-down($n = 1)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L73) Scroll down by an amount.

[scroll-up($n = 1)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L82) Scroll up by an amount.

[set-bg-color($n)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L152) Set bg color to $n.

[set-fg-color($n)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L147) Set fg color to $n.

[set-scroll-region($top, $bottom)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L59) Set scroll region to top, bottom.

[show-cursor()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L96) Show the cursor.

[start-of-line()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L167) Move to start of line.

[tget(&callable)](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L197) Get strings instead of printing them.

[virtual-screen()](https://git.sr.ht/~bduggan/raku-terminal-ansi/tree/0.0.9/lib/Terminal/ANSI.rakumod#L219) Get the virtual screen receiving commands
