use Test::More tests => 10;

use FindBin;
use lib "$FindBin::Bin/../lib";
use strict;
use warnings;
use Hash::MD5 qw( sum_hash );

# 01.)
my $check_sum1 = sum_hash( { string => "This is a test string.",    number => 'This is a another string.' } );
my $check_sum2 = sum_hash( { number => 'This is a another string.', string => "This is a test string." } );
ok( ( $check_sum1 eq $check_sum2 ) == 1, 'test compare strings' );

# 02.)
$check_sum1 = sum_hash( { string => 123, number => 321 } );
$check_sum2 = sum_hash( { number => 321, string => 123 } );
ok( ( $check_sum1 eq $check_sum2 ) == 1, 'test compare number' );

# 03.)
$check_sum1 = sum_hash( { string => 321, number => 123 } );
$check_sum2 = sum_hash( { number => 321, string => 123 } );
ok( ( $check_sum1 eq $check_sum2 ) != 1, 'test compare number' );

# 04.)
$check_sum1 = sum_hash( { number => 321, string => "This is a test string." } );
$check_sum2 = sum_hash( { string => "This is a test string.", number => 321 } );
ok( ( $check_sum1 eq $check_sum2 ) == 1, 'test compare mixed' );

# 05.)
$check_sum1 = sum_hash( { number => 321, string => "This is a test string.", a => [ 1, 2, 3 ] } );
$check_sum2 = sum_hash( { string => "This is a test string.", number => 321, a => [ 1, 2, 3 ] } );
ok( ( $check_sum1 eq $check_sum2 ) == 1, 'test compare mixed' );

# 06.)
$check_sum1 = sum_hash( { a  => '', aaaa => '', } );
$check_sum2 = sum_hash( { aa => '', aaa  => '', } );
ok( ( $check_sum1 eq $check_sum2 ) != 1, 'different keys' );

# 07.)
$check_sum1 = sum_hash( { a => 'a',           aa => 'aaaaaaaaaaa', } );
$check_sum2 = sum_hash( { a => 'aaaaaaaaaaa', aa => 'a', } );
ok( ( $check_sum1 eq $check_sum2 ) != 1, 'different keys' );

# 08.)
$check_sum1 = sum_hash( { 'aaaaaaaaaaaaaaa"' => '', } );
$check_sum2 = sum_hash( { a => 'aa', aa => 'aaaaaaaaaa' } );
ok( ( $check_sum1 eq $check_sum2 ) != 1, 'string keys' );

# 09.)
my %x;
$x{a} = \%x;
ok( defined sum_hash( \%x ), 'deep recursion 1' );

# 10.)
%x = ();
$x{a} = 'one';
$x{b} = { c => \%x };
ok( defined sum_hash( \%x ), 'very deep recursion' );
