use Test::More tests=>9;

use Math::Intersection::Circle::Line;
use warnings FATAL => qw(all);
use strict;
use utf8;

sub near($$$$$$$$)                                                              # Check that we are near enough
 {my ($a, $b, $c, $d, $A, $B, $C, $D) = @_;
  my $𝗱 = 1e-6;
  abs($A - $a) < $𝗱 && abs($B - $b) < $𝗱 &&
  abs($C - $c) < $𝗱 && abs($D - $d) < $𝗱
 }

my $h = sqrt(1/2);
my $t = sqrt(3);

intersectionCircleLine {ok $_[0] == 0 && $_[1] == 1}          0,   0,   1, -1,  1, 1,  1;
intersectionCircleLine {ok &near(@_, -$h, $h, $h, -$h)}       0,   0,   1, -1,  1, 1, -1;
intersectionCircleLine {ok &near(@_,   0,   1,   2,   1)}     1,   1,   1, -1,  1, 1,  1;
intersectionCircleLine {ok &near(@_,   1,   0,   1,   2)}     1,   1,   1,  1,  0, 1,  1;
intersectionCircleLine {ok &near(@_,-0.5,   0,   0.5, 0)}     0, -$t/2, 1, -1,  0, 1,  0;
intersectionCircleLine {ok &near(@_,   0,  -0.5, 0,   0.5)} -$t/2, 0,   1,  0, -1, 0,  1;
intersectionCircleLine {ok &near(@_,   0,   0,  18,   0)}     9,   0,   9,  0,  0, 1,  0;
intersectionCircleLine {ok &near(@_,   0,   0,   0,  18)}     0,   9,   9,  0,  0, 0,  1;
intersectionCircleLine {ok 0 == @_}                           0,   0,   1, -2,  2, 2,  2;

