/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Iterator;
import java.util.TreeMap;
import javax.media.jai.Histogram;
import javax.media.jai.StatisticsOpImage;

final class MlibHistogramOpImage
extends StatisticsOpImage {
    private int[] numBins;
    private double[] lowValueFP;
    private double[] highValueFP;
    private int[] lowValue;
    private int[] highValue;
    private int numBands = this.sampleModel.getNumBands();
    private int[] bandIndexMap;
    private boolean reorderBands = false;

    public MlibHistogramOpImage(RenderedImage renderedImage, int n, int n2, int[] nArray, double[] dArray, double[] dArray2) {
        super(renderedImage, null, renderedImage.getMinX(), renderedImage.getMinY(), n, n2);
        this.numBins = new int[this.numBands];
        this.lowValueFP = new double[this.numBands];
        this.highValueFP = new double[this.numBands];
        int n3 = 0;
        while (n3 < this.numBands) {
            this.numBins[n3] = nArray.length == 1 ? nArray[0] : nArray[n3];
            this.lowValueFP[n3] = dArray.length == 1 ? dArray[0] : dArray[n3];
            this.highValueFP[n3] = dArray2.length == 1 ? dArray2[0] : dArray2[n3];
            ++n3;
        }
        this.lowValue = new int[this.lowValueFP.length];
        int n4 = 0;
        while (n4 < this.lowValueFP.length) {
            this.lowValue[n4] = (int)Math.ceil(this.lowValueFP[n4]);
            ++n4;
        }
        this.highValue = new int[this.highValueFP.length];
        int n5 = 0;
        while (n5 < this.highValueFP.length) {
            this.highValue[n5] = (int)Math.ceil(this.highValueFP[n5]);
            ++n5;
        }
        if (this.numBands > 1) {
            int n6;
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)this.sampleModel;
            TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
            int[] nArray2 = componentSampleModel.getBankIndices();
            boolean bl = false;
            int n7 = 1;
            while (n7 < this.numBands) {
                if (nArray2[n7] != nArray2[n7 - 1]) {
                    bl = true;
                    break;
                }
                ++n7;
            }
            if (bl) {
                int n8 = 0;
                while (n8 < this.numBands) {
                    treeMap.put(new Integer(nArray2[n8]), new Integer(n8));
                    ++n8;
                }
                this.bandIndexMap = new int[this.numBands];
                Iterator iterator = treeMap.keySet().iterator();
                int n9 = 0;
                while (iterator.hasNext()) {
                    n6 = (Integer)treeMap.get(iterator.next());
                    if (n6 != n9) {
                        this.reorderBands = true;
                    }
                    this.bandIndexMap[n9++] = n6;
                }
            }
            if (!this.reorderBands) {
                treeMap.clear();
                if (this.bandIndexMap == null) {
                    this.bandIndexMap = new int[this.numBands];
                }
                int[] nArray3 = componentSampleModel.getBandOffsets();
                int n10 = 0;
                while (n10 < this.numBands) {
                    treeMap.put(new Integer(nArray3[n10]), new Integer(n10));
                    ++n10;
                }
                Iterator iterator = treeMap.keySet().iterator();
                n6 = 0;
                while (iterator.hasNext()) {
                    int n11 = (Integer)treeMap.get(iterator.next());
                    if (n11 != n6) {
                        this.reorderBands = true;
                    }
                    this.bandIndexMap[n6++] = n11;
                }
            }
        }
    }

    protected String[] getStatisticsNames() {
        String[] stringArray = new String[]{"histogram"};
        return stringArray;
    }

    protected Object createStatistics(String string) {
        if (string.equalsIgnoreCase("histogram")) {
            return new Histogram(this.numBins, this.lowValueFP, this.highValueFP);
        }
        return Image.UndefinedProperty;
    }

    protected void accumulateStatistics(String string, Raster raster, Object object) {
        int n;
        Object object2;
        Histogram histogram = (Histogram)object;
        int n2 = histogram.getNumBands();
        int[][] nArray = histogram.getBins();
        Rectangle rectangle = raster.getBounds();
        if (!this.reorderBands && rectangle.equals(this.getBounds())) {
            object2 = nArray;
        } else {
            object2 = new int[n2][];
            n = 0;
            while (n < n2) {
                object2[n] = new int[histogram.getNumBins(n)];
                ++n;
            }
        }
        n = MediaLibAccessor.findCompatibleTag(null, raster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle, n);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        int n3 = (this.xPeriod - (rectangle.x - this.xStart) % this.xPeriod) % this.xPeriod;
        int n4 = (this.yPeriod - (rectangle.y - this.yStart) % this.yPeriod) % this.yPeriod;
        if (object2 == nArray) {
            Histogram histogram2 = histogram;
            synchronized (histogram2) {
                com.sun.medialib.mlib.Image.Histogram2((int[][])object2, (mediaLibImage)mediaLibImageArray[0], (int[])this.lowValue, (int[])this.highValue, (int)n3, (int)n4, (int)this.xPeriod, (int)this.yPeriod);
            }
        }
        com.sun.medialib.mlib.Image.Histogram2((int[][])object2, (mediaLibImage)mediaLibImageArray[0], (int[])this.lowValue, (int[])this.highValue, (int)n3, (int)n4, (int)this.xPeriod, (int)this.yPeriod);
        Histogram histogram3 = histogram;
        synchronized (histogram3) {
            int n5 = 0;
            while (n5 < n2) {
                int n6 = object2[n5].length;
                int[] nArray2 = this.reorderBands ? nArray[this.bandIndexMap[n5]] : nArray[n5];
                int[] nArray3 = object2[n5];
                int n7 = 0;
                while (n7 < n6) {
                    int n8 = n7;
                    nArray2[n8] = nArray2[n8] + nArray3[n7];
                    ++n7;
                }
                ++n5;
            }
        }
    }
}

