/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.util.PDFStreamEngine;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PDFImageWriter
extends PDFStreamEngine {
    private static final String STANDARD_METADATA_FORMAT = "javax_imageio_1.0";

    public PDFImageWriter() throws IOException {
    }

    public PDFImageWriter(Properties props) throws IOException {
        super(props);
    }

    public boolean writeImage(PDDocument document, String imageType, String password, int startPage, int endPage, String outputPrefix) throws IOException {
        int resolution;
        try {
            resolution = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (HeadlessException e) {
            resolution = 96;
        }
        return this.writeImage(document, imageType, password, startPage, endPage, outputPrefix, 8, resolution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeImage(PDDocument document, String imageFormat, String password, int startPage, int endPage, String outputPrefix, int imageType, int resolution) throws IOException {
        boolean bSuccess = true;
        List pages = document.getDocumentCatalog().getAllPages();
        for (int i = startPage - 1; i < endPage && i < pages.size(); ++i) {
            ImageInputStream output = null;
            ImageWriter imageWriter = null;
            try {
                PDPage page = (PDPage)pages.get(i);
                BufferedImage image = page.convertToImage(imageType, resolution);
                String fileName = outputPrefix + (i + 1) + "." + imageFormat;
                System.out.println("Writing: " + fileName);
                output = ImageIO.createImageOutputStream(new File(fileName));
                boolean foundWriter = false;
                Iterator<ImageWriter> writerIter = ImageIO.getImageWritersByFormatName(imageFormat);
                while (writerIter.hasNext() && !foundWriter) {
                    try {
                        imageWriter = writerIter.next();
                        ImageWriteParam writerParams = imageWriter.getDefaultWriteParam();
                        if (writerParams.canWriteCompressed()) {
                            writerParams.setCompressionMode(2);
                            writerParams.setCompressionQuality(1.0f);
                        }
                        IIOMetadata meta = this.createMetadata(image, imageWriter, writerParams, resolution);
                        imageWriter.setOutput(output);
                        imageWriter.write(null, new IIOImage(image, null, meta), writerParams);
                        foundWriter = true;
                    }
                    catch (IIOException io) {
                        throw new IOException(io.getMessage());
                    }
                    finally {
                        if (imageWriter == null) continue;
                        imageWriter.dispose();
                    }
                }
                if (foundWriter) continue;
                bSuccess = false;
                continue;
            }
            finally {
                if (output != null) {
                    output.flush();
                    output.close();
                }
            }
        }
        return bSuccess;
    }

    private IIOMetadata createMetadata(RenderedImage image, ImageWriter imageWriter, ImageWriteParam writerParams, int resolution) {
        ImageTypeSpecifier type = writerParams.getDestinationType() != null ? writerParams.getDestinationType() : ImageTypeSpecifier.createFromRenderedImage(image);
        IIOMetadata meta = imageWriter.getDefaultImageMetadata(type, writerParams);
        return this.addResolution(meta, resolution) ? meta : null;
    }

    private boolean addResolution(IIOMetadata meta, int resolution) {
        if (meta.isStandardMetadataFormatSupported()) {
            IIOMetadataNode root = (IIOMetadataNode)meta.getAsTree(STANDARD_METADATA_FORMAT);
            IIOMetadataNode dim = PDFImageWriter.getChildNode(root, "Dimension");
            IIOMetadataNode child = PDFImageWriter.getChildNode(dim, "HorizontalPixelSize");
            if (child == null) {
                child = new IIOMetadataNode("HorizontalPixelSize");
                dim.appendChild(child);
            }
            child.setAttribute("value", Double.toString((double)resolution / 25.4));
            child = PDFImageWriter.getChildNode(dim, "VerticalPixelSize");
            if (child == null) {
                child = new IIOMetadataNode("VerticalPixelSize");
                dim.appendChild(child);
            }
            child.setAttribute("value", Double.toString((double)resolution / 25.4));
            try {
                meta.mergeTree(STANDARD_METADATA_FORMAT, root);
            }
            catch (IIOInvalidTreeException e) {
                throw new RuntimeException("Cannot update image metadata: " + e.getMessage());
            }
            return true;
        }
        return false;
    }

    private static IIOMetadataNode getChildNode(Node n, String name) {
        NodeList nodes = n.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            if (!name.equals(child.getNodeName())) continue;
            return (IIOMetadataNode)child;
        }
        return null;
    }
}

