/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils.schemas;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.common.util.ClasspathScanner;
import org.apache.cxf.common.xmlschema.LSInputImpl;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class SchemaHandler {
    static final String DEFAULT_CATALOG_LOCATION = "classpath:META-INF/jax-rs-catalog.xml";
    private Schema schema;
    private Bus bus;
    private String catalogLocation;

    public void setBus(Bus b) {
        this.bus = b;
    }

    @Deprecated
    public void setSchemas(List<String> locations) {
        this.setSchemaLocations(locations);
    }

    public void setSchemaLocations(List<String> locations) {
        this.schema = SchemaHandler.createSchema(locations, this.catalogLocation, this.bus == null ? BusFactory.getThreadDefaultBus() : this.bus);
    }

    public void setCatalogLocation(String name) {
        this.catalogLocation = name;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public static Schema createSchema(List<String> locations, String catalogLocation, final Bus bus) {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema s = null;
        try {
            URL catalogURL;
            ArrayList<StreamSource> sources = new ArrayList<StreamSource>();
            for (String loc : locations) {
                List<Object> schemaURLs = new LinkedList();
                if (loc.lastIndexOf(".") == -1 || loc.lastIndexOf(42) != -1) {
                    schemaURLs = ClasspathScanner.findResources(loc, "xsd");
                } else {
                    URL url = ResourceUtils.getResourceURL(loc, bus);
                    if (url != null) {
                        schemaURLs.add(url);
                    }
                }
                if (schemaURLs.isEmpty()) {
                    throw new IllegalArgumentException("Cannot find XML schema location: " + loc);
                }
                for (URL uRL : schemaURLs) {
                    BufferedReader r = new BufferedReader(new InputStreamReader(uRL.openStream(), "UTF-8"));
                    StreamSource source = new StreamSource(r);
                    source.setSystemId(uRL.toString());
                    sources.add(source);
                }
            }
            if (sources.isEmpty()) {
                return null;
            }
            final OASISCatalogManager catalogResolver = OASISCatalogManager.getCatalogManager(bus);
            if (catalogResolver != null && (catalogURL = ResourceUtils.getResourceURL(catalogLocation = catalogLocation == null ? DEFAULT_CATALOG_LOCATION : catalogLocation, bus)) != null) {
                try {
                    catalogResolver.loadCatalog(catalogURL);
                    factory.setResourceResolver(new LSResourceResolver(){

                        @Override
                        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                            try {
                                InputStream resourceStream;
                                String resolvedLocation = catalogResolver.resolveSystem(systemId);
                                if (resolvedLocation == null) {
                                    resolvedLocation = catalogResolver.resolveURI(namespaceURI);
                                }
                                if (resolvedLocation == null) {
                                    resolvedLocation = catalogResolver.resolvePublic(publicId != null ? publicId : namespaceURI, systemId);
                                }
                                if (resolvedLocation != null && (resourceStream = ResourceUtils.getResourceStream(resolvedLocation, bus)) != null) {
                                    return new LSInputImpl(publicId, systemId, resourceStream);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return null;
                        }
                    });
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("Catalog " + catalogLocation + " can not be loaded", ex);
                }
            }
            s = factory.newSchema(sources.toArray(new Source[sources.size()]));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to load XML schema : " + ex.getMessage(), ex);
        }
        return s;
    }
}

