/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.util.ArrayList;
import java.util.List;
import org.apache.sis.internal.system.Threads;

abstract class DaemonThread
extends Thread {
    private final DaemonThread previous;
    private volatile boolean killRequested;

    protected DaemonThread(String string, DaemonThread daemonThread) {
        super(Threads.DAEMONS, string);
        this.previous = daemonThread;
        this.setDaemon(true);
    }

    @Override
    public abstract void run();

    protected boolean isStalled() {
        return false;
    }

    protected final boolean isKillRequested() {
        return this.killRequested;
    }

    static void killAll(DaemonThread daemonThread, long l) throws InterruptedException {
        long l2;
        DaemonThread daemonThread2 = daemonThread;
        while (daemonThread2 != null) {
            daemonThread2.killRequested = true;
            daemonThread2.interrupt();
            daemonThread2 = daemonThread2.previous;
        }
        while (daemonThread != null && (l2 = l - System.nanoTime()) > 0L) {
            daemonThread.join(l2 / 1000000L);
            daemonThread = daemonThread.previous;
        }
    }

    static List<Thread> listStalledThreads(DaemonThread daemonThread) {
        ArrayList<DaemonThread> arrayList = null;
        while (daemonThread != null) {
            if (!daemonThread.isAlive() || daemonThread.isStalled()) {
                if (arrayList == null) {
                    arrayList = new ArrayList<DaemonThread>();
                }
                arrayList.add(daemonThread);
            }
            daemonThread = daemonThread.previous;
        }
        return arrayList;
    }
}

