#!perl

use strict;
use warnings;

# This test was generated by inc::CheckJiraInChanges

use Test::More tests => 1;

my @commits = split /\n/, <<'EOC';
83440506 (sandbox/maint-v1.x, origin/maint-v1.x, dagolden/maint-v1.x) PERL-906 Relax Bool type constraint
82fc51e4 PERL-882 Document how to use the latest TLS protocols
1bb01768 PERL-880 Use only a single host type per variant in Evergreen
f3cb744e PERL-879 Skip snapshot testing on MongoDB 3.7+
fb2d431a PERL-878 Bump Authen::SCRAM prereq to 0.009 for Unicode encoding bug
02aba7a1 PERL-870 Fix repeated credential validation

EOC

my %ticket_map;
for my $commit ( @commits ) {
    for my $ticket ( $commit =~ /PERL-(\d+)/g ) {
        next if $ENV{CHECK_JIRA_SKIP}
            && grep { $ticket eq $_ } split " ", $ENV{CHECK_JIRA_SKIP};
        $ticket_map{$ticket} ||= [];
        push @{$ticket_map{$ticket}}, $commit;
    }
}

# grab Changes lines from new version to next un-indented line
open my $fh, "<:encoding(UTF-8)", "Changes";
my $changelog = do { local $/; <$fh> };

my @bad;
for my $ticket ( keys %ticket_map ) {
    if ( index( $changelog, "PERL-$ticket" ) < 0 ) {
       push @bad, $ticket;
    }
}

if ( !@commits ) {
    pass("No commits with Jira tickets");
}
else {
    ok( ! scalar @bad, "Jira tickets in Changes")
        or diag "Jira tickets missing:\n"
        . join("\n", map { "  * $_" } map { @{$ticket_map{$_}} } sort { $a <=> $b } @bad );
}
