# Generated by default/object.tt
package Paws::LexModels::SlotDefaultValue;
  use Moose;
  has DefaultValue => (is => 'ro', isa => 'Str', request_name => 'defaultValue', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModels::SlotDefaultValue

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModels::SlotDefaultValue object:

  $service_obj->Method(Att1 => { DefaultValue => $value, ..., DefaultValue => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModels::SlotDefaultValue object:

  $result = $service_obj->Method(...);
  $result->Att1->DefaultValue

=head1 DESCRIPTION

A default value for a slot.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DefaultValue => Str

The default value for the slot. You can specify one of the following:

=over

=item *

C<#context-name.slot-name> - The slot value "slot-name" in the context
"context-name."

=item *

C<{attribute}> - The slot value of the session attribute "attribute."

=item *

C<'value'> - The discrete value "value."

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModels>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

