%define _use_internal_dependency_generator 0

Name:           perl-Term-Spinner-Color
Version:        0.06
Release:        1
Summary:        Terminal spinner/progress bar with Unicode, color, and no non-core dependencies
License:        BSD
Group:          Development/Libraries
URL:            http://search.cpan.org/dist/Term-Spinner-Color/
Source0:        http://www.cpan.org/authors/id/S/SW/SWELLJOE/Term-Spinner-Color-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:      noarch
BuildRequires:  perl >= 0:5.010
BuildRequires:  perl(ExtUtils::MakeMaker)
BuildRequires:  perl(File::Spec)
BuildRequires:  perl(Term::ANSIColor)
BuildRequires:  perl(Test::More)
Requires:       perl(Term::ANSIColor)
Provides:	perl(Term::Spinner::Color)

%description
This is a simple spinner, useful when you want to show some kind of
activity during a long-running process of indeterminant length. It's
loosely based on the API from Term::Spinner and Term::Spinner::Lite. Unlike
Term::Spinner though, this module doesn't have any dependencies outside of
modules shipped with Perl itself. And, unlike Term::Spinner::Lite, this
module has color support and support for wide progress bars.

%prep
%setup -q -n Term-Spinner-Color-%{version}

%build
%{__perl} Makefile.PL INSTALLDIRS=vendor
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT

make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT

find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null \;

%{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%doc dist.ini examples LICENSE META.json README
%{perl_vendorlib}/*
%{_mandir}/man1/*
%{_mandir}/man3/*
%{_bindir}/*

%changelog
* Fri Aug 11 2017 build 0.04-1
- Bump rev, fix to doc
* Sat Jul 29 2017 build 0.03-2
- Update with progress bar color to match slib
* Mon May 08 2017 build 0.03-1
- Clean up deps and such
* Fri May 05 2017 build 0.02-1
- Specfile autogenerated by cpanspec 1.78.
